/*
    Win 32 Portions of the data panel class

    Sergei L. Kosakovsky Pond, Spring 2000 - January 2003.
*/

#include "HYTreePanel.h"
#include "HYDataPanel.h"
#include "HYUtils.h"

#include "likefunc.h"

#define     HY_DATA_WIN32_MENU_BASE    8000
#define     HY_DATALF_WIN32_MENU_BASE  8500

//__________________________________________________________________

void _HYDataPanel::_SetMenuBar(void)
{
    _HYWindow::_SetMenuBar();

    HMENU            windowMenu = GetMenu (theWindow),
                     dataMenu   = GetSubMenu(windowMenu,2);

    if (!dataMenu) {
        HMENU      dataMenu         = CreateMenu (),
                   lfMenu             = CreateMenu (),
                   blockMenu       = CreatePopupMenu (),
                   repeatCharMenu   = CreatePopupMenu (),
                   nameDisplayMenu  = CreatePopupMenu (),
                   additionalInfo  = CreatePopupMenu (),
                   lfDisplayMode   = CreatePopupMenu (),
                   omittedSpecies   = CreatePopupMenu (),
                   simulateData  = CreatePopupMenu (),
                   saveSubMenu     = CreatePopupMenu (),
                   procMenu         = CreatePopupMenu (),
                   inferSubMenu     = nil;

        _HYSequencePane* sp = (_HYSequencePane*)GetObject (0);

        if (!(dataMenu&&blockMenu&&repeatCharMenu&&nameDisplayMenu&&omittedSpecies&&additionalInfo)) {
            warnError (-108);
        }

        InsertMenu      (dataMenu,  0xFFFFFFFF, MF_BYPOSITION|MF_STRING|MF_GRAYED, HY_DATA_WIN32_MENU_BASE,
                         "&Partition->Selection\tCtrl-1");
        InsertMenu      (dataMenu,  0xFFFFFFFF, MF_BYPOSITION|MF_STRING|MF_GRAYED, HY_DATA_WIN32_MENU_BASE+1,
                         "&Selection->Partition\tCtrl-2");
        InsertMenu      (dataMenu,  0xFFFFFFFF, MF_BYPOSITION|MF_STRING, HY_DATA_WIN32_MENU_BASE+2,
                         "&Invert Selection\tCtrl-3");

        InsertMenu      (dataMenu,  0xFFFFFFFF, MF_BYPOSITION|MF_SEPARATOR, 0, nil);

        InsertMenu      (blockMenu, 0xFFFFFFFF, MF_BYPOSITION|MF_STRING, HY_DATA_WIN32_MENU_BASE+50, "&9");
        InsertMenu      (blockMenu, 0xFFFFFFFF, MF_BYPOSITION|MF_STRING, HY_DATA_WIN32_MENU_BASE+51, "&10");

        InsertMenu      (dataMenu,  0xFFFFFFFF, MF_BYPOSITION|MF_POPUP, (UINT)blockMenu, "&Block Width");

        InsertMenu      (repeatCharMenu, 0xFFFFFFFF, MF_BYPOSITION|MF_STRING, HY_DATA_WIN32_MENU_BASE+60, "Display &Actual Character");
        InsertMenu      (repeatCharMenu, 0xFFFFFFFF, MF_BYPOSITION|MF_STRING, HY_DATA_WIN32_MENU_BASE+61, "&Display '.'");

        InsertMenu      (dataMenu,  0xFFFFFFFF, MF_BYPOSITION|MF_POPUP, (UINT)repeatCharMenu, "&Repeat Characters");

        InsertMenu      (nameDisplayMenu, 0xFFFFFFFF, MF_BYPOSITION|MF_STRING, HY_DATA_WIN32_MENU_BASE+70, "&None");
        InsertMenu      (nameDisplayMenu, 0xFFFFFFFF, MF_BYPOSITION|MF_STRING, HY_DATA_WIN32_MENU_BASE+71, "&First 10 characters");
        InsertMenu      (nameDisplayMenu, 0xFFFFFFFF, MF_BYPOSITION|MF_STRING, HY_DATA_WIN32_MENU_BASE+72, "F&ull names");
        InsertMenu      (nameDisplayMenu, 0xFFFFFFFF, MF_BYPOSITION|MF_SEPARATOR, 0, nil);
        InsertMenu      (nameDisplayMenu, 0xFFFFFFFF, MF_BYPOSITION|MF_STRING, HY_DATA_WIN32_MENU_BASE+73, "&Alphabetize names");
        InsertMenu      (nameDisplayMenu, 0xFFFFFFFF, MF_BYPOSITION|MF_STRING, HY_DATA_WIN32_MENU_BASE+74, "&Revert to file order");
        InsertMenu      (nameDisplayMenu, 0xFFFFFFFF, MF_BYPOSITION|MF_STRING, HY_DATA_WIN32_MENU_BASE+75, "&Clean up sequence names");

        InsertMenu      (dataMenu,  0xFFFFFFFF, MF_BYPOSITION|MF_POPUP, (UINT)nameDisplayMenu, "&Name Display");

        InsertMenu      (omittedSpecies, 0xFFFFFFFF, MF_BYPOSITION|MF_STRING, HY_DATA_WIN32_MENU_BASE+10000, "&Restore All");
        InsertMenu      (omittedSpecies, 0xFFFFFFFF, MF_BYPOSITION|MF_SEPARATOR, 0, nil);
        InsertMenu      (dataMenu,  0xFFFFFFFF, MF_BYPOSITION|MF_POPUP|MF_GRAYED, (UINT)omittedSpecies, "&Omitted Sequences");

        InsertMenu      (additionalInfo, 0xFFFFFFFF, MF_BYPOSITION|MF_STRING, HY_DATA_WIN32_MENU_BASE+80, "&Consensus Sequence");
        InsertMenu      (additionalInfo, 0xFFFFFFFF, MF_BYPOSITION|MF_STRING|MF_GRAYED, HY_DATA_WIN32_MENU_BASE+81,
                         "&Rate Class");
        InsertMenu      (additionalInfo, 0xFFFFFFFF, MF_BYPOSITION|MF_STRING|MF_GRAYED, HY_DATA_WIN32_MENU_BASE+82,
                         "&Aminoacid Translation");
        InsertMenu      (additionalInfo, 0xFFFFFFFF, MF_BYPOSITION|MF_STRING, HY_DATA_WIN32_MENU_BASE+83,  "Re&ference Sequence");

        InsertMenu      (dataMenu,  0xFFFFFFFF, MF_BYPOSITION|MF_POPUP, (UINT)additionalInfo, "&Additonal Info");
        InsertMenu      (dataMenu,  0xFFFFFFFF, MF_BYPOSITION|MF_SEPARATOR, 0, nil);

        InsertMenu      (dataMenu,  0xFFFFFFFF, MF_BYPOSITION|MF_STRING|MF_GRAYED, HY_DATA_WIN32_MENU_BASE+3,"Part&ition Properties");
        InsertMenu      (dataMenu,  0xFFFFFFFF, MF_BYPOSITION|MF_STRING, HY_DATA_WIN32_MENU_BASE+4,"Inp&ut Partition");
        InsertMenu      (dataMenu,  0xFFFFFFFF, MF_BYPOSITION|MF_SEPARATOR, 0, nil);

        InsertMenu      (simulateData, 0xFFFFFFFF, MF_BYPOSITION|MF_STRING, HY_DATA_WIN32_MENU_BASE+90, "&Simulate 1");
        InsertMenu      (simulateData, 0xFFFFFFFF, MF_BYPOSITION|MF_STRING, HY_DATA_WIN32_MENU_BASE+91, "Simulate 1 To &File");
        InsertMenu      (simulateData, 0xFFFFFFFF, MF_BYPOSITION|MF_STRING, HY_DATA_WIN32_MENU_BASE+92, "Simulate &Many");

        InsertMenu      (dataMenu,  0xFFFFFFFF, MF_BYPOSITION|MF_POPUP, (UINT)simulateData, "&Simulation");
        InsertMenu      (dataMenu,  0xFFFFFFFF, MF_BYPOSITION|MF_STRING|MF_GRAYED, HY_DATA_WIN32_MENU_BASE+5,"An&cestors");
        InsertMenu      (dataMenu,  0xFFFFFFFF, MF_BYPOSITION|MF_SEPARATOR, 0, nil);
        InsertMenu      (dataMenu,  0xFFFFFFFF, MF_BYPOSITION|MF_STRING, HY_DATA_WIN32_MENU_BASE+6,"&Font Options");

        if (dataPanelProcessors.lLength == 0) {
            InsertMenu      (dataMenu, 0xFFFFFFFF, MF_BYPOSITION|MF_STRING|MF_GRAYED, 0, "&Data Processing");
            DestroyMenu     (procMenu);
        } else {
            for (long k=0; k<dataPanelProcessors.lLength; k++) {
                _String *thisItem = (_String*)dataPanelProcessors (k),
                         chopped = thisItem->Cut (thisItem->FindBackwards ('\\',0,-1)+1,-1);

                InsertMenu      (procMenu, 0xFFFFFFFF, MF_BYPOSITION|MF_STRING, HY_DATA_WIN32_MENU_BASE+100+k, chopped.sData);
            }
            InsertMenu      (dataMenu, 0xFFFFFFFF, MF_BYPOSITION|MF_POPUP, (UINT)procMenu, "&Data Processing");
        }

        InsertMenu      (lfMenu,  0xFFFFFFFF, MF_BYPOSITION|MF_STRING, HY_DATALF_WIN32_MENU_BASE, "&Build\tCtrl-L");

        InsertMenu      (lfDisplayMode, 0xFFFFFFFF, MF_BYPOSITION|MF_STRING, HY_DATALF_WIN32_MENU_BASE+50, "Log-Lkhd &Only");
        InsertMenu      (lfDisplayMode, 0xFFFFFFFF, MF_BYPOSITION|MF_STRING, HY_DATALF_WIN32_MENU_BASE+51, "Log-Lkhd with &Parameter Values");
        InsertMenu      (lfDisplayMode, 0xFFFFFFFF, MF_BYPOSITION|MF_STRING, HY_DATALF_WIN32_MENU_BASE+52, "Log-Lkhd with &Concise Trees");
        InsertMenu      (lfDisplayMode, 0xFFFFFFFF, MF_BYPOSITION|MF_STRING, HY_DATALF_WIN32_MENU_BASE+53, "&Parameter Listing");
        InsertMenu      (lfDisplayMode, 0xFFFFFFFF, MF_BYPOSITION|MF_STRING, HY_DATALF_WIN32_MENU_BASE+54, "Log-Lkhd with Complete &Trees");

        InsertMenu      (lfMenu,  0xFFFFFFFF, MF_BYPOSITION|MF_POPUP|MF_GRAYED, (UINT)lfDisplayMode, "&Display");
        InsertMenu      (lfMenu,  0xFFFFFFFF, MF_BYPOSITION|MF_STRING|MF_GRAYED, HY_DATALF_WIN32_MENU_BASE+1, "&Optimize\tCtrl-T");
        InsertMenu      (lfMenu,  0xFFFFFFFF, MF_BYPOSITION|MF_SEPARATOR, 0, nil);
        InsertMenu      (lfMenu,  0xFFFFFFFF, MF_BYPOSITION|MF_STRING|MF_GRAYED, HY_DATALF_WIN32_MENU_BASE+2, "&Show Parameters\tCtrl-H");
        InsertMenu      (lfMenu,  0xFFFFFFFF, MF_BYPOSITION|MF_SEPARATOR, 0, nil);
        InsertMenu      (lfMenu,  0xFFFFFFFF, MF_BYPOSITION|MF_STRING|MF_GRAYED, HY_DATALF_WIN32_MENU_BASE+3, "&General Bootstrap\tCtrl-B");

        if (omittedSeqs.lLength) {
            _OmitSelectedSpecies(omittedSeqs);
        }

        CheckMenuItem (blockMenu,(sp->blockWidth==10)?1:0,MF_CHECKED|MF_BYPOSITION);
        if (sp->nameDisplayFlags&HY_SEQUENCE_PANE_NAMES_ALL) {
            CheckMenuItem (nameDisplayMenu,2,MF_CHECKED|MF_BYPOSITION);
        } else if (sp->nameDisplayFlags&HY_SEQUENCE_PANE_NAMES_SHORT) {
            CheckMenuItem (nameDisplayMenu,1,MF_CHECKED|MF_BYPOSITION);
        } else {
            CheckMenuItem (nameDisplayMenu,0,MF_CHECKED|MF_BYPOSITION);
        }
        if (sp->showDots) {
            CheckMenuItem (repeatCharMenu,1,MF_CHECKED|MF_BYPOSITION);
        } else {
            CheckMenuItem (repeatCharMenu,0,MF_CHECKED|MF_BYPOSITION);
        }

        if (dataType&HY_DATAPANEL_NUCDATA) {
            EnableMenuItem (additionalInfo,2, MF_ENABLED|MF_BYPOSITION);
        }

        _UpdateLFMenu();

        InsertMenu   (windowMenu, 2, MF_BYPOSITION|MF_POPUP, (UINT) dataMenu , "&Data");

        InsertMenu      (saveSubMenu, 0xFFFFFFFF, MF_BYPOSITION|MF_STRING, HY_WINDOW_MENU_ID_FILE+1, "&Save\tCtrl-S");
        InsertMenu      (saveSubMenu, 0xFFFFFFFF, MF_BYPOSITION|MF_STRING, HY_WINDOW_MENU_ID_FILE+3, "Save &As");

        dataMenu =  GetSubMenu(windowMenu,0);

        ModifyMenu   (dataMenu, 0, MF_BYPOSITION|MF_POPUP, (UINT) saveSubMenu , "&Save");

        dataMenu =  GetSubMenu(windowMenu,1);
        InsertMenu   (dataMenu, 0xFFFFFFFF, MF_BYPOSITION|MF_STRING, HY_WINDOW_MENU_ID_EDIT+6 ,  "&Find\tCtrl-F");
        InsertMenu   (dataMenu, 0xFFFFFFFF, MF_BYPOSITION|MF_STRING, HY_WINDOW_MENU_ID_EDIT+7 ,  "&Search and &Replace");
        EnableMenuItem (dataMenu,2,MF_BYPOSITION|MF_ENABLED);
        EnableMenuItem (dataMenu,6,MF_BYPOSITION|MF_ENABLED);

        InsertMenu   (windowMenu, 3, MF_BYPOSITION|MF_POPUP, (UINT) lfMenu , "&Likelihood");

        accels       << (FCONTROL|FVIRTKEY);
        accels       << 'F';
        accels       << HY_WINDOW_MENU_ID_EDIT+6;

        accels       << (FCONTROL|FVIRTKEY);
        accels       << 'L';
        accels       << HY_DATALF_WIN32_MENU_BASE;

        accels       << (FCONTROL|FVIRTKEY);
        accels       << 'T';
        accels       << HY_DATALF_WIN32_MENU_BASE+1;

        accels       << (FCONTROL|FVIRTKEY);
        accels       << 'H';
        accels       << HY_DATALF_WIN32_MENU_BASE+2;

        accels       << (FCONTROL|FVIRTKEY);
        accels       << 'B';
        accels       << HY_DATALF_WIN32_MENU_BASE+3;

        accels       << (FCONTROL|FVIRTKEY);
        accels       << '1';
        accels       << HY_DATA_WIN32_MENU_BASE;

        accels       << (FCONTROL|FVIRTKEY);
        accels       << '2';
        accels       << HY_DATA_WIN32_MENU_BASE+1;

        accels       << (FCONTROL|FVIRTKEY);
        accels       << '3';
        accels       << HY_DATA_WIN32_MENU_BASE+2;

        _AddStandardAccels();
        _BuildAccelTable  (true);
        accels.Clear();
    }
    _VerifyInferMenu    ();
}
//__________________________________________________________________


bool        _HYDataPanel::_ProcessMenuSelection (long msel)
{
    if (_HYWindow::_ProcessMenuSelection(msel)) {
        return true;
    }

    _HYSequencePane* sp = (_HYSequencePane*)GetObject (0);
    _HYSequencePane* sp2 =(_HYSequencePane*)GetObject (4);
    _String     prompt;
    bool        done = false;
    HMENU       treeMenu;

    //printf ("Menu selection %d\n", msel);

    switch (msel) {
    case HY_WINDOW_MENU_ID_FILE+2: {
        _PrintData();
        done = true;
        break;
    }

    case HY_WINDOW_MENU_ID_EDIT+1: { // Copy
        _CopySelectionToClipboard   ();
        done = true;
        break;
    }

    case HY_WINDOW_MENU_ID_EDIT+5: { // Select All
        sp->SelectAll(true);
        done = true;
        break;
    }

    case HY_WINDOW_MENU_ID_EDIT+6: { // Find Function
        FindFunction();
        done = true;
        break;
    }

    case HY_WINDOW_MENU_ID_EDIT+7: { // Find Function
        HandleSearchAndReplace();
        done = true;
        break;
    }

    case HY_DATA_WIN32_MENU_BASE: { // Partition->Selection
        SelectPartition();
        done = true;
        break;
    }

    case HY_DATA_WIN32_MENU_BASE+1: { // Selection->Partition
        if (sp->selection.lLength) {
            CreatePartition (sp->selection,1,true);
        }
        done = true;
        break;
    }

    case HY_DATA_WIN32_MENU_BASE+2: { // Invert Selection
        InvertSelection();
        done = true;
        break;
    }

    case HY_DATA_WIN32_MENU_BASE+3: { // Parition props
        PartitionPropsMenu ();
        done = true;
        break;
    }

    case HY_DATA_WIN32_MENU_BASE+4: { // Input part
        InputPartitionString ();
        done = true;
        break;
    }

    case HY_DATA_WIN32_MENU_BASE+5: { // Ancestors
        SimulateDataSet (0,true);
        done = true;
        break;
    }

    case HY_DATA_WIN32_MENU_BASE+6: { // Ancestors
        HandleFontChange();
        done = true;
        break;
    }

    case HY_DATALF_WIN32_MENU_BASE: { // Build LF
        if (GetSubMenu (GetSubMenu (GetMenu (theWindow), 3), 0)) {
            InferTopologies ();
        } else {
            BuildLikelihoodFunction();
        }
        done = true;
        break;
    }

    case HY_DATALF_WIN32_MENU_BASE+1: { // Optimize LF
        OptimizeLikelihoodFunction();
        done = true;
        break;
    }

    case HY_DATALF_WIN32_MENU_BASE+2: { // Show Parameters
        DisplayParameterTable ();
        done = true;
        break;
    }

    case HY_DATALF_WIN32_MENU_BASE+3: { // General bootstrap
        //Uncomment when rdy
        OpenGeneralBSWindow ();
        done = true;
        break;
    }

    case HY_DATA_WIN32_MENU_BASE+50: // Block size
    case HY_DATA_WIN32_MENU_BASE+51: {
        treeMenu       = GetSubMenu (GetSubMenu(GetMenu (theWindow),2), 4);
        long             newBlockSize;
        bool             is9 = (msel==HY_DATA_WIN32_MENU_BASE+50);

        if (is9) {
            newBlockSize = 9;
        } else {
            newBlockSize = 10;
        }

        if (sp->blockWidth!=newBlockSize) {
            sp->blockWidth = newBlockSize;
            sp2->blockWidth = newBlockSize;
            sp->BuildPane();
            sp->_MarkForUpdate();
            sp2->BuildPane();
            sp2->_MarkForUpdate();
            CheckMenuItem (treeMenu, 0, MF_BYPOSITION|(is9?MF_CHECKED:MF_UNCHECKED));
            CheckMenuItem (treeMenu, 1, MF_BYPOSITION|((!is9)?MF_CHECKED:MF_UNCHECKED));
        }
        done = true;
        break;
    }

    case HY_DATA_WIN32_MENU_BASE+60: // Repeating character
    case HY_DATA_WIN32_MENU_BASE+61: {
        treeMenu = GetSubMenu (GetSubMenu(GetMenu (theWindow),2), 5);
        bool       newDisplay;
        if (msel==HY_DATA_WIN32_MENU_BASE+60) {
            newDisplay = false;
        } else {
            newDisplay = true;
        }

        if (sp->showDots!=newDisplay) {
            sp->showDots = newDisplay;
            sp->BuildPane();
            sp->_MarkForUpdate();
            CheckMenuItem (treeMenu, newDisplay, MF_BYPOSITION|MF_CHECKED);
            CheckMenuItem (treeMenu, !newDisplay, MF_BYPOSITION|MF_UNCHECKED);
        }
        done = true;
        break;
    }

    case HY_DATA_WIN32_MENU_BASE+70: // Sequence names
    case HY_DATA_WIN32_MENU_BASE+71:
    case HY_DATA_WIN32_MENU_BASE+72:
    case HY_DATA_WIN32_MENU_BASE+73:
    case HY_DATA_WIN32_MENU_BASE+74:
    case HY_DATA_WIN32_MENU_BASE+75: {
        treeMenu = GetSubMenu (GetSubMenu(GetMenu (theWindow),2), 6);
        if (msel<=HY_DATA_WIN32_MENU_BASE+72) {
            unsigned char newDisplay;
            switch (msel) {
            case HY_DATA_WIN32_MENU_BASE+70:
                newDisplay = HY_SEQUENCE_PANE_NAMES_NONE;
                break;
            case HY_DATA_WIN32_MENU_BASE+71:
                newDisplay = HY_SEQUENCE_PANE_NAMES_SHORT;
                break;
            case HY_DATA_WIN32_MENU_BASE+72:
                newDisplay = HY_SEQUENCE_PANE_NAMES_ALL;

            }

            if ((sp->nameDisplayFlags&HY_SEQUENCE_PANE_NAMES_MASK)!=newDisplay) {
                CheckMenuItem (treeMenu, (sp->nameDisplayFlags&HY_SEQUENCE_PANE_NAMES_MASK), MF_BYPOSITION|MF_UNCHECKED);
                sp->SetNameDisplayMode(newDisplay,true);
                sp2->SetNameDisplayMode(newDisplay,true);
                BuildThermometer();
                BuildMarksPane();
                CheckMenuItem (treeMenu, newDisplay, MF_BYPOSITION|MF_CHECKED);
            }
        } else {
            if (msel==HY_DATA_WIN32_MENU_BASE+73) {
                sp->AlphabetizeSpecies();
            } else if (msel==HY_DATA_WIN32_MENU_BASE+74) {
                sp->RevertFileOrder();
            } else {
                sp->CleanUpSequenceNames();
            }
        }
        done = true;
        break;
    }

    case HY_DATA_WIN32_MENU_BASE+80: // status lines
    case HY_DATA_WIN32_MENU_BASE+81: // status lines
    case HY_DATA_WIN32_MENU_BASE+82: // status lines
    case HY_DATA_WIN32_MENU_BASE+83: { // status lines
        treeMenu = GetSubMenu (GetSubMenu(GetMenu (theWindow),2), 8);
        if (AdjustStatusLine (msel-HY_DATA_WIN32_MENU_BASE-80)) {
            CheckMenuItem(treeMenu,msel-HY_DATA_WIN32_MENU_BASE-80,MF_BYPOSITION|MF_CHECKED);
        } else {
            CheckMenuItem(treeMenu,msel-HY_DATA_WIN32_MENU_BASE-80,MF_BYPOSITION|MF_UNCHECKED);
        }

        done = true;
        break;
    }

    case HY_DATALF_WIN32_MENU_BASE+50: // likelihood display
    case HY_DATALF_WIN32_MENU_BASE+51: // likelihood display
    case HY_DATALF_WIN32_MENU_BASE+52: // likelihood display
    case HY_DATALF_WIN32_MENU_BASE+53: // likelihood display
    case HY_DATALF_WIN32_MENU_BASE+54: { // likelihood display
        ComputeLikelihoodFunction (msel-HY_DATALF_WIN32_MENU_BASE-50);
        done = true;
        break;
    }

    case HY_DATA_WIN32_MENU_BASE+90: // simulate data set
    case HY_DATA_WIN32_MENU_BASE+91: // simulate data set
    case HY_DATA_WIN32_MENU_BASE+92: { // simulate data set
        SimulateDataSet (msel-HY_DATA_WIN32_MENU_BASE-90);
        done = true;
        break;
    }

    case HY_WINDOW_MENU_ID_FILE+1: // save/save as
    case HY_WINDOW_MENU_ID_FILE+3: { // save/save as
        SaveDataPanel (msel==HY_WINDOW_MENU_ID_FILE+1);
        done = true;
        break;
    }

    case HY_DATALF_WIN32_MENU_BASE+20: // infer
    case HY_DATALF_WIN32_MENU_BASE+21: { // infer
        InferTopologies (msel==HY_DATALF_WIN32_MENU_BASE+21);
        _VerifyInferMenu ();
        done = true;
        break;
    }

    default: {
        if (msel>=HY_DATA_WIN32_MENU_BASE+10000) {
            RestoreOmittedSequence(msel-HY_DATA_WIN32_MENU_BASE-10003);
            done = true;
            break;
        } else {
            if (msel >= HY_DATA_WIN32_MENU_BASE + 100) {
                ExecuteProcessor (msel-HY_DATA_WIN32_MENU_BASE-100);
                break;
            }
        }
    }
    }
    DrawMenuBar(theWindow);
    return done;
}

//__________________________________________________________________

void        _HYDataPanel::_PaintThermRect(bool update)
{
    navRect = ComputeNavRect();

    _HYCanvas* theCanvas = (_HYCanvas*)GetObject (1);

    HDC        windowDC = GetDC (theWindow);
    RECT       r;

    r.left   = navRect.left+theCanvas->rel.left+thermRect.left+1;
    r.right  = navRect.right+theCanvas->rel.left+thermRect.left-1;
    r.top    = navRect.top+theCanvas->rel.top+thermRect.top+1;
    r.bottom = navRect.bottom+theCanvas->rel.top+thermRect.top-1;

    HBRUSH     newBr  = CreateSolidBrush (RGB(255,151,51));


    FrameRect (windowDC,&r,newBr);
    InflateRect (&r, -1, -1);
    FrameRect (windowDC,&r,newBr);
    InflateRect (&r, 1, 1);

    DeleteObject (newBr);

    if (update) {
        HRGN        newClip = CreateRectRgn (r.left,r.top,r.right,r.bottom),
                    oldClip = CreateRectRgn (0,0,1,1);

        if (GetClipRgn (windowDC, oldClip) == 0) {
            DeleteObject (oldClip);
            oldClip = nil;
        }

        SelectClipRgn      (windowDC, nil);
        ExtSelectClipRgn   (windowDC, newClip,RGN_XOR);
        DeleteObject       (newClip);
        newClip = CreateRectRgn (r.left+2,r.top+2,r.right-2,r.bottom-2);
        ExtSelectClipRgn   (windowDC, newClip,RGN_OR);

        _HYRect rect;
        rect.left   = componentL.lData[1];
        rect.right  = componentR.lData[1];
        rect.top    = componentT.lData[1];
        rect.bottom = componentB.lData[1];
        rect.width  = (long)windowDC;
        theCanvas->_Paint((char*)&rect);

        SelectClipRgn (windowDC, oldClip);
        if (oldClip) {
            DeleteObject (oldClip);
        }
        DeleteObject (newClip);
    }

    ReleaseDC (theWindow, windowDC);
    _PaintLFStatus ();
}

//__________________________________________________________________

void        _HYDataPanel::_PaintLFStatus(void)
{
    HDC theDC = GetDC (theWindow);
    if (lfID<0) {
        _SimpleList goodP;
        bool    paintOrange = GenerateGoodPartitions (goodP);

        if (goodP.lLength) {
            _PaintTheCircle (paintOrange?orangeButtonIcon:yellowButtonIcon,theWindow, theDC);
        } else {
            _PaintTheCircle (redButtonIcon,theWindow, theDC);
        }
    } else {
        _PaintTheCircle (greenButtonIcon,theWindow, theDC);
    }

    ReleaseDC (theWindow, theDC);
}

//__________________________________________________________________

void        _HYDataPanel::_PrintData(void)
{
    DOCINFO                 di = {sizeof(DOCINFO), "HYPHY.out", NULL };
    PRINTDLG                pd;
    BOOL                    SuccessFlag;

    pd.lStructSize         = sizeof(PRINTDLG);
    pd.hwndOwner           = theWindow;
    pd.hDevMode            = NULL;
    pd.hDevNames           = NULL;
    pd.hDC                 = NULL;
    pd.Flags               = PD_COLLATE | PD_RETURNDC | PD_NOSELECTION;
    pd.nFromPage           = 1;
    pd.nToPage             = 0xffff;
    pd.nMinPage            = 1;
    pd.nMaxPage            = 0xffff;
    pd.nCopies             = 1;
    pd.hInstance           = NULL;
    pd.lCustData           = 0L;
    pd.lpfnPrintHook       = NULL;
    pd.lpfnSetupHook       = NULL;
    pd.lpPrintTemplateName = NULL;
    pd.lpSetupTemplateName = NULL;
    pd.hPrintTemplate      = NULL;
    pd.hSetupTemplate      = NULL;

    if (!PrintDlg(&pd)) {
        return;
    }

    if (pd.hDC == NULL) {
        pd.hDC = GetPrinterDeviceContext(theWindow);
    }


    EnableWindow(theWindow, FALSE);

    SuccessFlag   = TRUE;
    UserAbortFlag = FALSE;

    PrintDialogHandle = CreateDialog(GetModuleHandle(NULL), (LPCTSTR)"PrintDlgBox", theWindow,
                                     PrintDialogProc);
    SetDlgItemText(PrintDialogHandle, IDD_FNAME, "Table Printing...");

    SetAbortProc(pd.hDC, AbortProc);

    if (StartDoc(pd.hDC, &di) > 0) {
        _HYSequencePane* sp = (_HYSequencePane*)GetObject (0);
        HDC         windowDC = GetDC (theWindow);

        long        printW = GetDeviceCaps(pd.hDC, HORZRES),
                    printH = GetDeviceCaps(pd.hDC, VERTRES),

                    hRes = GetDeviceCaps(pd.hDC, LOGPIXELSX),
                    vRes = GetDeviceCaps(pd.hDC, LOGPIXELSY),

                    screenHRes = GetDeviceCaps(windowDC, LOGPIXELSX),
                    screenVRes = GetDeviceCaps(windowDC, LOGPIXELSY),

                    fromPage = pd.nMinPage,
                    toPage   = pd.nMaxPage;


        if (pd.Flags & PD_PAGENUMS) {
            fromPage = pd.nFromPage;
            toPage   = pd.nToPage;
        }

        ReleaseDC   (theWindow, windowDC);
        hRes = printW*((_Parameter)screenHRes/hRes);
        vRes = printH*((_Parameter)screenVRes/vRes);
        screenHRes = printW;
        screenVRes = printH;

        printW = hRes;
        printH = vRes;

        long
        vOffset = vOffset = sp->GetSlotHeight()*sp->speciesIndex.lLength+sp->GetSlotHeight()*3/2+1+20*(dataPartitions.lLength>0),
        cOffset = (printW-sp->headerWidth)/sp->charWidth,
        pageShift = printH/vOffset,
        sC = sp->startColumn,
        lC = sp->endColumn,
        sR = sp->startRow,
        lR = sp->endRow,
        sH = sp->settings.bottom,
        pageCount;

        _HYColor c1 = sp->backColor,
                 c2 = sp->headerColor,
                 bc = {0,0,0};


        sp->backColor   = (_HYColor) {
            255,255,255
        };
        sp->headerColor = (_HYColor) {
            255,255,255
        };
        cOffset     -= ((cOffset/sp->blockWidth)*2)/sp->charWidth;
        cOffset     = (cOffset/sp->blockWidth)*sp->blockWidth;
        pageShift   *= cOffset;
        if (sp->columnStrings.lLength%pageShift==0) {
            pageShift = sp->columnStrings.lLength / pageShift;
        } else {
            pageShift = sp->columnStrings.lLength / pageShift + 1;
        }

        if (toPage > pageShift) {
            toPage = pageShift;
        }


        sp->startColumn = 0;
        sp->endColumn = cOffset;
        sp->startRow = 0;
        sp->endRow = sp->speciesIndex.lLength;
        sp->settings.bottom = vOffset+5+HY_SCROLLER_WIDTH;

        for (pageCount = 1; pageCount<fromPage; pageCount++) {
            sp->endColumn       +=  printH/vOffset * cOffset;
            sp->startColumn     +=  printH/vOffset * cOffset;
        }

        RECT         hangover = {0,sp->headerWidth + cOffset * sp->charWidth + (cOffset * 2)/sp->blockWidth + 1,
                                 vOffset,printW
                                },
                     frame = {0,0,vOffset+1,hangover.left};

        if (sp->startColumn< sp->columnStrings.lLength)
            for (pageCount = fromPage; pageCount<=toPage; pageCount++) {
                pageShift       = vOffset;
                if (StartPage (pd.hDC) <= 0) {
                    SuccessFlag = FALSE;
                    break;
                }

                SetMapMode  (pd.hDC, MM_ISOTROPIC);
                SetWindowExtEx (pd.hDC, hRes, vRes,nil);
                SetViewportExtEx (pd.hDC, screenHRes, screenVRes, nil);
                HDC saveDC = sp->thePane;
                sp->thePane = pd.hDC;
                sp->_HYGraphicPane::SetFont     (sp->GetFont());
                sp->SetColor    (sp->GetColor());
                while (pageShift < printH) {
                    sp->BuildPane   (false);
                    if (dataPartitions.lLength) {
                        _HYRect          daFrame;
                        daFrame.top    = frame.bottom;
                        daFrame.bottom = frame.bottom + 20;
                        daFrame.left   = frame.left   + HY_SEQUENCE_PANE_CHAR_SPACING/2 + sp->headerWidth;
                        daFrame.right  = daFrame.left + cOffset*sp->charWidth + 2*(cOffset/sp->blockWidth) - HY_SCROLLER_WIDTH;
                        BuildThermometer (&daFrame);
                    }
                    sp->startColumn = sp->endColumn;
                    sp->endColumn += cOffset;
                    sp->SetColor (bc);
                    SetWindowOrgEx (pd.hDC,0,-pageShift,nil);
                    pageShift += vOffset;
                    if (sp->startColumn>=sp->columnStrings.lLength) {
                        break;
                    }
                }
                sp->thePane = saveDC;
                if (EndPage (pd.hDC) <= 0) {
                    SuccessFlag = FALSE;
                }
            }

        sp->startColumn = sC;
        sp->endColumn   = lC;
        sp->startRow    = sR;
        sp->endRow      = lR;
        sp->backColor   = c1;
        sp->headerColor = c2;
        sp->settings.bottom = sH;

    } else {
        SuccessFlag = FALSE;
    }

    if (SuccessFlag) {
        SuccessFlag = (EndDoc(pd.hDC)>0);
    }

    if (!UserAbortFlag) {
        EnableWindow(theWindow, TRUE);
        DestroyWindow(PrintDialogHandle);
    }

    DeleteDC (pd.hDC);

    if (!SuccessFlag && !UserAbortFlag) {
        _String errMsg = _String("Failed to print sequence data. Windows Error:") & (long)GetLastError();
        ProblemReport (errMsg,nil);
    }
}

//__________________________________________________________________

void _HYDataPanel::_VerifyInferMenu(void)
{
    HMENU       lfMenu          = GetSubMenu (GetMenu (theWindow), 3),
                inferSubMenu = GetSubMenu (lfMenu, 0);

    _SimpleList    gp;

    if (GenerateGoodPartitions(gp)) {
        if (!inferSubMenu) {
            inferSubMenu    = CreatePopupMenu ();
            checkPointer    (inferSubMenu);

            InsertMenu      (inferSubMenu,  0xFFFFFFFF, MF_BYPOSITION|MF_STRING, HY_DATALF_WIN32_MENU_BASE+20,
                             "&Infer Topology\tCtrl-L");
            InsertMenu      (inferSubMenu,  0xFFFFFFFF, MF_BYPOSITION|MF_STRING, HY_DATALF_WIN32_MENU_BASE+21,
                             "Infer Topology with Constraints");

            ModifyMenu      (lfMenu,0,MF_BYPOSITION|MF_POPUP,(UINT)inferSubMenu,"&Inference");
        }
    } else {
        if (inferSubMenu) {
            MENUITEMINFO    mInfo;
            mInfo.cbSize = sizeof (MENUITEMINFO);
            mInfo.fMask  = MIIM_SUBMENU;
            mInfo.hSubMenu = nil;
            SetMenuItemInfo (lfMenu, 0, true, &mInfo);

            ModifyMenu      (lfMenu,0,MF_BYPOSITION|MF_STRING,HY_DATALF_WIN32_MENU_BASE,"&Build\tCtrl-L");
            //ModifyMenu        (lfMenu,0,MF_BYPOSITION|MF_STRING,HY_DATALF_WIN32_MENU_BASE,"&Build\tCtrl-L");
            //DestroyMenu       (inferSubMenu);
        }
    }
    DrawMenuBar(theWindow);
}

//__________________________________________________________________

void _HYDataPanel::_UpdateLFMenu (void)
{
    HMENU      lfMenu   = GetSubMenu (GetMenu (theWindow), 3),
               dataMenu = GetSubMenu (GetMenu (theWindow), 2),

               addMenu  = GetSubMenu (dataMenu, 8);

    if (lfMenu && dataMenu && addMenu) {
        if (lfID>=0) {
            EnableMenuItem (lfMenu,1,MF_BYPOSITION|MF_ENABLED);
            EnableMenuItem (lfMenu,2,MF_BYPOSITION|MF_ENABLED);
            EnableMenuItem (lfMenu,4,MF_BYPOSITION|MF_ENABLED);
            EnableMenuItem (lfMenu,6,MF_BYPOSITION|MF_ENABLED);

            EnableMenuItem (dataMenu,13,MF_BYPOSITION|MF_ENABLED);
            EnableMenuItem (dataMenu,14,MF_BYPOSITION|MF_ENABLED);

            if (((_LikelihoodFunction*)likeFuncList (lfID))->GetCategoryVars().lLength) {
                EnableMenuItem (addMenu,1,MF_BYPOSITION|MF_ENABLED);
                DrawMenuBar(theWindow);
                return;
            }
        } else {
            EnableMenuItem (lfMenu,1,MF_BYPOSITION|MF_GRAYED);
            EnableMenuItem (lfMenu,2,MF_BYPOSITION|MF_GRAYED);
            EnableMenuItem (lfMenu,4,MF_BYPOSITION|MF_GRAYED);
            EnableMenuItem (lfMenu,6,MF_BYPOSITION|MF_GRAYED);

            EnableMenuItem (dataMenu,13,MF_BYPOSITION|MF_GRAYED);
            EnableMenuItem (dataMenu,14,MF_BYPOSITION|MF_GRAYED);
        }
        EnableMenuItem (addMenu,1,MF_BYPOSITION|MF_GRAYED);
    }
    DrawMenuBar(theWindow);
}

//__________________________________________________________________

void _HYDataPanel::_UpdateSelectionChoices (bool toggle)
{
    HMENU dataMenu  = GetSubMenu (GetMenu (theWindow), 2);

    if (toggle) {
        EnableMenuItem(dataMenu,1,MF_BYPOSITION|MF_ENABLED);
    } else {
        EnableMenuItem(dataMenu,1,MF_BYPOSITION|MF_GRAYED);
    }
    DrawMenuBar(theWindow);
}

//__________________________________________________________________

void _HYDataPanel::_CopySelectionToClipboard (void)
{
    _HYSequencePane*    sp = (_HYSequencePane*)GetObject(0);
    _String             cbStr (128L,true);

    if (sp->selection.lLength) {
        for (long m=0; m<sp->speciesIndex.lLength; m++) {
            long idx = sp->speciesIndex.lData[m];
            for (long k=0; k<sp->selection.lLength; k++) {
                cbStr << ((_String*)(sp->columnStrings(sp->selection.lData[k])))->sData[idx];
                if (k&&((k+1)%sp->blockWidth==0)) {
                    cbStr << ' ';
                }
            }
            cbStr << '\r';
            cbStr << '\n';
        }
    } else if (sp->vselection.lLength)
        for (long m=0; m<sp->vselection.lLength; m++) {
            cbStr << (_String*)(sp->rowHeaders(sp->speciesIndex(sp->vselection.lData[m])));
            cbStr << '\r';
            cbStr << '\n';
        }

    cbStr.Finalize();

    if (cbStr.sLength) {
        HGLOBAL TextHandle = GlobalAlloc(GHND, cbStr.sLength+1);
        if (TextHandle) {
            char *TextPtr = (char*)GlobalLock(TextHandle);
            char *SourcePtr = cbStr.sData;
            for (; *SourcePtr; SourcePtr++) {
                *TextPtr++ = *SourcePtr;
            }
            *TextPtr = '\0';
            GlobalUnlock(TextHandle);
            OpenClipboard(theWindow);
            EmptyClipboard();
            SetClipboardData(CF_TEXT, TextHandle);
            CloseClipboard();
        }
    }
}

//__________________________________________________________________

void _HYDataPanel::_OmitSelectedSpecies (_SimpleList& idx)
{
    HMENU      dataMenu       = GetSubMenu (GetMenu (theWindow), 2),
               omittedSpecies = GetSubMenu (dataMenu, 7);

    if (omittedSpecies) {
        _HYSequencePane*    sp = (_HYSequencePane*)GetObject(0);
        long                idxShift = 10001+GetMenuItemCount (omittedSpecies);

        for (long k=0; k<idx.lLength; k++) {
            _String*        thisSpec = (_String*)sp->rowHeaders(idx.lData[k]);
            InsertMenu      (omittedSpecies,  0xFFFFFFFF, MF_BYPOSITION|MF_STRING, HY_DATA_WIN32_MENU_BASE+idxShift+k, thisSpec->sData);
        }

        EnableMenuItem (dataMenu,7, MF_BYPOSITION|MF_ENABLED);
        DrawMenuBar (theWindow);
    }
}

//__________________________________________________________________

void _HYDataPanel::_RestoreOmittedSequence (long index)
{
    HMENU      dataMenu       = GetSubMenu (GetMenu (theWindow), 2),
               omittedSpecies = GetSubMenu (dataMenu, 7);

    if (index>=0) {
        DeleteMenu  (omittedSpecies,index+2, MF_BYPOSITION);
        long        mic = GetMenuItemCount (omittedSpecies);

        MENUITEMINFO mi;
        mi.cbSize = sizeof (MENUITEMINFO);
        mi.fMask  = MIIM_ID;
        mi.wID    = HY_DATA_WIN32_MENU_BASE+10003+index;

        for (long k=index+2; k<mic; k++, mi.wID++) {
            SetMenuItemInfo (omittedSpecies, k, true, &mi);
        }

        if (mic==2) {
            EnableMenuItem (dataMenu,7, MF_BYPOSITION|MF_GRAYED);
        }
    } else {
        for (long k=0; k< omittedSeqs.lLength; k++) {
            DeleteMenu (omittedSpecies,2,MF_BYPOSITION);
        }

        EnableMenuItem (dataMenu,7, MF_BYPOSITION|MF_GRAYED);
    }
    DrawMenuBar (theWindow);
}

//__________________________________________________________________

void _HYDataPanel::_UpdatePartitionOperations (_SimpleList* sl)
{
    HMENU      dataMenu       = GetSubMenu (GetMenu (theWindow), 2);

    if (sl->lData[0]) {
        EnableMenuItem (dataMenu,0 , MF_BYPOSITION|MF_ENABLED);
        EnableMenuItem (dataMenu,10, MF_BYPOSITION|MF_ENABLED);
    } else {
        EnableMenuItem (dataMenu,0 , MF_BYPOSITION|MF_GRAYED);
        EnableMenuItem (dataMenu,10, MF_BYPOSITION|MF_GRAYED);
    }
    DrawMenuBar (theWindow);
}

//__________________________________________________________________

void _HYDataPanel::_UnsetMenuBar(void)
{
}

//__________________________________________________________________
bool _HYDataPanel::_ProcessOSEvent (Ptr vEvent)
{
    static  long        clickH   = 0;
    static  bool        isNavBar = false;

    if (!_HYTWindow::_ProcessOSEvent (vEvent)) {
        _HYWindowsUIMessage *theEvent = (_HYWindowsUIMessage*)vEvent;

        if ((theEvent->iMsg==WM_LBUTTONDOWN)||(theEvent->iMsg==WM_LBUTTONDBLCLK)
                ||(theEvent->iMsg==WM_RBUTTONDOWN)||(theEvent->iMsg==WM_MOUSEMOVE)) {
            int   ch = LOWORD(theEvent->lParam),
                  cv = HIWORD(theEvent->lParam),
                  c  = FindClickedCell(ch, cv);

            if (c<0) {
                return false;
            }

            _HYComponent* thisComponent = (_HYComponent*)components(c);

            if (c==1) { // navBar
                ch = ch-componentL.lData[1]-thermRect.left;
                cv = cv-componentT.lData[1]-thermRect.top;

                if (theEvent->iMsg==WM_LBUTTONDBLCLK) {
                    NavBarDblClick (ch);
                    return true;
                }
                if (navRect.Contains(ch,cv)||isNavBar) {
                    if ((theEvent->iMsg==WM_MOUSEMOVE)&&(theEvent->wParam & MK_LBUTTON)) {
                        isNavBar = true;
                        SetNavRectCenter (LOWORD(theEvent->lParam)-componentL.lData[1]-thermRect.left+clickH,0);
                    } else {
                        if (theEvent->iMsg==WM_LBUTTONDOWN) {
                            clickH = (navRect.right+navRect.left)/2-ch;
                        }
                        isNavBar = false;
                    }
                } else {
                    if (theEvent->iMsg==WM_LBUTTONDOWN) {
                        SetNavRectCenter (ch,cv);
                    }
                }

                //lastH = LOWORD(theEvent->lParam);
                //lastV = HIWORD(theEvent->lParam);

                return true;
            } else if ((c==4)&&(theEvent->iMsg==WM_RBUTTONDOWN)) {
                _HYSequencePane* sp2 = (_HYSequencePane*)components (4);
                sp2->ProcessContextualPopUp (ch,cv);
                return true;
            }
        } else if (theEvent->iMsg==WM_KEYDOWN) {
            TCHAR keyCode = theEvent->wParam;
            if ((keyCode==VK_LEFT)||(keyCode==VK_RIGHT)) { // left/right arrow
                _HYSequencePane* sp = (_HYSequencePane*) GetObject (0);
                if ((keyCode==VK_LEFT)&&(sp->startColumn)) {
                    sp->HScrollPane (-1);
                } else if ((keyCode==VK_RIGHT)&&(sp->endColumn<sp->columnStrings.lLength)) {
                    sp->HScrollPane (1);
                }
                return true;
            }
        } else if (theEvent->iMsg==WM_LBUTTONUP) {
            isNavBar = false;
            return   true;
        }
    } else {
        return true;
    }

    return false;
}



//EOF