/*
    A general composite window component object, Windows specifics

    Sergei L. Kosakovsky Pond, June 2000-June 2002.
*/

#ifndef _HYPCOMPONENT_
#define _HYPCOMPONENT_
#pragma once

#include "HYBaseGUI.h"
#include "Windows.h"

#define  HY_COMPONENT_ENABLE_H_SCROLL 0x01
#define  HY_COMPONENT_ENABLE_V_SCROLL 0x02

#define  HY_SCROLLER_WIDTH 16

//__________________________________________________________________

class _HYPlatformComponent
{

public:

    _HYPlatformComponent(void);
    _HYPlatformComponent(_HYRect,Ptr);
    // settings

    virtual ~_HYPlatformComponent() {};

    virtual void        Duplicate (BaseRef);

    virtual void        _CleanUp   (void);

    virtual void        _SetDimensions (_HYRect,_HYRect);
    virtual void        _SetVisibleSize(_HYRect);

    virtual void        _Paint (Ptr);
    virtual void        _Update (Ptr);
    virtual bool        _ProcessOSEvent (Ptr);
    virtual _HYRect     _VisibleContents(Ptr);
    virtual void        _MarkForUpdate (void);


// new

    virtual void        _MarkContentsForUpdate (void);
    virtual long        _GetHScrollerPos (void);
    virtual long        _GetVScrollerPos (void);
    virtual void        _SetHScrollerPos (long);
    virtual void        _SetVScrollerPos (long);
    virtual void        _Activate (void);
    virtual void        _Deactivate(void);
    virtual void        _ComponentMouseExit (void) {}



    HWND          parentWindow,
                  vScroll,
                  hScroll;

    bool          activationFlag;

    _HYRect       rel;

    char          scrollState;
};

//__________________________________________________________________

void                AlignRectangle   (_HYRect& rel , RECT& target , unsigned char alFlags);
COLORREF            HYColor2ColorRef (_HYColor&, HDC);
RECT                HYRect2Rect      (_HYRect&);
#endif

//EOF