/*
    Graphics Window Object  for Win32 API

    Sergei L. Kosakovsky Pond, June 2000-December 2002
*/

#include "HYGWindow.h"
#include "HYEventTypes.h"
#include "HYUtils.h"

//__________________________________________________________________

void    _HYGWindow::_Paint (Ptr p)
{
    RECT srcRect,destRect;
    GetClientRect (theWindow,&destRect);
    destRect.right;
    destRect.bottom;
    int t,l,b,r;
    _VisibleContents (t,l,b,r);
    srcRect.top = t;
    srcRect.left = l;
    srcRect.bottom = b;
    srcRect.right = r;
    InvalidateRect (theWindow,&destRect,FALSE);
    PAINTSTRUCT      thePS;
    HDC theContext = BeginPaint (theWindow,&thePS);
    BitBlt (theContext,0,0,srcRect.right-srcRect.left,srcRect.bottom-srcRect.top,
            thePane,srcRect.left,srcRect.top,SRCCOPY);
    EndPaint (theWindow,&thePS);
}

//__________________________________________________________________

void    _HYGWindow::_Update (Ptr p)
{
    _Paint (p);
}

//__________________________________________________________________


bool        _HYGWindow::_ProcessMenuSelection (long msel)
{
    if (_HYWindow::_ProcessMenuSelection(msel)) {
        return true;
    }

    bool        done = false;
    switch (msel) {

    case HY_WINDOW_MENU_ID_EDIT+1: {
        _CopyToClipboard ();
        done = true;
    }
    break;

    case HY_WINDOW_MENU_ID_FILE+1: {
        _SavePicture (GetTitle());
        done = true;
    }
    break;
    }


    return done;
}

//__________________________________________________________________

void _HYGWindow::_SetMenuBar(void)
{
    _HYWindow::_SetMenuBar();
    HMENU        fileHandle = GetSubMenu(GetMenu (theWindow),1);

    EnableMenuItem (fileHandle, 2, MF_BYPOSITION|MF_ENABLED);

    _AddStandardAccels();
    _BuildAccelTable  ();

    accels.Clear();
}

//__________________________________________________________________

void _HYGWindow::_UnsetMenuBar(void)
{
}


//EOF