/*
    Container Window Object  for Win32 API

    Sergei L. Kosakovsky Pond, June 2000-December 2002
*/

#include "HYWindow.h"
#include "HYEventTypes.h"
#include "HYTableWindow.h"
#include "HYUtils.h"


//__________________________________________________________________

HFONT           _HY_StatusBarFont = //CreateFont (12,0,0,0,0,0,FALSE,FALSE,ANSI_CHARSET,OUT_DEFAULT_PRECIS,
    //CLIP_DEFAULT_PRECIS,DEFAULT_QUALITY,DEFAULT_PITCH|FF_DONTCARE,"Times Roman");
    CreateFont (10,0,0,0,400,FALSE,FALSE,FALSE,ANSI_CHARSET,OUT_DEFAULT_PRECIS,
                CLIP_DEFAULT_PRECIS,DEFAULT_QUALITY,DEFAULT_PITCH|FF_SWISS,"MS Sans Serif");


HPEN            _BLACKPEN_        = CreatePen  (PS_SOLID,1,RGB(0,0,0));

//__________________________________________________________________

VOID CALLBACK IdleWindowTimer (HWND hwnd, UINT uMsg, UINT_PTR idEvent, DWORD dwTime)
{
    if (idEvent == IDLE_WINDOW_TIMER) {
        _HYTWindow * myTW = (_HYTWindow*)windowObjects(windowPtrs.Find((long)hwnd));
        for (long k=0; k<myTW->components.lLength; k++)
            if (myTW->cells.Find(k)>=0) {
                _HYComponent* tC = (_HYComponent*)myTW->components(k);
                tC->IdleHandler();
            }

        myTW->_HandleIdleEvent ();
    }
}

//__________________________________________________________________

long _HYTWindow::_Grow(Ptr theData)
{
    RECT myDims;
    GetClientRect (theWindow,&myDims);

    SetWindowRectangle (0,0,myDims.bottom,myDims.right,false);

    GetClientRect  (theWindow,&myDims);
    InvalidateRect (theWindow,&myDims,false);

    return 0;
}

//__________________________________________________________________

void _HYTWindow::_PaintStatusBar(Ptr hdc, bool)
{
    if ((flags&HY_WINDOW_SCROLL)==0) {
        RECT clearRect;
        GetClientRect (theWindow, &clearRect);

        clearRect.left--;
        clearRect.top = clearRect.bottom-HY_SCROLLER_WIDTH;
        clearRect.bottom++;

        HDC      windowContext;

        if (hdc) {
            windowContext = (HDC)hdc;
        } else {
            windowContext = GetDC (theWindow);
        }

        FillRect (windowContext, &clearRect, windowStatusBarBrush);

        HPEN     savePen = (HPEN)SelectObject (windowContext, _BLACKPEN_);

        /*MoveToEx (windowContext,clearRect.left,clearRect.top,NULL);
        LineTo (windowContext,clearRect.right,clearRect.top);*/

        DrawEdge (windowContext, &clearRect, EDGE_SUNKEN, BF_TOP);

        SelectObject (windowContext, savePen);

        if (statusBar.sLength) {
            UINT  saveAlign  = GetTextAlign (windowContext);
            int   saveBkMode = GetBkMode (windowContext);

            SetTextAlign (windowContext, TA_BASELINE);
            SetBkMode    (windowContext, TRANSPARENT);
            HFONT saveFont = (HFONT)SelectObject (windowContext, _HY_StatusBarFont);

            TextOut (windowContext, (flags&HY_WINDOW_STATUS_BAR_LIGHT_LEFT)?20:5,
                     clearRect.bottom-4, statusBar.sData, statusBar.sLength);

            SetBkMode    (windowContext, saveBkMode);
            SelectObject (windowContext, saveFont);
            SetTextAlign (windowContext, saveAlign);
        }

        if (!hdc) {
            ReleaseDC (theWindow,windowContext);
        }
    }
}

//__________________________________________________________________

void _HYTWindow::_Paint(Ptr)
{
    if (!GetUpdateRect(theWindow,NULL,FALSE)) {
        return;
    }
    PAINTSTRUCT      thePS;
    HDC theContext = BeginPaint (theWindow,&thePS);
    _HYRect  relRect;
    relRect.width = (long)theContext;

    _SimpleList     alreadyDone (components.lLength);

    for (int k=0; k<cells.lLength; k++) {
        long i = cells.lData[k];

        if (alreadyDone.lData[i] == 0) {
            relRect.left = componentL.lData[i];
            relRect.right = componentR.lData[i];
            relRect.top = componentT.lData[i];
            relRect.bottom = componentB.lData[i];
            ((_HYComponent*)components(i))->Update((Ptr)&relRect);
            alreadyDone.lData[i] = 1;
        }
    }
    if(flags&HY_WINDOW_SIZE) {
        _PaintStatusBar((Ptr)theContext);
    }

    EndPaint (theWindow,&thePS);
}

//__________________________________________________________________

void _HYTWindow::_Update(Ptr)
{
    _Paint(nil);
}


//__________________________________________________________________
void        _HYTWindow::_SetStatusBar(_String& text)
{
    statusBar = text;
    _PaintStatusBar();
}

//__________________________________________________________________

bool _HYTWindow::_ProcessOSEvent (Ptr vEvent)
{
    _HYWindowsUIMessage * theEvent = (_HYWindowsUIMessage *)vEvent;
    long       invisPixels;
    long       currentValue, oldValue;
    POINT      localPoint;
    int        c;
    RECT       bigR, smallR;
    MINMAXINFO* windowInfo;

    switch (theEvent->iMsg) {
    case WM_HSCROLL:
    case WM_VSCROLL: {
        HWND sW = (HWND)theEvent->lParam;
        if (sW) {
            for (int i=0; i<components.lLength; i++) {
                _HYComponent *thisC = (_HYComponent*)components(i);
                if ((thisC->hScroll==sW)||(thisC->vScroll==sW)) {
                    return thisC->_ProcessOSEvent (vEvent);
                }
            }
        }
        return true;
    }

    case WM_LBUTTONDOWN:
    case WM_LBUTTONDBLCLK:
    case WM_RBUTTONDBLCLK:
    case WM_LBUTTONUP:
    case WM_RBUTTONDOWN:
    case WM_RBUTTONUP:
    case 0x020A:
        if (trackMouseComponent) {
            return ((_HYComponent*)trackMouseComponent)->_ProcessOSEvent (vEvent);
        }
        if (theEvent->iMsg == 0x020A) {
            localPoint = (POINT) {
                LOWORD(theEvent->lParam),HIWORD(theEvent->lParam)
            };
            ScreenToClient (theWindow, &localPoint);
            c = FindClickedCell(localPoint.x, localPoint.y);
            if (c<0) {
                return false;
            }
            DoMouseWheel (c, ((signed short)HIWORD(theEvent->wParam))/120);
            return true;
        }
        c = FindClickedCell(LOWORD(theEvent->lParam),HIWORD(theEvent->lParam));
        if (c<0) {
            return false;
        }
        return ((_HYComponent*)components(c))->_ProcessOSEvent (vEvent);
        break;


    case WM_GETMINMAXINFO:

        windowInfo = (MINMAXINFO*)theEvent->lParam;

        if ((hWindowPad==0)&&(vWindowPad==0))
            if (!IsIconic (theWindow)) {
                GetClientRect (theWindow,&smallR);
                ::GetWindowRect (theWindow,&bigR);
                hWindowPad = bigR.right-bigR.left-smallR.right-1;
                vWindowPad = bigR.bottom-bigR.top-smallR.bottom-1;
            }

        windowInfo->ptMinTrackSize.x = dim.left+hWindowPad-1;
        windowInfo->ptMinTrackSize.y = dim.top+vWindowPad-1;
        windowInfo->ptMaxSize.x=windowInfo->ptMaxTrackSize.x = dim.right+hWindowPad;
        windowInfo->ptMaxSize.y=windowInfo->ptMaxTrackSize.y = dim.bottom+vWindowPad;

        return false;
        break;

        /*case WM_DESTROY:
        {
            KillTimer (theWindow,idleTimer);
            break;
        }*/

    case WM_CHAR:
    case WM_KEYDOWN: {
        if (keyboardFocusChain.lLength) {
            int keyCode = theEvent->wParam;
            if (keyCode == VK_TAB) { // tab
                bool    backwards = (GetAsyncKeyState (VK_SHIFT) & 0x8000);

                if (keyboardFocus==-1) {
                    keyCode = keyboardFocusChain.lData[backwards?keyboardFocusChain.lLength-1:0];
                } else if (keyboardFocusChain.lLength>1) {
                    keyCode = keyboardFocusChain.Find (keyboardFocus);
                    keyCode += backwards?(-1):1;
                    if (keyCode<0) {
                        keyCode = keyboardFocusChain.lLength-1;
                    } else if (keyCode >= keyboardFocusChain.lLength) {
                        keyCode = 0;
                    }
                    keyCode = keyboardFocusChain.lData[keyCode];
                } else {
                    keyCode = -1;
                }

                if (keyCode>=0) {
                    ProcessEvent (generateKeyboardFocusEvent (((_HYComponent*)components(keyCode))->GetID()));
                }
                return true;
            }
        }

        for (long k=0; k<components.lLength; k++)
            if (cells.Find(k)>=0) {
                _HYComponent* tC = (_HYComponent*)components(k);
                if (tC->UnfocusedKeyboardInput())
                    if (tC->_ProcessOSEvent (vEvent)) {
                        return true;
                    }
            }

        if ((keyboardFocus>=0)&&(keyboardFocus<components.lLength)) {
            if (((_HYComponent*)components(keyboardFocus))->_ProcessOSEvent (vEvent)) {
                return true;
            }
        }

        return false;
    }


    case WM_MOUSEMOVE: {
        if (trackMouseComponent) {
            return ((_HYComponent*)trackMouseComponent)->_ProcessOSEvent (vEvent);
        }

        int c = FindClickedCell(LOWORD(theEvent->lParam),HIWORD(theEvent->lParam));
        if (c<0) {
            if (lastMouseComponent>=0) {
                ((_HYComponent*)components(lastMouseComponent))->_ComponentMouseExit();
            }
            lastMouseComponent = -1;
            return false;
        } else {
            if (lastMouseComponent>=0) {
                if (c!=lastMouseComponent) {
                    ((_HYComponent*)components(lastMouseComponent))->_ComponentMouseExit();
                }
            } else {
                SetCursor (LoadCursor (nil, IDC_ARROW));
            }

            lastMouseComponent = c;
            return ((_HYComponent*)components(c))->_ProcessOSEvent (vEvent);
        }
        break;
    }

    case WM_NCMOUSEMOVE: {
        if (lastMouseComponent>=0) {
            ((_HYComponent*)components(lastMouseComponent))->_ComponentMouseExit();
        }
        lastMouseComponent = -1;
        return false;
    }

    case WM_ACTIVATE: {
        if (LOWORD(theEvent->wParam)!=WA_INACTIVE) {
            _Activate2();
        } else {
            _Deactivate2();
        }

        return true;
    }

    default: {
        //printf ("%x %x %x\n", theEvent->iMsg, theEvent->wParam, theEvent->lParam);
        for (int i=0; i<components.lLength; i++) {
            _HYComponent *thisC = (_HYComponent*)components(i);
            if (thisC->_ProcessOSEvent (vEvent)) {
                return true;
            }
        }
    }
    }
    return _HYPlatformWindow::_ProcessOSEvent (vEvent);
}

//__________________________________________________________________

void        _HYTWindow::_SetCopyString (_String* str)
{
    EmptyClipboard();

    HGLOBAL          cHandle = GlobalAlloc (GHND, str->sLength+1);
    checkPointer     (cHandle);
    LPVOID           cPtr = GlobalLock (cHandle);
    CopyMemory       (cPtr, str->sData, str->sLength+1);
    GlobalUnlock     (cHandle);

    SetClipboardData (CF_TEXT, cHandle);
    CloseClipboard();
}

//__________________________________________________________________

_String*        _HYTWindow::_GetPasteString (void)
{
    _String *res = nil;

    OpenClipboard  (theWindow);

    if (IsClipboardFormatAvailable (CF_TEXT)) {
        HANDLE           cHandle = GetClipboardData (CF_TEXT);
        LPVOID           cPtr = GlobalLock (cHandle);
        res = new _String((unsigned long)GlobalSize (cHandle)-1, false);
        checkPointer     (res);
        CopyMemory       (res->sData, cPtr, res->sLength+1);
        GlobalUnlock     (cHandle);
    }
    return res;
}

//__________________________________________________________________

void _HYTWindow::_Activate(void)
{
    for (int i=0; i<components.lLength; i++)
        if (cells.Find(i)>=0) {
            ((_HYComponent*)components(i))->Activate();
        }


    idleTimer = SetTimer (theWindow, IDLE_WINDOW_TIMER , 500,(TIMERPROC) IdleWindowTimer);
    _HYPlatformWindow::_Activate();

    if (keyboardFocus>=0) {
        ((_HYComponent*)components(keyboardFocus))->FocusComponent();
    }
}

//__________________________________________________________________

void _HYTWindow::_Activate2(void)
{
    //ReportWarning (_String ("Activated ") & (long)GetID());
    for (int i=0; i<components.lLength; i++)
        if (cells.Find(i)>=0) {
            //ReportWarning (_String ("Activated Component") & (long)i);
            ((_HYComponent*)components(i))->Activate();
        }


    idleTimer = SetTimer (theWindow, IDLE_WINDOW_TIMER , 500,(TIMERPROC) IdleWindowTimer);
    if (keyboardFocus>=0) {
        ((_HYComponent*)components(keyboardFocus))->FocusComponent();
    }
}

//__________________________________________________________________

void _HYTWindow::_Deactivate2(void)
{
    //ReportWarning (_String ("Deactivated ") &  (long)GetID());
    for (int i=0; i<components.lLength; i++)
        if (cells.Find(i)>=0) {
            ((_HYComponent*)components(i))->Deactivate();
        }

    KillTimer (theWindow,idleTimer);
}

//__________________________________________________________________

void _HYTWindow::_Deactivate(void)
{
    _Deactivate2 ();
    _HYPlatformWindow::_Deactivate();
}


//__________________________________________________________________


bool        _HYTWindow::_ProcessMenuSelection (long msel)
{
    bool done = false;

    if (_HYWindow::_ProcessMenuSelection(msel)) {
        return true;
    }

    switch (msel) {
    case HY_WINDOW_MENU_ID_EDIT+1:
        HandleCopyPaste(0);
        done = true;
        break;
    case HY_WINDOW_MENU_ID_EDIT+3:
        HandleCopyPaste(1);
        done = true;
        break;
    }

    return done;
}

//__________________________________________________________________

void _HYTWindow::_Zoom(bool inOut)
{
}


//__________________________________________________________________
void        _HYPlatformTWindow::_SetWindowRectangle     (int,int,int,int,bool)
{

}



//EOF