/*
    A text input box object for Win 32.

    Sergei L. Kosakovsky Pond, May 2000-December 2002.
*/

#ifndef _HYPLTABLE_
#define _HYPLTABLE_


//__________________________________________________________________

#include "HYPlatformComponent.h"

#define     HY_TABLE_SIZE_CURSOR   0x01
#define     HY_TABLE_DRAG_CURSOR   0x02
#define     HY_TABLE_EDIT_CURSOR   0x04

//__________________________________________________________________

class _HYPlatformTable
{

public:

    _HYPlatformTable        (void);
    virtual             ~_HYPlatformTable       (void);

    void            _SetFont                (void);
    void            _SetBackColor           (_HYColor&);
    void            _SetBackColor2          (_HYColor&);

    void            _CreateTextBox          (_HYRect&,_String&);
    _String         _RetrieveTextValue      (void);
    void            _KillTextBox            (void);
    bool            _HasTextBox             (void) {
        return      editBox;
    }

    RECT            _GetVisibleRowRect      (long);

    void            _HiliteRowForDrag       (long,long);
    void            _ResetCursorState       (void);

    void            _FrameRect              (RECT&);

    HBRUSH          backPattern,
                    backPattern2;

    HFONT           tableFont,
                    tableFontB,
                    tableFontI,
                    tableFontBI;

    char            cursorState;

    HWND            editBox;
    RECT            textBoxRect,
                    limits;

    long            activeColumn,
                    activeColumn2;

    LONG_PTR        defautlTextHandler;


};

#endif