/*
    A text input box object for Win32

    Sergei L. Kosakovsky Pond, May 2000-December 2002.
*/

#ifndef _HYPLTEXTBOX_
#define _HYPLTEXTBOX_

#include "HYPlatformComponent.h"
#include <richedit.h>

//__________________________________________________________________

class _HYPlatformTextBox
{

public:

    _HYPlatformTextBox (void);

    virtual ~_HYPlatformTextBox(void);

    virtual void            _SetBackColor    (_HYColor&);
    virtual void            _SetBackTColor   (_HYColor&);
    virtual void            _SetForeColor    (_HYColor&);
    virtual void            _SetDimensions   (_HYRect,_HYRect);
    virtual void            _SetVisibleSize  (_HYRect);
    virtual void            _SetFont         (_HYFont&);
    void            _SetText         (const _String&);
    void            _InsertText      (const _String&, bool);
    _String         _GetText         (void);
    void            _StoreText       (_String*&, bool);
    void            _CreateTE        (void);
    void            _EnableTextBox   (bool);
    void            _SetMargins      (_HYRect&);
    void            _SetAlignFlags   (unsigned char);

    virtual void            _Paint (Ptr p);
    virtual void            _Update(Ptr p);

    virtual void            _FocusComponent  (void);
    virtual void            _UnfocusComponent(void);
    virtual bool            _NeedMultiLines  (void);

    HBRUSH          backFill,
                    backTFill;
    HWND            te;
    RECT            textBoxRect;
    COLORREF        textColor;
    HFONT           pLabelFont;

    LONG_PTR        mainHandler;
    bool            isSingleLine;
};

//__________________________________________________________________

_String                 retrieveEditControlText (HWND);
void                    retrieveEditControlText (HWND, _String*&);

#endif