
from info2soft import config
from info2soft import https


class Label (object):
    def __init__(self, auth):
        self.auth = auth
    '''
     * 应用高可用 - 集群服务器池 标签 新建
     * 
     * @param dict $body  参数详见 API 手册
     * @return list
    '''
    def createLabel(self, body):
        
        url = '{0}/vers/v3/ha/service_label'.format(config.get_default('default_api_host'))
        
        res = https._post(url, body, self.auth)
        return res

    '''
     * 应用高可用 - 集群服务器池 标签 修改
     * 
     * @body['uuid'] String  必填 节点uuid
     * @param dict $body  参数详见 API 手册
     * @return list
    '''
    def modifyLabel(self, body, uuid):
        if uuid is None:
            exit()
        url = '{0}/vers/v3/ha/service_label/{1}'.format(config.get_default('default_api_host'), uuid)
        
        res = https._put(url, body, self.auth)
        return res

    '''
     * 应用高可用 - 集群服务器池 标签 删除
     * 
     * @param dict $body  参数详见 API 手册
     * @return list
    '''
    def deleteLabel(self, body):
        
        url = '{0}/vers/v3/ha/service_label'.format(config.get_default('default_api_host'))
        
        res = https._delete(url, body, self.auth)
        return res

    '''
     * 应用高可用 - 集群服务器池 标签 列表
     * 
     * @param dict $body  参数详见 API 手册
     * @return list
    '''
    def listLabel(self, body):
        
        url = '{0}/vers/v3/ha/service_label'.format(config.get_default('default_api_host'))
        
        res = https._get(url, body, self.auth)
        return res

