import linecache
import os
import json
import struct
import random
import requests

from info2soft.common.Rsa import Rsa
from info2soft import https
from info2soft import config


def getToken(username, pwd, access_key='', secret_key=''):
    token = ''
    ssoToken = ''
    # path = os.path.split(os.path.realpath(__file__))[0] + '/token.dat'
    path = os.sep.join([os.path.split(os.path.realpath(__file__))[0], 'token.dat'])
    # token文件不存在
    if not os.path.exists(path):
        lists = []
        code = -1
    else:
        lists = linecache.getlines(path)
        code = 0
    # 鉴定 token.txt 不为空
    if len(lists) != 0:
        token = lists[0].strip('\n')
        ssoToken = lists[1].strip('\n')
        # token文件有就用本地的，防止每个接口重新获取token
        if token is not None:
            return [token, ssoToken]
        url = '{0}/auth/token'.format(config.get_default('default_api_host'))
        data = {
            'access_token': ssoToken
        }
        res = https._get(url, data)
        if res is not None:
            code = res[0]['data']['code']
        else:
            code = -1
    if code != 0 or token == '':
        url = '{0}/auth/token'.format(config.get_default('default_api_host'))
        # 如果提供了 access_key 和 secret_key，使用 ak/sk 方式获取 token
        if access_key and secret_key:
            token, ssoToken = _get_token_by_ak(url, access_key, secret_key, path)
        else:
            # 使用用户名密码方式获取 token
            rsa = Rsa()
            data = {
                'username': username,
                'pwd': rsa.rsaEncrypt(pwd)
            }
            r = https._post(url, data)
            if r[0] is not None and r[0]['ret'] == 200 and r[0]['data']['code'] == 0:
                # 密码错误处理
                token = r[0]['data']['token']
                ssoToken = ''
                refreshToken = r[0]['data']['refresh_token']
                with open(path, mode='w+', encoding='UTF-8') as tokenFile:
                    tokenFile.write(token + '\n' + ssoToken + '\n' + refreshToken)
                    tokenFile.close()
            else:
                if r[0] is None:
                    print('Can Not Connect Host')
                else:
                    print(r[0]['data']['message'])
                exit()
    return [token, ssoToken]


def _get_token_by_ak(url, access_key, secret_key, token_file_path):
    """使用 AK/SK 方式获取 token
    
    Args:
        url: auth/token 的完整 URL
        access_key: 访问密钥
        secret_key: 安全密钥
        token_file_path: token 文件保存路径
        
    Returns:
        [token, ssoToken] 元组
    """
    # 生成随机参数
    data = {}
    data['_'] = hex(struct.unpack('<I', struct.pack('<f', random.random()))[0])[2:]
    
    # 直接调用 https.py 中的 _generate_header 函数生成请求头和签名
    # 注意：这里使用 'ak' 作为 auth_type，这样 _generate_header 会使用 secret_key 进行签名
    from info2soft.https import _generate_header
    headers = _generate_header('ak', '', access_key, secret_key, 'post', url, data['_'], data)
    
    # 发送请求
    requests.packages.urllib3.disable_warnings()
    response = requests.post(
        url,
        data=json.dumps(data),
        headers=headers,
        timeout=config.get_default('connection_timeout'),
        verify=False
    )
    
    # 处理响应
    if response.status_code == 200:
        result = response.json()
        if result.get('data', {}).get('code') == 0:
            token = result['data']['token']
            ssoToken = ''
            refresh_token = result['data']['refresh_token']
            with open(token_file_path, mode='w+', encoding='UTF-8') as token_file:
                token_file.write(token + '\n' + ssoToken + '\n' + refresh_token)
            return token, ssoToken
        else:
            print(result['data']['message'])
            exit()
    else:
        print('Can Not Connect Host')
        exit()


def refreshToken():
    token = ''
    ssoToken = ''
    path = os.sep.join([os.path.split(os.path.realpath(__file__))[0], 'token.dat'])
    lists = linecache.getlines(path)
    refresh_token = lists[2].strip('\n')
    # 删除token文件
    os.remove(path)
    url = '{0}/auth/refresh_token'.format(config.get_default('default_api_host'))
    data = {
        'refresh_token': refresh_token,
    }
    r = https._put(url, data)
    if r[0] is not None and r[0]['ret'] == 200 and r[0]['data']['code'] == 0:
        # 密码错误处理
        token = r[0]['data']['token']
        ssoToken = ''
        refreshToken = r[0]['data']['refresh_token']
        with open(path, mode='w+', encoding='UTF-8') as tokenFile:
            tokenFile.write(token + '\n' + ssoToken + '\n' + refreshToken)
            tokenFile.close()
    elif r[0] is not None and r[0]['ret'] == 200 and (r[0]['data']['code'] == 'auth.refresh_token_invalid' or r[0]['data']['code'] == 1010001109):
        print('refresh_token is invalid, need to get token again')
        # 返回None，用于后续判断是否需要重新获取token
        return [None, None]
    else:
        if r[0] is None:
            print('Can Not Connect Host')
        else:
            print(r[0]['data']['message'])
        exit()
    return [token, ssoToken]

