import os

import sentry_sdk

from ideas import __version__

SENTRY_DSN = os.environ.get("IDEAS_CLI_SENTRY_DSN")
SENTRY_ENV = os.environ.get("IDEAS_CLI_SENTRY_ENV", "development")


def setup_sentry():
    if SENTRY_DSN:
        sentry_sdk.init(
            dsn=SENTRY_DSN,
            environment=SENTRY_ENV,
            release=__version__,
        )
