[![Build Status](https://travis-ci.org/danielecook/iex-api-python.svg?branch=master)](https://travis-ci.org/danielecook/iex-api-python) [![Coverage Status](https://coveralls.io/repos/github/danielecook/iex-api-python/badge.svg)](https://coveralls.io/github/danielecook/iex-api-python)

# IEX-API-Python - [Documentation](http://www.danielecook.com/iex-api-python/stocks/)

__Python >=3.6__

### Summary

__IEX-API-Python__ is a python wrapper for the [IEX API](https://iextrading.com/developer/docs/). The __IEX API__ provides stock market data from the IEX exchange for free.

Before using __IEX-API-Python__ and the __IEX API__ you should read the [API terms of use](https://iextrading.com/api-terms/) and review the [documentation](https://iextrading.com/developer/docs/).

### Organization

The `IEX-API-Python` module is designed to map closely to the API from IEX. For many of the API calls, the resulting dataset is better represented in a tabular format. For these calls, data are returned as a [pandas.DataFrame](https://pandas.pydata.org/pandas-docs/stable/generated/pandas.DataFrame.html).

### Stocks

* [ ] Batch Requests
* [x] Book
* [x] Chart (+ Table)
* [x] Company
* [x] Delayed Quote
* [x] Dividends
* [x] Earnings
* [x] Effective Spread
* [x] Financials
* [ ] IEX Regulation SHO Threshold Securities List
* [ ] IEX Short Interest List
* [ ] Key Stats
* [ ] List
* [ ] Logo
* [ ] News
* [ ] OHLC
* [ ] Open / Close
* [ ] Peers
* [ ] Previous
* [x] Price
* [ ] Quote
* [ ] Relevant
* [ ] Splits
* [ ] Time Series
* [ ] Volume by Venue

### Batch

* [ ] Batch Requests
* [ ] Book
* [ ] Chart (+ Table)
* [x] Company
* [x] Delayed Quote
* [ ] Dividends
* [x] Earnings
* [ ] Effective Spread
* [x] Financials
* [ ] IEX Regulation SHO Threshold Securities List
* [ ] IEX Short Interest List
* [x] Key Stats
* [ ] List
* [ ] Logo
* [ ] News
* [ ] OHLC
* [ ] Open / Close
* [x] Peers
* [ ] Previous
* [x] Price
* [x] Quote
* [ ] Relevant
* [ ] Splits
* [ ] Time Series
* [ ] Volume by Venue

__reference__