"""Dataclasses mirroring the IlisMeta16 INTERLIS metamodel.

This file was generated by :mod:`ili2c.dataclasses.generator`.
Do not edit manually.
"""
from __future__ import annotations

from dataclasses import dataclass, field
from typing import Literal

@dataclass(kw_only=True)
class DocText:
    name: str | None = field(
        default=None,
        metadata={'ili': {'display_name': 'TEXT',
                 'ili_type': 'TextType',
                 'mandatory': False,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'Name',
                 'normalized': True,
                 'text_kind': 'TEXT',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    text: str = field(
        metadata={'ili': {'display_name': 'MTEXT',
                 'ili_type': 'TextType',
                 'mandatory': True,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'Text',
                 'normalized': False,
                 'text_kind': 'MTEXT',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.DocText'
        topic = 'IlisMeta16.ModelData'
        kind = 'structure'
        abstract = False
        extends = None

@dataclass(kw_only=True)
class Ili1Format:
    is_free: bool = field(
        metadata={'ili': {'alias': 'BOOLEAN',
                 'alias_kind': 'boolean',
                 'display_name': 'BOOLEAN',
                 'ili_type': 'TypeAlias',
                 'mandatory': True,
                 'model': 'IlisMeta16',
                 'name': 'isFree',
                 'python_type': 'bool',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    line_size: int | None = field(
        default=None,
        metadata={'ili': {'alias': 'LengthRange',
                 'alias_kind': 'numeric',
                 'display_name': 'LengthRange',
                 'ili_type': 'TypeAlias',
                 'mandatory': False,
                 'maximum': 2147483647,
                 'minimum': 1,
                 'model': 'IlisMeta16',
                 'name': 'LineSize',
                 'python_type': 'int',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    tid_size: int | None = field(
        default=None,
        metadata={'ili': {'alias': 'LengthRange',
                 'alias_kind': 'numeric',
                 'display_name': 'LengthRange',
                 'ili_type': 'TypeAlias',
                 'mandatory': False,
                 'maximum': 2147483647,
                 'minimum': 1,
                 'model': 'IlisMeta16',
                 'name': 'tidSize',
                 'python_type': 'int',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    blank_code: int = field(
        metadata={'ili': {'alias': 'Code',
                 'alias_kind': 'numeric',
                 'display_name': 'Code',
                 'ili_type': 'TypeAlias',
                 'mandatory': True,
                 'maximum': 255,
                 'minimum': 0,
                 'model': 'IlisMeta16',
                 'name': 'blankCode',
                 'python_type': 'int',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    undefined_code: int = field(
        metadata={'ili': {'alias': 'Code',
                 'alias_kind': 'numeric',
                 'display_name': 'Code',
                 'ili_type': 'TypeAlias',
                 'mandatory': True,
                 'maximum': 255,
                 'minimum': 0,
                 'model': 'IlisMeta16',
                 'name': 'undefinedCode',
                 'python_type': 'int',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    continue_code: int = field(
        metadata={'ili': {'alias': 'Code',
                 'alias_kind': 'numeric',
                 'display_name': 'Code',
                 'ili_type': 'TypeAlias',
                 'mandatory': True,
                 'maximum': 255,
                 'minimum': 0,
                 'model': 'IlisMeta16',
                 'name': 'continueCode',
                 'python_type': 'int',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    font: str = field(
        metadata={'ili': {'display_name': 'TEXT',
                 'ili_type': 'TextType',
                 'mandatory': True,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'Font',
                 'normalized': True,
                 'text_kind': 'TEXT',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    tid_kind: Literal['TID_I16', 'TID_I32', 'TID_ANY', 'TID_EXPLANATION'] = field(
        metadata={'ili': {'display_name': 'TID_I16, TID_I32, TID_ANY, TID_EXPLANATION',
                 'ili_type': 'EnumerationType',
                 'literals': ['TID_I16', 'TID_I32', 'TID_ANY', 'TID_EXPLANATION'],
                 'mandatory': True,
                 'model': 'IlisMeta16',
                 'name': 'tidKind',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    tid_explanation: str | None = field(
        default=None,
        metadata={'ili': {'display_name': 'TEXT',
                 'ili_type': 'TextType',
                 'mandatory': False,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'tidExplanation',
                 'normalized': True,
                 'text_kind': 'TEXT',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.Ili1Format'
        topic = 'IlisMeta16.ModelData'
        kind = 'structure'
        abstract = False
        extends = None

@dataclass(kw_only=True)
class Expression:
    class Meta:
        ili_name = 'IlisMeta16.ModelData.Expression'
        topic = 'IlisMeta16.ModelData'
        kind = 'structure'
        abstract = True
        extends = None

@dataclass(kw_only=True)
class Multiplicity:
    min: int = field(
        metadata={'ili': {'alias': 'MultRange',
                 'alias_kind': 'numeric',
                 'display_name': 'MultRange',
                 'ili_type': 'TypeAlias',
                 'mandatory': True,
                 'maximum': 2147483647,
                 'minimum': 0,
                 'model': 'IlisMeta16',
                 'name': 'Min',
                 'python_type': 'int',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    max: int | None = field(
        default=None,
        metadata={'ili': {'alias': 'MultRange',
                 'alias_kind': 'numeric',
                 'display_name': 'MultRange',
                 'ili_type': 'TypeAlias',
                 'mandatory': False,
                 'maximum': 2147483647,
                 'minimum': 0,
                 'model': 'IlisMeta16',
                 'name': 'Max',
                 'python_type': 'int',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.Multiplicity'
        topic = 'IlisMeta16.ModelData'
        kind = 'structure'
        abstract = False
        extends = None

@dataclass(kw_only=True)
class UnaryExpr(Expression):
    operation: Literal['Not', 'Defined', 'Nested'] | None = field(
        default=None,
        metadata={'ili': {'display_name': 'Not, Defined, Nested',
                 'ili_type': 'EnumerationType',
                 'literals': ['Not', 'Defined', 'Nested'],
                 'mandatory': False,
                 'model': 'IlisMeta16',
                 'name': 'Operation',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    sub_expression: Expression | None = field(
        default=None,
        metadata={'ili': {'alias': 'Expression',
                 'alias_kind': 'object',
                 'display_name': 'Expression',
                 'ili_type': 'TypeAlias',
                 'mandatory': False,
                 'model': 'IlisMeta16',
                 'name': 'SubExpression',
                 'python_type': 'Expression',
                 'qualified_target': 'IlisMeta16.ModelData.Expression',
                 'target': 'Expression',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.UnaryExpr'
        topic = 'IlisMeta16.ModelData'
        kind = 'structure'
        abstract = False
        extends = 'Expression'

@dataclass(kw_only=True)
class CompoundExpr(Expression):
    operation: Literal['Implication', 'And', 'Or', 'Mult', 'Div', 'Add', 'Sub', 'Relation.Equal', 'Relation.NotEqual', 'Relation.LessOrEqual', 'Relation.GreaterOrEqual', 'Relation.Less', 'Relation.Greater'] | None = field(
        default=None,
        metadata={'ili': {'display_name': 'Implication, And, Or, Mult, Div, Add, Sub, Relation.Equal, '
                                 'Relation.NotEqual, Relation.LessOrEqual, '
                                 'Relation.GreaterOrEqual, Relation.Less, Relation.Greater',
                 'ili_type': 'EnumerationType',
                 'literals': ['Implication',
                              'And',
                              'Or',
                              'Mult',
                              'Div',
                              'Add',
                              'Sub',
                              'Relation.Equal',
                              'Relation.NotEqual',
                              'Relation.LessOrEqual',
                              'Relation.GreaterOrEqual',
                              'Relation.Less',
                              'Relation.Greater'],
                 'mandatory': False,
                 'model': 'IlisMeta16',
                 'name': 'Operation',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    sub_expressions: tuple[Expression, ...] = field(
        default_factory=tuple,
        metadata={'ili': {'cardinality': {'max': None, 'min': 0},
                 'display_name': 'Unknown',
                 'ili_type': 'ListType',
                 'is_bag': False,
                 'items': {'display_name': 'Expression',
                           'ili_type': 'ObjectType',
                           'qualified_target': 'IlisMeta16.ModelData.Expression',
                           'target': 'Expression'},
                 'mandatory': False,
                 'model': 'IlisMeta16',
                 'name': 'SubExpressions',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.CompoundExpr'
        topic = 'IlisMeta16.ModelData'
        kind = 'structure'
        abstract = False
        extends = 'Expression'

@dataclass(kw_only=True)
class Factor(Expression):
    class Meta:
        ili_name = 'IlisMeta16.ModelData.Factor'
        topic = 'IlisMeta16.ModelData'
        kind = 'structure'
        abstract = True
        extends = 'Expression'

@dataclass(kw_only=True)
class PathEl:
    kind: Literal['This', 'ThisArea', 'ThatArea', 'Parent', 'ReferenceAttr', 'AssocPath', 'Role', 'ViewBase', 'Attribute', 'MetaObject', 'ORDERED'] | None = field(
        default=None,
        metadata={'ili': {'display_name': 'This, ThisArea, ThatArea, Parent, ReferenceAttr, AssocPath, '
                                 'Role, ViewBase, Attribute, MetaObject, ORDERED',
                 'ili_type': 'EnumerationType',
                 'literals': ['This',
                              'ThisArea',
                              'ThatArea',
                              'Parent',
                              'ReferenceAttr',
                              'AssocPath',
                              'Role',
                              'ViewBase',
                              'Attribute',
                              'MetaObject',
                              'ORDERED'],
                 'mandatory': False,
                 'model': 'IlisMeta16',
                 'name': 'Kind',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    ref: str | None = field(
        default=None,
        metadata={'ili': {'display_name': '(EXTERNAL)MetaElement',
                 'external': True,
                 'ili_type': 'ReferenceType',
                 'mandatory': False,
                 'model': 'IlisMeta16',
                 'name': 'Ref',
                 'qualified_target': 'IlisMeta16.ModelData.MetaElement',
                 'target': 'MetaElement',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    num_index: int | None = field(
        default=None,
        metadata={'ili': {'alias': 'MultRange',
                 'alias_kind': 'numeric',
                 'display_name': 'MultRange',
                 'ili_type': 'TypeAlias',
                 'mandatory': False,
                 'maximum': 2147483647,
                 'minimum': 0,
                 'model': 'IlisMeta16',
                 'name': 'NumIndex',
                 'python_type': 'int',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    spec_index: Literal['First', 'Last'] | None = field(
        default=None,
        metadata={'ili': {'display_name': 'First, Last',
                 'ili_type': 'EnumerationType',
                 'literals': ['First', 'Last'],
                 'mandatory': False,
                 'model': 'IlisMeta16',
                 'name': 'SpecIndex',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.PathEl'
        topic = 'IlisMeta16.ModelData'
        kind = 'structure'
        abstract = False
        extends = None

@dataclass(kw_only=True)
class PathOrInspFactor(Factor):
    path_els: tuple[PathEl, ...] = field(
        default_factory=tuple,
        metadata={'ili': {'cardinality': {'max': None, 'min': 0},
                 'display_name': 'Unknown',
                 'ili_type': 'ListType',
                 'is_bag': False,
                 'items': {'display_name': 'PathEl',
                           'ili_type': 'ObjectType',
                           'qualified_target': 'IlisMeta16.ModelData.PathEl',
                           'target': 'PathEl'},
                 'mandatory': False,
                 'model': 'IlisMeta16',
                 'name': 'PathEls',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    inspection: str | None = field(
        default=None,
        metadata={'ili': {'display_name': '(EXTERNAL)View',
                 'external': True,
                 'ili_type': 'ReferenceType',
                 'mandatory': False,
                 'model': 'IlisMeta16',
                 'name': 'Inspection',
                 'qualified_target': 'IlisMeta16.ModelData.View',
                 'target': 'View',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.PathOrInspFactor'
        topic = 'IlisMeta16.ModelData'
        kind = 'structure'
        abstract = False
        extends = 'Factor'

@dataclass(kw_only=True)
class EnumAssignment:
    value_to_assign: Expression | None = field(
        default=None,
        metadata={'ili': {'alias': 'Expression',
                 'alias_kind': 'object',
                 'display_name': 'Expression',
                 'ili_type': 'TypeAlias',
                 'mandatory': False,
                 'model': 'IlisMeta16',
                 'name': 'ValueToAssign',
                 'python_type': 'Expression',
                 'qualified_target': 'IlisMeta16.ModelData.Expression',
                 'target': 'Expression',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    min_enum_value: str = field(
        metadata={'ili': {'display_name': '(EXTERNAL)EnumNode',
                 'external': True,
                 'ili_type': 'ReferenceType',
                 'mandatory': True,
                 'model': 'IlisMeta16',
                 'name': 'MinEnumValue',
                 'qualified_target': 'IlisMeta16.ModelData.EnumNode',
                 'target': 'EnumNode',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    max_enum_value: str | None = field(
        default=None,
        metadata={'ili': {'display_name': '(EXTERNAL)EnumNode',
                 'external': True,
                 'ili_type': 'ReferenceType',
                 'mandatory': False,
                 'model': 'IlisMeta16',
                 'name': 'MaxEnumValue',
                 'qualified_target': 'IlisMeta16.ModelData.EnumNode',
                 'target': 'EnumNode',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.EnumAssignment'
        topic = 'IlisMeta16.ModelData'
        kind = 'structure'
        abstract = False
        extends = None

@dataclass(kw_only=True)
class EnumMapping(Factor):
    enum_value: PathOrInspFactor | None = field(
        default=None,
        metadata={'ili': {'alias': 'PathOrInspFactor',
                 'alias_kind': 'object',
                 'display_name': 'PathOrInspFactor',
                 'ili_type': 'TypeAlias',
                 'mandatory': False,
                 'model': 'IlisMeta16',
                 'name': 'EnumValue',
                 'python_type': 'PathOrInspFactor',
                 'qualified_target': 'IlisMeta16.ModelData.PathOrInspFactor',
                 'target': 'PathOrInspFactor',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    cases: tuple[EnumAssignment, ...] = field(
        default_factory=tuple,
        metadata={'ili': {'cardinality': {'max': None, 'min': 0},
                 'display_name': 'Unknown',
                 'ili_type': 'ListType',
                 'is_bag': False,
                 'items': {'display_name': 'EnumAssignment',
                           'ili_type': 'ObjectType',
                           'qualified_target': 'IlisMeta16.ModelData.EnumAssignment',
                           'target': 'EnumAssignment'},
                 'mandatory': False,
                 'model': 'IlisMeta16',
                 'name': 'Cases',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.EnumMapping'
        topic = 'IlisMeta16.ModelData'
        kind = 'structure'
        abstract = False
        extends = 'Factor'

@dataclass(kw_only=True)
class ClassRef:
    ref: str = field(
        metadata={'ili': {'display_name': '(EXTERNAL)Class',
                 'external': True,
                 'ili_type': 'ReferenceType',
                 'mandatory': True,
                 'model': 'IlisMeta16',
                 'name': 'Ref',
                 'qualified_target': 'IlisMeta16.ModelData.Class',
                 'target': 'Class',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.ClassRef'
        topic = 'IlisMeta16.ModelData'
        kind = 'structure'
        abstract = False
        extends = None

@dataclass(kw_only=True)
class ActualArgument:
    formal_argument: str = field(
        metadata={'ili': {'display_name': '(EXTERNAL)Argument',
                 'external': True,
                 'ili_type': 'ReferenceType',
                 'mandatory': True,
                 'model': 'IlisMeta16',
                 'name': 'FormalArgument',
                 'qualified_target': 'IlisMeta16.ModelData.Argument',
                 'target': 'Argument',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    kind: Literal['Expression', 'AllOf'] = field(
        metadata={'ili': {'display_name': 'Expression, AllOf',
                 'ili_type': 'EnumerationType',
                 'literals': ['Expression', 'AllOf'],
                 'mandatory': True,
                 'model': 'IlisMeta16',
                 'name': 'Kind',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    expression: tuple[Expression, ...] = field(
        default_factory=tuple,
        metadata={'ili': {'cardinality': {'max': 1, 'min': 0},
                 'display_name': 'Unknown',
                 'ili_type': 'ListType',
                 'is_bag': True,
                 'items': {'display_name': 'Expression',
                           'ili_type': 'ObjectType',
                           'qualified_target': 'IlisMeta16.ModelData.Expression',
                           'target': 'Expression'},
                 'mandatory': False,
                 'model': 'IlisMeta16',
                 'name': 'Expression',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    object_classes: tuple[ClassRef, ...] = field(
        default_factory=tuple,
        metadata={'ili': {'cardinality': {'max': None, 'min': 0},
                 'display_name': 'Unknown',
                 'ili_type': 'ListType',
                 'is_bag': True,
                 'items': {'display_name': 'ClassRef',
                           'ili_type': 'ObjectType',
                           'qualified_target': 'IlisMeta16.ModelData.ClassRef',
                           'target': 'ClassRef'},
                 'mandatory': False,
                 'model': 'IlisMeta16',
                 'name': 'ObjectClasses',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.ActualArgument'
        topic = 'IlisMeta16.ModelData'
        kind = 'structure'
        abstract = False
        extends = None

@dataclass(kw_only=True)
class FunctionCall(Factor):
    function: str = field(
        metadata={'ili': {'display_name': '(EXTERNAL)FunctionDef',
                 'external': True,
                 'ili_type': 'ReferenceType',
                 'mandatory': True,
                 'model': 'IlisMeta16',
                 'name': 'Function',
                 'qualified_target': 'IlisMeta16.ModelData.FunctionDef',
                 'target': 'FunctionDef',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    arguments: tuple[ActualArgument, ...] = field(
        default_factory=tuple,
        metadata={'ili': {'cardinality': {'max': None, 'min': 0},
                 'display_name': 'Unknown',
                 'ili_type': 'ListType',
                 'is_bag': False,
                 'items': {'display_name': 'ActualArgument',
                           'ili_type': 'ObjectType',
                           'qualified_target': 'IlisMeta16.ModelData.ActualArgument',
                           'target': 'ActualArgument'},
                 'mandatory': False,
                 'model': 'IlisMeta16',
                 'name': 'Arguments',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.FunctionCall'
        topic = 'IlisMeta16.ModelData'
        kind = 'structure'
        abstract = False
        extends = 'Factor'

@dataclass(kw_only=True)
class RuntimeParamRef(Factor):
    runtime_param: str = field(
        metadata={'ili': {'display_name': 'AttrOrParam',
                 'ili_type': 'ReferenceType',
                 'mandatory': True,
                 'model': 'IlisMeta16',
                 'name': 'RuntimeParam',
                 'qualified_target': 'IlisMeta16.ModelData.AttrOrParam',
                 'target': 'AttrOrParam',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.RuntimeParamRef'
        topic = 'IlisMeta16.ModelData'
        kind = 'structure'
        abstract = False
        extends = 'Factor'

@dataclass(kw_only=True)
class Constant(Factor):
    value: str = field(
        metadata={'ili': {'display_name': 'TEXT',
                 'ili_type': 'TextType',
                 'mandatory': True,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'Value',
                 'normalized': True,
                 'text_kind': 'TEXT',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    type: Literal['Undefined', 'Numeric', 'Text', 'Enumeration'] = field(
        metadata={'ili': {'display_name': 'Undefined, Numeric, Text, Enumeration',
                 'ili_type': 'EnumerationType',
                 'literals': ['Undefined', 'Numeric', 'Text', 'Enumeration'],
                 'mandatory': True,
                 'model': 'IlisMeta16',
                 'name': 'Type',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.Constant'
        topic = 'IlisMeta16.ModelData'
        kind = 'structure'
        abstract = False
        extends = 'Factor'

@dataclass(kw_only=True)
class ClassConst(Factor):
    class_: str | None = field(
        default=None,
        metadata={'ili': {'display_name': '(EXTERNAL)Class',
                 'external': True,
                 'ili_type': 'ReferenceType',
                 'mandatory': False,
                 'model': 'IlisMeta16',
                 'name': 'Class',
                 'qualified_target': 'IlisMeta16.ModelData.Class',
                 'target': 'Class',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.ClassConst'
        topic = 'IlisMeta16.ModelData'
        kind = 'structure'
        abstract = False
        extends = 'Factor'

@dataclass(kw_only=True)
class AttributeConst(Factor):
    attribute: str | None = field(
        default=None,
        metadata={'ili': {'display_name': '(EXTERNAL)AttrOrParam',
                 'external': True,
                 'ili_type': 'ReferenceType',
                 'mandatory': False,
                 'model': 'IlisMeta16',
                 'name': 'Attribute',
                 'qualified_target': 'IlisMeta16.ModelData.AttrOrParam',
                 'target': 'AttrOrParam',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.AttributeConst'
        topic = 'IlisMeta16.ModelData'
        kind = 'structure'
        abstract = False
        extends = 'Factor'

@dataclass(kw_only=True)
class UnitRef(Factor):
    unit: str | None = field(
        default=None,
        metadata={'ili': {'display_name': 'Unit',
                 'external': True,
                 'ili_type': 'ReferenceType',
                 'mandatory': False,
                 'model': 'IlisMeta16',
                 'name': 'Unit',
                 'qualified_target': 'IlisMeta16.ModelData.Unit',
                 'target': 'Unit',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.UnitRef'
        topic = 'IlisMeta16.ModelData'
        kind = 'structure'
        abstract = False
        extends = 'Factor'

@dataclass(kw_only=True)
class UnitFunction(Factor):
    explanation: str = field(
        metadata={'ili': {'display_name': 'TEXT',
                 'ili_type': 'TextType',
                 'mandatory': True,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'Explanation',
                 'normalized': True,
                 'text_kind': 'TEXT',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.UnitFunction'
        topic = 'IlisMeta16.ModelData'
        kind = 'structure'
        abstract = False
        extends = 'Factor'

@dataclass(kw_only=True)
class ExistenceDef:
    exists_in: str = field(
        metadata={'ili': {'display_name': 'Class',
                 'external': True,
                 'ili_type': 'ReferenceType',
                 'mandatory': True,
                 'model': 'IlisMeta16',
                 'name': 'ExistsIn',
                 'qualified_target': 'IlisMeta16.ModelData.Class',
                 'target': 'Class',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    attr: PathOrInspFactor = field(
        metadata={'ili': {'alias': 'PathOrInspFactor',
                 'alias_kind': 'object',
                 'display_name': 'PathOrInspFactor',
                 'ili_type': 'TypeAlias',
                 'mandatory': True,
                 'model': 'IlisMeta16',
                 'name': 'Attr',
                 'python_type': 'PathOrInspFactor',
                 'qualified_target': 'IlisMeta16.ModelData.PathOrInspFactor',
                 'target': 'PathOrInspFactor',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.ExistenceDef'
        topic = 'IlisMeta16.ModelData'
        kind = 'structure'
        abstract = False
        extends = None

@dataclass(kw_only=True)
class SignParamAssignment:
    param: str = field(
        metadata={'ili': {'display_name': '(EXTERNAL)AttrOrParam',
                 'external': True,
                 'ili_type': 'ReferenceType',
                 'mandatory': True,
                 'model': 'IlisMeta16',
                 'name': 'Param',
                 'qualified_target': 'IlisMeta16.ModelData.AttrOrParam',
                 'target': 'AttrOrParam',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    assignment: Expression | None = field(
        default=None,
        metadata={'ili': {'alias': 'Expression',
                 'alias_kind': 'object',
                 'display_name': 'Expression',
                 'ili_type': 'TypeAlias',
                 'mandatory': False,
                 'model': 'IlisMeta16',
                 'name': 'Assignment',
                 'python_type': 'Expression',
                 'qualified_target': 'IlisMeta16.ModelData.Expression',
                 'target': 'Expression',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.SignParamAssignment'
        topic = 'IlisMeta16.ModelData'
        kind = 'structure'
        abstract = False
        extends = None

@dataclass(kw_only=True)
class CondSignParamAssignment:
    where: Expression | None = field(
        default=None,
        metadata={'ili': {'alias': 'Expression',
                 'alias_kind': 'object',
                 'display_name': 'Expression',
                 'ili_type': 'TypeAlias',
                 'mandatory': False,
                 'model': 'IlisMeta16',
                 'name': 'Where',
                 'python_type': 'Expression',
                 'qualified_target': 'IlisMeta16.ModelData.Expression',
                 'target': 'Expression',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    assignments: tuple[SignParamAssignment, ...] = field(
        default_factory=tuple,
        metadata={'ili': {'cardinality': {'max': None, 'min': 0},
                 'display_name': 'Unknown',
                 'ili_type': 'ListType',
                 'is_bag': False,
                 'items': {'display_name': 'SignParamAssignment',
                           'ili_type': 'ObjectType',
                           'qualified_target': 'IlisMeta16.ModelData.SignParamAssignment',
                           'target': 'SignParamAssignment'},
                 'mandatory': False,
                 'model': 'IlisMeta16',
                 'name': 'Assignments',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.CondSignParamAssignment'
        topic = 'IlisMeta16.ModelData'
        kind = 'structure'
        abstract = False
        extends = None

@dataclass(kw_only=True)
class MetaElement:
    tid: str | None = field(
        default=None,
        metadata={'ili': {'alias': 'IlisMeta16.MetaElemOID',
                 'alias_kind': 'domain',
                 'display_name': 'OID TEXT',
                 'domain': 'IlisMeta16.MetaElemOID',
                 'identifier': True,
                 'identifier_category': 'oid',
                 'identifier_kind': 'text',
                 'ili_type': 'TextOIDType',
                 'mandatory': True,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'TID',
                 'python_type': 'str',
                 'topic': 'IlisMeta16.ModelData',
                 'value_type': {'display_name': 'TEXT',
                                'ili_type': 'TextType',
                                'max_length': None,
                                'normalized': True,
                                'text_kind': 'TEXT'}}},
    )
    name: str = field(
        metadata={'ili': {'display_name': 'TEXT',
                 'ili_type': 'TextType',
                 'mandatory': True,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'Name',
                 'normalized': True,
                 'text_kind': 'TEXT',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    documentation: tuple[DocText, ...] = field(
        default_factory=tuple,
        metadata={'ili': {'cardinality': {'max': None, 'min': 0},
                 'display_name': 'Unknown',
                 'ili_type': 'ListType',
                 'is_bag': False,
                 'items': {'display_name': 'DocText',
                           'ili_type': 'ObjectType',
                           'qualified_target': 'IlisMeta16.ModelData.DocText',
                           'target': 'DocText'},
                 'mandatory': False,
                 'model': 'IlisMeta16',
                 'name': 'Documentation',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.MetaElement'
        topic = 'IlisMeta16.ModelData'
        kind = 'class'
        abstract = True
        extends = None

@dataclass(kw_only=True)
class MetaAttribute:
    tid: str | None = field(
        default=None,
        metadata={'ili': {'alias': 'IlisMeta16.MetaElemOID',
                 'alias_kind': 'domain',
                 'display_name': 'OID TEXT',
                 'domain': 'IlisMeta16.MetaElemOID',
                 'identifier': True,
                 'identifier_category': 'oid',
                 'identifier_kind': 'text',
                 'ili_type': 'TextOIDType',
                 'mandatory': True,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'TID',
                 'python_type': 'str',
                 'topic': 'IlisMeta16.ModelData',
                 'value_type': {'display_name': 'TEXT',
                                'ili_type': 'TextType',
                                'max_length': None,
                                'normalized': True,
                                'text_kind': 'TEXT'}}},
    )
    name: str = field(
        metadata={'ili': {'display_name': 'TEXT',
                 'ili_type': 'TextType',
                 'mandatory': True,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'Name',
                 'normalized': True,
                 'text_kind': 'TEXT',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    value: str = field(
        metadata={'ili': {'display_name': 'TEXT',
                 'ili_type': 'TextType',
                 'mandatory': True,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'Value',
                 'normalized': True,
                 'text_kind': 'TEXT',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.MetaAttribute'
        topic = 'IlisMeta16.ModelData'
        kind = 'class'
        abstract = False
        extends = None

@dataclass(kw_only=True)
class ExtendableME(MetaElement):
    tid: str | None = field(
        default=None,
        metadata={'ili': {'alias': 'IlisMeta16.MetaElemOID',
                 'alias_kind': 'domain',
                 'display_name': 'OID TEXT',
                 'domain': 'IlisMeta16.MetaElemOID',
                 'identifier': True,
                 'identifier_category': 'oid',
                 'identifier_kind': 'text',
                 'ili_type': 'TextOIDType',
                 'mandatory': True,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'TID',
                 'python_type': 'str',
                 'topic': 'IlisMeta16.ModelData',
                 'value_type': {'display_name': 'TEXT',
                                'ili_type': 'TextType',
                                'max_length': None,
                                'normalized': True,
                                'text_kind': 'TEXT'}}},
    )
    abstract: bool = field(
        metadata={'ili': {'alias': 'BOOLEAN',
                 'alias_kind': 'boolean',
                 'display_name': 'BOOLEAN',
                 'ili_type': 'TypeAlias',
                 'mandatory': True,
                 'model': 'IlisMeta16',
                 'name': 'Abstract',
                 'python_type': 'bool',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    generic: bool = field(
        metadata={'ili': {'alias': 'BOOLEAN',
                 'alias_kind': 'boolean',
                 'display_name': 'BOOLEAN',
                 'ili_type': 'TypeAlias',
                 'mandatory': True,
                 'model': 'IlisMeta16',
                 'name': 'Generic',
                 'python_type': 'bool',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    final: bool = field(
        metadata={'ili': {'alias': 'BOOLEAN',
                 'alias_kind': 'boolean',
                 'display_name': 'BOOLEAN',
                 'ili_type': 'TypeAlias',
                 'mandatory': True,
                 'model': 'IlisMeta16',
                 'name': 'Final',
                 'python_type': 'bool',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.ExtendableME'
        topic = 'IlisMeta16.ModelData'
        kind = 'class'
        abstract = True
        extends = 'MetaElement'

@dataclass(kw_only=True)
class Package(MetaElement):
    tid: str | None = field(
        default=None,
        metadata={'ili': {'alias': 'IlisMeta16.MetaElemOID',
                 'alias_kind': 'domain',
                 'display_name': 'OID TEXT',
                 'domain': 'IlisMeta16.MetaElemOID',
                 'identifier': True,
                 'identifier_category': 'oid',
                 'identifier_kind': 'text',
                 'ili_type': 'TextOIDType',
                 'mandatory': True,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'TID',
                 'python_type': 'str',
                 'topic': 'IlisMeta16.ModelData',
                 'value_type': {'display_name': 'TEXT',
                                'ili_type': 'TextType',
                                'max_length': None,
                                'normalized': True,
                                'text_kind': 'TEXT'}}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.Package'
        topic = 'IlisMeta16.ModelData'
        kind = 'class'
        abstract = True
        extends = 'MetaElement'

@dataclass(kw_only=True)
class Model(Package):
    tid: str | None = field(
        default=None,
        metadata={'ili': {'alias': 'IlisMeta16.MetaElemOID',
                 'alias_kind': 'domain',
                 'display_name': 'OID TEXT',
                 'domain': 'IlisMeta16.MetaElemOID',
                 'identifier': True,
                 'identifier_category': 'oid',
                 'identifier_kind': 'text',
                 'ili_type': 'TextOIDType',
                 'mandatory': True,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'TID',
                 'python_type': 'str',
                 'topic': 'IlisMeta16.ModelData',
                 'value_type': {'display_name': 'TEXT',
                                'ili_type': 'TextType',
                                'max_length': None,
                                'normalized': True,
                                'text_kind': 'TEXT'}}},
    )
    ili_version: str = field(
        metadata={'ili': {'display_name': 'TEXT',
                 'ili_type': 'TextType',
                 'mandatory': True,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'iliVersion',
                 'normalized': True,
                 'text_kind': 'TEXT',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    contracted: bool | None = field(
        default=None,
        metadata={'ili': {'alias': 'BOOLEAN',
                 'alias_kind': 'boolean',
                 'display_name': 'BOOLEAN',
                 'ili_type': 'TypeAlias',
                 'mandatory': False,
                 'model': 'IlisMeta16',
                 'name': 'Contracted',
                 'python_type': 'bool',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    kind: Literal['NormalM', 'TypeM', 'RefSystemM', 'SymbologyM'] = field(
        metadata={'ili': {'display_name': 'NormalM, TypeM, RefSystemM, SymbologyM',
                 'ili_type': 'EnumerationType',
                 'literals': ['NormalM', 'TypeM', 'RefSystemM', 'SymbologyM'],
                 'mandatory': True,
                 'model': 'IlisMeta16',
                 'name': 'Kind',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    language: str | None = field(
        default=None,
        metadata={'ili': {'alias': 'LanguageCode',
                 'alias_kind': 'text',
                 'display_name': 'LanguageCode',
                 'ili_type': 'TypeAlias',
                 'mandatory': False,
                 'max_length': 5,
                 'model': 'IlisMeta16',
                 'name': 'Language',
                 'python_type': 'str',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    at: str | None = field(
        default=None,
        metadata={'ili': {'display_name': 'TEXT',
                 'ili_type': 'TextType',
                 'mandatory': False,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'At',
                 'normalized': True,
                 'text_kind': 'TEXT',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    version: str | None = field(
        default=None,
        metadata={'ili': {'display_name': 'TEXT',
                 'ili_type': 'TextType',
                 'mandatory': False,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'Version',
                 'normalized': True,
                 'text_kind': 'TEXT',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    no_incremental_transfer: bool | None = field(
        default=None,
        metadata={'ili': {'alias': 'BOOLEAN',
                 'alias_kind': 'boolean',
                 'display_name': 'BOOLEAN',
                 'ili_type': 'TypeAlias',
                 'mandatory': False,
                 'model': 'IlisMeta16',
                 'name': 'NoIncrementalTransfer',
                 'python_type': 'bool',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    char_set_iana_name: str | None = field(
        default=None,
        metadata={'ili': {'display_name': 'TEXT',
                 'ili_type': 'TextType',
                 'mandatory': False,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'CharSetIANAName',
                 'normalized': True,
                 'text_kind': 'TEXT',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    xmlns: str | None = field(
        default=None,
        metadata={'ili': {'display_name': 'TEXT',
                 'ili_type': 'TextType',
                 'mandatory': False,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'xmlns',
                 'normalized': True,
                 'text_kind': 'TEXT',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    ili1_transfername: str | None = field(
        default=None,
        metadata={'ili': {'display_name': 'TEXT',
                 'ili_type': 'TextType',
                 'mandatory': False,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'ili1Transfername',
                 'normalized': True,
                 'text_kind': 'TEXT',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    ili1_format: Ili1Format | None = field(
        default=None,
        metadata={'ili': {'alias': 'Ili1Format',
                 'alias_kind': 'object',
                 'display_name': 'Ili1Format',
                 'ili_type': 'TypeAlias',
                 'mandatory': False,
                 'model': 'IlisMeta16',
                 'name': 'ili1Format',
                 'python_type': 'Ili1Format',
                 'qualified_target': 'IlisMeta16.ModelData.Ili1Format',
                 'target': 'Ili1Format',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.Model'
        topic = 'IlisMeta16.ModelData'
        kind = 'class'
        abstract = False
        extends = 'Package'

@dataclass(kw_only=True)
class SubModel(Package):
    tid: str | None = field(
        default=None,
        metadata={'ili': {'alias': 'IlisMeta16.MetaElemOID',
                 'alias_kind': 'domain',
                 'display_name': 'OID TEXT',
                 'domain': 'IlisMeta16.MetaElemOID',
                 'identifier': True,
                 'identifier_category': 'oid',
                 'identifier_kind': 'text',
                 'ili_type': 'TextOIDType',
                 'mandatory': True,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'TID',
                 'python_type': 'str',
                 'topic': 'IlisMeta16.ModelData',
                 'value_type': {'display_name': 'TEXT',
                                'ili_type': 'TextType',
                                'max_length': None,
                                'normalized': True,
                                'text_kind': 'TEXT'}}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.SubModel'
        topic = 'IlisMeta16.ModelData'
        kind = 'class'
        abstract = False
        extends = 'Package'

@dataclass(kw_only=True)
class Type(ExtendableME):
    tid: str | None = field(
        default=None,
        metadata={'ili': {'alias': 'IlisMeta16.MetaElemOID',
                 'alias_kind': 'domain',
                 'display_name': 'OID TEXT',
                 'domain': 'IlisMeta16.MetaElemOID',
                 'identifier': True,
                 'identifier_category': 'oid',
                 'identifier_kind': 'text',
                 'ili_type': 'TextOIDType',
                 'mandatory': True,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'TID',
                 'python_type': 'str',
                 'topic': 'IlisMeta16.ModelData',
                 'value_type': {'display_name': 'TEXT',
                                'ili_type': 'TextType',
                                'max_length': None,
                                'normalized': True,
                                'text_kind': 'TEXT'}}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.Type'
        topic = 'IlisMeta16.ModelData'
        kind = 'class'
        abstract = True
        extends = 'ExtendableME'

@dataclass(kw_only=True)
class Constraint(MetaElement):
    tid: str | None = field(
        default=None,
        metadata={'ili': {'alias': 'IlisMeta16.MetaElemOID',
                 'alias_kind': 'domain',
                 'display_name': 'OID TEXT',
                 'domain': 'IlisMeta16.MetaElemOID',
                 'identifier': True,
                 'identifier_category': 'oid',
                 'identifier_kind': 'text',
                 'ili_type': 'TextOIDType',
                 'mandatory': True,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'TID',
                 'python_type': 'str',
                 'topic': 'IlisMeta16.ModelData',
                 'value_type': {'display_name': 'TEXT',
                                'ili_type': 'TextType',
                                'max_length': None,
                                'normalized': True,
                                'text_kind': 'TEXT'}}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.Constraint'
        topic = 'IlisMeta16.ModelData'
        kind = 'class'
        abstract = True
        extends = 'MetaElement'

@dataclass(kw_only=True)
class DomainType(Type):
    tid: str | None = field(
        default=None,
        metadata={'ili': {'alias': 'IlisMeta16.MetaElemOID',
                 'alias_kind': 'domain',
                 'display_name': 'OID TEXT',
                 'domain': 'IlisMeta16.MetaElemOID',
                 'identifier': True,
                 'identifier_category': 'oid',
                 'identifier_kind': 'text',
                 'ili_type': 'TextOIDType',
                 'mandatory': True,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'TID',
                 'python_type': 'str',
                 'topic': 'IlisMeta16.ModelData',
                 'value_type': {'display_name': 'TEXT',
                                'ili_type': 'TextType',
                                'max_length': None,
                                'normalized': True,
                                'text_kind': 'TEXT'}}},
    )
    mandatory: bool = field(
        metadata={'ili': {'alias': 'BOOLEAN',
                 'alias_kind': 'boolean',
                 'display_name': 'BOOLEAN',
                 'ili_type': 'TypeAlias',
                 'mandatory': True,
                 'model': 'IlisMeta16',
                 'name': 'Mandatory',
                 'python_type': 'bool',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.DomainType'
        topic = 'IlisMeta16.ModelData'
        kind = 'class'
        abstract = True
        extends = 'Type'

@dataclass(kw_only=True)
class Class(Type):
    tid: str | None = field(
        default=None,
        metadata={'ili': {'alias': 'IlisMeta16.MetaElemOID',
                 'alias_kind': 'domain',
                 'display_name': 'OID TEXT',
                 'domain': 'IlisMeta16.MetaElemOID',
                 'identifier': True,
                 'identifier_category': 'oid',
                 'identifier_kind': 'text',
                 'ili_type': 'TextOIDType',
                 'mandatory': True,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'TID',
                 'python_type': 'str',
                 'topic': 'IlisMeta16.ModelData',
                 'value_type': {'display_name': 'TEXT',
                                'ili_type': 'TextType',
                                'max_length': None,
                                'normalized': True,
                                'text_kind': 'TEXT'}}},
    )
    kind: Literal['Structure', 'Class', 'View', 'Association'] = field(
        metadata={'ili': {'display_name': 'Structure, Class, View, Association',
                 'ili_type': 'EnumerationType',
                 'literals': ['Structure', 'Class', 'View', 'Association'],
                 'mandatory': True,
                 'model': 'IlisMeta16',
                 'name': 'Kind',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    multiplicity: Multiplicity | None = field(
        default=None,
        metadata={'ili': {'alias': 'Multiplicity',
                 'alias_kind': 'object',
                 'display_name': 'Multiplicity',
                 'ili_type': 'TypeAlias',
                 'mandatory': False,
                 'model': 'IlisMeta16',
                 'name': 'Multiplicity',
                 'python_type': 'Multiplicity',
                 'qualified_target': 'IlisMeta16.ModelData.Multiplicity',
                 'target': 'Multiplicity',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    embedded_role_transfer: bool = field(
        metadata={'ili': {'alias': 'BOOLEAN',
                 'alias_kind': 'boolean',
                 'display_name': 'BOOLEAN',
                 'ili_type': 'TypeAlias',
                 'mandatory': True,
                 'model': 'IlisMeta16',
                 'name': 'EmbeddedRoleTransfer',
                 'python_type': 'bool',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    ili1_optional_table: bool | None = field(
        default=None,
        metadata={'ili': {'alias': 'BOOLEAN',
                 'alias_kind': 'boolean',
                 'display_name': 'BOOLEAN',
                 'ili_type': 'TypeAlias',
                 'mandatory': False,
                 'model': 'IlisMeta16',
                 'name': 'ili1OptionalTable',
                 'python_type': 'bool',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.Class'
        topic = 'IlisMeta16.ModelData'
        kind = 'class'
        abstract = False
        extends = 'Type'

@dataclass(kw_only=True)
class AttrOrParam(ExtendableME):
    tid: str | None = field(
        default=None,
        metadata={'ili': {'alias': 'IlisMeta16.MetaElemOID',
                 'alias_kind': 'domain',
                 'display_name': 'OID TEXT',
                 'domain': 'IlisMeta16.MetaElemOID',
                 'identifier': True,
                 'identifier_category': 'oid',
                 'identifier_kind': 'text',
                 'ili_type': 'TextOIDType',
                 'mandatory': True,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'TID',
                 'python_type': 'str',
                 'topic': 'IlisMeta16.ModelData',
                 'value_type': {'display_name': 'TEXT',
                                'ili_type': 'TextType',
                                'max_length': None,
                                'normalized': True,
                                'text_kind': 'TEXT'}}},
    )
    subdivision_kind: Literal['NoSubDiv', 'SubDiv', 'ContSubDiv'] | None = field(
        default=None,
        metadata={'ili': {'display_name': 'NoSubDiv, SubDiv, ContSubDiv',
                 'ili_type': 'EnumerationType',
                 'literals': ['NoSubDiv', 'SubDiv', 'ContSubDiv'],
                 'mandatory': False,
                 'model': 'IlisMeta16',
                 'name': 'SubdivisionKind',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    transient: bool | None = field(
        default=None,
        metadata={'ili': {'alias': 'BOOLEAN',
                 'alias_kind': 'boolean',
                 'display_name': 'BOOLEAN',
                 'ili_type': 'TypeAlias',
                 'mandatory': False,
                 'model': 'IlisMeta16',
                 'name': 'Transient',
                 'python_type': 'bool',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    derivates: tuple[Expression, ...] = field(
        default_factory=tuple,
        metadata={'ili': {'cardinality': {'max': None, 'min': 0},
                 'display_name': 'Unknown',
                 'ili_type': 'ListType',
                 'is_bag': False,
                 'items': {'display_name': 'Expression',
                           'ili_type': 'ObjectType',
                           'qualified_target': 'IlisMeta16.ModelData.Expression',
                           'target': 'Expression'},
                 'mandatory': False,
                 'model': 'IlisMeta16',
                 'name': 'Derivates',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.AttrOrParam'
        topic = 'IlisMeta16.ModelData'
        kind = 'class'
        abstract = False
        extends = 'ExtendableME'

@dataclass(kw_only=True)
class TypeRelatedType(DomainType):
    tid: str | None = field(
        default=None,
        metadata={'ili': {'alias': 'IlisMeta16.MetaElemOID',
                 'alias_kind': 'domain',
                 'display_name': 'OID TEXT',
                 'domain': 'IlisMeta16.MetaElemOID',
                 'identifier': True,
                 'identifier_category': 'oid',
                 'identifier_kind': 'text',
                 'ili_type': 'TextOIDType',
                 'mandatory': True,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'TID',
                 'python_type': 'str',
                 'topic': 'IlisMeta16.ModelData',
                 'value_type': {'display_name': 'TEXT',
                                'ili_type': 'TextType',
                                'max_length': None,
                                'normalized': True,
                                'text_kind': 'TEXT'}}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.TypeRelatedType'
        topic = 'IlisMeta16.ModelData'
        kind = 'class'
        abstract = True
        extends = 'DomainType'

@dataclass(kw_only=True)
class MultiValue(TypeRelatedType):
    tid: str | None = field(
        default=None,
        metadata={'ili': {'alias': 'IlisMeta16.MetaElemOID',
                 'alias_kind': 'domain',
                 'display_name': 'OID TEXT',
                 'domain': 'IlisMeta16.MetaElemOID',
                 'identifier': True,
                 'identifier_category': 'oid',
                 'identifier_kind': 'text',
                 'ili_type': 'TextOIDType',
                 'mandatory': True,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'TID',
                 'python_type': 'str',
                 'topic': 'IlisMeta16.ModelData',
                 'value_type': {'display_name': 'TEXT',
                                'ili_type': 'TextType',
                                'max_length': None,
                                'normalized': True,
                                'text_kind': 'TEXT'}}},
    )
    ordered: bool = field(
        metadata={'ili': {'alias': 'BOOLEAN',
                 'alias_kind': 'boolean',
                 'display_name': 'BOOLEAN',
                 'ili_type': 'TypeAlias',
                 'mandatory': True,
                 'model': 'IlisMeta16',
                 'name': 'Ordered',
                 'python_type': 'bool',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    multiplicity: Multiplicity | None = field(
        default=None,
        metadata={'ili': {'alias': 'Multiplicity',
                 'alias_kind': 'object',
                 'display_name': 'Multiplicity',
                 'ili_type': 'TypeAlias',
                 'mandatory': False,
                 'model': 'IlisMeta16',
                 'name': 'Multiplicity',
                 'python_type': 'Multiplicity',
                 'qualified_target': 'IlisMeta16.ModelData.Multiplicity',
                 'target': 'Multiplicity',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.MultiValue'
        topic = 'IlisMeta16.ModelData'
        kind = 'class'
        abstract = False
        extends = 'TypeRelatedType'

@dataclass(kw_only=True)
class ClassRelatedType(DomainType):
    tid: str | None = field(
        default=None,
        metadata={'ili': {'alias': 'IlisMeta16.MetaElemOID',
                 'alias_kind': 'domain',
                 'display_name': 'OID TEXT',
                 'domain': 'IlisMeta16.MetaElemOID',
                 'identifier': True,
                 'identifier_category': 'oid',
                 'identifier_kind': 'text',
                 'ili_type': 'TextOIDType',
                 'mandatory': True,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'TID',
                 'python_type': 'str',
                 'topic': 'IlisMeta16.ModelData',
                 'value_type': {'display_name': 'TEXT',
                                'ili_type': 'TextType',
                                'max_length': None,
                                'normalized': True,
                                'text_kind': 'TEXT'}}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.ClassRelatedType'
        topic = 'IlisMeta16.ModelData'
        kind = 'class'
        abstract = True
        extends = 'DomainType'

@dataclass(kw_only=True)
class ReferenceType(ClassRelatedType):
    tid: str | None = field(
        default=None,
        metadata={'ili': {'alias': 'IlisMeta16.MetaElemOID',
                 'alias_kind': 'domain',
                 'display_name': 'OID TEXT',
                 'domain': 'IlisMeta16.MetaElemOID',
                 'identifier': True,
                 'identifier_category': 'oid',
                 'identifier_kind': 'text',
                 'ili_type': 'TextOIDType',
                 'mandatory': True,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'TID',
                 'python_type': 'str',
                 'topic': 'IlisMeta16.ModelData',
                 'value_type': {'display_name': 'TEXT',
                                'ili_type': 'TextType',
                                'max_length': None,
                                'normalized': True,
                                'text_kind': 'TEXT'}}},
    )
    external: bool = field(
        metadata={'ili': {'alias': 'BOOLEAN',
                 'alias_kind': 'boolean',
                 'display_name': 'BOOLEAN',
                 'ili_type': 'TypeAlias',
                 'mandatory': True,
                 'model': 'IlisMeta16',
                 'name': 'External',
                 'python_type': 'bool',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.ReferenceType'
        topic = 'IlisMeta16.ModelData'
        kind = 'class'
        abstract = False
        extends = 'ClassRelatedType'

@dataclass(kw_only=True)
class Role(ReferenceType):
    tid: str | None = field(
        default=None,
        metadata={'ili': {'alias': 'IlisMeta16.MetaElemOID',
                 'alias_kind': 'domain',
                 'display_name': 'OID TEXT',
                 'domain': 'IlisMeta16.MetaElemOID',
                 'identifier': True,
                 'identifier_category': 'oid',
                 'identifier_kind': 'text',
                 'ili_type': 'TextOIDType',
                 'mandatory': True,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'TID',
                 'python_type': 'str',
                 'topic': 'IlisMeta16.ModelData',
                 'value_type': {'display_name': 'TEXT',
                                'ili_type': 'TextType',
                                'max_length': None,
                                'normalized': True,
                                'text_kind': 'TEXT'}}},
    )
    strongness: Literal['Assoc', 'Aggr', 'Comp'] = field(
        metadata={'ili': {'display_name': 'Assoc, Aggr, Comp',
                 'ili_type': 'EnumerationType',
                 'literals': ['Assoc', 'Aggr', 'Comp'],
                 'mandatory': True,
                 'model': 'IlisMeta16',
                 'name': 'Strongness',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    ordered: bool = field(
        metadata={'ili': {'alias': 'BOOLEAN',
                 'alias_kind': 'boolean',
                 'display_name': 'BOOLEAN',
                 'ili_type': 'TypeAlias',
                 'mandatory': True,
                 'model': 'IlisMeta16',
                 'name': 'Ordered',
                 'python_type': 'bool',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    multiplicity: Multiplicity | None = field(
        default=None,
        metadata={'ili': {'alias': 'Multiplicity',
                 'alias_kind': 'object',
                 'display_name': 'Multiplicity',
                 'ili_type': 'TypeAlias',
                 'mandatory': False,
                 'model': 'IlisMeta16',
                 'name': 'Multiplicity',
                 'python_type': 'Multiplicity',
                 'qualified_target': 'IlisMeta16.ModelData.Multiplicity',
                 'target': 'Multiplicity',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    derivates: tuple[Expression, ...] = field(
        default_factory=tuple,
        metadata={'ili': {'cardinality': {'max': None, 'min': 0},
                 'display_name': 'Unknown',
                 'ili_type': 'ListType',
                 'is_bag': False,
                 'items': {'display_name': 'Expression',
                           'ili_type': 'ObjectType',
                           'qualified_target': 'IlisMeta16.ModelData.Expression',
                           'target': 'Expression'},
                 'mandatory': False,
                 'model': 'IlisMeta16',
                 'name': 'Derivates',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    embedded_transfer: bool = field(
        metadata={'ili': {'alias': 'BOOLEAN',
                 'alias_kind': 'boolean',
                 'display_name': 'BOOLEAN',
                 'ili_type': 'TypeAlias',
                 'mandatory': True,
                 'model': 'IlisMeta16',
                 'name': 'EmbeddedTransfer',
                 'python_type': 'bool',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.Role'
        topic = 'IlisMeta16.ModelData'
        kind = 'class'
        abstract = False
        extends = 'ReferenceType'

@dataclass(kw_only=True)
class ExplicitAssocAccess(ExtendableME):
    tid: str | None = field(
        default=None,
        metadata={'ili': {'alias': 'IlisMeta16.MetaElemOID',
                 'alias_kind': 'domain',
                 'display_name': 'OID TEXT',
                 'domain': 'IlisMeta16.MetaElemOID',
                 'identifier': True,
                 'identifier_category': 'oid',
                 'identifier_kind': 'text',
                 'ili_type': 'TextOIDType',
                 'mandatory': True,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'TID',
                 'python_type': 'str',
                 'topic': 'IlisMeta16.ModelData',
                 'value_type': {'display_name': 'TEXT',
                                'ili_type': 'TextType',
                                'max_length': None,
                                'normalized': True,
                                'text_kind': 'TEXT'}}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.ExplicitAssocAccess'
        topic = 'IlisMeta16.ModelData'
        kind = 'class'
        abstract = False
        extends = 'ExtendableME'

@dataclass(kw_only=True)
class DataUnit(ExtendableME):
    tid: str | None = field(
        default=None,
        metadata={'ili': {'alias': 'IlisMeta16.MetaElemOID',
                 'alias_kind': 'domain',
                 'display_name': 'OID TEXT',
                 'domain': 'IlisMeta16.MetaElemOID',
                 'identifier': True,
                 'identifier_category': 'oid',
                 'identifier_kind': 'text',
                 'ili_type': 'TextOIDType',
                 'mandatory': True,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'TID',
                 'python_type': 'str',
                 'topic': 'IlisMeta16.ModelData',
                 'value_type': {'display_name': 'TEXT',
                                'ili_type': 'TextType',
                                'max_length': None,
                                'normalized': True,
                                'text_kind': 'TEXT'}}},
    )
    name: str = field(
        metadata={'ili': {'display_name': 'TEXT',
                 'ili_type': 'TextType',
                 'mandatory': True,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'Name',
                 'normalized': True,
                 'text_kind': 'TEXT',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    view_unit: bool = field(
        metadata={'ili': {'alias': 'BOOLEAN',
                 'alias_kind': 'boolean',
                 'display_name': 'BOOLEAN',
                 'ili_type': 'TypeAlias',
                 'mandatory': True,
                 'model': 'IlisMeta16',
                 'name': 'ViewUnit',
                 'python_type': 'bool',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    data_unit_name: str = field(
        metadata={'ili': {'display_name': 'TEXT',
                 'ili_type': 'TextType',
                 'mandatory': True,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'DataUnitName',
                 'normalized': True,
                 'text_kind': 'TEXT',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.DataUnit'
        topic = 'IlisMeta16.ModelData'
        kind = 'class'
        abstract = False
        extends = 'ExtendableME'

@dataclass(kw_only=True)
class Context(MetaElement):
    tid: str | None = field(
        default=None,
        metadata={'ili': {'alias': 'IlisMeta16.MetaElemOID',
                 'alias_kind': 'domain',
                 'display_name': 'OID TEXT',
                 'domain': 'IlisMeta16.MetaElemOID',
                 'identifier': True,
                 'identifier_category': 'oid',
                 'identifier_kind': 'text',
                 'ili_type': 'TextOIDType',
                 'mandatory': True,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'TID',
                 'python_type': 'str',
                 'topic': 'IlisMeta16.ModelData',
                 'value_type': {'display_name': 'TEXT',
                                'ili_type': 'TextType',
                                'max_length': None,
                                'normalized': True,
                                'text_kind': 'TEXT'}}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.Context'
        topic = 'IlisMeta16.ModelData'
        kind = 'class'
        abstract = False
        extends = 'MetaElement'

@dataclass(kw_only=True)
class Unit(ExtendableME):
    tid: str | None = field(
        default=None,
        metadata={'ili': {'alias': 'IlisMeta16.MetaElemOID',
                 'alias_kind': 'domain',
                 'display_name': 'OID TEXT',
                 'domain': 'IlisMeta16.MetaElemOID',
                 'identifier': True,
                 'identifier_category': 'oid',
                 'identifier_kind': 'text',
                 'ili_type': 'TextOIDType',
                 'mandatory': True,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'TID',
                 'python_type': 'str',
                 'topic': 'IlisMeta16.ModelData',
                 'value_type': {'display_name': 'TEXT',
                                'ili_type': 'TextType',
                                'max_length': None,
                                'normalized': True,
                                'text_kind': 'TEXT'}}},
    )
    kind: Literal['BaseU', 'DerivedU', 'ComposedU'] = field(
        metadata={'ili': {'display_name': 'BaseU, DerivedU, ComposedU',
                 'ili_type': 'EnumerationType',
                 'literals': ['BaseU', 'DerivedU', 'ComposedU'],
                 'mandatory': True,
                 'model': 'IlisMeta16',
                 'name': 'Kind',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    definition: Expression | None = field(
        default=None,
        metadata={'ili': {'alias': 'Expression',
                 'alias_kind': 'object',
                 'display_name': 'Expression',
                 'ili_type': 'TypeAlias',
                 'mandatory': False,
                 'model': 'IlisMeta16',
                 'name': 'Definition',
                 'python_type': 'Expression',
                 'qualified_target': 'IlisMeta16.ModelData.Expression',
                 'target': 'Expression',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.Unit'
        topic = 'IlisMeta16.ModelData'
        kind = 'class'
        abstract = False
        extends = 'ExtendableME'

@dataclass(kw_only=True)
class MetaBasketDef(ExtendableME):
    tid: str | None = field(
        default=None,
        metadata={'ili': {'alias': 'IlisMeta16.MetaElemOID',
                 'alias_kind': 'domain',
                 'display_name': 'OID TEXT',
                 'domain': 'IlisMeta16.MetaElemOID',
                 'identifier': True,
                 'identifier_category': 'oid',
                 'identifier_kind': 'text',
                 'ili_type': 'TextOIDType',
                 'mandatory': True,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'TID',
                 'python_type': 'str',
                 'topic': 'IlisMeta16.ModelData',
                 'value_type': {'display_name': 'TEXT',
                                'ili_type': 'TextType',
                                'max_length': None,
                                'normalized': True,
                                'text_kind': 'TEXT'}}},
    )
    kind: Literal['SignB', 'RefSystemB'] = field(
        metadata={'ili': {'display_name': 'SignB, RefSystemB',
                 'ili_type': 'EnumerationType',
                 'literals': ['SignB', 'RefSystemB'],
                 'mandatory': True,
                 'model': 'IlisMeta16',
                 'name': 'Kind',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.MetaBasketDef'
        topic = 'IlisMeta16.ModelData'
        kind = 'class'
        abstract = False
        extends = 'ExtendableME'

@dataclass(kw_only=True)
class MetaObjectDef(MetaElement):
    tid: str | None = field(
        default=None,
        metadata={'ili': {'alias': 'IlisMeta16.MetaElemOID',
                 'alias_kind': 'domain',
                 'display_name': 'OID TEXT',
                 'domain': 'IlisMeta16.MetaElemOID',
                 'identifier': True,
                 'identifier_category': 'oid',
                 'identifier_kind': 'text',
                 'ili_type': 'TextOIDType',
                 'mandatory': True,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'TID',
                 'python_type': 'str',
                 'topic': 'IlisMeta16.ModelData',
                 'value_type': {'display_name': 'TEXT',
                                'ili_type': 'TextType',
                                'max_length': None,
                                'normalized': True,
                                'text_kind': 'TEXT'}}},
    )
    is_ref_system: bool = field(
        metadata={'ili': {'alias': 'BOOLEAN',
                 'alias_kind': 'boolean',
                 'display_name': 'BOOLEAN',
                 'ili_type': 'TypeAlias',
                 'mandatory': True,
                 'model': 'IlisMeta16',
                 'name': 'IsRefSystem',
                 'python_type': 'bool',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.MetaObjectDef'
        topic = 'IlisMeta16.ModelData'
        kind = 'class'
        abstract = False
        extends = 'MetaElement'

@dataclass(kw_only=True)
class BooleanType(DomainType):
    tid: str | None = field(
        default=None,
        metadata={'ili': {'alias': 'IlisMeta16.MetaElemOID',
                 'alias_kind': 'domain',
                 'display_name': 'OID TEXT',
                 'domain': 'IlisMeta16.MetaElemOID',
                 'identifier': True,
                 'identifier_category': 'oid',
                 'identifier_kind': 'text',
                 'ili_type': 'TextOIDType',
                 'mandatory': True,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'TID',
                 'python_type': 'str',
                 'topic': 'IlisMeta16.ModelData',
                 'value_type': {'display_name': 'TEXT',
                                'ili_type': 'TextType',
                                'max_length': None,
                                'normalized': True,
                                'text_kind': 'TEXT'}}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.BooleanType'
        topic = 'IlisMeta16.ModelData'
        kind = 'class'
        abstract = False
        extends = 'DomainType'

@dataclass(kw_only=True)
class TextType(DomainType):
    tid: str | None = field(
        default=None,
        metadata={'ili': {'alias': 'IlisMeta16.MetaElemOID',
                 'alias_kind': 'domain',
                 'display_name': 'OID TEXT',
                 'domain': 'IlisMeta16.MetaElemOID',
                 'identifier': True,
                 'identifier_category': 'oid',
                 'identifier_kind': 'text',
                 'ili_type': 'TextOIDType',
                 'mandatory': True,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'TID',
                 'python_type': 'str',
                 'topic': 'IlisMeta16.ModelData',
                 'value_type': {'display_name': 'TEXT',
                                'ili_type': 'TextType',
                                'max_length': None,
                                'normalized': True,
                                'text_kind': 'TEXT'}}},
    )
    kind: Literal['MText', 'Text', 'Name', 'Uri'] = field(
        metadata={'ili': {'display_name': 'MText, Text, Name, Uri',
                 'ili_type': 'EnumerationType',
                 'literals': ['MText', 'Text', 'Name', 'Uri'],
                 'mandatory': True,
                 'model': 'IlisMeta16',
                 'name': 'Kind',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    max_length: int | None = field(
        default=None,
        metadata={'ili': {'alias': 'LengthRange',
                 'alias_kind': 'numeric',
                 'display_name': 'LengthRange',
                 'ili_type': 'TypeAlias',
                 'mandatory': False,
                 'maximum': 2147483647,
                 'minimum': 1,
                 'model': 'IlisMeta16',
                 'name': 'MaxLength',
                 'python_type': 'int',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.TextType'
        topic = 'IlisMeta16.ModelData'
        kind = 'class'
        abstract = False
        extends = 'DomainType'

@dataclass(kw_only=True)
class BlackboxType(DomainType):
    tid: str | None = field(
        default=None,
        metadata={'ili': {'alias': 'IlisMeta16.MetaElemOID',
                 'alias_kind': 'domain',
                 'display_name': 'OID TEXT',
                 'domain': 'IlisMeta16.MetaElemOID',
                 'identifier': True,
                 'identifier_category': 'oid',
                 'identifier_kind': 'text',
                 'ili_type': 'TextOIDType',
                 'mandatory': True,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'TID',
                 'python_type': 'str',
                 'topic': 'IlisMeta16.ModelData',
                 'value_type': {'display_name': 'TEXT',
                                'ili_type': 'TextType',
                                'max_length': None,
                                'normalized': True,
                                'text_kind': 'TEXT'}}},
    )
    kind: Literal['Binary', 'Xml'] = field(
        metadata={'ili': {'display_name': 'Binary, Xml',
                 'ili_type': 'EnumerationType',
                 'literals': ['Binary', 'Xml'],
                 'mandatory': True,
                 'model': 'IlisMeta16',
                 'name': 'Kind',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.BlackboxType'
        topic = 'IlisMeta16.ModelData'
        kind = 'class'
        abstract = False
        extends = 'DomainType'

@dataclass(kw_only=True)
class NumType(DomainType):
    tid: str | None = field(
        default=None,
        metadata={'ili': {'alias': 'IlisMeta16.MetaElemOID',
                 'alias_kind': 'domain',
                 'display_name': 'OID TEXT',
                 'domain': 'IlisMeta16.MetaElemOID',
                 'identifier': True,
                 'identifier_category': 'oid',
                 'identifier_kind': 'text',
                 'ili_type': 'TextOIDType',
                 'mandatory': True,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'TID',
                 'python_type': 'str',
                 'topic': 'IlisMeta16.ModelData',
                 'value_type': {'display_name': 'TEXT',
                                'ili_type': 'TextType',
                                'max_length': None,
                                'normalized': True,
                                'text_kind': 'TEXT'}}},
    )
    min: str | None = field(
        default=None,
        metadata={'ili': {'display_name': 'TEXT',
                 'ili_type': 'TextType',
                 'mandatory': False,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'Min',
                 'normalized': True,
                 'text_kind': 'TEXT',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    max: str | None = field(
        default=None,
        metadata={'ili': {'display_name': 'TEXT',
                 'ili_type': 'TextType',
                 'mandatory': False,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'Max',
                 'normalized': True,
                 'text_kind': 'TEXT',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    circular: bool | None = field(
        default=None,
        metadata={'ili': {'alias': 'BOOLEAN',
                 'alias_kind': 'boolean',
                 'display_name': 'BOOLEAN',
                 'ili_type': 'TypeAlias',
                 'mandatory': False,
                 'model': 'IlisMeta16',
                 'name': 'Circular',
                 'python_type': 'bool',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    clockwise: bool | None = field(
        default=None,
        metadata={'ili': {'alias': 'BOOLEAN',
                 'alias_kind': 'boolean',
                 'display_name': 'BOOLEAN',
                 'ili_type': 'TypeAlias',
                 'mandatory': False,
                 'model': 'IlisMeta16',
                 'name': 'Clockwise',
                 'python_type': 'bool',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.NumType'
        topic = 'IlisMeta16.ModelData'
        kind = 'class'
        abstract = False
        extends = 'DomainType'

@dataclass(kw_only=True)
class CoordType(DomainType):
    tid: str | None = field(
        default=None,
        metadata={'ili': {'alias': 'IlisMeta16.MetaElemOID',
                 'alias_kind': 'domain',
                 'display_name': 'OID TEXT',
                 'domain': 'IlisMeta16.MetaElemOID',
                 'identifier': True,
                 'identifier_category': 'oid',
                 'identifier_kind': 'text',
                 'ili_type': 'TextOIDType',
                 'mandatory': True,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'TID',
                 'python_type': 'str',
                 'topic': 'IlisMeta16.ModelData',
                 'value_type': {'display_name': 'TEXT',
                                'ili_type': 'TextType',
                                'max_length': None,
                                'normalized': True,
                                'text_kind': 'TEXT'}}},
    )
    null_axis: int | None = field(
        default=None,
        metadata={'ili': {'alias': 'AxisInd',
                 'alias_kind': 'numeric',
                 'display_name': 'AxisInd',
                 'ili_type': 'TypeAlias',
                 'mandatory': False,
                 'maximum': 3,
                 'minimum': 1,
                 'model': 'IlisMeta16',
                 'name': 'NullAxis',
                 'python_type': 'int',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    pi_half_axis: int | None = field(
        default=None,
        metadata={'ili': {'alias': 'AxisInd',
                 'alias_kind': 'numeric',
                 'display_name': 'AxisInd',
                 'ili_type': 'TypeAlias',
                 'mandatory': False,
                 'maximum': 3,
                 'minimum': 1,
                 'model': 'IlisMeta16',
                 'name': 'PiHalfAxis',
                 'python_type': 'int',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    multi: bool | None = field(
        default=None,
        metadata={'ili': {'alias': 'BOOLEAN',
                 'alias_kind': 'boolean',
                 'display_name': 'BOOLEAN',
                 'ili_type': 'TypeAlias',
                 'mandatory': False,
                 'model': 'IlisMeta16',
                 'name': 'Multi',
                 'python_type': 'bool',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.CoordType'
        topic = 'IlisMeta16.ModelData'
        kind = 'class'
        abstract = False
        extends = 'DomainType'

@dataclass(kw_only=True)
class FormattedType(NumType):
    tid: str | None = field(
        default=None,
        metadata={'ili': {'alias': 'IlisMeta16.MetaElemOID',
                 'alias_kind': 'domain',
                 'display_name': 'OID TEXT',
                 'domain': 'IlisMeta16.MetaElemOID',
                 'identifier': True,
                 'identifier_category': 'oid',
                 'identifier_kind': 'text',
                 'ili_type': 'TextOIDType',
                 'mandatory': True,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'TID',
                 'python_type': 'str',
                 'topic': 'IlisMeta16.ModelData',
                 'value_type': {'display_name': 'TEXT',
                                'ili_type': 'TextType',
                                'max_length': None,
                                'normalized': True,
                                'text_kind': 'TEXT'}}},
    )
    format: str = field(
        metadata={'ili': {'display_name': 'TEXT',
                 'ili_type': 'TextType',
                 'mandatory': True,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'Format',
                 'normalized': True,
                 'text_kind': 'TEXT',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.FormattedType'
        topic = 'IlisMeta16.ModelData'
        kind = 'class'
        abstract = False
        extends = 'NumType'

@dataclass(kw_only=True)
class AnyOIDType(DomainType):
    tid: str | None = field(
        default=None,
        metadata={'ili': {'alias': 'IlisMeta16.MetaElemOID',
                 'alias_kind': 'domain',
                 'display_name': 'OID TEXT',
                 'domain': 'IlisMeta16.MetaElemOID',
                 'identifier': True,
                 'identifier_category': 'oid',
                 'identifier_kind': 'text',
                 'ili_type': 'TextOIDType',
                 'mandatory': True,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'TID',
                 'python_type': 'str',
                 'topic': 'IlisMeta16.ModelData',
                 'value_type': {'display_name': 'TEXT',
                                'ili_type': 'TextType',
                                'max_length': None,
                                'normalized': True,
                                'text_kind': 'TEXT'}}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.AnyOIDType'
        topic = 'IlisMeta16.ModelData'
        kind = 'class'
        abstract = False
        extends = 'DomainType'

@dataclass(kw_only=True)
class FunctionDef(MetaElement):
    tid: str | None = field(
        default=None,
        metadata={'ili': {'alias': 'IlisMeta16.MetaElemOID',
                 'alias_kind': 'domain',
                 'display_name': 'OID TEXT',
                 'domain': 'IlisMeta16.MetaElemOID',
                 'identifier': True,
                 'identifier_category': 'oid',
                 'identifier_kind': 'text',
                 'ili_type': 'TextOIDType',
                 'mandatory': True,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'TID',
                 'python_type': 'str',
                 'topic': 'IlisMeta16.ModelData',
                 'value_type': {'display_name': 'TEXT',
                                'ili_type': 'TextType',
                                'max_length': None,
                                'normalized': True,
                                'text_kind': 'TEXT'}}},
    )
    explanation: str | None = field(
        default=None,
        metadata={'ili': {'display_name': 'TEXT',
                 'ili_type': 'TextType',
                 'mandatory': False,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'Explanation',
                 'normalized': True,
                 'text_kind': 'TEXT',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.FunctionDef'
        topic = 'IlisMeta16.ModelData'
        kind = 'class'
        abstract = False
        extends = 'MetaElement'

@dataclass(kw_only=True)
class Argument(MetaElement):
    tid: str | None = field(
        default=None,
        metadata={'ili': {'alias': 'IlisMeta16.MetaElemOID',
                 'alias_kind': 'domain',
                 'display_name': 'OID TEXT',
                 'domain': 'IlisMeta16.MetaElemOID',
                 'identifier': True,
                 'identifier_category': 'oid',
                 'identifier_kind': 'text',
                 'ili_type': 'TextOIDType',
                 'mandatory': True,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'TID',
                 'python_type': 'str',
                 'topic': 'IlisMeta16.ModelData',
                 'value_type': {'display_name': 'TEXT',
                                'ili_type': 'TextType',
                                'max_length': None,
                                'normalized': True,
                                'text_kind': 'TEXT'}}},
    )
    kind: Literal['Type', 'EnumVal', 'EnumTreeVal'] = field(
        metadata={'ili': {'display_name': 'Type, EnumVal, EnumTreeVal',
                 'ili_type': 'EnumerationType',
                 'literals': ['Type', 'EnumVal', 'EnumTreeVal'],
                 'mandatory': True,
                 'model': 'IlisMeta16',
                 'name': 'Kind',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.Argument'
        topic = 'IlisMeta16.ModelData'
        kind = 'class'
        abstract = False
        extends = 'MetaElement'

@dataclass(kw_only=True)
class ClassRefType(ClassRelatedType):
    tid: str | None = field(
        default=None,
        metadata={'ili': {'alias': 'IlisMeta16.MetaElemOID',
                 'alias_kind': 'domain',
                 'display_name': 'OID TEXT',
                 'domain': 'IlisMeta16.MetaElemOID',
                 'identifier': True,
                 'identifier_category': 'oid',
                 'identifier_kind': 'text',
                 'ili_type': 'TextOIDType',
                 'mandatory': True,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'TID',
                 'python_type': 'str',
                 'topic': 'IlisMeta16.ModelData',
                 'value_type': {'display_name': 'TEXT',
                                'ili_type': 'TextType',
                                'max_length': None,
                                'normalized': True,
                                'text_kind': 'TEXT'}}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.ClassRefType'
        topic = 'IlisMeta16.ModelData'
        kind = 'class'
        abstract = False
        extends = 'ClassRelatedType'

@dataclass(kw_only=True)
class ObjectType(ClassRelatedType):
    tid: str | None = field(
        default=None,
        metadata={'ili': {'alias': 'IlisMeta16.MetaElemOID',
                 'alias_kind': 'domain',
                 'display_name': 'OID TEXT',
                 'domain': 'IlisMeta16.MetaElemOID',
                 'identifier': True,
                 'identifier_category': 'oid',
                 'identifier_kind': 'text',
                 'ili_type': 'TextOIDType',
                 'mandatory': True,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'TID',
                 'python_type': 'str',
                 'topic': 'IlisMeta16.ModelData',
                 'value_type': {'display_name': 'TEXT',
                                'ili_type': 'TextType',
                                'max_length': None,
                                'normalized': True,
                                'text_kind': 'TEXT'}}},
    )
    multiple: bool = field(
        metadata={'ili': {'alias': 'BOOLEAN',
                 'alias_kind': 'boolean',
                 'display_name': 'BOOLEAN',
                 'ili_type': 'TypeAlias',
                 'mandatory': True,
                 'model': 'IlisMeta16',
                 'name': 'Multiple',
                 'python_type': 'bool',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.ObjectType'
        topic = 'IlisMeta16.ModelData'
        kind = 'class'
        abstract = False
        extends = 'ClassRelatedType'

@dataclass(kw_only=True)
class AttributeRefType(DomainType):
    tid: str | None = field(
        default=None,
        metadata={'ili': {'alias': 'IlisMeta16.MetaElemOID',
                 'alias_kind': 'domain',
                 'display_name': 'OID TEXT',
                 'domain': 'IlisMeta16.MetaElemOID',
                 'identifier': True,
                 'identifier_category': 'oid',
                 'identifier_kind': 'text',
                 'ili_type': 'TextOIDType',
                 'mandatory': True,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'TID',
                 'python_type': 'str',
                 'topic': 'IlisMeta16.ModelData',
                 'value_type': {'display_name': 'TEXT',
                                'ili_type': 'TextType',
                                'max_length': None,
                                'normalized': True,
                                'text_kind': 'TEXT'}}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.AttributeRefType'
        topic = 'IlisMeta16.ModelData'
        kind = 'class'
        abstract = False
        extends = 'DomainType'

@dataclass(kw_only=True)
class EnumType(DomainType):
    tid: str | None = field(
        default=None,
        metadata={'ili': {'alias': 'IlisMeta16.MetaElemOID',
                 'alias_kind': 'domain',
                 'display_name': 'OID TEXT',
                 'domain': 'IlisMeta16.MetaElemOID',
                 'identifier': True,
                 'identifier_category': 'oid',
                 'identifier_kind': 'text',
                 'ili_type': 'TextOIDType',
                 'mandatory': True,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'TID',
                 'python_type': 'str',
                 'topic': 'IlisMeta16.ModelData',
                 'value_type': {'display_name': 'TEXT',
                                'ili_type': 'TextType',
                                'max_length': None,
                                'normalized': True,
                                'text_kind': 'TEXT'}}},
    )
    order: Literal['Unordered', 'Ordered', 'Circular'] = field(
        metadata={'ili': {'display_name': 'Unordered, Ordered, Circular',
                 'ili_type': 'EnumerationType',
                 'literals': ['Unordered', 'Ordered', 'Circular'],
                 'mandatory': True,
                 'model': 'IlisMeta16',
                 'name': 'Order',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.EnumType'
        topic = 'IlisMeta16.ModelData'
        kind = 'class'
        abstract = False
        extends = 'DomainType'

@dataclass(kw_only=True)
class EnumNode(ExtendableME):
    tid: str | None = field(
        default=None,
        metadata={'ili': {'alias': 'IlisMeta16.MetaElemOID',
                 'alias_kind': 'domain',
                 'display_name': 'OID TEXT',
                 'domain': 'IlisMeta16.MetaElemOID',
                 'identifier': True,
                 'identifier_category': 'oid',
                 'identifier_kind': 'text',
                 'ili_type': 'TextOIDType',
                 'mandatory': True,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'TID',
                 'python_type': 'str',
                 'topic': 'IlisMeta16.ModelData',
                 'value_type': {'display_name': 'TEXT',
                                'ili_type': 'TextType',
                                'max_length': None,
                                'normalized': True,
                                'text_kind': 'TEXT'}}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.EnumNode'
        topic = 'IlisMeta16.ModelData'
        kind = 'class'
        abstract = False
        extends = 'ExtendableME'

@dataclass(kw_only=True)
class EnumTreeValueType(DomainType):
    tid: str | None = field(
        default=None,
        metadata={'ili': {'alias': 'IlisMeta16.MetaElemOID',
                 'alias_kind': 'domain',
                 'display_name': 'OID TEXT',
                 'domain': 'IlisMeta16.MetaElemOID',
                 'identifier': True,
                 'identifier_category': 'oid',
                 'identifier_kind': 'text',
                 'ili_type': 'TextOIDType',
                 'mandatory': True,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'TID',
                 'python_type': 'str',
                 'topic': 'IlisMeta16.ModelData',
                 'value_type': {'display_name': 'TEXT',
                                'ili_type': 'TextType',
                                'max_length': None,
                                'normalized': True,
                                'text_kind': 'TEXT'}}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.EnumTreeValueType'
        topic = 'IlisMeta16.ModelData'
        kind = 'class'
        abstract = False
        extends = 'DomainType'

@dataclass(kw_only=True)
class LineForm(MetaElement):
    tid: str | None = field(
        default=None,
        metadata={'ili': {'alias': 'IlisMeta16.MetaElemOID',
                 'alias_kind': 'domain',
                 'display_name': 'OID TEXT',
                 'domain': 'IlisMeta16.MetaElemOID',
                 'identifier': True,
                 'identifier_category': 'oid',
                 'identifier_kind': 'text',
                 'ili_type': 'TextOIDType',
                 'mandatory': True,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'TID',
                 'python_type': 'str',
                 'topic': 'IlisMeta16.ModelData',
                 'value_type': {'display_name': 'TEXT',
                                'ili_type': 'TextType',
                                'max_length': None,
                                'normalized': True,
                                'text_kind': 'TEXT'}}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.LineForm'
        topic = 'IlisMeta16.ModelData'
        kind = 'class'
        abstract = False
        extends = 'MetaElement'

@dataclass(kw_only=True)
class LineType(DomainType):
    tid: str | None = field(
        default=None,
        metadata={'ili': {'alias': 'IlisMeta16.MetaElemOID',
                 'alias_kind': 'domain',
                 'display_name': 'OID TEXT',
                 'domain': 'IlisMeta16.MetaElemOID',
                 'identifier': True,
                 'identifier_category': 'oid',
                 'identifier_kind': 'text',
                 'ili_type': 'TextOIDType',
                 'mandatory': True,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'TID',
                 'python_type': 'str',
                 'topic': 'IlisMeta16.ModelData',
                 'value_type': {'display_name': 'TEXT',
                                'ili_type': 'TextType',
                                'max_length': None,
                                'normalized': True,
                                'text_kind': 'TEXT'}}},
    )
    kind: Literal['Polyline', 'DirectedPolyline', 'Surface', 'Area'] = field(
        metadata={'ili': {'display_name': 'Polyline, DirectedPolyline, Surface, Area',
                 'ili_type': 'EnumerationType',
                 'literals': ['Polyline', 'DirectedPolyline', 'Surface', 'Area'],
                 'mandatory': True,
                 'model': 'IlisMeta16',
                 'name': 'Kind',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    max_overlap: str | None = field(
        default=None,
        metadata={'ili': {'display_name': 'TEXT',
                 'ili_type': 'TextType',
                 'mandatory': False,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'MaxOverlap',
                 'normalized': True,
                 'text_kind': 'TEXT',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    multi: bool | None = field(
        default=None,
        metadata={'ili': {'alias': 'BOOLEAN',
                 'alias_kind': 'boolean',
                 'display_name': 'BOOLEAN',
                 'ili_type': 'TypeAlias',
                 'mandatory': False,
                 'model': 'IlisMeta16',
                 'name': 'Multi',
                 'python_type': 'bool',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.LineType'
        topic = 'IlisMeta16.ModelData'
        kind = 'class'
        abstract = False
        extends = 'DomainType'

@dataclass(kw_only=True)
class View(Class):
    tid: str | None = field(
        default=None,
        metadata={'ili': {'alias': 'IlisMeta16.MetaElemOID',
                 'alias_kind': 'domain',
                 'display_name': 'OID TEXT',
                 'domain': 'IlisMeta16.MetaElemOID',
                 'identifier': True,
                 'identifier_category': 'oid',
                 'identifier_kind': 'text',
                 'ili_type': 'TextOIDType',
                 'mandatory': True,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'TID',
                 'python_type': 'str',
                 'topic': 'IlisMeta16.ModelData',
                 'value_type': {'display_name': 'TEXT',
                                'ili_type': 'TextType',
                                'max_length': None,
                                'normalized': True,
                                'text_kind': 'TEXT'}}},
    )
    formation_kind: Literal['Projection', 'Join', 'Union', 'Aggregation.All', 'Aggregation.Equal', 'Inspection.Normal', 'Inspection.Area'] = field(
        metadata={'ili': {'display_name': 'Projection, Join, Union, Aggregation.All, Aggregation.Equal, '
                                 'Inspection.Normal, Inspection.Area',
                 'ili_type': 'EnumerationType',
                 'literals': ['Projection',
                              'Join',
                              'Union',
                              'Aggregation.All',
                              'Aggregation.Equal',
                              'Inspection.Normal',
                              'Inspection.Area'],
                 'mandatory': True,
                 'model': 'IlisMeta16',
                 'name': 'FormationKind',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    formation_parameter: tuple[Expression, ...] = field(
        default_factory=tuple,
        metadata={'ili': {'cardinality': {'max': None, 'min': 0},
                 'display_name': 'Unknown',
                 'ili_type': 'ListType',
                 'is_bag': False,
                 'items': {'display_name': 'Expression',
                           'ili_type': 'ObjectType',
                           'qualified_target': 'IlisMeta16.ModelData.Expression',
                           'target': 'Expression'},
                 'mandatory': False,
                 'model': 'IlisMeta16',
                 'name': 'FormationParameter',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    where: Expression | None = field(
        default=None,
        metadata={'ili': {'alias': 'Expression',
                 'alias_kind': 'object',
                 'display_name': 'Expression',
                 'ili_type': 'TypeAlias',
                 'mandatory': False,
                 'model': 'IlisMeta16',
                 'name': 'Where',
                 'python_type': 'Expression',
                 'qualified_target': 'IlisMeta16.ModelData.Expression',
                 'target': 'Expression',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    transient: bool = field(
        metadata={'ili': {'alias': 'BOOLEAN',
                 'alias_kind': 'boolean',
                 'display_name': 'BOOLEAN',
                 'ili_type': 'TypeAlias',
                 'mandatory': True,
                 'model': 'IlisMeta16',
                 'name': 'Transient',
                 'python_type': 'bool',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.View'
        topic = 'IlisMeta16.ModelData'
        kind = 'class'
        abstract = False
        extends = 'Class'

@dataclass(kw_only=True)
class RenamedBaseView(ExtendableME):
    tid: str | None = field(
        default=None,
        metadata={'ili': {'alias': 'IlisMeta16.MetaElemOID',
                 'alias_kind': 'domain',
                 'display_name': 'OID TEXT',
                 'domain': 'IlisMeta16.MetaElemOID',
                 'identifier': True,
                 'identifier_category': 'oid',
                 'identifier_kind': 'text',
                 'ili_type': 'TextOIDType',
                 'mandatory': True,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'TID',
                 'python_type': 'str',
                 'topic': 'IlisMeta16.ModelData',
                 'value_type': {'display_name': 'TEXT',
                                'ili_type': 'TextType',
                                'max_length': None,
                                'normalized': True,
                                'text_kind': 'TEXT'}}},
    )
    or_null: bool | None = field(
        default=None,
        metadata={'ili': {'alias': 'BOOLEAN',
                 'alias_kind': 'boolean',
                 'display_name': 'BOOLEAN',
                 'ili_type': 'TypeAlias',
                 'mandatory': False,
                 'model': 'IlisMeta16',
                 'name': 'OrNull',
                 'python_type': 'bool',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.RenamedBaseView'
        topic = 'IlisMeta16.ModelData'
        kind = 'class'
        abstract = False
        extends = 'ExtendableME'

@dataclass(kw_only=True)
class SimpleConstraint(Constraint):
    tid: str | None = field(
        default=None,
        metadata={'ili': {'alias': 'IlisMeta16.MetaElemOID',
                 'alias_kind': 'domain',
                 'display_name': 'OID TEXT',
                 'domain': 'IlisMeta16.MetaElemOID',
                 'identifier': True,
                 'identifier_category': 'oid',
                 'identifier_kind': 'text',
                 'ili_type': 'TextOIDType',
                 'mandatory': True,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'TID',
                 'python_type': 'str',
                 'topic': 'IlisMeta16.ModelData',
                 'value_type': {'display_name': 'TEXT',
                                'ili_type': 'TextType',
                                'max_length': None,
                                'normalized': True,
                                'text_kind': 'TEXT'}}},
    )
    kind: Literal['MandC', 'LowPercC', 'HighPercC'] | None = field(
        default=None,
        metadata={'ili': {'display_name': 'MandC, LowPercC, HighPercC',
                 'ili_type': 'EnumerationType',
                 'literals': ['MandC', 'LowPercC', 'HighPercC'],
                 'mandatory': False,
                 'model': 'IlisMeta16',
                 'name': 'Kind',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    percentage: float | None = field(
        default=None,
        metadata={'ili': {'display_name': '0.00..100.00',
                 'ili_type': 'NumericType',
                 'mandatory': False,
                 'maximum': '100.00',
                 'minimum': '0.00',
                 'model': 'IlisMeta16',
                 'name': 'Percentage',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    logical_expression: Expression | None = field(
        default=None,
        metadata={'ili': {'alias': 'Expression',
                 'alias_kind': 'object',
                 'display_name': 'Expression',
                 'ili_type': 'TypeAlias',
                 'mandatory': False,
                 'model': 'IlisMeta16',
                 'name': 'LogicalExpression',
                 'python_type': 'Expression',
                 'qualified_target': 'IlisMeta16.ModelData.Expression',
                 'target': 'Expression',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.SimpleConstraint'
        topic = 'IlisMeta16.ModelData'
        kind = 'class'
        abstract = False
        extends = 'Constraint'

@dataclass(kw_only=True)
class ExistenceConstraint(Constraint):
    tid: str | None = field(
        default=None,
        metadata={'ili': {'alias': 'IlisMeta16.MetaElemOID',
                 'alias_kind': 'domain',
                 'display_name': 'OID TEXT',
                 'domain': 'IlisMeta16.MetaElemOID',
                 'identifier': True,
                 'identifier_category': 'oid',
                 'identifier_kind': 'text',
                 'ili_type': 'TextOIDType',
                 'mandatory': True,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'TID',
                 'python_type': 'str',
                 'topic': 'IlisMeta16.ModelData',
                 'value_type': {'display_name': 'TEXT',
                                'ili_type': 'TextType',
                                'max_length': None,
                                'normalized': True,
                                'text_kind': 'TEXT'}}},
    )
    attr: PathOrInspFactor = field(
        metadata={'ili': {'alias': 'PathOrInspFactor',
                 'alias_kind': 'object',
                 'display_name': 'PathOrInspFactor',
                 'ili_type': 'TypeAlias',
                 'mandatory': True,
                 'model': 'IlisMeta16',
                 'name': 'Attr',
                 'python_type': 'PathOrInspFactor',
                 'qualified_target': 'IlisMeta16.ModelData.PathOrInspFactor',
                 'target': 'PathOrInspFactor',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    required_in: tuple[ExistenceDef, ...] = field(
        metadata={'ili': {'cardinality': {'max': None, 'min': 1},
                 'display_name': 'Unknown',
                 'ili_type': 'ListType',
                 'is_bag': True,
                 'items': {'display_name': 'ExistenceDef',
                           'ili_type': 'ObjectType',
                           'qualified_target': 'IlisMeta16.ModelData.ExistenceDef',
                           'target': 'ExistenceDef'},
                 'mandatory': False,
                 'model': 'IlisMeta16',
                 'name': 'RequiredIn',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.ExistenceConstraint'
        topic = 'IlisMeta16.ModelData'
        kind = 'class'
        abstract = False
        extends = 'Constraint'

@dataclass(kw_only=True)
class UniqueConstraint(Constraint):
    tid: str | None = field(
        default=None,
        metadata={'ili': {'alias': 'IlisMeta16.MetaElemOID',
                 'alias_kind': 'domain',
                 'display_name': 'OID TEXT',
                 'domain': 'IlisMeta16.MetaElemOID',
                 'identifier': True,
                 'identifier_category': 'oid',
                 'identifier_kind': 'text',
                 'ili_type': 'TextOIDType',
                 'mandatory': True,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'TID',
                 'python_type': 'str',
                 'topic': 'IlisMeta16.ModelData',
                 'value_type': {'display_name': 'TEXT',
                                'ili_type': 'TextType',
                                'max_length': None,
                                'normalized': True,
                                'text_kind': 'TEXT'}}},
    )
    where: tuple[Expression, ...] = field(
        default_factory=tuple,
        metadata={'ili': {'cardinality': {'max': 1, 'min': 0},
                 'display_name': 'Unknown',
                 'ili_type': 'ListType',
                 'is_bag': True,
                 'items': {'display_name': 'Expression',
                           'ili_type': 'ObjectType',
                           'qualified_target': 'IlisMeta16.ModelData.Expression',
                           'target': 'Expression'},
                 'mandatory': False,
                 'model': 'IlisMeta16',
                 'name': 'Where',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    kind: Literal['GlobalU', 'BasketU', 'LocalU'] = field(
        metadata={'ili': {'display_name': 'GlobalU, BasketU, LocalU',
                 'ili_type': 'EnumerationType',
                 'literals': ['GlobalU', 'BasketU', 'LocalU'],
                 'mandatory': True,
                 'model': 'IlisMeta16',
                 'name': 'Kind',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    unique_def: tuple[PathOrInspFactor, ...] = field(
        metadata={'ili': {'cardinality': {'max': None, 'min': 1},
                 'display_name': 'Unknown',
                 'ili_type': 'ListType',
                 'is_bag': False,
                 'items': {'display_name': 'PathOrInspFactor',
                           'ili_type': 'ObjectType',
                           'qualified_target': 'IlisMeta16.ModelData.PathOrInspFactor',
                           'target': 'PathOrInspFactor'},
                 'mandatory': False,
                 'model': 'IlisMeta16',
                 'name': 'UniqueDef',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.UniqueConstraint'
        topic = 'IlisMeta16.ModelData'
        kind = 'class'
        abstract = False
        extends = 'Constraint'

@dataclass(kw_only=True)
class SetConstraint(Constraint):
    tid: str | None = field(
        default=None,
        metadata={'ili': {'alias': 'IlisMeta16.MetaElemOID',
                 'alias_kind': 'domain',
                 'display_name': 'OID TEXT',
                 'domain': 'IlisMeta16.MetaElemOID',
                 'identifier': True,
                 'identifier_category': 'oid',
                 'identifier_kind': 'text',
                 'ili_type': 'TextOIDType',
                 'mandatory': True,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'TID',
                 'python_type': 'str',
                 'topic': 'IlisMeta16.ModelData',
                 'value_type': {'display_name': 'TEXT',
                                'ili_type': 'TextType',
                                'max_length': None,
                                'normalized': True,
                                'text_kind': 'TEXT'}}},
    )
    where: tuple[Expression, ...] = field(
        default_factory=tuple,
        metadata={'ili': {'cardinality': {'max': 1, 'min': 0},
                 'display_name': 'Unknown',
                 'ili_type': 'ListType',
                 'is_bag': True,
                 'items': {'display_name': 'Expression',
                           'ili_type': 'ObjectType',
                           'qualified_target': 'IlisMeta16.ModelData.Expression',
                           'target': 'Expression'},
                 'mandatory': False,
                 'model': 'IlisMeta16',
                 'name': 'Where',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    per_basket: bool | None = field(
        default=None,
        metadata={'ili': {'alias': 'BOOLEAN',
                 'alias_kind': 'boolean',
                 'display_name': 'BOOLEAN',
                 'ili_type': 'TypeAlias',
                 'mandatory': False,
                 'model': 'IlisMeta16',
                 'name': 'PerBasket',
                 'python_type': 'bool',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    constraint: Expression | None = field(
        default=None,
        metadata={'ili': {'alias': 'Expression',
                 'alias_kind': 'object',
                 'display_name': 'Expression',
                 'ili_type': 'TypeAlias',
                 'mandatory': False,
                 'model': 'IlisMeta16',
                 'name': 'Constraint',
                 'python_type': 'Expression',
                 'qualified_target': 'IlisMeta16.ModelData.Expression',
                 'target': 'Expression',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.SetConstraint'
        topic = 'IlisMeta16.ModelData'
        kind = 'class'
        abstract = False
        extends = 'Constraint'

@dataclass(kw_only=True)
class Graphic(ExtendableME):
    tid: str | None = field(
        default=None,
        metadata={'ili': {'alias': 'IlisMeta16.MetaElemOID',
                 'alias_kind': 'domain',
                 'display_name': 'OID TEXT',
                 'domain': 'IlisMeta16.MetaElemOID',
                 'identifier': True,
                 'identifier_category': 'oid',
                 'identifier_kind': 'text',
                 'ili_type': 'TextOIDType',
                 'mandatory': True,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'TID',
                 'python_type': 'str',
                 'topic': 'IlisMeta16.ModelData',
                 'value_type': {'display_name': 'TEXT',
                                'ili_type': 'TextType',
                                'max_length': None,
                                'normalized': True,
                                'text_kind': 'TEXT'}}},
    )
    where: Expression | None = field(
        default=None,
        metadata={'ili': {'alias': 'Expression',
                 'alias_kind': 'object',
                 'display_name': 'Expression',
                 'ili_type': 'TypeAlias',
                 'mandatory': False,
                 'model': 'IlisMeta16',
                 'name': 'Where',
                 'python_type': 'Expression',
                 'qualified_target': 'IlisMeta16.ModelData.Expression',
                 'target': 'Expression',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.Graphic'
        topic = 'IlisMeta16.ModelData'
        kind = 'class'
        abstract = False
        extends = 'ExtendableME'

@dataclass(kw_only=True)
class DrawingRule(ExtendableME):
    tid: str | None = field(
        default=None,
        metadata={'ili': {'alias': 'IlisMeta16.MetaElemOID',
                 'alias_kind': 'domain',
                 'display_name': 'OID TEXT',
                 'domain': 'IlisMeta16.MetaElemOID',
                 'identifier': True,
                 'identifier_category': 'oid',
                 'identifier_kind': 'text',
                 'ili_type': 'TextOIDType',
                 'mandatory': True,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'TID',
                 'python_type': 'str',
                 'topic': 'IlisMeta16.ModelData',
                 'value_type': {'display_name': 'TEXT',
                                'ili_type': 'TextType',
                                'max_length': None,
                                'normalized': True,
                                'text_kind': 'TEXT'}}},
    )
    rule: tuple[CondSignParamAssignment, ...] = field(
        default_factory=tuple,
        metadata={'ili': {'cardinality': {'max': None, 'min': 0},
                 'display_name': 'Unknown',
                 'ili_type': 'ListType',
                 'is_bag': False,
                 'items': {'display_name': 'CondSignParamAssignment',
                           'ili_type': 'ObjectType',
                           'qualified_target': 'IlisMeta16.ModelData.CondSignParamAssignment',
                           'target': 'CondSignParamAssignment'},
                 'mandatory': False,
                 'model': 'IlisMeta16',
                 'name': 'Rule',
                 'topic': 'IlisMeta16.ModelData'}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelData.DrawingRule'
        topic = 'IlisMeta16.ModelData'
        kind = 'class'
        abstract = False
        extends = 'ExtendableME'

@dataclass(kw_only=True)
class DocTextTranslation:
    text: str = field(
        metadata={'ili': {'display_name': 'MTEXT',
                 'ili_type': 'TextType',
                 'mandatory': True,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'Text',
                 'normalized': False,
                 'text_kind': 'MTEXT',
                 'topic': 'IlisMeta16.ModelTranslation'}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelTranslation.DocTextTranslation'
        topic = 'IlisMeta16.ModelTranslation'
        kind = 'structure'
        abstract = False
        extends = None

@dataclass(kw_only=True)
class METranslation:
    of: str = field(
        metadata={'ili': {'display_name': 'MetaElement',
                 'external': True,
                 'ili_type': 'ReferenceType',
                 'mandatory': True,
                 'model': 'IlisMeta16',
                 'name': 'Of',
                 'qualified_target': 'IlisMeta16.ModelData.MetaElement',
                 'target': 'MetaElement',
                 'topic': 'IlisMeta16.ModelTranslation'}},
    )
    translated_name: str | None = field(
        default=None,
        metadata={'ili': {'display_name': 'TEXT',
                 'ili_type': 'TextType',
                 'mandatory': False,
                 'max_length': None,
                 'model': 'IlisMeta16',
                 'name': 'TranslatedName',
                 'normalized': True,
                 'text_kind': 'TEXT',
                 'topic': 'IlisMeta16.ModelTranslation'}},
    )
    translated_doc: tuple[DocTextTranslation, ...] = field(
        default_factory=tuple,
        metadata={'ili': {'cardinality': {'max': None, 'min': 0},
                 'display_name': 'Unknown',
                 'ili_type': 'ListType',
                 'is_bag': False,
                 'items': {'display_name': 'DocTextTranslation',
                           'ili_type': 'ObjectType',
                           'qualified_target': 'IlisMeta16.ModelTranslation.DocTextTranslation',
                           'target': 'DocTextTranslation'},
                 'mandatory': False,
                 'model': 'IlisMeta16',
                 'name': 'TranslatedDoc',
                 'topic': 'IlisMeta16.ModelTranslation'}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelTranslation.METranslation'
        topic = 'IlisMeta16.ModelTranslation'
        kind = 'structure'
        abstract = False
        extends = None

@dataclass(kw_only=True)
class Translation:
    language: str = field(
        metadata={'ili': {'alias': 'LanguageCode',
                 'alias_kind': 'text',
                 'display_name': 'LanguageCode',
                 'ili_type': 'TypeAlias',
                 'mandatory': True,
                 'max_length': 5,
                 'model': 'IlisMeta16',
                 'name': 'Language',
                 'python_type': 'str',
                 'topic': 'IlisMeta16.ModelTranslation'}},
    )
    translations: tuple[METranslation, ...] = field(
        default_factory=tuple,
        metadata={'ili': {'cardinality': {'max': None, 'min': 0},
                 'display_name': 'Unknown',
                 'ili_type': 'ListType',
                 'is_bag': True,
                 'items': {'display_name': 'METranslation',
                           'ili_type': 'ObjectType',
                           'qualified_target': 'IlisMeta16.ModelTranslation.METranslation',
                           'target': 'METranslation'},
                 'mandatory': False,
                 'model': 'IlisMeta16',
                 'name': 'Translations',
                 'topic': 'IlisMeta16.ModelTranslation'}},
    )
    class Meta:
        ili_name = 'IlisMeta16.ModelTranslation.Translation'
        topic = 'IlisMeta16.ModelTranslation'
        kind = 'class'
        abstract = False
        extends = None

__all__ = ["DocText", "Ili1Format", "Expression", "Multiplicity", "UnaryExpr", "CompoundExpr", "Factor", "PathEl", "PathOrInspFactor", "EnumAssignment", "EnumMapping", "ClassRef", "ActualArgument", "FunctionCall", "RuntimeParamRef", "Constant", "ClassConst", "AttributeConst", "UnitRef", "UnitFunction", "ExistenceDef", "SignParamAssignment", "CondSignParamAssignment", "MetaElement", "MetaAttribute", "ExtendableME", "Package", "Model", "SubModel", "Type", "Constraint", "DomainType", "Class", "AttrOrParam", "TypeRelatedType", "MultiValue", "ClassRelatedType", "ReferenceType", "Role", "ExplicitAssocAccess", "DataUnit", "Context", "Unit", "MetaBasketDef", "MetaObjectDef", "BooleanType", "TextType", "BlackboxType", "NumType", "CoordType", "FormattedType", "AnyOIDType", "FunctionDef", "Argument", "ClassRefType", "ObjectType", "AttributeRefType", "EnumType", "EnumNode", "EnumTreeValueType", "LineForm", "LineType", "View", "RenamedBaseView", "SimpleConstraint", "ExistenceConstraint", "UniqueConstraint", "SetConstraint", "Graphic", "DrawingRule", "DocTextTranslation", "METranslation", "Translation"]

