# Contributing guidelines

We welcome any kind of contribution to `IMAS-Python`, 
from a simple comment, a question or even a full fledged pull 
request. 
Please first make sure you read and follow the 
[Code of Conduct](CODE_OF_CONDUCT.md).

## You think you found a bug in the code, or have a question in its use
1. use the [issue search](https://github.com/iterorganization/IMAS-Python/issues)
to check if someone already created a similar issue;
2. if not, make a **new issue** to describe your problem or question. 
In the case of a bug suspiscion, please try to give all the relevant 
information to allow reproducing the error or identifying 
its root cause (version of the IMAS-Python, OS and relevant 
dependencies, snippet of code);
3. apply relevant labels to the issue.

## You want to make or ask some change to the code
1. use the [issue search](https://github.com/iterorganization/IMAS-Python/issues)
to check if someone already proposed a similar idea/change;
2. if not, create a **new issue** to describe what change you would like to see 
implemented and specify it if you intend to work on it yourself or if some help 
will be needed;
3. wait until some kind of consensus is reached about your idea being relevant, 
at which time the issue will be assigned (to you or someone else who can work on 
this topic);
4. if you do the development yourself, fork the repository to your own Github 
profile and create your own feature branch off of the latest develop commit. 
Make sure to regularly sync your branch with the latest commits from `develop` 
(find instructions 
[here](https://docs.github.com/en/pull-requests/collaborating-with-pull-requests/working-with-forks/syncing-a-fork));
5. when your development is ready, create a pull request (find instructions 
[here](https://docs.github.com/en/pull-requests/collaborating-with-pull-requests/proposing-changes-to-your-work-with-pull-requests/creating-a-pull-request-from-a-fork)).


While we will try to answer questions quickly and to address issues in a timely 
manner, it can may sometimes take longer than expected. A friendly ping in the 
discussion or the issue thread can help draw attention if you find that it was 
stalled.
