"""
    Infobip Client API Libraries OpenAPI Specification

    OpenAPI specification containing public endpoints supported in client API libraries.  # noqa: E501

    The version of the OpenAPI document: 1.0.171
    Contact: support@infobip.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from infobip_api_client.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)


def lazy_import():
    from infobip_api_client.model.tfa_language import TfaLanguage
    from infobip_api_client.model.tfa_pin_type import TfaPinType
    from infobip_api_client.model.tfa_regional_options import TfaRegionalOptions

    globals()["TfaLanguage"] = TfaLanguage
    globals()["TfaPinType"] = TfaPinType
    globals()["TfaRegionalOptions"] = TfaRegionalOptions


class TfaUpdateMessageRequest(ModelNormal):
    """
    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {}

    validations = {}

    additional_properties_type = None

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            "language": (TfaLanguage,),  # noqa: E501
            "message_text": (str,),  # noqa: E501
            "pin_length": (int,),  # noqa: E501
            "pin_type": (TfaPinType,),  # noqa: E501
            "regional": (TfaRegionalOptions,),  # noqa: E501
            "repeat_dtmf": (str,),  # noqa: E501
            "sender_id": (str,),  # noqa: E501
            "speech_rate": (float,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None

    attribute_map = {
        "language": "language",  # noqa: E501
        "message_text": "messageText",  # noqa: E501
        "pin_length": "pinLength",  # noqa: E501
        "pin_type": "pinType",  # noqa: E501
        "regional": "regional",  # noqa: E501
        "repeat_dtmf": "repeatDTMF",  # noqa: E501
        "sender_id": "senderId",  # noqa: E501
        "speech_rate": "speechRate",  # noqa: E501
    }

    _composed_schemas = {}

    required_properties = set(
        [
            "_data_store",
            "_check_type",
            "_spec_property_naming",
            "_path_to_item",
            "_configuration",
            "_visited_composed_classes",
        ]
    )

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """TfaUpdateMessageRequest - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            language (TfaLanguage): Language code of language in which message text is written. It is used for reading the message when it is sent via voice. If no language is set, message will be read in `English`.. [optional]  # noqa: E501
            message_text (str): Text of a message that will be sent. Message text must contain `pinPlaceholder`.. [optional]  # noqa: E501
            pin_length (int): PIN code length.. [optional]  # noqa: E501
            pin_type (TfaPinType): Type of PIN code that will be generated and sent as part of 2FA message. You can set PIN type to numeric, alpha, alphanumeric or hex.. [optional]  # noqa: E501
            regional (TfaRegionalOptions): Region specific parameters, often specified by local laws. Use this if country or region that you are sending SMS to requires some extra parameters.. [optional]  # noqa: E501
            repeat_dtmf (str): In case PIN message is sent by Voice, DTMF code will enable replaying the message.. [optional]  # noqa: E501
            sender_id (str): The name that will appear as the sender of the 2FA message (Example: CompanyName).. [optional]  # noqa: E501
            speech_rate (float): In case PIN message is sent by Voice, the speed of speech can be set for the message. Supported range is from `0.5` to `2`.. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop("_check_type", True)
        _spec_property_naming = kwargs.pop("_spec_property_naming", False)
        _path_to_item = kwargs.pop("_path_to_item", ())
        _configuration = kwargs.pop("_configuration", None)
        _visited_composed_classes = kwargs.pop("_visited_composed_classes", ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments."
                % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if (
                var_name not in self.attribute_map
                and self._configuration is not None
                and self._configuration.discard_unknown_keys
                and self.additional_properties_type is None
            ):
                # discard variable.
                continue
            setattr(self, var_name, var_value)
