# coding: utf-8

"""
    Infobip Client API Libraries OpenAPI Specification

    OpenAPI specification containing public endpoints supported in client API libraries.

    The version of the OpenAPI document: 1.0.0
    Contact: support@infobip.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from datetime import datetime
from pydantic import Field, StrictInt, StrictStr
from typing import List, Optional
from typing_extensions import Annotated
from infobip_api_client.models.sms_advanced_binary_request import (
    SmsAdvancedBinaryRequest,
)
from infobip_api_client.models.sms_advanced_textual_request import (
    SmsAdvancedTextualRequest,
)
from infobip_api_client.models.sms_bulk_request import SmsBulkRequest
from infobip_api_client.models.sms_bulk_response import SmsBulkResponse
from infobip_api_client.models.sms_bulk_status_response import SmsBulkStatusResponse
from infobip_api_client.models.sms_delivery_result import SmsDeliveryResult
from infobip_api_client.models.sms_inbound_message_result import SmsInboundMessageResult
from infobip_api_client.models.sms_logs_response import SmsLogsResponse
from infobip_api_client.models.sms_preview_request import SmsPreviewRequest
from infobip_api_client.models.sms_preview_response import SmsPreviewResponse
from infobip_api_client.models.sms_response import SmsResponse
from infobip_api_client.models.sms_update_status_request import SmsUpdateStatusRequest

from infobip_api_client.api_client import ApiClient, RequestSerialized
from infobip_api_client.api_response import ApiResponse
from infobip_api_client.rest import RESTResponseType


class SmsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_call
    def get_inbound_sms_messages(
        self,
        limit: Annotated[
            Optional[StrictInt],
            Field(
                description="Maximum number of messages to be returned in a response. If not set, the latest 50 records are returned. Maximum limit value is `1000` and you can only access messages for the last 48h."
            ),
        ] = None,
        application_id: Annotated[
            Optional[StrictStr],
            Field(
                description="Application id that the message is linked to. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management)."
            ),
        ] = None,
        entity_id: Annotated[
            Optional[StrictStr],
            Field(
                description="Entity id that the message is linked to. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management)."
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> SmsInboundMessageResult:
        """Get inbound SMS messages

        If for some reason you are unable to receive incoming SMS to the endpoint of your choice in real time, you can use this API call to fetch messages. Each request will return a batch of received messages - only once. The API request will only return new messages that arrived since the last API request.

        :param limit: Maximum number of messages to be returned in a response. If not set, the latest 50 records are returned. Maximum limit value is `1000` and you can only access messages for the last 48h.
        :type limit: int
        :param application_id: Application id that the message is linked to. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management).
        :type application_id: str
        :param entity_id: Entity id that the message is linked to. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management).
        :type entity_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_inbound_sms_messages_serialize(
            limit=limit,
            application_id=application_id,
            entity_id=entity_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "SmsInboundMessageResult",
            "401": "ApiException",
            "500": "ApiException",
            "4XX": "ApiException",
            "5XX": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def get_inbound_sms_messages_with_http_info(
        self,
        limit: Annotated[
            Optional[StrictInt],
            Field(
                description="Maximum number of messages to be returned in a response. If not set, the latest 50 records are returned. Maximum limit value is `1000` and you can only access messages for the last 48h."
            ),
        ] = None,
        application_id: Annotated[
            Optional[StrictStr],
            Field(
                description="Application id that the message is linked to. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management)."
            ),
        ] = None,
        entity_id: Annotated[
            Optional[StrictStr],
            Field(
                description="Entity id that the message is linked to. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management)."
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[SmsInboundMessageResult]:
        """Get inbound SMS messages

        If for some reason you are unable to receive incoming SMS to the endpoint of your choice in real time, you can use this API call to fetch messages. Each request will return a batch of received messages - only once. The API request will only return new messages that arrived since the last API request.

        :param limit: Maximum number of messages to be returned in a response. If not set, the latest 50 records are returned. Maximum limit value is `1000` and you can only access messages for the last 48h.
        :type limit: int
        :param application_id: Application id that the message is linked to. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management).
        :type application_id: str
        :param entity_id: Entity id that the message is linked to. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management).
        :type entity_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_inbound_sms_messages_serialize(
            limit=limit,
            application_id=application_id,
            entity_id=entity_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "SmsInboundMessageResult",
            "401": "ApiException",
            "500": "ApiException",
            "4XX": "ApiException",
            "5XX": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def get_inbound_sms_messages_without_preload_content(
        self,
        limit: Annotated[
            Optional[StrictInt],
            Field(
                description="Maximum number of messages to be returned in a response. If not set, the latest 50 records are returned. Maximum limit value is `1000` and you can only access messages for the last 48h."
            ),
        ] = None,
        application_id: Annotated[
            Optional[StrictStr],
            Field(
                description="Application id that the message is linked to. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management)."
            ),
        ] = None,
        entity_id: Annotated[
            Optional[StrictStr],
            Field(
                description="Entity id that the message is linked to. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management)."
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get inbound SMS messages

        If for some reason you are unable to receive incoming SMS to the endpoint of your choice in real time, you can use this API call to fetch messages. Each request will return a batch of received messages - only once. The API request will only return new messages that arrived since the last API request.

        :param limit: Maximum number of messages to be returned in a response. If not set, the latest 50 records are returned. Maximum limit value is `1000` and you can only access messages for the last 48h.
        :type limit: int
        :param application_id: Application id that the message is linked to. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management).
        :type application_id: str
        :param entity_id: Entity id that the message is linked to. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management).
        :type entity_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_inbound_sms_messages_serialize(
            limit=limit,
            application_id=application_id,
            entity_id=entity_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "SmsInboundMessageResult",
            "401": "ApiException",
            "500": "ApiException",
            "4XX": "ApiException",
            "5XX": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _get_inbound_sms_messages_serialize(
        self,
        limit,
        application_id,
        entity_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if limit is not None:

            _query_params.append(("limit", limit))

        if application_id is not None:

            _query_params.append(("applicationId", application_id))

        if entity_id is not None:

            _query_params.append(("entityId", entity_id))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/sms/1/inbox/reports",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def get_outbound_sms_message_delivery_reports(
        self,
        bulk_id: Annotated[
            Optional[StrictStr],
            Field(
                description="Unique ID assigned to the request if messaging multiple recipients or sending multiple messages via a single API request."
            ),
        ] = None,
        message_id: Annotated[
            Optional[StrictStr],
            Field(description="Unique message ID for which a report is requested."),
        ] = None,
        limit: Annotated[
            Optional[Annotated[int, Field(le=1000, strict=True)]],
            Field(
                description="Maximum number of delivery reports to be returned. If not set, the latest 50 records are returned. Maximum limit value is `1000` and you can only access reports for the last 48h."
            ),
        ] = None,
        application_id: Annotated[
            Optional[StrictStr],
            Field(
                description="Application id used to send the message. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management)."
            ),
        ] = None,
        entity_id: Annotated[
            Optional[StrictStr],
            Field(
                description="Entity id used to send the message. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management)."
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> SmsDeliveryResult:
        """Get outbound SMS message delivery reports

        If you are for any reason unable to receive real-time delivery reports on your endpoint, you can use this API method to learn if and when the message has been delivered to the recipient. Each request will return a batch of delivery reports - only once. The following API request will return only new reports that arrived since the last API request in the last 48 hours.

        :param bulk_id: Unique ID assigned to the request if messaging multiple recipients or sending multiple messages via a single API request.
        :type bulk_id: str
        :param message_id: Unique message ID for which a report is requested.
        :type message_id: str
        :param limit: Maximum number of delivery reports to be returned. If not set, the latest 50 records are returned. Maximum limit value is `1000` and you can only access reports for the last 48h.
        :type limit: int
        :param application_id: Application id used to send the message. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management).
        :type application_id: str
        :param entity_id: Entity id used to send the message. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management).
        :type entity_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_outbound_sms_message_delivery_reports_serialize(
            bulk_id=bulk_id,
            message_id=message_id,
            limit=limit,
            application_id=application_id,
            entity_id=entity_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "SmsDeliveryResult",
            "400": "ApiException",
            "401": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def get_outbound_sms_message_delivery_reports_with_http_info(
        self,
        bulk_id: Annotated[
            Optional[StrictStr],
            Field(
                description="Unique ID assigned to the request if messaging multiple recipients or sending multiple messages via a single API request."
            ),
        ] = None,
        message_id: Annotated[
            Optional[StrictStr],
            Field(description="Unique message ID for which a report is requested."),
        ] = None,
        limit: Annotated[
            Optional[Annotated[int, Field(le=1000, strict=True)]],
            Field(
                description="Maximum number of delivery reports to be returned. If not set, the latest 50 records are returned. Maximum limit value is `1000` and you can only access reports for the last 48h."
            ),
        ] = None,
        application_id: Annotated[
            Optional[StrictStr],
            Field(
                description="Application id used to send the message. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management)."
            ),
        ] = None,
        entity_id: Annotated[
            Optional[StrictStr],
            Field(
                description="Entity id used to send the message. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management)."
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[SmsDeliveryResult]:
        """Get outbound SMS message delivery reports

        If you are for any reason unable to receive real-time delivery reports on your endpoint, you can use this API method to learn if and when the message has been delivered to the recipient. Each request will return a batch of delivery reports - only once. The following API request will return only new reports that arrived since the last API request in the last 48 hours.

        :param bulk_id: Unique ID assigned to the request if messaging multiple recipients or sending multiple messages via a single API request.
        :type bulk_id: str
        :param message_id: Unique message ID for which a report is requested.
        :type message_id: str
        :param limit: Maximum number of delivery reports to be returned. If not set, the latest 50 records are returned. Maximum limit value is `1000` and you can only access reports for the last 48h.
        :type limit: int
        :param application_id: Application id used to send the message. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management).
        :type application_id: str
        :param entity_id: Entity id used to send the message. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management).
        :type entity_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_outbound_sms_message_delivery_reports_serialize(
            bulk_id=bulk_id,
            message_id=message_id,
            limit=limit,
            application_id=application_id,
            entity_id=entity_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "SmsDeliveryResult",
            "400": "ApiException",
            "401": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def get_outbound_sms_message_delivery_reports_without_preload_content(
        self,
        bulk_id: Annotated[
            Optional[StrictStr],
            Field(
                description="Unique ID assigned to the request if messaging multiple recipients or sending multiple messages via a single API request."
            ),
        ] = None,
        message_id: Annotated[
            Optional[StrictStr],
            Field(description="Unique message ID for which a report is requested."),
        ] = None,
        limit: Annotated[
            Optional[Annotated[int, Field(le=1000, strict=True)]],
            Field(
                description="Maximum number of delivery reports to be returned. If not set, the latest 50 records are returned. Maximum limit value is `1000` and you can only access reports for the last 48h."
            ),
        ] = None,
        application_id: Annotated[
            Optional[StrictStr],
            Field(
                description="Application id used to send the message. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management)."
            ),
        ] = None,
        entity_id: Annotated[
            Optional[StrictStr],
            Field(
                description="Entity id used to send the message. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management)."
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get outbound SMS message delivery reports

        If you are for any reason unable to receive real-time delivery reports on your endpoint, you can use this API method to learn if and when the message has been delivered to the recipient. Each request will return a batch of delivery reports - only once. The following API request will return only new reports that arrived since the last API request in the last 48 hours.

        :param bulk_id: Unique ID assigned to the request if messaging multiple recipients or sending multiple messages via a single API request.
        :type bulk_id: str
        :param message_id: Unique message ID for which a report is requested.
        :type message_id: str
        :param limit: Maximum number of delivery reports to be returned. If not set, the latest 50 records are returned. Maximum limit value is `1000` and you can only access reports for the last 48h.
        :type limit: int
        :param application_id: Application id used to send the message. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management).
        :type application_id: str
        :param entity_id: Entity id used to send the message. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management).
        :type entity_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_outbound_sms_message_delivery_reports_serialize(
            bulk_id=bulk_id,
            message_id=message_id,
            limit=limit,
            application_id=application_id,
            entity_id=entity_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "SmsDeliveryResult",
            "400": "ApiException",
            "401": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _get_outbound_sms_message_delivery_reports_serialize(
        self,
        bulk_id,
        message_id,
        limit,
        application_id,
        entity_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if bulk_id is not None:

            _query_params.append(("bulkId", bulk_id))

        if message_id is not None:

            _query_params.append(("messageId", message_id))

        if limit is not None:

            _query_params.append(("limit", limit))

        if application_id is not None:

            _query_params.append(("applicationId", application_id))

        if entity_id is not None:

            _query_params.append(("entityId", entity_id))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/sms/1/reports",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def get_outbound_sms_message_logs(
        self,
        var_from: Annotated[
            Optional[StrictStr],
            Field(description="The sender ID which can be alphanumeric or numeric."),
        ] = None,
        to: Annotated[
            Optional[StrictStr], Field(description="Message destination address.")
        ] = None,
        bulk_id: Annotated[
            Optional[List[StrictStr]],
            Field(
                description="Unique ID assigned to the request if messaging multiple recipients or sending multiple messages via a single API request. May contain multiple comma-separated values. Maximum length 2048 characters."
            ),
        ] = None,
        message_id: Annotated[
            Optional[List[StrictStr]],
            Field(
                description="Unique message ID for which a log is requested. May contain multiple comma-separated values. Maximum length 2048 characters."
            ),
        ] = None,
        general_status: Annotated[
            Optional[StrictStr],
            Field(
                description="Sent [message status](https://www.infobip.com/docs/essentials/response-status-and-error-codes#api-status-codes). Possible values: `ACCEPTED`, `PENDING`, `UNDELIVERABLE`, `DELIVERED`, `REJECTED`, `EXPIRED`."
            ),
        ] = None,
        sent_since: Annotated[
            Optional[datetime],
            Field(
                description="The logs will only include messages sent after this date. Use it together with `sentUntil` to return a time range or if you want to fetch more than 1000 logs allowed per call. Has the following format: `yyyy-MM-dd'T'HH:mm:ss.SSSZ`."
            ),
        ] = None,
        sent_until: Annotated[
            Optional[datetime],
            Field(
                description="The logs will only include messages sent before this date. Use it together with `sentBefore` to return a time range or if you want to fetch more than 1000 logs allowed per call. Has the following format: `yyyy-MM-dd'T'HH:mm:ss.SSSZ`."
            ),
        ] = None,
        limit: Annotated[
            Optional[StrictInt],
            Field(
                description="Maximum number of messages to include in logs. If not set, the latest 50 records are returned. Maximum limit value is `1000` and you can only access logs for the last 48h. If you want to fetch more than 1000 logs allowed per call, use `sentBefore` and `sentUntil` to retrieve them in pages."
            ),
        ] = None,
        mcc: Annotated[
            Optional[StrictStr], Field(description="Mobile Country Code.")
        ] = None,
        mnc: Annotated[
            Optional[StrictStr], Field(description="Mobile Network Code.")
        ] = None,
        application_id: Annotated[
            Optional[StrictStr],
            Field(
                description="Application id used to send the message. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management)."
            ),
        ] = None,
        entity_id: Annotated[
            Optional[StrictStr],
            Field(
                description="Entity id used to send the message. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management)."
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> SmsLogsResponse:
        """Get outbound SMS message logs

        Use this method for displaying logs for example in the user interface. Available are the logs for the last 48 hours and you can only retrieve maximum of 1000 logs per call. See [message delivery reports](#channels/sms/get-outbound-sms-message-delivery-reports) if your use case is to verify message delivery.

        :param var_from: The sender ID which can be alphanumeric or numeric.
        :type var_from: str
        :param to: Message destination address.
        :type to: str
        :param bulk_id: Unique ID assigned to the request if messaging multiple recipients or sending multiple messages via a single API request. May contain multiple comma-separated values. Maximum length 2048 characters.
        :type bulk_id: List[str]
        :param message_id: Unique message ID for which a log is requested. May contain multiple comma-separated values. Maximum length 2048 characters.
        :type message_id: List[str]
        :param general_status: Sent [message status](https://www.infobip.com/docs/essentials/response-status-and-error-codes#api-status-codes). Possible values: `ACCEPTED`, `PENDING`, `UNDELIVERABLE`, `DELIVERED`, `REJECTED`, `EXPIRED`.
        :type general_status: str
        :param sent_since: The logs will only include messages sent after this date. Use it together with `sentUntil` to return a time range or if you want to fetch more than 1000 logs allowed per call. Has the following format: `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.
        :type sent_since: datetime
        :param sent_until: The logs will only include messages sent before this date. Use it together with `sentBefore` to return a time range or if you want to fetch more than 1000 logs allowed per call. Has the following format: `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.
        :type sent_until: datetime
        :param limit: Maximum number of messages to include in logs. If not set, the latest 50 records are returned. Maximum limit value is `1000` and you can only access logs for the last 48h. If you want to fetch more than 1000 logs allowed per call, use `sentBefore` and `sentUntil` to retrieve them in pages.
        :type limit: int
        :param mcc: Mobile Country Code.
        :type mcc: str
        :param mnc: Mobile Network Code.
        :type mnc: str
        :param application_id: Application id used to send the message. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management).
        :type application_id: str
        :param entity_id: Entity id used to send the message. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management).
        :type entity_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_outbound_sms_message_logs_serialize(
            var_from=var_from,
            to=to,
            bulk_id=bulk_id,
            message_id=message_id,
            general_status=general_status,
            sent_since=sent_since,
            sent_until=sent_until,
            limit=limit,
            mcc=mcc,
            mnc=mnc,
            application_id=application_id,
            entity_id=entity_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "SmsLogsResponse",
            "401": "ApiException",
            "429": "ApiException",
            "500": "ApiException",
            "4XX": "ApiException",
            "5XX": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def get_outbound_sms_message_logs_with_http_info(
        self,
        var_from: Annotated[
            Optional[StrictStr],
            Field(description="The sender ID which can be alphanumeric or numeric."),
        ] = None,
        to: Annotated[
            Optional[StrictStr], Field(description="Message destination address.")
        ] = None,
        bulk_id: Annotated[
            Optional[List[StrictStr]],
            Field(
                description="Unique ID assigned to the request if messaging multiple recipients or sending multiple messages via a single API request. May contain multiple comma-separated values. Maximum length 2048 characters."
            ),
        ] = None,
        message_id: Annotated[
            Optional[List[StrictStr]],
            Field(
                description="Unique message ID for which a log is requested. May contain multiple comma-separated values. Maximum length 2048 characters."
            ),
        ] = None,
        general_status: Annotated[
            Optional[StrictStr],
            Field(
                description="Sent [message status](https://www.infobip.com/docs/essentials/response-status-and-error-codes#api-status-codes). Possible values: `ACCEPTED`, `PENDING`, `UNDELIVERABLE`, `DELIVERED`, `REJECTED`, `EXPIRED`."
            ),
        ] = None,
        sent_since: Annotated[
            Optional[datetime],
            Field(
                description="The logs will only include messages sent after this date. Use it together with `sentUntil` to return a time range or if you want to fetch more than 1000 logs allowed per call. Has the following format: `yyyy-MM-dd'T'HH:mm:ss.SSSZ`."
            ),
        ] = None,
        sent_until: Annotated[
            Optional[datetime],
            Field(
                description="The logs will only include messages sent before this date. Use it together with `sentBefore` to return a time range or if you want to fetch more than 1000 logs allowed per call. Has the following format: `yyyy-MM-dd'T'HH:mm:ss.SSSZ`."
            ),
        ] = None,
        limit: Annotated[
            Optional[StrictInt],
            Field(
                description="Maximum number of messages to include in logs. If not set, the latest 50 records are returned. Maximum limit value is `1000` and you can only access logs for the last 48h. If you want to fetch more than 1000 logs allowed per call, use `sentBefore` and `sentUntil` to retrieve them in pages."
            ),
        ] = None,
        mcc: Annotated[
            Optional[StrictStr], Field(description="Mobile Country Code.")
        ] = None,
        mnc: Annotated[
            Optional[StrictStr], Field(description="Mobile Network Code.")
        ] = None,
        application_id: Annotated[
            Optional[StrictStr],
            Field(
                description="Application id used to send the message. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management)."
            ),
        ] = None,
        entity_id: Annotated[
            Optional[StrictStr],
            Field(
                description="Entity id used to send the message. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management)."
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[SmsLogsResponse]:
        """Get outbound SMS message logs

        Use this method for displaying logs for example in the user interface. Available are the logs for the last 48 hours and you can only retrieve maximum of 1000 logs per call. See [message delivery reports](#channels/sms/get-outbound-sms-message-delivery-reports) if your use case is to verify message delivery.

        :param var_from: The sender ID which can be alphanumeric or numeric.
        :type var_from: str
        :param to: Message destination address.
        :type to: str
        :param bulk_id: Unique ID assigned to the request if messaging multiple recipients or sending multiple messages via a single API request. May contain multiple comma-separated values. Maximum length 2048 characters.
        :type bulk_id: List[str]
        :param message_id: Unique message ID for which a log is requested. May contain multiple comma-separated values. Maximum length 2048 characters.
        :type message_id: List[str]
        :param general_status: Sent [message status](https://www.infobip.com/docs/essentials/response-status-and-error-codes#api-status-codes). Possible values: `ACCEPTED`, `PENDING`, `UNDELIVERABLE`, `DELIVERED`, `REJECTED`, `EXPIRED`.
        :type general_status: str
        :param sent_since: The logs will only include messages sent after this date. Use it together with `sentUntil` to return a time range or if you want to fetch more than 1000 logs allowed per call. Has the following format: `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.
        :type sent_since: datetime
        :param sent_until: The logs will only include messages sent before this date. Use it together with `sentBefore` to return a time range or if you want to fetch more than 1000 logs allowed per call. Has the following format: `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.
        :type sent_until: datetime
        :param limit: Maximum number of messages to include in logs. If not set, the latest 50 records are returned. Maximum limit value is `1000` and you can only access logs for the last 48h. If you want to fetch more than 1000 logs allowed per call, use `sentBefore` and `sentUntil` to retrieve them in pages.
        :type limit: int
        :param mcc: Mobile Country Code.
        :type mcc: str
        :param mnc: Mobile Network Code.
        :type mnc: str
        :param application_id: Application id used to send the message. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management).
        :type application_id: str
        :param entity_id: Entity id used to send the message. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management).
        :type entity_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_outbound_sms_message_logs_serialize(
            var_from=var_from,
            to=to,
            bulk_id=bulk_id,
            message_id=message_id,
            general_status=general_status,
            sent_since=sent_since,
            sent_until=sent_until,
            limit=limit,
            mcc=mcc,
            mnc=mnc,
            application_id=application_id,
            entity_id=entity_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "SmsLogsResponse",
            "401": "ApiException",
            "429": "ApiException",
            "500": "ApiException",
            "4XX": "ApiException",
            "5XX": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def get_outbound_sms_message_logs_without_preload_content(
        self,
        var_from: Annotated[
            Optional[StrictStr],
            Field(description="The sender ID which can be alphanumeric or numeric."),
        ] = None,
        to: Annotated[
            Optional[StrictStr], Field(description="Message destination address.")
        ] = None,
        bulk_id: Annotated[
            Optional[List[StrictStr]],
            Field(
                description="Unique ID assigned to the request if messaging multiple recipients or sending multiple messages via a single API request. May contain multiple comma-separated values. Maximum length 2048 characters."
            ),
        ] = None,
        message_id: Annotated[
            Optional[List[StrictStr]],
            Field(
                description="Unique message ID for which a log is requested. May contain multiple comma-separated values. Maximum length 2048 characters."
            ),
        ] = None,
        general_status: Annotated[
            Optional[StrictStr],
            Field(
                description="Sent [message status](https://www.infobip.com/docs/essentials/response-status-and-error-codes#api-status-codes). Possible values: `ACCEPTED`, `PENDING`, `UNDELIVERABLE`, `DELIVERED`, `REJECTED`, `EXPIRED`."
            ),
        ] = None,
        sent_since: Annotated[
            Optional[datetime],
            Field(
                description="The logs will only include messages sent after this date. Use it together with `sentUntil` to return a time range or if you want to fetch more than 1000 logs allowed per call. Has the following format: `yyyy-MM-dd'T'HH:mm:ss.SSSZ`."
            ),
        ] = None,
        sent_until: Annotated[
            Optional[datetime],
            Field(
                description="The logs will only include messages sent before this date. Use it together with `sentBefore` to return a time range or if you want to fetch more than 1000 logs allowed per call. Has the following format: `yyyy-MM-dd'T'HH:mm:ss.SSSZ`."
            ),
        ] = None,
        limit: Annotated[
            Optional[StrictInt],
            Field(
                description="Maximum number of messages to include in logs. If not set, the latest 50 records are returned. Maximum limit value is `1000` and you can only access logs for the last 48h. If you want to fetch more than 1000 logs allowed per call, use `sentBefore` and `sentUntil` to retrieve them in pages."
            ),
        ] = None,
        mcc: Annotated[
            Optional[StrictStr], Field(description="Mobile Country Code.")
        ] = None,
        mnc: Annotated[
            Optional[StrictStr], Field(description="Mobile Network Code.")
        ] = None,
        application_id: Annotated[
            Optional[StrictStr],
            Field(
                description="Application id used to send the message. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management)."
            ),
        ] = None,
        entity_id: Annotated[
            Optional[StrictStr],
            Field(
                description="Entity id used to send the message. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management)."
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get outbound SMS message logs

        Use this method for displaying logs for example in the user interface. Available are the logs for the last 48 hours and you can only retrieve maximum of 1000 logs per call. See [message delivery reports](#channels/sms/get-outbound-sms-message-delivery-reports) if your use case is to verify message delivery.

        :param var_from: The sender ID which can be alphanumeric or numeric.
        :type var_from: str
        :param to: Message destination address.
        :type to: str
        :param bulk_id: Unique ID assigned to the request if messaging multiple recipients or sending multiple messages via a single API request. May contain multiple comma-separated values. Maximum length 2048 characters.
        :type bulk_id: List[str]
        :param message_id: Unique message ID for which a log is requested. May contain multiple comma-separated values. Maximum length 2048 characters.
        :type message_id: List[str]
        :param general_status: Sent [message status](https://www.infobip.com/docs/essentials/response-status-and-error-codes#api-status-codes). Possible values: `ACCEPTED`, `PENDING`, `UNDELIVERABLE`, `DELIVERED`, `REJECTED`, `EXPIRED`.
        :type general_status: str
        :param sent_since: The logs will only include messages sent after this date. Use it together with `sentUntil` to return a time range or if you want to fetch more than 1000 logs allowed per call. Has the following format: `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.
        :type sent_since: datetime
        :param sent_until: The logs will only include messages sent before this date. Use it together with `sentBefore` to return a time range or if you want to fetch more than 1000 logs allowed per call. Has the following format: `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.
        :type sent_until: datetime
        :param limit: Maximum number of messages to include in logs. If not set, the latest 50 records are returned. Maximum limit value is `1000` and you can only access logs for the last 48h. If you want to fetch more than 1000 logs allowed per call, use `sentBefore` and `sentUntil` to retrieve them in pages.
        :type limit: int
        :param mcc: Mobile Country Code.
        :type mcc: str
        :param mnc: Mobile Network Code.
        :type mnc: str
        :param application_id: Application id used to send the message. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management).
        :type application_id: str
        :param entity_id: Entity id used to send the message. For more details, see our [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management).
        :type entity_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_outbound_sms_message_logs_serialize(
            var_from=var_from,
            to=to,
            bulk_id=bulk_id,
            message_id=message_id,
            general_status=general_status,
            sent_since=sent_since,
            sent_until=sent_until,
            limit=limit,
            mcc=mcc,
            mnc=mnc,
            application_id=application_id,
            entity_id=entity_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "SmsLogsResponse",
            "401": "ApiException",
            "429": "ApiException",
            "500": "ApiException",
            "4XX": "ApiException",
            "5XX": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _get_outbound_sms_message_logs_serialize(
        self,
        var_from,
        to,
        bulk_id,
        message_id,
        general_status,
        sent_since,
        sent_until,
        limit,
        mcc,
        mnc,
        application_id,
        entity_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            "bulkId": "multi",
            "messageId": "multi",
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if var_from is not None:

            _query_params.append(("from", var_from))

        if to is not None:

            _query_params.append(("to", to))

        if bulk_id is not None:

            _query_params.append(("bulkId", bulk_id))

        if message_id is not None:

            _query_params.append(("messageId", message_id))

        if general_status is not None:

            _query_params.append(("generalStatus", general_status))

        if sent_since is not None:
            if isinstance(sent_since, datetime):
                _query_params.append(
                    (
                        "sentSince",
                        sent_since.strftime(
                            self.api_client.configuration.datetime_format
                        ),
                    )
                )
            else:
                _query_params.append(("sentSince", sent_since))

        if sent_until is not None:
            if isinstance(sent_until, datetime):
                _query_params.append(
                    (
                        "sentUntil",
                        sent_until.strftime(
                            self.api_client.configuration.datetime_format
                        ),
                    )
                )
            else:
                _query_params.append(("sentUntil", sent_until))

        if limit is not None:

            _query_params.append(("limit", limit))

        if mcc is not None:

            _query_params.append(("mcc", mcc))

        if mnc is not None:

            _query_params.append(("mnc", mnc))

        if application_id is not None:

            _query_params.append(("applicationId", application_id))

        if entity_id is not None:

            _query_params.append(("entityId", entity_id))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/sms/1/logs",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def get_scheduled_sms_messages(
        self,
        bulk_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> SmsBulkResponse:
        """Get scheduled SMS messages

        See all scheduled messages and their scheduled date and time. To schedule a message, use the `sendAt` field when [sending a message](https://www.infobip.com/docs/api/channels/sms/sms-messaging/outbound-sms/send-sms-message).

        :param bulk_id:  (required)
        :type bulk_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_scheduled_sms_messages_serialize(
            bulk_id=bulk_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "SmsBulkResponse",
            "401": "ApiException",
            "500": "ApiException",
            "4XX": "ApiException",
            "5XX": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def get_scheduled_sms_messages_with_http_info(
        self,
        bulk_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[SmsBulkResponse]:
        """Get scheduled SMS messages

        See all scheduled messages and their scheduled date and time. To schedule a message, use the `sendAt` field when [sending a message](https://www.infobip.com/docs/api/channels/sms/sms-messaging/outbound-sms/send-sms-message).

        :param bulk_id:  (required)
        :type bulk_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_scheduled_sms_messages_serialize(
            bulk_id=bulk_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "SmsBulkResponse",
            "401": "ApiException",
            "500": "ApiException",
            "4XX": "ApiException",
            "5XX": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def get_scheduled_sms_messages_without_preload_content(
        self,
        bulk_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get scheduled SMS messages

        See all scheduled messages and their scheduled date and time. To schedule a message, use the `sendAt` field when [sending a message](https://www.infobip.com/docs/api/channels/sms/sms-messaging/outbound-sms/send-sms-message).

        :param bulk_id:  (required)
        :type bulk_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_scheduled_sms_messages_serialize(
            bulk_id=bulk_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "SmsBulkResponse",
            "401": "ApiException",
            "500": "ApiException",
            "4XX": "ApiException",
            "5XX": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _get_scheduled_sms_messages_serialize(
        self,
        bulk_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if bulk_id is not None:

            _query_params.append(("bulkId", bulk_id))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/sms/1/bulks",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def get_scheduled_sms_messages_status(
        self,
        bulk_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> SmsBulkStatusResponse:
        """Get scheduled SMS messages status

        See the status of scheduled messages. To schedule a message, use the `sendAt` field when [sending a message](https://www.infobip.com/docs/api/channels/sms/sms-messaging/outbound-sms/send-sms-message).

        :param bulk_id: (required)
        :type bulk_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_scheduled_sms_messages_status_serialize(
            bulk_id=bulk_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "SmsBulkStatusResponse",
            "400": "ApiException",
            "401": "ApiException",
            "404": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def get_scheduled_sms_messages_status_with_http_info(
        self,
        bulk_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[SmsBulkStatusResponse]:
        """Get scheduled SMS messages status

        See the status of scheduled messages. To schedule a message, use the `sendAt` field when [sending a message](https://www.infobip.com/docs/api/channels/sms/sms-messaging/outbound-sms/send-sms-message).

        :param bulk_id: (required)
        :type bulk_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_scheduled_sms_messages_status_serialize(
            bulk_id=bulk_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "SmsBulkStatusResponse",
            "400": "ApiException",
            "401": "ApiException",
            "404": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def get_scheduled_sms_messages_status_without_preload_content(
        self,
        bulk_id: StrictStr,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get scheduled SMS messages status

        See the status of scheduled messages. To schedule a message, use the `sendAt` field when [sending a message](https://www.infobip.com/docs/api/channels/sms/sms-messaging/outbound-sms/send-sms-message).

        :param bulk_id: (required)
        :type bulk_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_scheduled_sms_messages_status_serialize(
            bulk_id=bulk_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "SmsBulkStatusResponse",
            "400": "ApiException",
            "401": "ApiException",
            "404": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _get_scheduled_sms_messages_status_serialize(
        self,
        bulk_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if bulk_id is not None:

            _query_params.append(("bulkId", bulk_id))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/sms/1/bulks/status",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def preview_sms_message(
        self,
        sms_preview_request: SmsPreviewRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> SmsPreviewResponse:
        """Preview SMS message

        Avoid unpleasant surprises and check how different message configurations will affect your message text, number of characters and message parts.

        :param sms_preview_request: (required)
        :type sms_preview_request: SmsPreviewRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._preview_sms_message_serialize(
            sms_preview_request=sms_preview_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "SmsPreviewResponse",
            "400": "ApiException",
            "401": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def preview_sms_message_with_http_info(
        self,
        sms_preview_request: SmsPreviewRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[SmsPreviewResponse]:
        """Preview SMS message

        Avoid unpleasant surprises and check how different message configurations will affect your message text, number of characters and message parts.

        :param sms_preview_request: (required)
        :type sms_preview_request: SmsPreviewRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._preview_sms_message_serialize(
            sms_preview_request=sms_preview_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "SmsPreviewResponse",
            "400": "ApiException",
            "401": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def preview_sms_message_without_preload_content(
        self,
        sms_preview_request: SmsPreviewRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Preview SMS message

        Avoid unpleasant surprises and check how different message configurations will affect your message text, number of characters and message parts.

        :param sms_preview_request: (required)
        :type sms_preview_request: SmsPreviewRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._preview_sms_message_serialize(
            sms_preview_request=sms_preview_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "SmsPreviewResponse",
            "400": "ApiException",
            "401": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _preview_sms_message_serialize(
        self,
        sms_preview_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if sms_preview_request is not None:
            _body_params = sms_preview_request

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(
                ["application/json"]
            )
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/sms/1/preview",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def reschedule_sms_messages(
        self,
        bulk_id: StrictStr,
        sms_bulk_request: SmsBulkRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> SmsBulkResponse:
        """Reschedule SMS messages

        Change the date and time of already scheduled messages. To schedule a message, use the `sendAt` field when [sending a message](https://www.infobip.com/docs/api/channels/sms/sms-messaging/outbound-sms/send-sms-message).

        :param bulk_id:  (required)
        :type bulk_id: str
        :param sms_bulk_request: (required)
        :type sms_bulk_request: SmsBulkRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._reschedule_sms_messages_serialize(
            bulk_id=bulk_id,
            sms_bulk_request=sms_bulk_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "SmsBulkResponse",
            "401": "ApiException",
            "500": "ApiException",
            "4XX": "ApiException",
            "5XX": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def reschedule_sms_messages_with_http_info(
        self,
        bulk_id: StrictStr,
        sms_bulk_request: SmsBulkRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[SmsBulkResponse]:
        """Reschedule SMS messages

        Change the date and time of already scheduled messages. To schedule a message, use the `sendAt` field when [sending a message](https://www.infobip.com/docs/api/channels/sms/sms-messaging/outbound-sms/send-sms-message).

        :param bulk_id:  (required)
        :type bulk_id: str
        :param sms_bulk_request: (required)
        :type sms_bulk_request: SmsBulkRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._reschedule_sms_messages_serialize(
            bulk_id=bulk_id,
            sms_bulk_request=sms_bulk_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "SmsBulkResponse",
            "401": "ApiException",
            "500": "ApiException",
            "4XX": "ApiException",
            "5XX": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def reschedule_sms_messages_without_preload_content(
        self,
        bulk_id: StrictStr,
        sms_bulk_request: SmsBulkRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Reschedule SMS messages

        Change the date and time of already scheduled messages. To schedule a message, use the `sendAt` field when [sending a message](https://www.infobip.com/docs/api/channels/sms/sms-messaging/outbound-sms/send-sms-message).

        :param bulk_id:  (required)
        :type bulk_id: str
        :param sms_bulk_request: (required)
        :type sms_bulk_request: SmsBulkRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._reschedule_sms_messages_serialize(
            bulk_id=bulk_id,
            sms_bulk_request=sms_bulk_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "SmsBulkResponse",
            "401": "ApiException",
            "500": "ApiException",
            "4XX": "ApiException",
            "5XX": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _reschedule_sms_messages_serialize(
        self,
        bulk_id,
        sms_bulk_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if bulk_id is not None:

            _query_params.append(("bulkId", bulk_id))

        # process the header parameters
        # process the form parameters
        # process the body parameter
        if sms_bulk_request is not None:
            _body_params = sms_bulk_request

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(
                ["application/json"]
            )
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="PUT",
            resource_path="/sms/1/bulks",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def send_binary_sms_message(
        self,
        sms_advanced_binary_request: SmsAdvancedBinaryRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> SmsResponse:
        """Send binary SMS message

        Send single or multiple binary messages to one or more destination address. The API response will not contain the final delivery status, use [Delivery Reports](https://www.infobip.com/docs/api/channels/sms/sms-messaging/logs-and-status-reports/receive-outbound-sms-message-report) instead.

        :param sms_advanced_binary_request: (required)
        :type sms_advanced_binary_request: SmsAdvancedBinaryRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._send_binary_sms_message_serialize(
            sms_advanced_binary_request=sms_advanced_binary_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "SmsResponse",
            "400": "ApiException",
            "401": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def send_binary_sms_message_with_http_info(
        self,
        sms_advanced_binary_request: SmsAdvancedBinaryRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[SmsResponse]:
        """Send binary SMS message

        Send single or multiple binary messages to one or more destination address. The API response will not contain the final delivery status, use [Delivery Reports](https://www.infobip.com/docs/api/channels/sms/sms-messaging/logs-and-status-reports/receive-outbound-sms-message-report) instead.

        :param sms_advanced_binary_request: (required)
        :type sms_advanced_binary_request: SmsAdvancedBinaryRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._send_binary_sms_message_serialize(
            sms_advanced_binary_request=sms_advanced_binary_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "SmsResponse",
            "400": "ApiException",
            "401": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def send_binary_sms_message_without_preload_content(
        self,
        sms_advanced_binary_request: SmsAdvancedBinaryRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Send binary SMS message

        Send single or multiple binary messages to one or more destination address. The API response will not contain the final delivery status, use [Delivery Reports](https://www.infobip.com/docs/api/channels/sms/sms-messaging/logs-and-status-reports/receive-outbound-sms-message-report) instead.

        :param sms_advanced_binary_request: (required)
        :type sms_advanced_binary_request: SmsAdvancedBinaryRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._send_binary_sms_message_serialize(
            sms_advanced_binary_request=sms_advanced_binary_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "SmsResponse",
            "400": "ApiException",
            "401": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _send_binary_sms_message_serialize(
        self,
        sms_advanced_binary_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if sms_advanced_binary_request is not None:
            _body_params = sms_advanced_binary_request

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(
                ["application/json"]
            )
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/sms/2/binary/advanced",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def send_sms_message(
        self,
        sms_advanced_textual_request: SmsAdvancedTextualRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> SmsResponse:
        """Send SMS message

        Use this endpoint to send an SMS and set up a rich set of features, such as batch sending with a single API request, scheduling, URL tracking, language and transliteration configuration, etc. The API response will not contain the final delivery status, use [Delivery Reports](https://www.infobip.com/docs/api/channels/sms/sms-messaging/logs-and-status-reports/receive-outbound-sms-message-report) instead.

        :param sms_advanced_textual_request: (required)
        :type sms_advanced_textual_request: SmsAdvancedTextualRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._send_sms_message_serialize(
            sms_advanced_textual_request=sms_advanced_textual_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "SmsResponse",
            "400": "ApiException",
            "401": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def send_sms_message_with_http_info(
        self,
        sms_advanced_textual_request: SmsAdvancedTextualRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[SmsResponse]:
        """Send SMS message

        Use this endpoint to send an SMS and set up a rich set of features, such as batch sending with a single API request, scheduling, URL tracking, language and transliteration configuration, etc. The API response will not contain the final delivery status, use [Delivery Reports](https://www.infobip.com/docs/api/channels/sms/sms-messaging/logs-and-status-reports/receive-outbound-sms-message-report) instead.

        :param sms_advanced_textual_request: (required)
        :type sms_advanced_textual_request: SmsAdvancedTextualRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._send_sms_message_serialize(
            sms_advanced_textual_request=sms_advanced_textual_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "SmsResponse",
            "400": "ApiException",
            "401": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def send_sms_message_without_preload_content(
        self,
        sms_advanced_textual_request: SmsAdvancedTextualRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Send SMS message

        Use this endpoint to send an SMS and set up a rich set of features, such as batch sending with a single API request, scheduling, URL tracking, language and transliteration configuration, etc. The API response will not contain the final delivery status, use [Delivery Reports](https://www.infobip.com/docs/api/channels/sms/sms-messaging/logs-and-status-reports/receive-outbound-sms-message-report) instead.

        :param sms_advanced_textual_request: (required)
        :type sms_advanced_textual_request: SmsAdvancedTextualRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._send_sms_message_serialize(
            sms_advanced_textual_request=sms_advanced_textual_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "SmsResponse",
            "400": "ApiException",
            "401": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _send_sms_message_serialize(
        self,
        sms_advanced_textual_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if sms_advanced_textual_request is not None:
            _body_params = sms_advanced_textual_request

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(
                ["application/json"]
            )
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/sms/2/text/advanced",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def update_scheduled_sms_messages_status(
        self,
        bulk_id: StrictStr,
        sms_update_status_request: SmsUpdateStatusRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> SmsBulkStatusResponse:
        """Update scheduled SMS messages status

        Change the status or completely cancel sending of scheduled messages. To schedule a message, use the `sendAt` field when [sending a message](https://www.infobip.com/docs/api/channels/sms/sms-messaging/outbound-sms/send-sms-message).

        :param bulk_id:  (required)
        :type bulk_id: str
        :param sms_update_status_request: (required)
        :type sms_update_status_request: SmsUpdateStatusRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._update_scheduled_sms_messages_status_serialize(
            bulk_id=bulk_id,
            sms_update_status_request=sms_update_status_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "SmsBulkStatusResponse",
            "401": "ApiException",
            "500": "ApiException",
            "4XX": "ApiException",
            "5XX": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def update_scheduled_sms_messages_status_with_http_info(
        self,
        bulk_id: StrictStr,
        sms_update_status_request: SmsUpdateStatusRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[SmsBulkStatusResponse]:
        """Update scheduled SMS messages status

        Change the status or completely cancel sending of scheduled messages. To schedule a message, use the `sendAt` field when [sending a message](https://www.infobip.com/docs/api/channels/sms/sms-messaging/outbound-sms/send-sms-message).

        :param bulk_id:  (required)
        :type bulk_id: str
        :param sms_update_status_request: (required)
        :type sms_update_status_request: SmsUpdateStatusRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._update_scheduled_sms_messages_status_serialize(
            bulk_id=bulk_id,
            sms_update_status_request=sms_update_status_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "SmsBulkStatusResponse",
            "401": "ApiException",
            "500": "ApiException",
            "4XX": "ApiException",
            "5XX": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def update_scheduled_sms_messages_status_without_preload_content(
        self,
        bulk_id: StrictStr,
        sms_update_status_request: SmsUpdateStatusRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update scheduled SMS messages status

        Change the status or completely cancel sending of scheduled messages. To schedule a message, use the `sendAt` field when [sending a message](https://www.infobip.com/docs/api/channels/sms/sms-messaging/outbound-sms/send-sms-message).

        :param bulk_id:  (required)
        :type bulk_id: str
        :param sms_update_status_request: (required)
        :type sms_update_status_request: SmsUpdateStatusRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._update_scheduled_sms_messages_status_serialize(
            bulk_id=bulk_id,
            sms_update_status_request=sms_update_status_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "SmsBulkStatusResponse",
            "401": "ApiException",
            "500": "ApiException",
            "4XX": "ApiException",
            "5XX": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _update_scheduled_sms_messages_status_serialize(
        self,
        bulk_id,
        sms_update_status_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if bulk_id is not None:

            _query_params.append(("bulkId", bulk_id))

        # process the header parameters
        # process the form parameters
        # process the body parameter
        if sms_update_status_request is not None:
            _body_params = sms_update_status_request

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(
                ["application/json"]
            )
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="PUT",
            resource_path="/sms/1/bulks/status",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )
