# coding: utf-8

"""
    Infobip Client API Libraries OpenAPI Specification

    OpenAPI specification containing public endpoints supported in client API libraries.

    The version of the OpenAPI document: 1.0.0
    Contact: support@infobip.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from infobip_api_client.models.calls_bulk_endpoint import CallsBulkEndpoint
from typing import Optional, Set
from typing_extensions import Self


class CallsBulkCall(BaseModel):
    """
    Bulk call list.
    """  # noqa: E501

    calls_configuration_id: Optional[StrictStr] = Field(
        default=None,
        description="Calls Configuration ID.",
        alias="callsConfigurationId",
    )
    application_id: Optional[StrictStr] = Field(
        default=None, description="Application ID.", alias="applicationId"
    )
    call_id: Optional[Annotated[str, Field(strict=True, max_length=128)]] = Field(
        default=None, description="Unique call ID.", alias="callId"
    )
    external_id: Optional[StrictStr] = Field(
        default=None, description="Client-defined call ID.", alias="externalId"
    )
    var_from: Optional[StrictStr] = Field(
        default=None, description="Caller identifier.", alias="from"
    )
    endpoint: Optional[CallsBulkEndpoint] = None
    status: Optional[StrictStr] = Field(default=None, description="Action status.")
    reason: Optional[StrictStr] = Field(
        default=None, description="Failure reason in human-readable format."
    )
    __properties: ClassVar[List[str]] = [
        "callsConfigurationId",
        "applicationId",
        "callId",
        "externalId",
        "from",
        "endpoint",
        "status",
        "reason",
    ]

    @field_validator("status")
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(["PENDING", "IN_PROGRESS", "COMPLETED", "FAILED"]):
            raise ValueError(
                "must be one of enum values ('PENDING', 'IN_PROGRESS', 'COMPLETED', 'FAILED')"
            )
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CallsBulkCall from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of endpoint
        if self.endpoint:
            _dict["endpoint"] = self.endpoint.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CallsBulkCall from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "callsConfigurationId": obj.get("callsConfigurationId"),
                "applicationId": obj.get("applicationId"),
                "callId": obj.get("callId"),
                "externalId": obj.get("externalId"),
                "from": obj.get("from"),
                "endpoint": CallsBulkEndpoint.from_dict(obj["endpoint"])
                if obj.get("endpoint") is not None
                else None,
                "status": obj.get("status"),
                "reason": obj.get("reason"),
            }
        )
        return _obj
