# coding: utf-8

"""
    Infobip Client API Libraries OpenAPI Specification

    OpenAPI specification containing public endpoints supported in client API libraries.

    The version of the OpenAPI document: 1.0.0
    Contact: support@infobip.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from infobip_api_client.models.calls_delivery_time_window import CallsDeliveryTimeWindow
from infobip_api_client.models.calls_retry import CallsRetry
from infobip_api_client.models.calls_voice import CallsVoice
from typing import Optional, Set
from typing_extensions import Self


class CallsClickToCallMessage(BaseModel):
    """
    Array of click to call messages to be sent.
    """  # noqa: E501

    anonymization: Optional[StrictBool] = Field(
        default=None,
        description="If set, same numeric sender (defined in _from_) is used for both calls (towards _destinationA_ and _destinationB_). If not set, _destinationA_ will be shown to _destinationB_. If _fromB_ is set up, _anonymization_ will not be applied; _from_ will be shown to _destinationA_ and _fromB_ will be shown to _destinationB_. Default value is `false`. ",
    )
    audio_file_url: Optional[StrictStr] = Field(
        default=None,
        description="An audio file can be delivered as a voice message to the recipients. An audio file must be uploaded online, so that the existing URL can be available for file download. Size of the audio file must be below 4 MB. Supported formats of the provided file are aac, aiff, m4a, mp2, mp3, mp4 (audio only), ogg, wav and wma. Our platform needs to have permission to make GET and HEAD HTTP requests on the provided URL. Standard http ports (like 80, 8080, etc.) are advised.",
        alias="audioFileUrl",
    )
    delivery_time_window: Optional[CallsDeliveryTimeWindow] = Field(
        default=None, alias="deliveryTimeWindow"
    )
    destination_a: StrictStr = Field(
        description="Original destination address. Address must be in the international format (Example: `41793026727`).",
        alias="destinationA",
    )
    destination_b: StrictStr = Field(
        description="Destination address to which the call will be transferred after successful answering. Address must be in the international format (Example: `41793026727`).",
        alias="destinationB",
    )
    var_from: StrictStr = Field(
        description="Numeric sender ID in E.164 format. Will be shown to _destinationA_.",
        alias="from",
    )
    from_b: Optional[StrictStr] = Field(
        default=None,
        description="Numeric sender ID in E.164 format. If set, it will be shown to _destinationB_. If not set, _from_ or _destinationA_ will be shown to _destinationB_, depending on the value of _anonymization_.",
        alias="fromB",
    )
    language: Optional[StrictStr] = Field(
        default=None,
        description="If the message is in text format, language in which the message is written must be defined for correct pronunciation. In the Languages section, you can find the list of languages that we support. If not set, default language is `English [en].`",
    )
    machine_detection: Optional[StrictStr] = Field(
        default=None,
        description="Used for enabling detection of answering machine after the call has been answered on `destinationA`. It can be set to `hangup` which means if a machine is detected, the call is hung up. If `machineDetection` is used, there is a minimum of 4 seconds detection time, which can result in delay of playing the message. Answering machine detection is additionally charged. For more information please contact your account manager.",
        alias="machineDetection",
    )
    max_duration: Optional[StrictInt] = Field(
        default=None,
        description="Maximum duration of transferred call in seconds. If set, when _maxDuration_ is reached call will be terminated.",
        alias="maxDuration",
    )
    message_id: Optional[StrictStr] = Field(
        default=None,
        description="The ID that uniquely identifies the message sent. It can be defined by you or Infobip will generate unique message ID for this specific call. The field is not mandatory.",
        alias="messageId",
    )
    notify_content_type: Optional[StrictStr] = Field(
        default=None,
        description="Preferred Delivery report content type. Can be `application/json` or `application/xml`.",
        alias="notifyContentType",
    )
    notify_content_version: Optional[StrictInt] = Field(
        default=None,
        description="Specifies the version of the report model to be sent. Can be `1` ([deprecated version 1](#programmable-communications/voice/receive-voice-delivery-reports-deprecated)) or `2` ([current version 2](#programmable-communications/voice/receive-voice-delivery-reports)). The default is version 2.",
        alias="notifyContentVersion",
    )
    notify_url: Optional[StrictStr] = Field(
        default=None,
        description="The URL on your callback server on which the Delivery report will be sent.",
        alias="notifyUrl",
    )
    retry: Optional[CallsRetry] = None
    text: Optional[StrictStr] = Field(
        default=None,
        description="Text of the message that will be played before call transfer.",
    )
    voice: Optional[CallsVoice] = None
    warning_time: Optional[StrictInt] = Field(
        default=None,
        description="Time before the end of the transferred call, in seconds, when warning beep sound will be played. For example, if _maxDuration_ is set to `60` and warningTime is set to `5`, this means that warning beep will be played on `55.` second of the transferred call, or `5` seconds before it's end.",
        alias="warningTime",
    )
    __properties: ClassVar[List[str]] = [
        "anonymization",
        "audioFileUrl",
        "deliveryTimeWindow",
        "destinationA",
        "destinationB",
        "from",
        "fromB",
        "language",
        "machineDetection",
        "maxDuration",
        "messageId",
        "notifyContentType",
        "notifyContentVersion",
        "notifyUrl",
        "retry",
        "text",
        "voice",
        "warningTime",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CallsClickToCallMessage from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of delivery_time_window
        if self.delivery_time_window:
            _dict["deliveryTimeWindow"] = self.delivery_time_window.to_dict()
        # override the default output from pydantic by calling `to_dict()` of retry
        if self.retry:
            _dict["retry"] = self.retry.to_dict()
        # override the default output from pydantic by calling `to_dict()` of voice
        if self.voice:
            _dict["voice"] = self.voice.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CallsClickToCallMessage from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "anonymization": obj.get("anonymization"),
                "audioFileUrl": obj.get("audioFileUrl"),
                "deliveryTimeWindow": CallsDeliveryTimeWindow.from_dict(
                    obj["deliveryTimeWindow"]
                )
                if obj.get("deliveryTimeWindow") is not None
                else None,
                "destinationA": obj.get("destinationA"),
                "destinationB": obj.get("destinationB"),
                "from": obj.get("from"),
                "fromB": obj.get("fromB"),
                "language": obj.get("language"),
                "machineDetection": obj.get("machineDetection"),
                "maxDuration": obj.get("maxDuration"),
                "messageId": obj.get("messageId"),
                "notifyContentType": obj.get("notifyContentType"),
                "notifyContentVersion": obj.get("notifyContentVersion"),
                "notifyUrl": obj.get("notifyUrl"),
                "retry": CallsRetry.from_dict(obj["retry"])
                if obj.get("retry") is not None
                else None,
                "text": obj.get("text"),
                "voice": CallsVoice.from_dict(obj["voice"])
                if obj.get("voice") is not None
                else None,
                "warningTime": obj.get("warningTime"),
            }
        )
        return _obj
