# coding: utf-8

"""
    Infobip Client API Libraries OpenAPI Specification

    OpenAPI specification containing public endpoints supported in client API libraries.

    The version of the OpenAPI document: 1.0.0
    Contact: support@infobip.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from infobip_api_client.models.calls_delivery_day import CallsDeliveryDay
from infobip_api_client.models.calls_delivery_time import CallsDeliveryTime
from typing import Optional, Set
from typing_extensions import Self


class CallsDeliveryTimeWindow(BaseModel):
    """
    Scheduling object that allows setting up detailed time windows in which the message can be sent. Consists of from, to and days properties. Days property is mandatory. Days in the week are written as their full names: Monday-Sunday. Days parameter must be populated as a list, between two square brackets. `Example: ['MONDAY', 'TUESDAY', 'WEDNESDAY']`. From and to properties should be either both included, to allow finer time window granulation or both omitted, to include whole days in the delivery time window. From and to parameters are objects, that consist of hour and minute fields that hold integer values. For example, ` from: [ hour: 15, minute:45 ]`. For complete json, please check out our example. Note: delivery time window is set in UTC timezone.
    """  # noqa: E501

    days: Optional[List[CallsDeliveryDay]] = None
    var_from: CallsDeliveryTime = Field(alias="from")
    to: CallsDeliveryTime
    __properties: ClassVar[List[str]] = ["days", "from", "to"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CallsDeliveryTimeWindow from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of var_from
        if self.var_from:
            _dict["from"] = self.var_from.to_dict()
        # override the default output from pydantic by calling `to_dict()` of to
        if self.to:
            _dict["to"] = self.to.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CallsDeliveryTimeWindow from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "days": obj.get("days"),
                "from": CallsDeliveryTime.from_dict(obj["from"])
                if obj.get("from") is not None
                else None,
                "to": CallsDeliveryTime.from_dict(obj["to"])
                if obj.get("to") is not None
                else None,
            }
        )
        return _obj
