# coding: utf-8

"""
    Infobip Client API Libraries OpenAPI Specification

    OpenAPI specification containing public endpoints supported in client API libraries.

    The version of the OpenAPI document: 1.0.0
    Contact: support@infobip.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from infobip_api_client.models.calls_dialog_recording_composition import (
    CallsDialogRecordingComposition,
)
from infobip_api_client.models.calls_recording_type import CallsRecordingType
from typing import Optional, Set
from typing_extensions import Self


class CallsDialogRecordingRequest(BaseModel):
    """
    CallsDialogRecordingRequest
    """  # noqa: E501

    recording_type: CallsRecordingType = Field(alias="recordingType")
    dialog_composition: Optional[CallsDialogRecordingComposition] = Field(
        default=None, alias="dialogComposition"
    )
    custom_data: Optional[Dict[str, StrictStr]] = Field(
        default=None, description="Custom data.", alias="customData"
    )
    file_prefix: Optional[StrictStr] = Field(
        default=None,
        description="Custom name for the recording's zip file. Applicable only when SFTP server is enabled on [Voice settings page](https://portal.infobip.com/apps/voice/recording/settings). Using the same filePrefix will override the files on the SFTP server. For recordings without composition, `callId` and `fileId` will be appended to the `filePrefix` value.",
        alias="filePrefix",
    )
    __properties: ClassVar[List[str]] = [
        "recordingType",
        "dialogComposition",
        "customData",
        "filePrefix",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CallsDialogRecordingRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of dialog_composition
        if self.dialog_composition:
            _dict["dialogComposition"] = self.dialog_composition.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CallsDialogRecordingRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "recordingType": obj.get("recordingType"),
                "dialogComposition": CallsDialogRecordingComposition.from_dict(
                    obj["dialogComposition"]
                )
                if obj.get("dialogComposition") is not None
                else None,
                "customData": obj.get("customData"),
                "filePrefix": obj.get("filePrefix"),
            }
        )
        return _obj
