# coding: utf-8

"""
    Infobip Client API Libraries OpenAPI Specification

    OpenAPI specification containing public endpoints supported in client API libraries.

    The version of the OpenAPI document: 1.0.0
    Contact: support@infobip.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from infobip_api_client.models.call_endpoint import CallEndpoint
from infobip_api_client.models.calls_media_properties import CallsMediaProperties
from infobip_api_client.models.calls_participant_state import CallsParticipantState
from typing import Optional, Set
from typing_extensions import Self


class CallsParticipant(BaseModel):
    """
    CallsParticipant
    """  # noqa: E501

    call_id: Optional[Annotated[str, Field(strict=True, max_length=128)]] = Field(
        default=None, description="Participant call ID.", alias="callId"
    )
    endpoint: CallEndpoint
    state: Optional[CallsParticipantState] = None
    join_time: Optional[datetime] = Field(
        default=None,
        description="Date and time when the participant has joined.",
        alias="joinTime",
    )
    leave_time: Optional[datetime] = Field(
        default=None,
        description="Date and time when the participant has left.",
        alias="leaveTime",
    )
    media: Optional[CallsMediaProperties] = None
    __properties: ClassVar[List[str]] = [
        "callId",
        "endpoint",
        "state",
        "joinTime",
        "leaveTime",
        "media",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CallsParticipant from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of endpoint
        if self.endpoint:
            _dict["endpoint"] = self.endpoint.to_dict()
        # override the default output from pydantic by calling `to_dict()` of media
        if self.media:
            _dict["media"] = self.media.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CallsParticipant from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "callId": obj.get("callId"),
                "endpoint": CallEndpoint.from_dict(obj["endpoint"])
                if obj.get("endpoint") is not None
                else None,
                "state": obj.get("state"),
                "joinTime": obj.get("joinTime"),
                "leaveTime": obj.get("leaveTime"),
                "media": CallsMediaProperties.from_dict(obj["media"])
                if obj.get("media") is not None
                else None,
            }
        )
        return _obj
