# coding: utf-8

"""
    Infobip Client API Libraries OpenAPI Specification

    OpenAPI specification containing public endpoints supported in client API libraries.

    The version of the OpenAPI document: 1.0.0
    Contact: support@infobip.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import ConfigDict, Field, StrictBool
from typing import Any, ClassVar, Dict, List, Optional
from infobip_api_client.models.calls_anonymization_type import CallsAnonymizationType
from infobip_api_client.models.calls_audio_codec import CallsAudioCodec
from infobip_api_client.models.calls_dtmf_type import CallsDtmfType
from infobip_api_client.models.calls_fax_type import CallsFaxType
from infobip_api_client.models.calls_number_presentation_format import (
    CallsNumberPresentationFormat,
)
from infobip_api_client.models.calls_pegasus_sip_trunk_type import (
    CallsPegasusSipTrunkType,
)
from infobip_api_client.models.calls_sip_trunk_update_request import (
    CallsSipTrunkUpdateRequest,
)
from typing import Optional, Set
from typing_extensions import Self


class CallsRegisteredSipTrunkUpdateRequest(CallsSipTrunkUpdateRequest):
    """
    CallsRegisteredSipTrunkUpdateRequest
    """  # noqa: E501

    invite_authentication: Optional[StrictBool] = Field(
        default=None,
        description="Enables an authentication challenge for each call.",
        alias="inviteAuthentication",
    )
    __properties: ClassVar[List[str]] = [
        "type",
        "name",
        "codecs",
        "dtmf",
        "fax",
        "numberFormat",
        "internationalCallsAllowed",
        "channelLimit",
        "anonymization",
        "inviteAuthentication",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CallsRegisteredSipTrunkUpdateRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CallsRegisteredSipTrunkUpdateRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "type": obj.get("type"),
                "name": obj.get("name"),
                "codecs": obj.get("codecs"),
                "dtmf": obj.get("dtmf"),
                "fax": obj.get("fax"),
                "numberFormat": obj.get("numberFormat"),
                "internationalCallsAllowed": obj.get("internationalCallsAllowed")
                if obj.get("internationalCallsAllowed") is not None
                else False,
                "channelLimit": obj.get("channelLimit"),
                "anonymization": obj.get("anonymization"),
                "inviteAuthentication": obj.get("inviteAuthentication"),
            }
        )
        return _obj
