# coding: utf-8

"""
    Infobip Client API Libraries OpenAPI Specification

    OpenAPI specification containing public endpoints supported in client API libraries.

    The version of the OpenAPI document: 1.0.0
    Contact: support@infobip.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self


class CallsRetryOptions(BaseModel):
    """
    Used to determine whether to retry the delivery of a bulk call if the initial attempt fails. Additional retries will occur based on the schedule defined by the _minWaitPeriod_ and _maxWaitPeriod_ parameters, as well as the platform's internal retry logic. If _minWaitPeriod_ differs from _maxWaitPeriod_, the delivery will be retried according to the following schedule: after 1 minute, 2 minutes, 5 minutes, 10 minutes, 20 minutes, 30 minutes, 1 hour, 2 hours, 4 hours, 8 hours, 16 hours, and 24 hours, or until _maxWaitPeriod_ is reached. Once the retry attempt for _maxWaitPeriod_ is reached, _maxWaitPeriod_ will be used for all subsequent retries. If _minWaitPeriod_ and _maxWaitPeriod_ are defined as equal values, the period between retries will be equal to this value. Bulk call delivery will be retried until successful delivery, call validity expiration, or reaching the _maxAttempts_ value.
    """  # noqa: E501

    min_wait_period: Optional[StrictInt] = Field(
        default=None,
        description="Defines the minimum waiting time (in minutes) after the previous failed attempt before trying to establish the call again. Supported values are 1 minute, 2 minutes, 5 minutes, 10 minutes, 20 minutes, 30 minutes, 1 hour, 2 hours, 4 hours, 8 hours, 16 hours, and 24 hours. If entered a value that is not in the list but is smaller than 24 hours, the next bigger value from the list will be used. If a value larger than 24 hours is entered, 24 hours will be used.",
        alias="minWaitPeriod",
    )
    max_wait_period: Optional[StrictInt] = Field(
        default=None,
        description="Defines the maximum waiting time (in minutes) after the previous failed attempt before trying to establish the call again. Supported values are 1 minute, 2 minutes, 5 minutes, 10 minutes, 20 minutes, 30 minutes, 1 hour, 2 hours, 4 hours, 8 hours, 16 hours, and 24 hours. If entered a value that is not in the list but is smaller than 24 hours, the next bigger value from the list will be used. If a value larger than 24 hours is entered, 24 hours will be used.",
        alias="maxWaitPeriod",
    )
    max_attempts: Optional[StrictInt] = Field(
        default=None,
        description="Defines the maximum number of retry attempts. The maximum value is `4`. If a value higher than `4` is entered, it will be set to `4`.",
        alias="maxAttempts",
    )
    __properties: ClassVar[List[str]] = [
        "minWaitPeriod",
        "maxWaitPeriod",
        "maxAttempts",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CallsRetryOptions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CallsRetryOptions from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "minWaitPeriod": obj.get("minWaitPeriod"),
                "maxWaitPeriod": obj.get("maxWaitPeriod"),
                "maxAttempts": obj.get("maxAttempts"),
            }
        )
        return _obj
