# coding: utf-8

"""
    Infobip Client API Libraries OpenAPI Specification

    OpenAPI specification containing public endpoints supported in client API libraries.

    The version of the OpenAPI document: 1.0.0
    Contact: support@infobip.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from infobip_api_client.models.calls_time_window_point import CallsTimeWindowPoint
from typing import Optional, Set
from typing_extensions import Self


class CallsTimeWindow(BaseModel):
    """
    Defines a scheduling object that allows setting up a detailed time window in which calls can be established. Consists of from, to and days properties. Days property is mandatory.
    """  # noqa: E501

    var_from: Optional[CallsTimeWindowPoint] = Field(default=None, alias="from")
    to: Optional[CallsTimeWindowPoint] = None
    days: List[StrictStr] = Field(
        description="Days when scheduling call establishment will be attempted."
    )
    __properties: ClassVar[List[str]] = ["from", "to", "days"]

    @field_validator("days")
    def days_validate_enum(cls, value):
        """Validates the enum"""
        for i in value:
            if i not in set(
                [
                    "MONDAY",
                    "TUESDAY",
                    "WEDNESDAY",
                    "THURSDAY",
                    "FRIDAY",
                    "SATURDAY",
                    "SUNDAY",
                ]
            ):
                raise ValueError(
                    "each list item must be one of ('MONDAY', 'TUESDAY', 'WEDNESDAY', 'THURSDAY', 'FRIDAY', 'SATURDAY', 'SUNDAY')"
                )
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CallsTimeWindow from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of var_from
        if self.var_from:
            _dict["from"] = self.var_from.to_dict()
        # override the default output from pydantic by calling `to_dict()` of to
        if self.to:
            _dict["to"] = self.to.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CallsTimeWindow from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "from": CallsTimeWindowPoint.from_dict(obj["from"])
                if obj.get("from") is not None
                else None,
                "to": CallsTimeWindowPoint.from_dict(obj["to"])
                if obj.get("to") is not None
                else None,
                "days": obj.get("days"),
            }
        )
        return _obj
