# coding: utf-8

"""
    Infobip Client API Libraries OpenAPI Specification

    OpenAPI specification containing public endpoints supported in client API libraries.

    The version of the OpenAPI document: 1.0.0
    Contact: support@infobip.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from infobip_api_client.models.sms_sending_speed_limit import SmsSendingSpeedLimit
from infobip_api_client.models.sms_textual_message import SmsTextualMessage
from infobip_api_client.models.sms_tracking import SmsTracking
from infobip_api_client.models.sms_url_options import SmsUrlOptions
from typing import Optional, Set
from typing_extensions import Self


class SmsAdvancedTextualRequest(BaseModel):
    """
    SmsAdvancedTextualRequest
    """  # noqa: E501

    bulk_id: Optional[StrictStr] = Field(
        default=None,
        description="Unique ID assigned to the request if messaging multiple recipients or sending multiple messages via a single API request. If not provided, it will be auto-generated and returned in the API response. Typically, used to fetch [delivery reports](#channels/sms/get-outbound-sms-message-delivery-reports) and [message logs](#channels/sms/get-outbound-sms-message-logs).",
        alias="bulkId",
    )
    messages: List[SmsTextualMessage] = Field(
        description="An array of message objects of a single message or multiple messages sent under one bulk ID."
    )
    sending_speed_limit: Optional[SmsSendingSpeedLimit] = Field(
        default=None, alias="sendingSpeedLimit"
    )
    url_options: Optional[SmsUrlOptions] = Field(default=None, alias="urlOptions")
    tracking: Optional[SmsTracking] = None
    include_sms_count_in_response: Optional[StrictBool] = Field(
        default=False,
        description="Set to true to return smsCount in the response.  Default is false. smsCount is the total count of SMS submitted in the request.  SMS messages have a character limit and messages longer than that limit will be split into multiple SMS and reflected in the total count of SMS submitted. ",
        alias="includeSmsCountInResponse",
    )
    __properties: ClassVar[List[str]] = [
        "bulkId",
        "messages",
        "sendingSpeedLimit",
        "urlOptions",
        "tracking",
        "includeSmsCountInResponse",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SmsAdvancedTextualRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in messages (list)
        _items = []
        if self.messages:
            for _item in self.messages:
                if _item:
                    _items.append(_item.to_dict())
            _dict["messages"] = _items
        # override the default output from pydantic by calling `to_dict()` of sending_speed_limit
        if self.sending_speed_limit:
            _dict["sendingSpeedLimit"] = self.sending_speed_limit.to_dict()
        # override the default output from pydantic by calling `to_dict()` of url_options
        if self.url_options:
            _dict["urlOptions"] = self.url_options.to_dict()
        # override the default output from pydantic by calling `to_dict()` of tracking
        if self.tracking:
            _dict["tracking"] = self.tracking.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SmsAdvancedTextualRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "bulkId": obj.get("bulkId"),
                "messages": [
                    SmsTextualMessage.from_dict(_item) for _item in obj["messages"]
                ]
                if obj.get("messages") is not None
                else None,
                "sendingSpeedLimit": SmsSendingSpeedLimit.from_dict(
                    obj["sendingSpeedLimit"]
                )
                if obj.get("sendingSpeedLimit") is not None
                else None,
                "urlOptions": SmsUrlOptions.from_dict(obj["urlOptions"])
                if obj.get("urlOptions") is not None
                else None,
                "tracking": SmsTracking.from_dict(obj["tracking"])
                if obj.get("tracking") is not None
                else None,
                "includeSmsCountInResponse": obj.get("includeSmsCountInResponse")
                if obj.get("includeSmsCountInResponse") is not None
                else False,
            }
        )
        return _obj
