# coding: utf-8

"""
    Infobip Client API Libraries OpenAPI Specification

    OpenAPI specification containing public endpoints supported in client API libraries.

    The version of the OpenAPI document: 1.0.0
    Contact: support@infobip.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from infobip_api_client.models.tfa_language import TfaLanguage
from infobip_api_client.models.tfa_pin_type import TfaPinType
from infobip_api_client.models.tfa_regional_options import TfaRegionalOptions
from typing import Optional, Set
from typing_extensions import Self


class TfaMessage(BaseModel):
    """
    TfaMessage
    """  # noqa: E501

    application_id: Optional[StrictStr] = Field(
        default=None,
        description="The ID of the application that represents your service (e.g. 2FA for login, 2FA for changing the password, etc.) for which the requested message has been created.",
        alias="applicationId",
    )
    email_template_id: Optional[StrictInt] = Field(
        default=None,
        description="Email template ID that should reference a previously created Email template. This field is present only for [Email message templates](#channels/sms/create-2fa-email-message-template).",
        alias="emailTemplateId",
    )
    var_from: Optional[StrictStr] = Field(
        default=None,
        description="The sender of the 2FA message, an email address with an optional sender name (e.g. `company@example.com` or `Jane Smith <jane.smith@somecompany.com>`). This field is present only for [Email message templates](#channels/sms/create-2fa-email-message-template).",
        alias="from",
    )
    language: Optional[TfaLanguage] = None
    message_id: Optional[StrictStr] = Field(
        default=None,
        description="The ID of the message template (message body with the PIN placeholder) that is sent to the recipient.",
        alias="messageId",
    )
    message_text: Optional[StrictStr] = Field(
        default=None,
        description="Text of a message that will be sent. Message text must contain `pinPlaceholder`.",
        alias="messageText",
    )
    pin_length: Optional[StrictInt] = Field(
        default=None, description="PIN code length.", alias="pinLength"
    )
    pin_placeholder: Optional[StrictStr] = Field(
        default=None,
        description="The PIN code placeholder that will be replaced with a generated PIN code.",
        alias="pinPlaceholder",
    )
    pin_type: Optional[TfaPinType] = Field(default=None, alias="pinType")
    regional: Optional[TfaRegionalOptions] = None
    repeat_dtmf: Optional[StrictStr] = Field(
        default=None,
        description="In case PIN message is sent by Voice, DTMF code will enable replaying the message.",
        alias="repeatDTMF",
    )
    sender_id: Optional[StrictStr] = Field(
        default=None,
        description="The sender of the 2FA message (Example: CompanyName).",
        alias="senderId",
    )
    speech_rate: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None,
        description="In case PIN message is sent by Voice, the speed of speech can be set for the message. Supported range is from `0.5` to `2`.",
        alias="speechRate",
    )
    __properties: ClassVar[List[str]] = [
        "applicationId",
        "emailTemplateId",
        "from",
        "language",
        "messageId",
        "messageText",
        "pinLength",
        "pinPlaceholder",
        "pinType",
        "regional",
        "repeatDTMF",
        "senderId",
        "speechRate",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TfaMessage from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of regional
        if self.regional:
            _dict["regional"] = self.regional.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TfaMessage from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "applicationId": obj.get("applicationId"),
                "emailTemplateId": obj.get("emailTemplateId"),
                "from": obj.get("from"),
                "language": obj.get("language"),
                "messageId": obj.get("messageId"),
                "messageText": obj.get("messageText"),
                "pinLength": obj.get("pinLength"),
                "pinPlaceholder": obj.get("pinPlaceholder"),
                "pinType": obj.get("pinType"),
                "regional": TfaRegionalOptions.from_dict(obj["regional"])
                if obj.get("regional") is not None
                else None,
                "repeatDTMF": obj.get("repeatDTMF"),
                "senderId": obj.get("senderId"),
                "speechRate": obj.get("speechRate"),
            }
        )
        return _obj
