# coding: utf-8

"""
    Infobip Client API Libraries OpenAPI Specification

    OpenAPI specification containing public endpoints supported in client API libraries.

    The version of the OpenAPI document: 1.0.0
    Contact: support@infobip.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501
import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictInt, StrictStr
from typing import Optional
from typing_extensions import Annotated
from infobip_api_client.models.flow_add_flow_participants_request import (
    FlowAddFlowParticipantsRequest,
)
from infobip_api_client.models.flow_add_flow_participants_response import (
    FlowAddFlowParticipantsResponse,
)
from infobip_api_client.models.flow_participants_report_response import (
    FlowParticipantsReportResponse,
)

from infobip_api_client.api_client import ApiClient, RequestSerialized
from infobip_api_client.api_response import ApiResponse
from infobip_api_client.rest import RESTResponseType


class FlowApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_call
    def add_flow_participants(
        self,
        campaign_id: Annotated[
            StrictInt,
            Field(
                description="Unique identifier of the flow that participant will be added to."
            ),
        ],
        flow_add_flow_participants_request: FlowAddFlowParticipantsRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> FlowAddFlowParticipantsResponse:
        """Add participants to flow

        Use this endpoint to add participants to a flow, accommodating anywhere from 1 to 1000 persons.                  When participants are added, their profiles in People are automatically created, updated or merged based on the identifiers provided.<br>                 If identifiers are unique, a new profile is created.<br>                 If identifiers match an existing profile, then that profile is updated.<br>                 If identifiers refer to multiple existing profiles or are not unique within the request, profiles are merged.<br>                 To prevent unwanted merges, ensure each participant's identifiers                  (<code>identifyBy</code>, <code>externalId</code> and <code>contactInformation</code>) are unique.

        :param campaign_id: Unique identifier of the flow that participant will be added to. (required)
        :type campaign_id: int
        :param flow_add_flow_participants_request: (required)
        :type flow_add_flow_participants_request: FlowAddFlowParticipantsRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._add_flow_participants_serialize(
            campaign_id=campaign_id,
            flow_add_flow_participants_request=flow_add_flow_participants_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "FlowAddFlowParticipantsResponse",
            "400": "FlowApiException",
            "401": "FlowApiException",
            "403": "FlowApiException",
            "404": "FlowApiException",
            "429": "FlowApiException",
            "500": "FlowApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def add_flow_participants_with_http_info(
        self,
        campaign_id: Annotated[
            StrictInt,
            Field(
                description="Unique identifier of the flow that participant will be added to."
            ),
        ],
        flow_add_flow_participants_request: FlowAddFlowParticipantsRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[FlowAddFlowParticipantsResponse]:
        """Add participants to flow

        Use this endpoint to add participants to a flow, accommodating anywhere from 1 to 1000 persons.                  When participants are added, their profiles in People are automatically created, updated or merged based on the identifiers provided.<br>                 If identifiers are unique, a new profile is created.<br>                 If identifiers match an existing profile, then that profile is updated.<br>                 If identifiers refer to multiple existing profiles or are not unique within the request, profiles are merged.<br>                 To prevent unwanted merges, ensure each participant's identifiers                  (<code>identifyBy</code>, <code>externalId</code> and <code>contactInformation</code>) are unique.

        :param campaign_id: Unique identifier of the flow that participant will be added to. (required)
        :type campaign_id: int
        :param flow_add_flow_participants_request: (required)
        :type flow_add_flow_participants_request: FlowAddFlowParticipantsRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._add_flow_participants_serialize(
            campaign_id=campaign_id,
            flow_add_flow_participants_request=flow_add_flow_participants_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "FlowAddFlowParticipantsResponse",
            "400": "FlowApiException",
            "401": "FlowApiException",
            "403": "FlowApiException",
            "404": "FlowApiException",
            "429": "FlowApiException",
            "500": "FlowApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def add_flow_participants_without_preload_content(
        self,
        campaign_id: Annotated[
            StrictInt,
            Field(
                description="Unique identifier of the flow that participant will be added to."
            ),
        ],
        flow_add_flow_participants_request: FlowAddFlowParticipantsRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Add participants to flow

        Use this endpoint to add participants to a flow, accommodating anywhere from 1 to 1000 persons.                  When participants are added, their profiles in People are automatically created, updated or merged based on the identifiers provided.<br>                 If identifiers are unique, a new profile is created.<br>                 If identifiers match an existing profile, then that profile is updated.<br>                 If identifiers refer to multiple existing profiles or are not unique within the request, profiles are merged.<br>                 To prevent unwanted merges, ensure each participant's identifiers                  (<code>identifyBy</code>, <code>externalId</code> and <code>contactInformation</code>) are unique.

        :param campaign_id: Unique identifier of the flow that participant will be added to. (required)
        :type campaign_id: int
        :param flow_add_flow_participants_request: (required)
        :type flow_add_flow_participants_request: FlowAddFlowParticipantsRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._add_flow_participants_serialize(
            campaign_id=campaign_id,
            flow_add_flow_participants_request=flow_add_flow_participants_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "FlowAddFlowParticipantsResponse",
            "400": "FlowApiException",
            "401": "FlowApiException",
            "403": "FlowApiException",
            "404": "FlowApiException",
            "429": "FlowApiException",
            "500": "FlowApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _add_flow_participants_serialize(
        self,
        campaign_id,
        flow_add_flow_participants_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if campaign_id is not None:
            _path_params["campaignId"] = campaign_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if flow_add_flow_participants_request is not None:
            _body_params = flow_add_flow_participants_request

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(
                ["application/json"]
            )
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/moments/1/flows/{campaignId}/participants",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def get_flow_participants_added_report(
        self,
        campaign_id: Annotated[
            StrictInt,
            Field(
                description="Unique identifier of the flow that participant will be added to."
            ),
        ],
        operation_id: Annotated[
            StrictStr, Field(description="Unique identifier of the operation.")
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> FlowParticipantsReportResponse:
        """Get a report on participants added to flow

        Use this API endpoint to fetch a report to confirm that all persons have been successfully added to the flow.                 Please note that report is stored for 30 days.

        :param campaign_id: Unique identifier of the flow that participant will be added to. (required)
        :type campaign_id: int
        :param operation_id: Unique identifier of the operation. (required)
        :type operation_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_flow_participants_added_report_serialize(
            campaign_id=campaign_id,
            operation_id=operation_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "FlowParticipantsReportResponse",
            "401": "FlowApiException",
            "403": "FlowApiException",
            "404": None,
            "429": "FlowApiException",
            "500": "FlowApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def get_flow_participants_added_report_with_http_info(
        self,
        campaign_id: Annotated[
            StrictInt,
            Field(
                description="Unique identifier of the flow that participant will be added to."
            ),
        ],
        operation_id: Annotated[
            StrictStr, Field(description="Unique identifier of the operation.")
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[FlowParticipantsReportResponse]:
        """Get a report on participants added to flow

        Use this API endpoint to fetch a report to confirm that all persons have been successfully added to the flow.                 Please note that report is stored for 30 days.

        :param campaign_id: Unique identifier of the flow that participant will be added to. (required)
        :type campaign_id: int
        :param operation_id: Unique identifier of the operation. (required)
        :type operation_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_flow_participants_added_report_serialize(
            campaign_id=campaign_id,
            operation_id=operation_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "FlowParticipantsReportResponse",
            "401": "FlowApiException",
            "403": "FlowApiException",
            "404": None,
            "429": "FlowApiException",
            "500": "FlowApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def get_flow_participants_added_report_without_preload_content(
        self,
        campaign_id: Annotated[
            StrictInt,
            Field(
                description="Unique identifier of the flow that participant will be added to."
            ),
        ],
        operation_id: Annotated[
            StrictStr, Field(description="Unique identifier of the operation.")
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a report on participants added to flow

        Use this API endpoint to fetch a report to confirm that all persons have been successfully added to the flow.                 Please note that report is stored for 30 days.

        :param campaign_id: Unique identifier of the flow that participant will be added to. (required)
        :type campaign_id: int
        :param operation_id: Unique identifier of the operation. (required)
        :type operation_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_flow_participants_added_report_serialize(
            campaign_id=campaign_id,
            operation_id=operation_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "FlowParticipantsReportResponse",
            "401": "FlowApiException",
            "403": "FlowApiException",
            "404": None,
            "429": "FlowApiException",
            "500": "FlowApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _get_flow_participants_added_report_serialize(
        self,
        campaign_id,
        operation_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if campaign_id is not None:
            _path_params["campaignId"] = campaign_id
        # process the query parameters
        if operation_id is not None:

            _query_params.append(("operationId", operation_id))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/moments/1/flows/{campaignId}/participants/report",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def remove_people_from_flow(
        self,
        campaign_id: Annotated[
            StrictInt,
            Field(
                description="Unique identifier of the flow that person will be removed from."
            ),
        ],
        phone: Annotated[
            Optional[StrictStr], Field(description="Person's phone number.")
        ] = None,
        email: Annotated[
            Optional[StrictStr], Field(description="Person's email address.")
        ] = None,
        external_id: Annotated[
            Optional[StrictStr],
            Field(description="Unique ID for the person from an external system."),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Remove person from flow

        Removes a participant with given identifier from the flow.

        :param campaign_id: Unique identifier of the flow that person will be removed from. (required)
        :type campaign_id: int
        :param phone: Person's phone number.
        :type phone: str
        :param email: Person's email address.
        :type email: str
        :param external_id: Unique ID for the person from an external system.
        :type external_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._remove_people_from_flow_serialize(
            campaign_id=campaign_id,
            phone=phone,
            email=email,
            external_id=external_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": None,
            "400": "FlowExceptionResponse",
            "401": "FlowApiException",
            "403": "FlowApiException",
            "404": "FlowExceptionResponse",
            "429": "FlowApiException",
            "500": "FlowApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def remove_people_from_flow_with_http_info(
        self,
        campaign_id: Annotated[
            StrictInt,
            Field(
                description="Unique identifier of the flow that person will be removed from."
            ),
        ],
        phone: Annotated[
            Optional[StrictStr], Field(description="Person's phone number.")
        ] = None,
        email: Annotated[
            Optional[StrictStr], Field(description="Person's email address.")
        ] = None,
        external_id: Annotated[
            Optional[StrictStr],
            Field(description="Unique ID for the person from an external system."),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Remove person from flow

        Removes a participant with given identifier from the flow.

        :param campaign_id: Unique identifier of the flow that person will be removed from. (required)
        :type campaign_id: int
        :param phone: Person's phone number.
        :type phone: str
        :param email: Person's email address.
        :type email: str
        :param external_id: Unique ID for the person from an external system.
        :type external_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._remove_people_from_flow_serialize(
            campaign_id=campaign_id,
            phone=phone,
            email=email,
            external_id=external_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": None,
            "400": "FlowExceptionResponse",
            "401": "FlowApiException",
            "403": "FlowApiException",
            "404": "FlowExceptionResponse",
            "429": "FlowApiException",
            "500": "FlowApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def remove_people_from_flow_without_preload_content(
        self,
        campaign_id: Annotated[
            StrictInt,
            Field(
                description="Unique identifier of the flow that person will be removed from."
            ),
        ],
        phone: Annotated[
            Optional[StrictStr], Field(description="Person's phone number.")
        ] = None,
        email: Annotated[
            Optional[StrictStr], Field(description="Person's email address.")
        ] = None,
        external_id: Annotated[
            Optional[StrictStr],
            Field(description="Unique ID for the person from an external system."),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Remove person from flow

        Removes a participant with given identifier from the flow.

        :param campaign_id: Unique identifier of the flow that person will be removed from. (required)
        :type campaign_id: int
        :param phone: Person's phone number.
        :type phone: str
        :param email: Person's email address.
        :type email: str
        :param external_id: Unique ID for the person from an external system.
        :type external_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._remove_people_from_flow_serialize(
            campaign_id=campaign_id,
            phone=phone,
            email=email,
            external_id=external_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": None,
            "400": "FlowExceptionResponse",
            "401": "FlowApiException",
            "403": "FlowApiException",
            "404": "FlowExceptionResponse",
            "429": "FlowApiException",
            "500": "FlowApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _remove_people_from_flow_serialize(
        self,
        campaign_id,
        phone,
        email,
        external_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if campaign_id is not None:
            _path_params["campaignId"] = campaign_id
        # process the query parameters
        if phone is not None:

            _query_params.append(("phone", phone))

        if email is not None:

            _query_params.append(("email", email))

        if external_id is not None:

            _query_params.append(("externalId", external_id))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="DELETE",
            resource_path="/communication/1/flows/{campaignId}/participants",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )
