# coding: utf-8

"""
    Infobip Client API Libraries OpenAPI Specification

    OpenAPI specification containing public endpoints supported in client API libraries.

    The version of the OpenAPI document: 1.0.0
    Contact: support@infobip.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from infobip_api_client.models.calls_dtmf_options import CallsDtmfOptions
from infobip_api_client.models.calls_send_to_reports import CallsSendToReports
from infobip_api_client.models.calls_speech_options import CallsSpeechOptions
from typing import Optional, Set
from typing_extensions import Self


class CallsCapture(BaseModel):
    """
    Capture action performs speech recognition of a specified duration. The recognized text can be used in other actions of the scenario.
    """  # noqa: E501

    capture: StrictStr = Field(
        description="Variable name. If speech recognition matches one of the specified keyPhrases, a variable with this name will be set to match the keyphrase. Otherwise, this variable will be an empty string. Together with this variable, an implicit variable that contains the full text of the captured speech will be created. The name of this variable is constructed by adding _Full suffix to the variable name."
    )
    timeout: Annotated[int, Field(le=30, strict=True, ge=1)] = Field(
        description="Number of seconds used for capturing speech or digits failover. Minimum value is 1 and maximum value is 30. Can be overriden with speechOptions.maxSilence."
    )
    speech_options: CallsSpeechOptions = Field(alias="speechOptions")
    dtmf_options: Optional[CallsDtmfOptions] = Field(default=None, alias="dtmfOptions")
    send_to_reports: Optional[CallsSendToReports] = Field(
        default=None, alias="sendToReports"
    )
    action_id: Optional[StrictInt] = Field(
        default=None,
        description="User-defined ID of an action that can be used with go-to action.",
        alias="actionId",
    )
    __properties: ClassVar[List[str]] = [
        "capture",
        "timeout",
        "speechOptions",
        "dtmfOptions",
        "sendToReports",
        "actionId",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CallsCapture from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of speech_options
        if self.speech_options:
            _dict["speechOptions"] = self.speech_options.to_dict()
        # override the default output from pydantic by calling `to_dict()` of dtmf_options
        if self.dtmf_options:
            _dict["dtmfOptions"] = self.dtmf_options.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CallsCapture from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "capture": obj.get("capture"),
                "timeout": obj.get("timeout"),
                "speechOptions": CallsSpeechOptions.from_dict(obj["speechOptions"])
                if obj.get("speechOptions") is not None
                else None,
                "dtmfOptions": CallsDtmfOptions.from_dict(obj["dtmfOptions"])
                if obj.get("dtmfOptions") is not None
                else None,
                "sendToReports": obj.get("sendToReports"),
                "actionId": obj.get("actionId"),
            }
        )
        return _obj
