# coding: utf-8

"""
    Infobip Client API Libraries OpenAPI Specification

    OpenAPI specification containing public endpoints supported in client API libraries.

    The version of the OpenAPI document: 1.0.0
    Contact: support@infobip.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from infobip_api_client.models.calls_dial_to_many_options import CallsDialToManyOptions
from infobip_api_client.models.calls_numbers import CallsNumbers
from typing import Optional, Set
from typing_extensions import Self


class CallsDialToMany(BaseModel):
    """
    Dial to Many action performs a call redirection to multiple destinations, joining the user’s call only with the destination that answered the call first. After Dial to Many action the following actions are forbidden: Say, Collect, Dial, Dial to Many, Dial to WebRTC, Dial to SIP trunk, Dial to Conversations, Play, Record and Play from Recording.
    """  # noqa: E501

    dial_to_many: List[CallsNumbers] = Field(alias="dialToMany")
    options: Optional[CallsDialToManyOptions] = None
    action_id: Optional[StrictInt] = Field(
        default=None,
        description="User-defined ID of an action that can be used with go-to action.",
        alias="actionId",
    )
    __properties: ClassVar[List[str]] = ["dialToMany", "options", "actionId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CallsDialToMany from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in dial_to_many (list)
        _items = []
        if self.dial_to_many:
            for _item in self.dial_to_many:
                if _item:
                    _items.append(_item.to_dict())
            _dict["dialToMany"] = _items
        # override the default output from pydantic by calling `to_dict()` of options
        if self.options:
            _dict["options"] = self.options.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CallsDialToMany from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "dialToMany": [
                    CallsNumbers.from_dict(_item) for _item in obj["dialToMany"]
                ]
                if obj.get("dialToMany") is not None
                else None,
                "options": CallsDialToManyOptions.from_dict(obj["options"])
                if obj.get("options") is not None
                else None,
                "actionId": obj.get("actionId"),
            }
        )
        return _obj
