# coding: utf-8

"""
    Infobip Client API Libraries OpenAPI Specification

    OpenAPI specification containing public endpoints supported in client API libraries.

    The version of the OpenAPI document: 1.0.0
    Contact: support@infobip.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import json
from enum import Enum
from typing_extensions import Self


class CallsMachineDetection(str, Enum):
    """
    Machine Detection action detects answering machines at the beginning of the call. This action sets `machineAnswered` variable upon completion to `true`  or `false`. Machine Detection introduces a delay of approximately 4s. This is the minimum time needed for machine detection. Machine Detection action has to be followed by a condition action that uses the value of `machineAnswered` for branching into the 'human answered' block and the 'answering machine answered' block. The 'answering machine' block can have a Say/Play/PlayFromRecording action or a Hangup action. If answering machine is detected, and a Say/Play/Play from Recording action is up next - the voice message will start playing into the voice mail only after the answering machine is finished with its greeting.
    """

    """
    allowed enum values
    """
    MACHINEDETECTION = "machineDetection"

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of CallsMachineDetection from a JSON string"""
        return cls(json.loads(json_str))
