# coding: utf-8

"""
    Infobip Client API Libraries OpenAPI Specification

    OpenAPI specification containing public endpoints supported in client API libraries.

    The version of the OpenAPI document: 1.0.0
    Contact: support@infobip.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import json
import pprint
from pydantic import (
    BaseModel,
    ConfigDict,
    Field,
    StrictStr,
    ValidationError,
    field_validator,
)
from typing import Any, List, Optional
from infobip_api_client.models.calls_call_api import CallsCallApi
from infobip_api_client.models.calls_capture import CallsCapture
from infobip_api_client.models.calls_collect import CallsCollect
from infobip_api_client.models.calls_dial import CallsDial
from infobip_api_client.models.calls_dial_to_conversations import (
    CallsDialToConversations,
)
from infobip_api_client.models.calls_dial_to_many import CallsDialToMany
from infobip_api_client.models.calls_dial_to_web_rtc import CallsDialToWebRTC
from infobip_api_client.models.calls_for_each import CallsForEach
from infobip_api_client.models.calls_go_to import CallsGoTo
from infobip_api_client.models.calls_hangup import CallsHangup
from infobip_api_client.models.calls_if_then_else import CallsIfThenElse
from infobip_api_client.models.calls_machine_detection import CallsMachineDetection
from infobip_api_client.models.calls_pause import CallsPause
from infobip_api_client.models.calls_play import CallsPlay
from infobip_api_client.models.calls_play_from_recording import CallsPlayFromRecording
from infobip_api_client.models.calls_record import CallsRecord
from infobip_api_client.models.calls_repeat_until import CallsRepeatUntil
from infobip_api_client.models.calls_repeat_while import CallsRepeatWhile
from infobip_api_client.models.calls_say import CallsSay
from infobip_api_client.models.calls_send_sms import CallsSendSms
from infobip_api_client.models.calls_set_variable import CallsSetVariable
from infobip_api_client.models.calls_switch_case import CallsSwitchCase
from infobip_api_client.models.calls_while_do import CallsWhileDo
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

CALLSSCRIPTINNER_ONE_OF_SCHEMAS = [
    "CallsCallApi",
    "CallsCapture",
    "CallsCollect",
    "CallsDial",
    "CallsDialToConversations",
    "CallsDialToMany",
    "CallsDialToWebRTC",
    "CallsForEach",
    "CallsGoTo",
    "CallsHangup",
    "CallsIfThenElse",
    "CallsMachineDetection",
    "CallsPause",
    "CallsPlay",
    "CallsPlayFromRecording",
    "CallsRecord",
    "CallsRepeatUntil",
    "CallsRepeatWhile",
    "CallsSay",
    "CallsSendSms",
    "CallsSetVariable",
    "CallsSwitchCase",
    "CallsWhileDo",
]


class CallsScriptInner(BaseModel):
    """
    CallsScriptInner
    """

    # data type: CallsCallApi
    oneof_schema_1_validator: Optional[CallsCallApi] = None
    # data type: CallsCapture
    oneof_schema_2_validator: Optional[CallsCapture] = None
    # data type: CallsCollect
    oneof_schema_3_validator: Optional[CallsCollect] = None
    # data type: CallsDial
    oneof_schema_4_validator: Optional[CallsDial] = None
    # data type: CallsDialToMany
    oneof_schema_5_validator: Optional[CallsDialToMany] = None
    # data type: CallsDialToWebRTC
    oneof_schema_6_validator: Optional[CallsDialToWebRTC] = None
    # data type: CallsDialToConversations
    oneof_schema_7_validator: Optional[CallsDialToConversations] = None
    # data type: CallsForEach
    oneof_schema_8_validator: Optional[CallsForEach] = None
    # data type: CallsGoTo
    oneof_schema_9_validator: Optional[CallsGoTo] = None
    # data type: CallsHangup
    oneof_schema_10_validator: Optional[CallsHangup] = None
    # data type: CallsIfThenElse
    oneof_schema_11_validator: Optional[CallsIfThenElse] = None
    # data type: CallsMachineDetection
    oneof_schema_12_validator: Optional[CallsMachineDetection] = None
    # data type: CallsPause
    oneof_schema_13_validator: Optional[CallsPause] = None
    # data type: CallsPlay
    oneof_schema_14_validator: Optional[CallsPlay] = None
    # data type: CallsPlayFromRecording
    oneof_schema_15_validator: Optional[CallsPlayFromRecording] = None
    # data type: CallsRecord
    oneof_schema_16_validator: Optional[CallsRecord] = None
    # data type: CallsRepeatUntil
    oneof_schema_17_validator: Optional[CallsRepeatUntil] = None
    # data type: CallsRepeatWhile
    oneof_schema_18_validator: Optional[CallsRepeatWhile] = None
    # data type: CallsSay
    oneof_schema_19_validator: Optional[CallsSay] = None
    # data type: CallsSendSms
    oneof_schema_20_validator: Optional[CallsSendSms] = None
    # data type: CallsSetVariable
    oneof_schema_21_validator: Optional[CallsSetVariable] = None
    # data type: CallsSwitchCase
    oneof_schema_22_validator: Optional[CallsSwitchCase] = None
    # data type: CallsWhileDo
    oneof_schema_23_validator: Optional[CallsWhileDo] = None
    actual_instance: Optional[
        Union[
            CallsCallApi,
            CallsCapture,
            CallsCollect,
            CallsDial,
            CallsDialToConversations,
            CallsDialToMany,
            CallsDialToWebRTC,
            CallsForEach,
            CallsGoTo,
            CallsHangup,
            CallsIfThenElse,
            CallsMachineDetection,
            CallsPause,
            CallsPlay,
            CallsPlayFromRecording,
            CallsRecord,
            CallsRepeatUntil,
            CallsRepeatWhile,
            CallsSay,
            CallsSendSms,
            CallsSetVariable,
            CallsSwitchCase,
            CallsWhileDo,
        ]
    ] = None
    one_of_schemas: Set[str] = Field(
        default_factory=lambda: {
            "CallsCallApi",
            "CallsCapture",
            "CallsCollect",
            "CallsDial",
            "CallsDialToConversations",
            "CallsDialToMany",
            "CallsDialToWebRTC",
            "CallsForEach",
            "CallsGoTo",
            "CallsHangup",
            "CallsIfThenElse",
            "CallsMachineDetection",
            "CallsPause",
            "CallsPlay",
            "CallsPlayFromRecording",
            "CallsRecord",
            "CallsRepeatUntil",
            "CallsRepeatWhile",
            "CallsSay",
            "CallsSendSms",
            "CallsSetVariable",
            "CallsSwitchCase",
            "CallsWhileDo",
        }
    )

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError(
                    "If a position argument is used, only 1 is allowed to set `actual_instance`"
                )
            if kwargs:
                raise ValueError(
                    "If a position argument is used, keyword arguments cannot be used."
                )
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator("actual_instance")
    def actual_instance_must_validate_oneof(cls, v):
        instance = CallsScriptInner.model_construct()
        error_messages = []
        match = 0
        # validate data type: CallsCallApi
        if not isinstance(v, CallsCallApi):
            error_messages.append(
                f"Error! Input type `{type(v)}` is not `CallsCallApi`"
            )
        else:
            match += 1
        # validate data type: CallsCapture
        if not isinstance(v, CallsCapture):
            error_messages.append(
                f"Error! Input type `{type(v)}` is not `CallsCapture`"
            )
        else:
            match += 1
        # validate data type: CallsCollect
        if not isinstance(v, CallsCollect):
            error_messages.append(
                f"Error! Input type `{type(v)}` is not `CallsCollect`"
            )
        else:
            match += 1
        # validate data type: CallsDial
        if not isinstance(v, CallsDial):
            error_messages.append(f"Error! Input type `{type(v)}` is not `CallsDial`")
        else:
            match += 1
        # validate data type: CallsDialToMany
        if not isinstance(v, CallsDialToMany):
            error_messages.append(
                f"Error! Input type `{type(v)}` is not `CallsDialToMany`"
            )
        else:
            match += 1
        # validate data type: CallsDialToWebRTC
        if not isinstance(v, CallsDialToWebRTC):
            error_messages.append(
                f"Error! Input type `{type(v)}` is not `CallsDialToWebRTC`"
            )
        else:
            match += 1
        # validate data type: CallsDialToConversations
        if not isinstance(v, CallsDialToConversations):
            error_messages.append(
                f"Error! Input type `{type(v)}` is not `CallsDialToConversations`"
            )
        else:
            match += 1
        # validate data type: CallsForEach
        if not isinstance(v, CallsForEach):
            error_messages.append(
                f"Error! Input type `{type(v)}` is not `CallsForEach`"
            )
        else:
            match += 1
        # validate data type: CallsGoTo
        if not isinstance(v, CallsGoTo):
            error_messages.append(f"Error! Input type `{type(v)}` is not `CallsGoTo`")
        else:
            match += 1
        # validate data type: CallsHangup
        if not isinstance(v, CallsHangup):
            error_messages.append(f"Error! Input type `{type(v)}` is not `CallsHangup`")
        else:
            match += 1
        # validate data type: CallsIfThenElse
        if not isinstance(v, CallsIfThenElse):
            error_messages.append(
                f"Error! Input type `{type(v)}` is not `CallsIfThenElse`"
            )
        else:
            match += 1
        # validate data type: CallsMachineDetection
        if not isinstance(v, CallsMachineDetection):
            error_messages.append(
                f"Error! Input type `{type(v)}` is not `CallsMachineDetection`"
            )
        else:
            match += 1
        # validate data type: CallsPause
        if not isinstance(v, CallsPause):
            error_messages.append(f"Error! Input type `{type(v)}` is not `CallsPause`")
        else:
            match += 1
        # validate data type: CallsPlay
        if not isinstance(v, CallsPlay):
            error_messages.append(f"Error! Input type `{type(v)}` is not `CallsPlay`")
        else:
            match += 1
        # validate data type: CallsPlayFromRecording
        if not isinstance(v, CallsPlayFromRecording):
            error_messages.append(
                f"Error! Input type `{type(v)}` is not `CallsPlayFromRecording`"
            )
        else:
            match += 1
        # validate data type: CallsRecord
        if not isinstance(v, CallsRecord):
            error_messages.append(f"Error! Input type `{type(v)}` is not `CallsRecord`")
        else:
            match += 1
        # validate data type: CallsRepeatUntil
        if not isinstance(v, CallsRepeatUntil):
            error_messages.append(
                f"Error! Input type `{type(v)}` is not `CallsRepeatUntil`"
            )
        else:
            match += 1
        # validate data type: CallsRepeatWhile
        if not isinstance(v, CallsRepeatWhile):
            error_messages.append(
                f"Error! Input type `{type(v)}` is not `CallsRepeatWhile`"
            )
        else:
            match += 1
        # validate data type: CallsSay
        if not isinstance(v, CallsSay):
            error_messages.append(f"Error! Input type `{type(v)}` is not `CallsSay`")
        else:
            match += 1
        # validate data type: CallsSendSms
        if not isinstance(v, CallsSendSms):
            error_messages.append(
                f"Error! Input type `{type(v)}` is not `CallsSendSms`"
            )
        else:
            match += 1
        # validate data type: CallsSetVariable
        if not isinstance(v, CallsSetVariable):
            error_messages.append(
                f"Error! Input type `{type(v)}` is not `CallsSetVariable`"
            )
        else:
            match += 1
        # validate data type: CallsSwitchCase
        if not isinstance(v, CallsSwitchCase):
            error_messages.append(
                f"Error! Input type `{type(v)}` is not `CallsSwitchCase`"
            )
        else:
            match += 1
        # validate data type: CallsWhileDo
        if not isinstance(v, CallsWhileDo):
            error_messages.append(
                f"Error! Input type `{type(v)}` is not `CallsWhileDo`"
            )
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError(
                "Multiple matches found when setting `actual_instance` in CallsScriptInner with oneOf schemas: CallsCallApi, CallsCapture, CallsCollect, CallsDial, CallsDialToConversations, CallsDialToMany, CallsDialToWebRTC, CallsForEach, CallsGoTo, CallsHangup, CallsIfThenElse, CallsMachineDetection, CallsPause, CallsPlay, CallsPlayFromRecording, CallsRecord, CallsRepeatUntil, CallsRepeatWhile, CallsSay, CallsSendSms, CallsSetVariable, CallsSwitchCase, CallsWhileDo. Details: "
                + ", ".join(error_messages)
            )
        elif match == 0:
            # no match
            raise ValueError(
                "No match found when setting `actual_instance` in CallsScriptInner with oneOf schemas: CallsCallApi, CallsCapture, CallsCollect, CallsDial, CallsDialToConversations, CallsDialToMany, CallsDialToWebRTC, CallsForEach, CallsGoTo, CallsHangup, CallsIfThenElse, CallsMachineDetection, CallsPause, CallsPlay, CallsPlayFromRecording, CallsRecord, CallsRepeatUntil, CallsRepeatWhile, CallsSay, CallsSendSms, CallsSetVariable, CallsSwitchCase, CallsWhileDo. Details: "
                + ", ".join(error_messages)
            )
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into CallsCallApi
        try:
            instance.actual_instance = CallsCallApi.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into CallsCapture
        try:
            instance.actual_instance = CallsCapture.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into CallsCollect
        try:
            instance.actual_instance = CallsCollect.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into CallsDial
        try:
            instance.actual_instance = CallsDial.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into CallsDialToMany
        try:
            instance.actual_instance = CallsDialToMany.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into CallsDialToWebRTC
        try:
            instance.actual_instance = CallsDialToWebRTC.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into CallsDialToConversations
        try:
            instance.actual_instance = CallsDialToConversations.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into CallsForEach
        try:
            instance.actual_instance = CallsForEach.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into CallsGoTo
        try:
            instance.actual_instance = CallsGoTo.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into CallsHangup
        try:
            instance.actual_instance = CallsHangup.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into CallsIfThenElse
        try:
            instance.actual_instance = CallsIfThenElse.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into CallsMachineDetection
        try:
            instance.actual_instance = CallsMachineDetection.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into CallsPause
        try:
            instance.actual_instance = CallsPause.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into CallsPlay
        try:
            instance.actual_instance = CallsPlay.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into CallsPlayFromRecording
        try:
            instance.actual_instance = CallsPlayFromRecording.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into CallsRecord
        try:
            instance.actual_instance = CallsRecord.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into CallsRepeatUntil
        try:
            instance.actual_instance = CallsRepeatUntil.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into CallsRepeatWhile
        try:
            instance.actual_instance = CallsRepeatWhile.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into CallsSay
        try:
            instance.actual_instance = CallsSay.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into CallsSendSms
        try:
            instance.actual_instance = CallsSendSms.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into CallsSetVariable
        try:
            instance.actual_instance = CallsSetVariable.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into CallsSwitchCase
        try:
            instance.actual_instance = CallsSwitchCase.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into CallsWhileDo
        try:
            instance.actual_instance = CallsWhileDo.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError(
                "Multiple matches found when deserializing the JSON string into CallsScriptInner with oneOf schemas: CallsCallApi, CallsCapture, CallsCollect, CallsDial, CallsDialToConversations, CallsDialToMany, CallsDialToWebRTC, CallsForEach, CallsGoTo, CallsHangup, CallsIfThenElse, CallsMachineDetection, CallsPause, CallsPlay, CallsPlayFromRecording, CallsRecord, CallsRepeatUntil, CallsRepeatWhile, CallsSay, CallsSendSms, CallsSetVariable, CallsSwitchCase, CallsWhileDo. Details: "
                + ", ".join(error_messages)
            )
        elif match == 0:
            # no match
            raise ValueError(
                "No match found when deserializing the JSON string into CallsScriptInner with oneOf schemas: CallsCallApi, CallsCapture, CallsCollect, CallsDial, CallsDialToConversations, CallsDialToMany, CallsDialToWebRTC, CallsForEach, CallsGoTo, CallsHangup, CallsIfThenElse, CallsMachineDetection, CallsPause, CallsPlay, CallsPlayFromRecording, CallsRecord, CallsRepeatUntil, CallsRepeatWhile, CallsSay, CallsSendSms, CallsSetVariable, CallsSwitchCase, CallsWhileDo. Details: "
                + ", ".join(error_messages)
            )
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(
            self.actual_instance.to_json
        ):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(
        self,
    ) -> Optional[
        Union[
            Dict[str, Any],
            CallsCallApi,
            CallsCapture,
            CallsCollect,
            CallsDial,
            CallsDialToConversations,
            CallsDialToMany,
            CallsDialToWebRTC,
            CallsForEach,
            CallsGoTo,
            CallsHangup,
            CallsIfThenElse,
            CallsMachineDetection,
            CallsPause,
            CallsPlay,
            CallsPlayFromRecording,
            CallsRecord,
            CallsRepeatUntil,
            CallsRepeatWhile,
            CallsSay,
            CallsSendSms,
            CallsSetVariable,
            CallsSwitchCase,
            CallsWhileDo,
        ]
    ]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(
            self.actual_instance.to_dict
        ):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())
