# coding: utf-8

"""
    Infobip Client API Libraries OpenAPI Specification

    OpenAPI specification containing public endpoints supported in client API libraries.

    The version of the OpenAPI document: 1.0.0
    Contact: support@infobip.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from infobip_api_client.models.calls_language import CallsLanguage
from typing import Optional, Set
from typing_extensions import Self


class CallsSpeechCaptureRequest(BaseModel):
    """
    CallsSpeechCaptureRequest
    """  # noqa: E501

    language: CallsLanguage
    timeout: Annotated[int, Field(le=30, strict=True, ge=1)] = Field(
        description="The maximum duration of speech capture."
    )
    max_silence: Optional[Annotated[int, Field(le=5, strict=True, ge=1)]] = Field(
        default=None,
        description="The silence duration before terminating the speech capture after speech has been detected.",
        alias="maxSilence",
    )
    key_phrases: List[StrictStr] = Field(
        description="Array of key-phrases used for matching capturing speech.",
        alias="keyPhrases",
    )
    __properties: ClassVar[List[str]] = [
        "language",
        "timeout",
        "maxSilence",
        "keyPhrases",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CallsSpeechCaptureRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CallsSpeechCaptureRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "language": obj.get("language"),
                "timeout": obj.get("timeout"),
                "maxSilence": obj.get("maxSilence"),
                "keyPhrases": obj.get("keyPhrases"),
            }
        )
        return _obj
