# coding: utf-8

"""
    Infobip Client API Libraries OpenAPI Specification

    OpenAPI specification containing public endpoints supported in client API libraries.

    The version of the OpenAPI document: 1.0.0
    Contact: support@infobip.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from infobip_api_client.models.email_dns_record_response import EmailDnsRecordResponse
from infobip_api_client.models.email_tracking_response import EmailTrackingResponse
from typing import Optional, Set
from typing_extensions import Self


class EmailDomainResponse(BaseModel):
    """
    Detailed domain information.
    """  # noqa: E501

    domain_id: Optional[StrictInt] = Field(
        default=None, description="Id of the domain.", alias="domainId"
    )
    domain_name: Optional[StrictStr] = Field(
        default=None, description="Name of the domain.", alias="domainName"
    )
    active: Optional[StrictBool] = Field(
        default=None, description="Activation status of the domain."
    )
    tracking: Optional[EmailTrackingResponse] = None
    dns_records: Optional[List[EmailDnsRecordResponse]] = Field(
        default=None, description="DNS records for the domain.", alias="dnsRecords"
    )
    blocked: Optional[StrictBool] = Field(
        default=None, description="Status if the domain is blocked."
    )
    created_at: Optional[datetime] = Field(
        default=None,
        description="Date the domain was created. Has the following format: `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.",
        alias="createdAt",
    )
    return_path_address: Optional[StrictStr] = Field(
        default=None, description="Mailbox for return path.", alias="returnPathAddress"
    )
    __properties: ClassVar[List[str]] = [
        "domainId",
        "domainName",
        "active",
        "tracking",
        "dnsRecords",
        "blocked",
        "createdAt",
        "returnPathAddress",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EmailDomainResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of tracking
        if self.tracking:
            _dict["tracking"] = self.tracking.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in dns_records (list)
        _items = []
        if self.dns_records:
            for _item in self.dns_records:
                if _item:
                    _items.append(_item.to_dict())
            _dict["dnsRecords"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EmailDomainResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "domainId": obj.get("domainId"),
                "domainName": obj.get("domainName"),
                "active": obj.get("active"),
                "tracking": EmailTrackingResponse.from_dict(obj["tracking"])
                if obj.get("tracking") is not None
                else None,
                "dnsRecords": [
                    EmailDnsRecordResponse.from_dict(_item)
                    for _item in obj["dnsRecords"]
                ]
                if obj.get("dnsRecords") is not None
                else None,
                "blocked": obj.get("blocked"),
                "createdAt": obj.get("createdAt"),
                "returnPathAddress": obj.get("returnPathAddress"),
            }
        )
        return _obj
