# coding: utf-8

"""
    Infobip Client API Libraries OpenAPI Specification

    OpenAPI specification containing public endpoints supported in client API libraries.

    The version of the OpenAPI document: 1.0.0
    Contact: support@infobip.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool
from typing import Any, ClassVar, Dict, List, Optional
from infobip_api_client.models.sms_language_code import SmsLanguageCode
from typing import Optional, Set
from typing_extensions import Self


class SmsLanguage(BaseModel):
    """
    Sets the language parameters for the message being sent.
    """  # noqa: E501

    language_code: Optional[SmsLanguageCode] = Field(default=None, alias="languageCode")
    single_shift: Optional[StrictBool] = Field(
        default=False,
        description="Uses a single shift table which enhances only the extension table of the GSM default alphabet. Allows you to selectively improve character support without altering the entire message.",
        alias="singleShift",
    )
    locking_shift: Optional[StrictBool] = Field(
        default=False,
        description="Uses a locking shift table which allows you to represent characters beyond the standard GSM default alphabet. This flexibility enables better language support.",
        alias="lockingShift",
    )
    __properties: ClassVar[List[str]] = ["languageCode", "singleShift", "lockingShift"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SmsLanguage from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SmsLanguage from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "languageCode": obj.get("languageCode"),
                "singleShift": obj.get("singleShift")
                if obj.get("singleShift") is not None
                else False,
                "lockingShift": obj.get("lockingShift")
                if obj.get("lockingShift") is not None
                else False,
            }
        )
        return _obj
