# coding: utf-8

"""
    Infobip Client API Libraries OpenAPI Specification

    OpenAPI specification containing public endpoints supported in client API libraries.

    The version of the OpenAPI document: 1.0.0
    Contact: support@infobip.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from infobip_api_client.models.message_price import MessagePrice
from typing import Optional, Set
from typing_extensions import Self


class SmsWebhookInboundReport(BaseModel):
    """
    SmsWebhookInboundReport
    """  # noqa: E501

    message_id: Optional[StrictStr] = Field(
        default=None, description="Unique SMS ID.", alias="messageId"
    )
    var_from: Optional[StrictStr] = Field(
        default=None,
        description="Sender ID that can be alphanumeric or numeric.",
        alias="from",
    )
    to: Optional[StrictStr] = Field(default=None, description="The recipient number.")
    text: Optional[StrictStr] = Field(
        default=None, description="Received message content."
    )
    clean_text: Optional[StrictStr] = Field(
        default=None,
        description="Text of received message without a keyword (if a keyword was sent).",
        alias="cleanText",
    )
    keyword: Optional[StrictStr] = Field(
        default=None, description="Keyword extracted from the message text."
    )
    received_at: Optional[datetime] = Field(
        default=None,
        description="Date and time when Infobip received the message.",
        alias="receivedAt",
    )
    sms_count: Optional[StrictInt] = Field(
        default=None,
        description="Long SMS messages have a character limit on how much can be sent over one message.  Longer messages will be split up into multiple messages and sent separately.  This is the total count of messages one SMS was sent over.",
        alias="smsCount",
    )
    price: Optional[MessagePrice] = None
    callback_data: Optional[StrictStr] = Field(
        default=None,
        description="The callback data sent through the callbackData field in your fully featured SMS message.",
        alias="callbackData",
    )
    __properties: ClassVar[List[str]] = [
        "messageId",
        "from",
        "to",
        "text",
        "cleanText",
        "keyword",
        "receivedAt",
        "smsCount",
        "price",
        "callbackData",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SmsWebhookInboundReport from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of price
        if self.price:
            _dict["price"] = self.price.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SmsWebhookInboundReport from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "messageId": obj.get("messageId"),
                "from": obj.get("from"),
                "to": obj.get("to"),
                "text": obj.get("text"),
                "cleanText": obj.get("cleanText"),
                "keyword": obj.get("keyword"),
                "receivedAt": obj.get("receivedAt"),
                "smsCount": obj.get("smsCount"),
                "price": MessagePrice.from_dict(obj["price"])
                if obj.get("price") is not None
                else None,
                "callbackData": obj.get("callbackData"),
            }
        )
        return _obj
