# coding: utf-8

"""
    Infobip Client API Libraries OpenAPI Specification

    OpenAPI specification containing public endpoints supported in client API libraries.

    The version of the OpenAPI document: 1.0.0
    Contact: support@infobip.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self


class UrlOptions(BaseModel):
    """
    Sets up [URL shortening](https://www.infobip.com/docs/url-shortening) and tracking feature.
    """  # noqa: E501

    shorten_url: Optional[StrictBool] = Field(
        default=True,
        description="Enable shortening of the URLs within a message. Set this to `true`, if you want to set up other URL options.",
        alias="shortenUrl",
    )
    track_clicks: Optional[StrictBool] = Field(
        default=True,
        description="Enable tracking of short URL clicks within a message: which URL was clicked, how many times, and by whom.",
        alias="trackClicks",
    )
    tracking_url: Optional[StrictStr] = Field(
        default=None,
        description="The URL of your callback server on to which the Click report will be sent.",
        alias="trackingUrl",
    )
    remove_protocol: Optional[StrictBool] = Field(
        default=False,
        description="Remove a protocol, such as `https://`, from links to shorten a message. Note that some mobiles may not recognize such links as a URL.",
        alias="removeProtocol",
    )
    custom_domain: Optional[StrictStr] = Field(
        default=None,
        description="Select a predefined custom domain to use when generating a short URL.",
        alias="customDomain",
    )
    __properties: ClassVar[List[str]] = [
        "shortenUrl",
        "trackClicks",
        "trackingUrl",
        "removeProtocol",
        "customDomain",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UrlOptions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UrlOptions from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "shortenUrl": obj.get("shortenUrl")
                if obj.get("shortenUrl") is not None
                else True,
                "trackClicks": obj.get("trackClicks")
                if obj.get("trackClicks") is not None
                else True,
                "trackingUrl": obj.get("trackingUrl"),
                "removeProtocol": obj.get("removeProtocol")
                if obj.get("removeProtocol") is not None
                else False,
                "customDomain": obj.get("customDomain"),
            }
        )
        return _obj
