# coding: utf-8

"""
    Infobip Client API Libraries OpenAPI Specification

    OpenAPI specification containing public endpoints supported in client API libraries.

    The version of the OpenAPI document: 1.0.0
    Contact: support@infobip.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501
from pydantic import validate_call, StrictFloat
from typing import Any, Dict, Tuple

from datetime import datetime
from pydantic import Field, StrictBool, StrictBytes, StrictInt, StrictStr
from typing import List, Optional, Union
from typing_extensions import Annotated
from infobip_api_client.models.email_add_domain_request import EmailAddDomainRequest
from infobip_api_client.models.email_add_suppression_request import (
    EmailAddSuppressionRequest,
)
from infobip_api_client.models.email_all_domains_response import EmailAllDomainsResponse
from infobip_api_client.models.email_bulk_reschedule_request import (
    EmailBulkRescheduleRequest,
)
from infobip_api_client.models.email_bulk_reschedule_response import (
    EmailBulkRescheduleResponse,
)
from infobip_api_client.models.email_bulk_schedule_response import (
    EmailBulkScheduleResponse,
)
from infobip_api_client.models.email_bulk_status_response import EmailBulkStatusResponse
from infobip_api_client.models.email_bulk_update_status_request import (
    EmailBulkUpdateStatusRequest,
)
from infobip_api_client.models.email_bulk_update_status_response import (
    EmailBulkUpdateStatusResponse,
)
from infobip_api_client.models.email_delete_suppression_request import (
    EmailDeleteSuppressionRequest,
)
from infobip_api_client.models.email_domain_info_page_response import (
    EmailDomainInfoPageResponse,
)
from infobip_api_client.models.email_domain_ip_pool_assign_api_request import (
    EmailDomainIpPoolAssignApiRequest,
)
from infobip_api_client.models.email_domain_ip_pool_update_api_request import (
    EmailDomainIpPoolUpdateApiRequest,
)
from infobip_api_client.models.email_domain_response import EmailDomainResponse
from infobip_api_client.models.email_ip_detail_response import EmailIpDetailResponse
from infobip_api_client.models.email_ip_domain_response import EmailIpDomainResponse
from infobip_api_client.models.email_ip_pool_assign_ip_api_request import (
    EmailIpPoolAssignIpApiRequest,
)
from infobip_api_client.models.email_ip_pool_create_api_request import (
    EmailIpPoolCreateApiRequest,
)
from infobip_api_client.models.email_ip_pool_detail_response import (
    EmailIpPoolDetailResponse,
)
from infobip_api_client.models.email_ip_pool_response import EmailIpPoolResponse
from infobip_api_client.models.email_ip_response import EmailIpResponse
from infobip_api_client.models.email_logs_response import EmailLogsResponse
from infobip_api_client.models.email_reports_result import EmailReportsResult
from infobip_api_client.models.email_return_path_address_request import (
    EmailReturnPathAddressRequest,
)
from infobip_api_client.models.email_send_response import EmailSendResponse
from infobip_api_client.models.email_suppression_info_page_response import (
    EmailSuppressionInfoPageResponse,
)
from infobip_api_client.models.email_suppression_type import EmailSuppressionType
from infobip_api_client.models.email_tracking_event_request import (
    EmailTrackingEventRequest,
)
from infobip_api_client.models.email_validation_request import EmailValidationRequest
from infobip_api_client.models.email_validation_response import EmailValidationResponse

from infobip_api_client.api_client import ApiClient, RequestSerialized
from infobip_api_client.api_response import ApiResponse
from infobip_api_client.rest import RESTResponseType


class EmailApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_call
    def add_domain(
        self,
        email_add_domain_request: EmailAddDomainRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> EmailDomainResponse:
        """Add new domain

        This method allows you to add new domains with a limit to create a maximum of 1000 domains in a day.

        :param email_add_domain_request: (required)
        :type email_add_domain_request: EmailAddDomainRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._add_domain_serialize(
            email_add_domain_request=email_add_domain_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "EmailDomainResponse",
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "409": "ApiException",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def add_domain_with_http_info(
        self,
        email_add_domain_request: EmailAddDomainRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[EmailDomainResponse]:
        """Add new domain

        This method allows you to add new domains with a limit to create a maximum of 1000 domains in a day.

        :param email_add_domain_request: (required)
        :type email_add_domain_request: EmailAddDomainRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._add_domain_serialize(
            email_add_domain_request=email_add_domain_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "EmailDomainResponse",
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "409": "ApiException",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def add_domain_without_preload_content(
        self,
        email_add_domain_request: EmailAddDomainRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Add new domain

        This method allows you to add new domains with a limit to create a maximum of 1000 domains in a day.

        :param email_add_domain_request: (required)
        :type email_add_domain_request: EmailAddDomainRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._add_domain_serialize(
            email_add_domain_request=email_add_domain_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "EmailDomainResponse",
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "409": "ApiException",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _add_domain_serialize(
        self,
        email_add_domain_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if email_add_domain_request is not None:
            _body_params = email_add_domain_request

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(
                ["application/json"]
            )
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/email/1/domains",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def add_suppressions(
        self,
        email_add_suppression_request: EmailAddSuppressionRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Add suppressions

        This method allows you to add email addresses to the suppression list. It accepts suppression requests, saves them asynchronously, and automatically ignores any duplicate entries.

        :param email_add_suppression_request: (required)
        :type email_add_suppression_request: EmailAddSuppressionRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._add_suppressions_serialize(
            email_add_suppression_request=email_add_suppression_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "400": "ApiError",
            "401": "ApiError",
            "403": "ApiError",
            "429": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def add_suppressions_with_http_info(
        self,
        email_add_suppression_request: EmailAddSuppressionRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Add suppressions

        This method allows you to add email addresses to the suppression list. It accepts suppression requests, saves them asynchronously, and automatically ignores any duplicate entries.

        :param email_add_suppression_request: (required)
        :type email_add_suppression_request: EmailAddSuppressionRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._add_suppressions_serialize(
            email_add_suppression_request=email_add_suppression_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "400": "ApiError",
            "401": "ApiError",
            "403": "ApiError",
            "429": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def add_suppressions_without_preload_content(
        self,
        email_add_suppression_request: EmailAddSuppressionRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Add suppressions

        This method allows you to add email addresses to the suppression list. It accepts suppression requests, saves them asynchronously, and automatically ignores any duplicate entries.

        :param email_add_suppression_request: (required)
        :type email_add_suppression_request: EmailAddSuppressionRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._add_suppressions_serialize(
            email_add_suppression_request=email_add_suppression_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "400": "ApiError",
            "401": "ApiError",
            "403": "ApiError",
            "429": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _add_suppressions_serialize(
        self,
        email_add_suppression_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if email_add_suppression_request is not None:
            _body_params = email_add_suppression_request

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(
                ["application/json"]
            )
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/email/1/suppressions",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def assign_ip_to_pool(
        self,
        pool_id: Annotated[StrictStr, Field(description="IP pool identifier.")],
        email_ip_pool_assign_ip_api_request: EmailIpPoolAssignIpApiRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Assign IP to pool

        Assign provided dedicated IP to the provided IP pool.

        :param pool_id: IP pool identifier. (required)
        :type pool_id: str
        :param email_ip_pool_assign_ip_api_request: (required)
        :type email_ip_pool_assign_ip_api_request: EmailIpPoolAssignIpApiRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._assign_ip_to_pool_serialize(
            pool_id=pool_id,
            email_ip_pool_assign_ip_api_request=email_ip_pool_assign_ip_api_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "400": "ApiError",
            "401": "ApiError",
            "403": "ApiError",
            "404": "ApiError",
            "429": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def assign_ip_to_pool_with_http_info(
        self,
        pool_id: Annotated[StrictStr, Field(description="IP pool identifier.")],
        email_ip_pool_assign_ip_api_request: EmailIpPoolAssignIpApiRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Assign IP to pool

        Assign provided dedicated IP to the provided IP pool.

        :param pool_id: IP pool identifier. (required)
        :type pool_id: str
        :param email_ip_pool_assign_ip_api_request: (required)
        :type email_ip_pool_assign_ip_api_request: EmailIpPoolAssignIpApiRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._assign_ip_to_pool_serialize(
            pool_id=pool_id,
            email_ip_pool_assign_ip_api_request=email_ip_pool_assign_ip_api_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "400": "ApiError",
            "401": "ApiError",
            "403": "ApiError",
            "404": "ApiError",
            "429": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def assign_ip_to_pool_without_preload_content(
        self,
        pool_id: Annotated[StrictStr, Field(description="IP pool identifier.")],
        email_ip_pool_assign_ip_api_request: EmailIpPoolAssignIpApiRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Assign IP to pool

        Assign provided dedicated IP to the provided IP pool.

        :param pool_id: IP pool identifier. (required)
        :type pool_id: str
        :param email_ip_pool_assign_ip_api_request: (required)
        :type email_ip_pool_assign_ip_api_request: EmailIpPoolAssignIpApiRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._assign_ip_to_pool_serialize(
            pool_id=pool_id,
            email_ip_pool_assign_ip_api_request=email_ip_pool_assign_ip_api_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "400": "ApiError",
            "401": "ApiError",
            "403": "ApiError",
            "404": "ApiError",
            "429": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _assign_ip_to_pool_serialize(
        self,
        pool_id,
        email_ip_pool_assign_ip_api_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if pool_id is not None:
            _path_params["poolId"] = pool_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if email_ip_pool_assign_ip_api_request is not None:
            _body_params = email_ip_pool_assign_ip_api_request

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(
                ["application/json"]
            )
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/email/1/ip-management/pools/{poolId}/ips",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def assign_pool_to_domain(
        self,
        domain_id: Annotated[
            int, Field(strict=True, ge=1, description="Domain identifier.")
        ],
        email_domain_ip_pool_assign_api_request: EmailDomainIpPoolAssignApiRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Assign IP pool to domain

        Assign an IP pool to the provided domain.

        :param domain_id: Domain identifier. (required)
        :type domain_id: int
        :param email_domain_ip_pool_assign_api_request: (required)
        :type email_domain_ip_pool_assign_api_request: EmailDomainIpPoolAssignApiRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._assign_pool_to_domain_serialize(
            domain_id=domain_id,
            email_domain_ip_pool_assign_api_request=email_domain_ip_pool_assign_api_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "400": "ApiError",
            "401": "ApiError",
            "403": "ApiError",
            "404": "ApiError",
            "429": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def assign_pool_to_domain_with_http_info(
        self,
        domain_id: Annotated[
            int, Field(strict=True, ge=1, description="Domain identifier.")
        ],
        email_domain_ip_pool_assign_api_request: EmailDomainIpPoolAssignApiRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Assign IP pool to domain

        Assign an IP pool to the provided domain.

        :param domain_id: Domain identifier. (required)
        :type domain_id: int
        :param email_domain_ip_pool_assign_api_request: (required)
        :type email_domain_ip_pool_assign_api_request: EmailDomainIpPoolAssignApiRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._assign_pool_to_domain_serialize(
            domain_id=domain_id,
            email_domain_ip_pool_assign_api_request=email_domain_ip_pool_assign_api_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "400": "ApiError",
            "401": "ApiError",
            "403": "ApiError",
            "404": "ApiError",
            "429": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def assign_pool_to_domain_without_preload_content(
        self,
        domain_id: Annotated[
            int, Field(strict=True, ge=1, description="Domain identifier.")
        ],
        email_domain_ip_pool_assign_api_request: EmailDomainIpPoolAssignApiRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Assign IP pool to domain

        Assign an IP pool to the provided domain.

        :param domain_id: Domain identifier. (required)
        :type domain_id: int
        :param email_domain_ip_pool_assign_api_request: (required)
        :type email_domain_ip_pool_assign_api_request: EmailDomainIpPoolAssignApiRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._assign_pool_to_domain_serialize(
            domain_id=domain_id,
            email_domain_ip_pool_assign_api_request=email_domain_ip_pool_assign_api_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "400": "ApiError",
            "401": "ApiError",
            "403": "ApiError",
            "404": "ApiError",
            "429": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _assign_pool_to_domain_serialize(
        self,
        domain_id,
        email_domain_ip_pool_assign_api_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if domain_id is not None:
            _path_params["domainId"] = domain_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if email_domain_ip_pool_assign_api_request is not None:
            _body_params = email_domain_ip_pool_assign_api_request

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(
                ["application/json"]
            )
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/email/1/ip-management/domains/{domainId}/pools",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def create_ip_pool(
        self,
        email_ip_pool_create_api_request: EmailIpPoolCreateApiRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> EmailIpPoolResponse:
        """Create IP pool

        Create a new IP pool.

        :param email_ip_pool_create_api_request: (required)
        :type email_ip_pool_create_api_request: EmailIpPoolCreateApiRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._create_ip_pool_serialize(
            email_ip_pool_create_api_request=email_ip_pool_create_api_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "201": "EmailIpPoolResponse",
            "400": "ApiError",
            "401": "ApiError",
            "403": "ApiError",
            "429": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def create_ip_pool_with_http_info(
        self,
        email_ip_pool_create_api_request: EmailIpPoolCreateApiRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[EmailIpPoolResponse]:
        """Create IP pool

        Create a new IP pool.

        :param email_ip_pool_create_api_request: (required)
        :type email_ip_pool_create_api_request: EmailIpPoolCreateApiRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._create_ip_pool_serialize(
            email_ip_pool_create_api_request=email_ip_pool_create_api_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "201": "EmailIpPoolResponse",
            "400": "ApiError",
            "401": "ApiError",
            "403": "ApiError",
            "429": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def create_ip_pool_without_preload_content(
        self,
        email_ip_pool_create_api_request: EmailIpPoolCreateApiRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create IP pool

        Create a new IP pool.

        :param email_ip_pool_create_api_request: (required)
        :type email_ip_pool_create_api_request: EmailIpPoolCreateApiRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._create_ip_pool_serialize(
            email_ip_pool_create_api_request=email_ip_pool_create_api_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "201": "EmailIpPoolResponse",
            "400": "ApiError",
            "401": "ApiError",
            "403": "ApiError",
            "429": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _create_ip_pool_serialize(
        self,
        email_ip_pool_create_api_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if email_ip_pool_create_api_request is not None:
            _body_params = email_ip_pool_create_api_request

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(
                ["application/json"]
            )
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/email/1/ip-management/pools",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def delete_domain(
        self,
        domain_name: Annotated[
            StrictStr, Field(description="Domain name which needs to be deleted.")
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Delete existing domain

        This method allows you to delete an existing domain.

        :param domain_name: Domain name which needs to be deleted. (required)
        :type domain_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._delete_domain_serialize(
            domain_name=domain_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "404": "ApiException",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def delete_domain_with_http_info(
        self,
        domain_name: Annotated[
            StrictStr, Field(description="Domain name which needs to be deleted.")
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Delete existing domain

        This method allows you to delete an existing domain.

        :param domain_name: Domain name which needs to be deleted. (required)
        :type domain_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._delete_domain_serialize(
            domain_name=domain_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "404": "ApiException",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def delete_domain_without_preload_content(
        self,
        domain_name: Annotated[
            StrictStr, Field(description="Domain name which needs to be deleted.")
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete existing domain

        This method allows you to delete an existing domain.

        :param domain_name: Domain name which needs to be deleted. (required)
        :type domain_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._delete_domain_serialize(
            domain_name=domain_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "404": "ApiException",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _delete_domain_serialize(
        self,
        domain_name,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if domain_name is not None:
            _path_params["domainName"] = domain_name
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="DELETE",
            resource_path="/email/1/domains/{domainName}",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def delete_ip_pool(
        self,
        pool_id: Annotated[StrictStr, Field(description="IP pool identifier.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Delete IP pool

        Delete provided IP pool. Deleting an IP pool also deletes any assigned IPs and any assignments to domains.

        :param pool_id: IP pool identifier. (required)
        :type pool_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._delete_ip_pool_serialize(
            pool_id=pool_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "401": "ApiError",
            "403": "ApiError",
            "404": "ApiError",
            "429": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def delete_ip_pool_with_http_info(
        self,
        pool_id: Annotated[StrictStr, Field(description="IP pool identifier.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Delete IP pool

        Delete provided IP pool. Deleting an IP pool also deletes any assigned IPs and any assignments to domains.

        :param pool_id: IP pool identifier. (required)
        :type pool_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._delete_ip_pool_serialize(
            pool_id=pool_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "401": "ApiError",
            "403": "ApiError",
            "404": "ApiError",
            "429": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def delete_ip_pool_without_preload_content(
        self,
        pool_id: Annotated[StrictStr, Field(description="IP pool identifier.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete IP pool

        Delete provided IP pool. Deleting an IP pool also deletes any assigned IPs and any assignments to domains.

        :param pool_id: IP pool identifier. (required)
        :type pool_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._delete_ip_pool_serialize(
            pool_id=pool_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "401": "ApiError",
            "403": "ApiError",
            "404": "ApiError",
            "429": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _delete_ip_pool_serialize(
        self,
        pool_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if pool_id is not None:
            _path_params["poolId"] = pool_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="DELETE",
            resource_path="/email/1/ip-management/pools/{poolId}",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def delete_suppressions(
        self,
        email_delete_suppression_request: EmailDeleteSuppressionRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Delete suppressions

        This method allows you to delete email addresses from the suppression list. It accepts delete suppression requests and asynchronously deletes them.

        :param email_delete_suppression_request: (required)
        :type email_delete_suppression_request: EmailDeleteSuppressionRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._delete_suppressions_serialize(
            email_delete_suppression_request=email_delete_suppression_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "400": "ApiError",
            "401": "ApiError",
            "403": "ApiError",
            "429": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def delete_suppressions_with_http_info(
        self,
        email_delete_suppression_request: EmailDeleteSuppressionRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Delete suppressions

        This method allows you to delete email addresses from the suppression list. It accepts delete suppression requests and asynchronously deletes them.

        :param email_delete_suppression_request: (required)
        :type email_delete_suppression_request: EmailDeleteSuppressionRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._delete_suppressions_serialize(
            email_delete_suppression_request=email_delete_suppression_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "400": "ApiError",
            "401": "ApiError",
            "403": "ApiError",
            "429": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def delete_suppressions_without_preload_content(
        self,
        email_delete_suppression_request: EmailDeleteSuppressionRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete suppressions

        This method allows you to delete email addresses from the suppression list. It accepts delete suppression requests and asynchronously deletes them.

        :param email_delete_suppression_request: (required)
        :type email_delete_suppression_request: EmailDeleteSuppressionRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._delete_suppressions_serialize(
            email_delete_suppression_request=email_delete_suppression_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "400": "ApiError",
            "401": "ApiError",
            "403": "ApiError",
            "429": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _delete_suppressions_serialize(
        self,
        email_delete_suppression_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if email_delete_suppression_request is not None:
            _body_params = email_delete_suppression_request

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(
                ["application/json"]
            )
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="DELETE",
            resource_path="/email/1/suppressions",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def get_all_domains(
        self,
        size: Annotated[
            Optional[Annotated[int, Field(le=20, strict=True, ge=1)]],
            Field(
                description="Maximum number of domains to be viewed per page. Default value is 10 with a maximum of 20 records per page."
            ),
        ] = None,
        page: Annotated[
            Optional[Annotated[int, Field(strict=True, ge=0)]],
            Field(description="Page number you want to see. Default is 0."),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> EmailAllDomainsResponse:
        """Get all domains for the account

        This API is to get all domain associated with the account. It also provides details of the retrieved domain like the DNS records, Tracking details, Active/Blocked status,etc.

        :param size: Maximum number of domains to be viewed per page. Default value is 10 with a maximum of 20 records per page.
        :type size: int
        :param page: Page number you want to see. Default is 0.
        :type page: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_all_domains_serialize(
            size=size,
            page=page,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "EmailAllDomainsResponse",
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def get_all_domains_with_http_info(
        self,
        size: Annotated[
            Optional[Annotated[int, Field(le=20, strict=True, ge=1)]],
            Field(
                description="Maximum number of domains to be viewed per page. Default value is 10 with a maximum of 20 records per page."
            ),
        ] = None,
        page: Annotated[
            Optional[Annotated[int, Field(strict=True, ge=0)]],
            Field(description="Page number you want to see. Default is 0."),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[EmailAllDomainsResponse]:
        """Get all domains for the account

        This API is to get all domain associated with the account. It also provides details of the retrieved domain like the DNS records, Tracking details, Active/Blocked status,etc.

        :param size: Maximum number of domains to be viewed per page. Default value is 10 with a maximum of 20 records per page.
        :type size: int
        :param page: Page number you want to see. Default is 0.
        :type page: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_all_domains_serialize(
            size=size,
            page=page,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "EmailAllDomainsResponse",
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def get_all_domains_without_preload_content(
        self,
        size: Annotated[
            Optional[Annotated[int, Field(le=20, strict=True, ge=1)]],
            Field(
                description="Maximum number of domains to be viewed per page. Default value is 10 with a maximum of 20 records per page."
            ),
        ] = None,
        page: Annotated[
            Optional[Annotated[int, Field(strict=True, ge=0)]],
            Field(description="Page number you want to see. Default is 0."),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get all domains for the account

        This API is to get all domain associated with the account. It also provides details of the retrieved domain like the DNS records, Tracking details, Active/Blocked status,etc.

        :param size: Maximum number of domains to be viewed per page. Default value is 10 with a maximum of 20 records per page.
        :type size: int
        :param page: Page number you want to see. Default is 0.
        :type page: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_all_domains_serialize(
            size=size,
            page=page,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "EmailAllDomainsResponse",
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _get_all_domains_serialize(
        self,
        size,
        page,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if size is not None:

            _query_params.append(("size", size))

        if page is not None:

            _query_params.append(("page", page))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/email/1/domains",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def get_all_ips(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[EmailIpResponse]:
        """Get IPs

        Returns all the dedicated IP addresses owned by this account.

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_all_ips_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "List[EmailIpResponse]",
            "401": "ApiError",
            "403": "ApiError",
            "429": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def get_all_ips_with_http_info(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[EmailIpResponse]]:
        """Get IPs

        Returns all the dedicated IP addresses owned by this account.

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_all_ips_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "List[EmailIpResponse]",
            "401": "ApiError",
            "403": "ApiError",
            "429": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def get_all_ips_without_preload_content(
        self,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get IPs

        Returns all the dedicated IP addresses owned by this account.

        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_all_ips_serialize(
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "List[EmailIpResponse]",
            "401": "ApiError",
            "403": "ApiError",
            "429": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _get_all_ips_serialize(
        self,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/email/1/ip-management/ips",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def get_domain_details(
        self,
        domain_name: Annotated[
            StrictStr,
            Field(description="Domain for which the details need to be viewed."),
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> EmailDomainResponse:
        """Get domain details

        This API provides with the details of the domain like the DNS records, Tracking details, Active/Blocked status,etc.

        :param domain_name: Domain for which the details need to be viewed. (required)
        :type domain_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_domain_details_serialize(
            domain_name=domain_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "EmailDomainResponse",
            "401": "ApiException",
            "403": "ApiException",
            "404": "ApiException",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def get_domain_details_with_http_info(
        self,
        domain_name: Annotated[
            StrictStr,
            Field(description="Domain for which the details need to be viewed."),
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[EmailDomainResponse]:
        """Get domain details

        This API provides with the details of the domain like the DNS records, Tracking details, Active/Blocked status,etc.

        :param domain_name: Domain for which the details need to be viewed. (required)
        :type domain_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_domain_details_serialize(
            domain_name=domain_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "EmailDomainResponse",
            "401": "ApiException",
            "403": "ApiException",
            "404": "ApiException",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def get_domain_details_without_preload_content(
        self,
        domain_name: Annotated[
            StrictStr,
            Field(description="Domain for which the details need to be viewed."),
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get domain details

        This API provides with the details of the domain like the DNS records, Tracking details, Active/Blocked status,etc.

        :param domain_name: Domain for which the details need to be viewed. (required)
        :type domain_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_domain_details_serialize(
            domain_name=domain_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "EmailDomainResponse",
            "401": "ApiException",
            "403": "ApiException",
            "404": "ApiException",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _get_domain_details_serialize(
        self,
        domain_name,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if domain_name is not None:
            _path_params["domainName"] = domain_name
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/email/1/domains/{domainName}",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def get_domains(
        self,
        page: Annotated[
            Optional[Annotated[int, Field(strict=True, ge=0)]],
            Field(description="Requested page number."),
        ] = None,
        size: Annotated[
            Optional[Annotated[int, Field(strict=True, ge=1)]],
            Field(description="Requested page size."),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> EmailDomainInfoPageResponse:
        """Get suppression domains

        This method allows you to get domains that can be managed for suppressions and are either owned or have granted permissions.

        :param page: Requested page number.
        :type page: int
        :param size: Requested page size.
        :type size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_domains_serialize(
            page=page,
            size=size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "EmailDomainInfoPageResponse",
            "401": "ApiError",
            "403": "ApiError",
            "429": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def get_domains_with_http_info(
        self,
        page: Annotated[
            Optional[Annotated[int, Field(strict=True, ge=0)]],
            Field(description="Requested page number."),
        ] = None,
        size: Annotated[
            Optional[Annotated[int, Field(strict=True, ge=1)]],
            Field(description="Requested page size."),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[EmailDomainInfoPageResponse]:
        """Get suppression domains

        This method allows you to get domains that can be managed for suppressions and are either owned or have granted permissions.

        :param page: Requested page number.
        :type page: int
        :param size: Requested page size.
        :type size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_domains_serialize(
            page=page,
            size=size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "EmailDomainInfoPageResponse",
            "401": "ApiError",
            "403": "ApiError",
            "429": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def get_domains_without_preload_content(
        self,
        page: Annotated[
            Optional[Annotated[int, Field(strict=True, ge=0)]],
            Field(description="Requested page number."),
        ] = None,
        size: Annotated[
            Optional[Annotated[int, Field(strict=True, ge=1)]],
            Field(description="Requested page size."),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get suppression domains

        This method allows you to get domains that can be managed for suppressions and are either owned or have granted permissions.

        :param page: Requested page number.
        :type page: int
        :param size: Requested page size.
        :type size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_domains_serialize(
            page=page,
            size=size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "EmailDomainInfoPageResponse",
            "401": "ApiError",
            "403": "ApiError",
            "429": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _get_domains_serialize(
        self,
        page,
        size,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if page is not None:

            _query_params.append(("page", page))

        if size is not None:

            _query_params.append(("size", size))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/email/1/suppressions/domains",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def get_email_delivery_reports(
        self,
        bulk_id: Annotated[
            Optional[StrictStr],
            Field(description="Bulk ID for which report is requested."),
        ] = None,
        message_id: Annotated[
            Optional[StrictStr],
            Field(description="The ID that uniquely identifies the sent email."),
        ] = None,
        campaign_reference_id: Annotated[
            Optional[StrictStr],
            Field(
                description="The ID that allows you to track, analyze, and show an aggregated overview and the performance of individual campaigns."
            ),
        ] = None,
        limit: Annotated[
            Optional[Annotated[int, Field(le=1000, strict=True)]],
            Field(description="Maximum number of reports."),
        ] = None,
        application_id: Annotated[
            Optional[StrictStr],
            Field(
                description="[Application](https://www.infobip.com/docs/cpaas-x/application-and-entity-management#application) identifier used for filtering."
            ),
        ] = None,
        entity_id: Annotated[
            Optional[StrictStr],
            Field(
                description="[Entity](https://www.infobip.com/docs/cpaas-x/application-and-entity-management#entity) identifier used for filtering."
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> EmailReportsResult:
        """Email delivery reports

        Get one-time delivery reports for all sent emails.

        :param bulk_id: Bulk ID for which report is requested.
        :type bulk_id: str
        :param message_id: The ID that uniquely identifies the sent email.
        :type message_id: str
        :param campaign_reference_id: The ID that allows you to track, analyze, and show an aggregated overview and the performance of individual campaigns.
        :type campaign_reference_id: str
        :param limit: Maximum number of reports.
        :type limit: int
        :param application_id: [Application](https://www.infobip.com/docs/cpaas-x/application-and-entity-management#application) identifier used for filtering.
        :type application_id: str
        :param entity_id: [Entity](https://www.infobip.com/docs/cpaas-x/application-and-entity-management#entity) identifier used for filtering.
        :type entity_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_email_delivery_reports_serialize(
            bulk_id=bulk_id,
            message_id=message_id,
            campaign_reference_id=campaign_reference_id,
            limit=limit,
            application_id=application_id,
            entity_id=entity_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "EmailReportsResult",
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def get_email_delivery_reports_with_http_info(
        self,
        bulk_id: Annotated[
            Optional[StrictStr],
            Field(description="Bulk ID for which report is requested."),
        ] = None,
        message_id: Annotated[
            Optional[StrictStr],
            Field(description="The ID that uniquely identifies the sent email."),
        ] = None,
        campaign_reference_id: Annotated[
            Optional[StrictStr],
            Field(
                description="The ID that allows you to track, analyze, and show an aggregated overview and the performance of individual campaigns."
            ),
        ] = None,
        limit: Annotated[
            Optional[Annotated[int, Field(le=1000, strict=True)]],
            Field(description="Maximum number of reports."),
        ] = None,
        application_id: Annotated[
            Optional[StrictStr],
            Field(
                description="[Application](https://www.infobip.com/docs/cpaas-x/application-and-entity-management#application) identifier used for filtering."
            ),
        ] = None,
        entity_id: Annotated[
            Optional[StrictStr],
            Field(
                description="[Entity](https://www.infobip.com/docs/cpaas-x/application-and-entity-management#entity) identifier used for filtering."
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[EmailReportsResult]:
        """Email delivery reports

        Get one-time delivery reports for all sent emails.

        :param bulk_id: Bulk ID for which report is requested.
        :type bulk_id: str
        :param message_id: The ID that uniquely identifies the sent email.
        :type message_id: str
        :param campaign_reference_id: The ID that allows you to track, analyze, and show an aggregated overview and the performance of individual campaigns.
        :type campaign_reference_id: str
        :param limit: Maximum number of reports.
        :type limit: int
        :param application_id: [Application](https://www.infobip.com/docs/cpaas-x/application-and-entity-management#application) identifier used for filtering.
        :type application_id: str
        :param entity_id: [Entity](https://www.infobip.com/docs/cpaas-x/application-and-entity-management#entity) identifier used for filtering.
        :type entity_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_email_delivery_reports_serialize(
            bulk_id=bulk_id,
            message_id=message_id,
            campaign_reference_id=campaign_reference_id,
            limit=limit,
            application_id=application_id,
            entity_id=entity_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "EmailReportsResult",
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def get_email_delivery_reports_without_preload_content(
        self,
        bulk_id: Annotated[
            Optional[StrictStr],
            Field(description="Bulk ID for which report is requested."),
        ] = None,
        message_id: Annotated[
            Optional[StrictStr],
            Field(description="The ID that uniquely identifies the sent email."),
        ] = None,
        campaign_reference_id: Annotated[
            Optional[StrictStr],
            Field(
                description="The ID that allows you to track, analyze, and show an aggregated overview and the performance of individual campaigns."
            ),
        ] = None,
        limit: Annotated[
            Optional[Annotated[int, Field(le=1000, strict=True)]],
            Field(description="Maximum number of reports."),
        ] = None,
        application_id: Annotated[
            Optional[StrictStr],
            Field(
                description="[Application](https://www.infobip.com/docs/cpaas-x/application-and-entity-management#application) identifier used for filtering."
            ),
        ] = None,
        entity_id: Annotated[
            Optional[StrictStr],
            Field(
                description="[Entity](https://www.infobip.com/docs/cpaas-x/application-and-entity-management#entity) identifier used for filtering."
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Email delivery reports

        Get one-time delivery reports for all sent emails.

        :param bulk_id: Bulk ID for which report is requested.
        :type bulk_id: str
        :param message_id: The ID that uniquely identifies the sent email.
        :type message_id: str
        :param campaign_reference_id: The ID that allows you to track, analyze, and show an aggregated overview and the performance of individual campaigns.
        :type campaign_reference_id: str
        :param limit: Maximum number of reports.
        :type limit: int
        :param application_id: [Application](https://www.infobip.com/docs/cpaas-x/application-and-entity-management#application) identifier used for filtering.
        :type application_id: str
        :param entity_id: [Entity](https://www.infobip.com/docs/cpaas-x/application-and-entity-management#entity) identifier used for filtering.
        :type entity_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_email_delivery_reports_serialize(
            bulk_id=bulk_id,
            message_id=message_id,
            campaign_reference_id=campaign_reference_id,
            limit=limit,
            application_id=application_id,
            entity_id=entity_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "EmailReportsResult",
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _get_email_delivery_reports_serialize(
        self,
        bulk_id,
        message_id,
        campaign_reference_id,
        limit,
        application_id,
        entity_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if bulk_id is not None:

            _query_params.append(("bulkId", bulk_id))

        if message_id is not None:

            _query_params.append(("messageId", message_id))

        if campaign_reference_id is not None:

            _query_params.append(("campaignReferenceId", campaign_reference_id))

        if limit is not None:

            _query_params.append(("limit", limit))

        if application_id is not None:

            _query_params.append(("applicationId", application_id))

        if entity_id is not None:

            _query_params.append(("entityId", entity_id))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/email/1/reports",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def get_email_logs(
        self,
        message_id: Annotated[
            Optional[StrictStr],
            Field(description="The ID that uniquely identifies the sent email."),
        ] = None,
        var_from: Annotated[
            Optional[StrictStr], Field(description="From email address.")
        ] = None,
        to: Annotated[
            Optional[StrictStr], Field(description="The recipient email address.")
        ] = None,
        bulk_id: Annotated[
            Optional[StrictStr],
            Field(description="Bulk ID that uniquely identifies the request."),
        ] = None,
        campaign_reference_id: Annotated[
            Optional[StrictStr],
            Field(
                description="The ID that allows you to track, analyze, and show an aggregated overview and the performance of individual campaigns."
            ),
        ] = None,
        general_status: Annotated[
            Optional[StrictStr],
            Field(
                description="Indicates whether the initiated email has been successfully sent, not sent, delivered, not delivered, waiting for delivery or any other possible status."
            ),
        ] = None,
        sent_since: Annotated[
            Optional[datetime],
            Field(
                description="Tells when the email was initiated. Has the following format: `yyyy-MM-dd'T'HH:mm:ss.SSSZ`."
            ),
        ] = None,
        sent_until: Annotated[
            Optional[datetime],
            Field(
                description="Tells when the email request was processed by Infobip.Has the following format: `yyyy-MM-dd'T'HH:mm:ss.SSSZ`."
            ),
        ] = None,
        limit: Annotated[
            Optional[Annotated[int, Field(le=1000, strict=True)]],
            Field(description="Maximum number of logs."),
        ] = None,
        application_id: Annotated[
            Optional[StrictStr],
            Field(
                description="[Application](https://www.infobip.com/docs/cpaas-x/application-and-entity-management#application) identifier used for filtering."
            ),
        ] = None,
        entity_id: Annotated[
            Optional[StrictStr],
            Field(
                description="[Entity](https://www.infobip.com/docs/cpaas-x/application-and-entity-management#entity) identifier used for filtering."
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> EmailLogsResponse:
        """Get email logs

        This method allows you to get logs for sent emails using their messageId. Email logs are available for the last 48 hours.

        :param message_id: The ID that uniquely identifies the sent email.
        :type message_id: str
        :param var_from: From email address.
        :type var_from: str
        :param to: The recipient email address.
        :type to: str
        :param bulk_id: Bulk ID that uniquely identifies the request.
        :type bulk_id: str
        :param campaign_reference_id: The ID that allows you to track, analyze, and show an aggregated overview and the performance of individual campaigns.
        :type campaign_reference_id: str
        :param general_status: Indicates whether the initiated email has been successfully sent, not sent, delivered, not delivered, waiting for delivery or any other possible status.
        :type general_status: str
        :param sent_since: Tells when the email was initiated. Has the following format: `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.
        :type sent_since: datetime
        :param sent_until: Tells when the email request was processed by Infobip.Has the following format: `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.
        :type sent_until: datetime
        :param limit: Maximum number of logs.
        :type limit: int
        :param application_id: [Application](https://www.infobip.com/docs/cpaas-x/application-and-entity-management#application) identifier used for filtering.
        :type application_id: str
        :param entity_id: [Entity](https://www.infobip.com/docs/cpaas-x/application-and-entity-management#entity) identifier used for filtering.
        :type entity_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_email_logs_serialize(
            message_id=message_id,
            var_from=var_from,
            to=to,
            bulk_id=bulk_id,
            campaign_reference_id=campaign_reference_id,
            general_status=general_status,
            sent_since=sent_since,
            sent_until=sent_until,
            limit=limit,
            application_id=application_id,
            entity_id=entity_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "EmailLogsResponse",
            "401": "ApiException",
            "403": "ApiException",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def get_email_logs_with_http_info(
        self,
        message_id: Annotated[
            Optional[StrictStr],
            Field(description="The ID that uniquely identifies the sent email."),
        ] = None,
        var_from: Annotated[
            Optional[StrictStr], Field(description="From email address.")
        ] = None,
        to: Annotated[
            Optional[StrictStr], Field(description="The recipient email address.")
        ] = None,
        bulk_id: Annotated[
            Optional[StrictStr],
            Field(description="Bulk ID that uniquely identifies the request."),
        ] = None,
        campaign_reference_id: Annotated[
            Optional[StrictStr],
            Field(
                description="The ID that allows you to track, analyze, and show an aggregated overview and the performance of individual campaigns."
            ),
        ] = None,
        general_status: Annotated[
            Optional[StrictStr],
            Field(
                description="Indicates whether the initiated email has been successfully sent, not sent, delivered, not delivered, waiting for delivery or any other possible status."
            ),
        ] = None,
        sent_since: Annotated[
            Optional[datetime],
            Field(
                description="Tells when the email was initiated. Has the following format: `yyyy-MM-dd'T'HH:mm:ss.SSSZ`."
            ),
        ] = None,
        sent_until: Annotated[
            Optional[datetime],
            Field(
                description="Tells when the email request was processed by Infobip.Has the following format: `yyyy-MM-dd'T'HH:mm:ss.SSSZ`."
            ),
        ] = None,
        limit: Annotated[
            Optional[Annotated[int, Field(le=1000, strict=True)]],
            Field(description="Maximum number of logs."),
        ] = None,
        application_id: Annotated[
            Optional[StrictStr],
            Field(
                description="[Application](https://www.infobip.com/docs/cpaas-x/application-and-entity-management#application) identifier used for filtering."
            ),
        ] = None,
        entity_id: Annotated[
            Optional[StrictStr],
            Field(
                description="[Entity](https://www.infobip.com/docs/cpaas-x/application-and-entity-management#entity) identifier used for filtering."
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[EmailLogsResponse]:
        """Get email logs

        This method allows you to get logs for sent emails using their messageId. Email logs are available for the last 48 hours.

        :param message_id: The ID that uniquely identifies the sent email.
        :type message_id: str
        :param var_from: From email address.
        :type var_from: str
        :param to: The recipient email address.
        :type to: str
        :param bulk_id: Bulk ID that uniquely identifies the request.
        :type bulk_id: str
        :param campaign_reference_id: The ID that allows you to track, analyze, and show an aggregated overview and the performance of individual campaigns.
        :type campaign_reference_id: str
        :param general_status: Indicates whether the initiated email has been successfully sent, not sent, delivered, not delivered, waiting for delivery or any other possible status.
        :type general_status: str
        :param sent_since: Tells when the email was initiated. Has the following format: `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.
        :type sent_since: datetime
        :param sent_until: Tells when the email request was processed by Infobip.Has the following format: `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.
        :type sent_until: datetime
        :param limit: Maximum number of logs.
        :type limit: int
        :param application_id: [Application](https://www.infobip.com/docs/cpaas-x/application-and-entity-management#application) identifier used for filtering.
        :type application_id: str
        :param entity_id: [Entity](https://www.infobip.com/docs/cpaas-x/application-and-entity-management#entity) identifier used for filtering.
        :type entity_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_email_logs_serialize(
            message_id=message_id,
            var_from=var_from,
            to=to,
            bulk_id=bulk_id,
            campaign_reference_id=campaign_reference_id,
            general_status=general_status,
            sent_since=sent_since,
            sent_until=sent_until,
            limit=limit,
            application_id=application_id,
            entity_id=entity_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "EmailLogsResponse",
            "401": "ApiException",
            "403": "ApiException",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def get_email_logs_without_preload_content(
        self,
        message_id: Annotated[
            Optional[StrictStr],
            Field(description="The ID that uniquely identifies the sent email."),
        ] = None,
        var_from: Annotated[
            Optional[StrictStr], Field(description="From email address.")
        ] = None,
        to: Annotated[
            Optional[StrictStr], Field(description="The recipient email address.")
        ] = None,
        bulk_id: Annotated[
            Optional[StrictStr],
            Field(description="Bulk ID that uniquely identifies the request."),
        ] = None,
        campaign_reference_id: Annotated[
            Optional[StrictStr],
            Field(
                description="The ID that allows you to track, analyze, and show an aggregated overview and the performance of individual campaigns."
            ),
        ] = None,
        general_status: Annotated[
            Optional[StrictStr],
            Field(
                description="Indicates whether the initiated email has been successfully sent, not sent, delivered, not delivered, waiting for delivery or any other possible status."
            ),
        ] = None,
        sent_since: Annotated[
            Optional[datetime],
            Field(
                description="Tells when the email was initiated. Has the following format: `yyyy-MM-dd'T'HH:mm:ss.SSSZ`."
            ),
        ] = None,
        sent_until: Annotated[
            Optional[datetime],
            Field(
                description="Tells when the email request was processed by Infobip.Has the following format: `yyyy-MM-dd'T'HH:mm:ss.SSSZ`."
            ),
        ] = None,
        limit: Annotated[
            Optional[Annotated[int, Field(le=1000, strict=True)]],
            Field(description="Maximum number of logs."),
        ] = None,
        application_id: Annotated[
            Optional[StrictStr],
            Field(
                description="[Application](https://www.infobip.com/docs/cpaas-x/application-and-entity-management#application) identifier used for filtering."
            ),
        ] = None,
        entity_id: Annotated[
            Optional[StrictStr],
            Field(
                description="[Entity](https://www.infobip.com/docs/cpaas-x/application-and-entity-management#entity) identifier used for filtering."
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get email logs

        This method allows you to get logs for sent emails using their messageId. Email logs are available for the last 48 hours.

        :param message_id: The ID that uniquely identifies the sent email.
        :type message_id: str
        :param var_from: From email address.
        :type var_from: str
        :param to: The recipient email address.
        :type to: str
        :param bulk_id: Bulk ID that uniquely identifies the request.
        :type bulk_id: str
        :param campaign_reference_id: The ID that allows you to track, analyze, and show an aggregated overview and the performance of individual campaigns.
        :type campaign_reference_id: str
        :param general_status: Indicates whether the initiated email has been successfully sent, not sent, delivered, not delivered, waiting for delivery or any other possible status.
        :type general_status: str
        :param sent_since: Tells when the email was initiated. Has the following format: `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.
        :type sent_since: datetime
        :param sent_until: Tells when the email request was processed by Infobip.Has the following format: `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.
        :type sent_until: datetime
        :param limit: Maximum number of logs.
        :type limit: int
        :param application_id: [Application](https://www.infobip.com/docs/cpaas-x/application-and-entity-management#application) identifier used for filtering.
        :type application_id: str
        :param entity_id: [Entity](https://www.infobip.com/docs/cpaas-x/application-and-entity-management#entity) identifier used for filtering.
        :type entity_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_email_logs_serialize(
            message_id=message_id,
            var_from=var_from,
            to=to,
            bulk_id=bulk_id,
            campaign_reference_id=campaign_reference_id,
            general_status=general_status,
            sent_since=sent_since,
            sent_until=sent_until,
            limit=limit,
            application_id=application_id,
            entity_id=entity_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "EmailLogsResponse",
            "401": "ApiException",
            "403": "ApiException",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _get_email_logs_serialize(
        self,
        message_id,
        var_from,
        to,
        bulk_id,
        campaign_reference_id,
        general_status,
        sent_since,
        sent_until,
        limit,
        application_id,
        entity_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if message_id is not None:

            _query_params.append(("messageId", message_id))

        if var_from is not None:

            _query_params.append(("from", var_from))

        if to is not None:

            _query_params.append(("to", to))

        if bulk_id is not None:

            _query_params.append(("bulkId", bulk_id))

        if campaign_reference_id is not None:

            _query_params.append(("campaignReferenceId", campaign_reference_id))

        if general_status is not None:

            _query_params.append(("generalStatus", general_status))

        if sent_since is not None:
            if isinstance(sent_since, datetime):
                _query_params.append(
                    (
                        "sentSince",
                        sent_since.strftime(
                            self.api_client.configuration.datetime_format
                        ),
                    )
                )
            else:
                _query_params.append(("sentSince", sent_since))

        if sent_until is not None:
            if isinstance(sent_until, datetime):
                _query_params.append(
                    (
                        "sentUntil",
                        sent_until.strftime(
                            self.api_client.configuration.datetime_format
                        ),
                    )
                )
            else:
                _query_params.append(("sentUntil", sent_until))

        if limit is not None:

            _query_params.append(("limit", limit))

        if application_id is not None:

            _query_params.append(("applicationId", application_id))

        if entity_id is not None:

            _query_params.append(("entityId", entity_id))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/email/1/logs",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def get_ip_details(
        self,
        ip_id: Annotated[StrictStr, Field(description="Dedicated IP identifier.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> EmailIpDetailResponse:
        """Get IP

        Get detailed information about provided dedicated IP.

        :param ip_id: Dedicated IP identifier. (required)
        :type ip_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_ip_details_serialize(
            ip_id=ip_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "EmailIpDetailResponse",
            "400": "ApiError",
            "401": "ApiError",
            "403": "ApiError",
            "404": "ApiError",
            "429": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def get_ip_details_with_http_info(
        self,
        ip_id: Annotated[StrictStr, Field(description="Dedicated IP identifier.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[EmailIpDetailResponse]:
        """Get IP

        Get detailed information about provided dedicated IP.

        :param ip_id: Dedicated IP identifier. (required)
        :type ip_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_ip_details_serialize(
            ip_id=ip_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "EmailIpDetailResponse",
            "400": "ApiError",
            "401": "ApiError",
            "403": "ApiError",
            "404": "ApiError",
            "429": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def get_ip_details_without_preload_content(
        self,
        ip_id: Annotated[StrictStr, Field(description="Dedicated IP identifier.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get IP

        Get detailed information about provided dedicated IP.

        :param ip_id: Dedicated IP identifier. (required)
        :type ip_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_ip_details_serialize(
            ip_id=ip_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "EmailIpDetailResponse",
            "400": "ApiError",
            "401": "ApiError",
            "403": "ApiError",
            "404": "ApiError",
            "429": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _get_ip_details_serialize(
        self,
        ip_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if ip_id is not None:
            _path_params["ipId"] = ip_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/email/1/ip-management/ips/{ipId}",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def get_ip_domain(
        self,
        domain_id: Annotated[
            int, Field(strict=True, ge=1, description="Domain identifier.")
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> EmailIpDomainResponse:
        """Get domain

        Get detailed information for provided domain such as assigned pools and their IPs.

        :param domain_id: Domain identifier. (required)
        :type domain_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_ip_domain_serialize(
            domain_id=domain_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "EmailIpDomainResponse",
            "401": "ApiError",
            "403": "ApiError",
            "404": "ApiError",
            "429": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def get_ip_domain_with_http_info(
        self,
        domain_id: Annotated[
            int, Field(strict=True, ge=1, description="Domain identifier.")
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[EmailIpDomainResponse]:
        """Get domain

        Get detailed information for provided domain such as assigned pools and their IPs.

        :param domain_id: Domain identifier. (required)
        :type domain_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_ip_domain_serialize(
            domain_id=domain_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "EmailIpDomainResponse",
            "401": "ApiError",
            "403": "ApiError",
            "404": "ApiError",
            "429": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def get_ip_domain_without_preload_content(
        self,
        domain_id: Annotated[
            int, Field(strict=True, ge=1, description="Domain identifier.")
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get domain

        Get detailed information for provided domain such as assigned pools and their IPs.

        :param domain_id: Domain identifier. (required)
        :type domain_id: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_ip_domain_serialize(
            domain_id=domain_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "EmailIpDomainResponse",
            "401": "ApiError",
            "403": "ApiError",
            "404": "ApiError",
            "429": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _get_ip_domain_serialize(
        self,
        domain_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if domain_id is not None:
            _path_params["domainId"] = domain_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/email/1/ip-management/domains/{domainId}",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def get_ip_pool(
        self,
        pool_id: Annotated[StrictStr, Field(description="IP pool identifier.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> EmailIpPoolDetailResponse:
        """Get IP pool

        Get detailed information about a provided IP pool.

        :param pool_id: IP pool identifier. (required)
        :type pool_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_ip_pool_serialize(
            pool_id=pool_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "EmailIpPoolDetailResponse",
            "401": "ApiError",
            "403": "ApiError",
            "404": "ApiError",
            "429": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def get_ip_pool_with_http_info(
        self,
        pool_id: Annotated[StrictStr, Field(description="IP pool identifier.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[EmailIpPoolDetailResponse]:
        """Get IP pool

        Get detailed information about a provided IP pool.

        :param pool_id: IP pool identifier. (required)
        :type pool_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_ip_pool_serialize(
            pool_id=pool_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "EmailIpPoolDetailResponse",
            "401": "ApiError",
            "403": "ApiError",
            "404": "ApiError",
            "429": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def get_ip_pool_without_preload_content(
        self,
        pool_id: Annotated[StrictStr, Field(description="IP pool identifier.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get IP pool

        Get detailed information about a provided IP pool.

        :param pool_id: IP pool identifier. (required)
        :type pool_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_ip_pool_serialize(
            pool_id=pool_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "EmailIpPoolDetailResponse",
            "401": "ApiError",
            "403": "ApiError",
            "404": "ApiError",
            "429": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _get_ip_pool_serialize(
        self,
        pool_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if pool_id is not None:
            _path_params["poolId"] = pool_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/email/1/ip-management/pools/{poolId}",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def get_ip_pools(
        self,
        name: Annotated[
            Optional[Annotated[str, Field(min_length=1, strict=True, max_length=100)]],
            Field(description="IP pool name."),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[EmailIpPoolResponse]:
        """Get IP pools

        Returns all the pools that are owned (created) by this account.

        :param name: IP pool name.
        :type name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_ip_pools_serialize(
            name=name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "List[EmailIpPoolResponse]",
            "401": "ApiError",
            "403": "ApiError",
            "429": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def get_ip_pools_with_http_info(
        self,
        name: Annotated[
            Optional[Annotated[str, Field(min_length=1, strict=True, max_length=100)]],
            Field(description="IP pool name."),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[EmailIpPoolResponse]]:
        """Get IP pools

        Returns all the pools that are owned (created) by this account.

        :param name: IP pool name.
        :type name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_ip_pools_serialize(
            name=name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "List[EmailIpPoolResponse]",
            "401": "ApiError",
            "403": "ApiError",
            "429": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def get_ip_pools_without_preload_content(
        self,
        name: Annotated[
            Optional[Annotated[str, Field(min_length=1, strict=True, max_length=100)]],
            Field(description="IP pool name."),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get IP pools

        Returns all the pools that are owned (created) by this account.

        :param name: IP pool name.
        :type name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_ip_pools_serialize(
            name=name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "List[EmailIpPoolResponse]",
            "401": "ApiError",
            "403": "ApiError",
            "429": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _get_ip_pools_serialize(
        self,
        name,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if name is not None:

            _query_params.append(("name", name))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/email/1/ip-management/pools",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def get_scheduled_email_statuses(
        self,
        bulk_id: Annotated[
            StrictStr,
            Field(description="The ID uniquely identifies the sent email request."),
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> EmailBulkStatusResponse:
        """Get sent email bulks status

        See the status of scheduled email messages.

        :param bulk_id: The ID uniquely identifies the sent email request. (required)
        :type bulk_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_scheduled_email_statuses_serialize(
            bulk_id=bulk_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "EmailBulkStatusResponse",
            "401": "ApiException",
            "403": "ApiException",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def get_scheduled_email_statuses_with_http_info(
        self,
        bulk_id: Annotated[
            StrictStr,
            Field(description="The ID uniquely identifies the sent email request."),
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[EmailBulkStatusResponse]:
        """Get sent email bulks status

        See the status of scheduled email messages.

        :param bulk_id: The ID uniquely identifies the sent email request. (required)
        :type bulk_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_scheduled_email_statuses_serialize(
            bulk_id=bulk_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "EmailBulkStatusResponse",
            "401": "ApiException",
            "403": "ApiException",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def get_scheduled_email_statuses_without_preload_content(
        self,
        bulk_id: Annotated[
            StrictStr,
            Field(description="The ID uniquely identifies the sent email request."),
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get sent email bulks status

        See the status of scheduled email messages.

        :param bulk_id: The ID uniquely identifies the sent email request. (required)
        :type bulk_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_scheduled_email_statuses_serialize(
            bulk_id=bulk_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "EmailBulkStatusResponse",
            "401": "ApiException",
            "403": "ApiException",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _get_scheduled_email_statuses_serialize(
        self,
        bulk_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if bulk_id is not None:

            _query_params.append(("bulkId", bulk_id))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/email/1/bulks/status",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def get_scheduled_emails(
        self,
        bulk_id: Annotated[
            StrictStr,
            Field(description="The ID uniquely identifies the sent email request."),
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> EmailBulkScheduleResponse:
        """Get sent email bulks

        See the scheduled time of your Email messages.

        :param bulk_id: The ID uniquely identifies the sent email request. (required)
        :type bulk_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_scheduled_emails_serialize(
            bulk_id=bulk_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "EmailBulkScheduleResponse",
            "401": "ApiException",
            "403": "ApiException",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def get_scheduled_emails_with_http_info(
        self,
        bulk_id: Annotated[
            StrictStr,
            Field(description="The ID uniquely identifies the sent email request."),
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[EmailBulkScheduleResponse]:
        """Get sent email bulks

        See the scheduled time of your Email messages.

        :param bulk_id: The ID uniquely identifies the sent email request. (required)
        :type bulk_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_scheduled_emails_serialize(
            bulk_id=bulk_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "EmailBulkScheduleResponse",
            "401": "ApiException",
            "403": "ApiException",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def get_scheduled_emails_without_preload_content(
        self,
        bulk_id: Annotated[
            StrictStr,
            Field(description="The ID uniquely identifies the sent email request."),
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get sent email bulks

        See the scheduled time of your Email messages.

        :param bulk_id: The ID uniquely identifies the sent email request. (required)
        :type bulk_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_scheduled_emails_serialize(
            bulk_id=bulk_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "EmailBulkScheduleResponse",
            "401": "ApiException",
            "403": "ApiException",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _get_scheduled_emails_serialize(
        self,
        bulk_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if bulk_id is not None:

            _query_params.append(("bulkId", bulk_id))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/email/1/bulks",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def get_suppressions(
        self,
        domain_name: Annotated[
            StrictStr, Field(description="Name of the requested domain.")
        ],
        type: Annotated[
            EmailSuppressionType, Field(description="Type of suppression.")
        ],
        email_address: Annotated[
            Optional[StrictStr], Field(description="Email address that is suppressed.")
        ] = None,
        recipient_domain: Annotated[
            Optional[StrictStr],
            Field(description="Recipient domain that is suppressed."),
        ] = None,
        created_date_from: Annotated[
            Optional[datetime],
            Field(description="Start date for searching suppressions."),
        ] = None,
        created_date_to: Annotated[
            Optional[datetime],
            Field(description="End date for searching suppressions."),
        ] = None,
        page: Annotated[
            Optional[Annotated[int, Field(strict=True, ge=0)]],
            Field(description="Requested page number."),
        ] = None,
        size: Annotated[
            Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]],
            Field(description="Requested page size."),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> EmailSuppressionInfoPageResponse:
        """Get suppressions

        This method retrieves the suppressions for domains that are owned or have permissions granted.

        :param domain_name: Name of the requested domain. (required)
        :type domain_name: str
        :param type: Type of suppression. (required)
        :type type: EmailSuppressionType
        :param email_address: Email address that is suppressed.
        :type email_address: str
        :param recipient_domain: Recipient domain that is suppressed.
        :type recipient_domain: str
        :param created_date_from: Start date for searching suppressions.
        :type created_date_from: datetime
        :param created_date_to: End date for searching suppressions.
        :type created_date_to: datetime
        :param page: Requested page number.
        :type page: int
        :param size: Requested page size.
        :type size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_suppressions_serialize(
            domain_name=domain_name,
            type=type,
            email_address=email_address,
            recipient_domain=recipient_domain,
            created_date_from=created_date_from,
            created_date_to=created_date_to,
            page=page,
            size=size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "EmailSuppressionInfoPageResponse",
            "400": "ApiError",
            "401": "ApiError",
            "403": "ApiError",
            "429": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def get_suppressions_with_http_info(
        self,
        domain_name: Annotated[
            StrictStr, Field(description="Name of the requested domain.")
        ],
        type: Annotated[
            EmailSuppressionType, Field(description="Type of suppression.")
        ],
        email_address: Annotated[
            Optional[StrictStr], Field(description="Email address that is suppressed.")
        ] = None,
        recipient_domain: Annotated[
            Optional[StrictStr],
            Field(description="Recipient domain that is suppressed."),
        ] = None,
        created_date_from: Annotated[
            Optional[datetime],
            Field(description="Start date for searching suppressions."),
        ] = None,
        created_date_to: Annotated[
            Optional[datetime],
            Field(description="End date for searching suppressions."),
        ] = None,
        page: Annotated[
            Optional[Annotated[int, Field(strict=True, ge=0)]],
            Field(description="Requested page number."),
        ] = None,
        size: Annotated[
            Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]],
            Field(description="Requested page size."),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[EmailSuppressionInfoPageResponse]:
        """Get suppressions

        This method retrieves the suppressions for domains that are owned or have permissions granted.

        :param domain_name: Name of the requested domain. (required)
        :type domain_name: str
        :param type: Type of suppression. (required)
        :type type: EmailSuppressionType
        :param email_address: Email address that is suppressed.
        :type email_address: str
        :param recipient_domain: Recipient domain that is suppressed.
        :type recipient_domain: str
        :param created_date_from: Start date for searching suppressions.
        :type created_date_from: datetime
        :param created_date_to: End date for searching suppressions.
        :type created_date_to: datetime
        :param page: Requested page number.
        :type page: int
        :param size: Requested page size.
        :type size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_suppressions_serialize(
            domain_name=domain_name,
            type=type,
            email_address=email_address,
            recipient_domain=recipient_domain,
            created_date_from=created_date_from,
            created_date_to=created_date_to,
            page=page,
            size=size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "EmailSuppressionInfoPageResponse",
            "400": "ApiError",
            "401": "ApiError",
            "403": "ApiError",
            "429": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def get_suppressions_without_preload_content(
        self,
        domain_name: Annotated[
            StrictStr, Field(description="Name of the requested domain.")
        ],
        type: Annotated[
            EmailSuppressionType, Field(description="Type of suppression.")
        ],
        email_address: Annotated[
            Optional[StrictStr], Field(description="Email address that is suppressed.")
        ] = None,
        recipient_domain: Annotated[
            Optional[StrictStr],
            Field(description="Recipient domain that is suppressed."),
        ] = None,
        created_date_from: Annotated[
            Optional[datetime],
            Field(description="Start date for searching suppressions."),
        ] = None,
        created_date_to: Annotated[
            Optional[datetime],
            Field(description="End date for searching suppressions."),
        ] = None,
        page: Annotated[
            Optional[Annotated[int, Field(strict=True, ge=0)]],
            Field(description="Requested page number."),
        ] = None,
        size: Annotated[
            Optional[Annotated[int, Field(le=1000, strict=True, ge=1)]],
            Field(description="Requested page size."),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get suppressions

        This method retrieves the suppressions for domains that are owned or have permissions granted.

        :param domain_name: Name of the requested domain. (required)
        :type domain_name: str
        :param type: Type of suppression. (required)
        :type type: EmailSuppressionType
        :param email_address: Email address that is suppressed.
        :type email_address: str
        :param recipient_domain: Recipient domain that is suppressed.
        :type recipient_domain: str
        :param created_date_from: Start date for searching suppressions.
        :type created_date_from: datetime
        :param created_date_to: End date for searching suppressions.
        :type created_date_to: datetime
        :param page: Requested page number.
        :type page: int
        :param size: Requested page size.
        :type size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_suppressions_serialize(
            domain_name=domain_name,
            type=type,
            email_address=email_address,
            recipient_domain=recipient_domain,
            created_date_from=created_date_from,
            created_date_to=created_date_to,
            page=page,
            size=size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "EmailSuppressionInfoPageResponse",
            "400": "ApiError",
            "401": "ApiError",
            "403": "ApiError",
            "429": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _get_suppressions_serialize(
        self,
        domain_name,
        type,
        email_address,
        recipient_domain,
        created_date_from,
        created_date_to,
        page,
        size,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if domain_name is not None:

            _query_params.append(("domainName", domain_name))

        if type is not None:

            _query_params.append(("type", type.value))

        if email_address is not None:

            _query_params.append(("emailAddress", email_address))

        if recipient_domain is not None:

            _query_params.append(("recipientDomain", recipient_domain))

        if created_date_from is not None:
            if isinstance(created_date_from, datetime):
                _query_params.append(
                    (
                        "createdDateFrom",
                        created_date_from.strftime(
                            self.api_client.configuration.datetime_format
                        ),
                    )
                )
            else:
                _query_params.append(("createdDateFrom", created_date_from))

        if created_date_to is not None:
            if isinstance(created_date_to, datetime):
                _query_params.append(
                    (
                        "createdDateTo",
                        created_date_to.strftime(
                            self.api_client.configuration.datetime_format
                        ),
                    )
                )
            else:
                _query_params.append(("createdDateTo", created_date_to))

        if page is not None:

            _query_params.append(("page", page))

        if size is not None:

            _query_params.append(("size", size))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/email/1/suppressions",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def remove_ip_from_pool(
        self,
        pool_id: Annotated[StrictStr, Field(description="IP pool identifier.")],
        ip_id: Annotated[StrictStr, Field(description="Dedicated IP identifier.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Unassign IP from pool

        Unassign provided IP from the specific pool.

        :param pool_id: IP pool identifier. (required)
        :type pool_id: str
        :param ip_id: Dedicated IP identifier. (required)
        :type ip_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._remove_ip_from_pool_serialize(
            pool_id=pool_id,
            ip_id=ip_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "401": "ApiError",
            "403": "ApiError",
            "404": "ApiError",
            "429": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def remove_ip_from_pool_with_http_info(
        self,
        pool_id: Annotated[StrictStr, Field(description="IP pool identifier.")],
        ip_id: Annotated[StrictStr, Field(description="Dedicated IP identifier.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Unassign IP from pool

        Unassign provided IP from the specific pool.

        :param pool_id: IP pool identifier. (required)
        :type pool_id: str
        :param ip_id: Dedicated IP identifier. (required)
        :type ip_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._remove_ip_from_pool_serialize(
            pool_id=pool_id,
            ip_id=ip_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "401": "ApiError",
            "403": "ApiError",
            "404": "ApiError",
            "429": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def remove_ip_from_pool_without_preload_content(
        self,
        pool_id: Annotated[StrictStr, Field(description="IP pool identifier.")],
        ip_id: Annotated[StrictStr, Field(description="Dedicated IP identifier.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Unassign IP from pool

        Unassign provided IP from the specific pool.

        :param pool_id: IP pool identifier. (required)
        :type pool_id: str
        :param ip_id: Dedicated IP identifier. (required)
        :type ip_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._remove_ip_from_pool_serialize(
            pool_id=pool_id,
            ip_id=ip_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "401": "ApiError",
            "403": "ApiError",
            "404": "ApiError",
            "429": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _remove_ip_from_pool_serialize(
        self,
        pool_id,
        ip_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if pool_id is not None:
            _path_params["poolId"] = pool_id
        if ip_id is not None:
            _path_params["ipId"] = ip_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="DELETE",
            resource_path="/email/1/ip-management/pools/{poolId}/ips/{ipId}",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def remove_ip_pool_from_domain(
        self,
        domain_id: Annotated[
            int, Field(strict=True, ge=1, description="Domain identifier.")
        ],
        pool_id: Annotated[StrictStr, Field(description="IP pool identifier.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Unassign IP pool from domain

        Unassign a specified pool from the provided domain.

        :param domain_id: Domain identifier. (required)
        :type domain_id: int
        :param pool_id: IP pool identifier. (required)
        :type pool_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._remove_ip_pool_from_domain_serialize(
            domain_id=domain_id,
            pool_id=pool_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "401": "ApiError",
            "403": "ApiError",
            "404": "ApiError",
            "429": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def remove_ip_pool_from_domain_with_http_info(
        self,
        domain_id: Annotated[
            int, Field(strict=True, ge=1, description="Domain identifier.")
        ],
        pool_id: Annotated[StrictStr, Field(description="IP pool identifier.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Unassign IP pool from domain

        Unassign a specified pool from the provided domain.

        :param domain_id: Domain identifier. (required)
        :type domain_id: int
        :param pool_id: IP pool identifier. (required)
        :type pool_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._remove_ip_pool_from_domain_serialize(
            domain_id=domain_id,
            pool_id=pool_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "401": "ApiError",
            "403": "ApiError",
            "404": "ApiError",
            "429": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def remove_ip_pool_from_domain_without_preload_content(
        self,
        domain_id: Annotated[
            int, Field(strict=True, ge=1, description="Domain identifier.")
        ],
        pool_id: Annotated[StrictStr, Field(description="IP pool identifier.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Unassign IP pool from domain

        Unassign a specified pool from the provided domain.

        :param domain_id: Domain identifier. (required)
        :type domain_id: int
        :param pool_id: IP pool identifier. (required)
        :type pool_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._remove_ip_pool_from_domain_serialize(
            domain_id=domain_id,
            pool_id=pool_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "401": "ApiError",
            "403": "ApiError",
            "404": "ApiError",
            "429": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _remove_ip_pool_from_domain_serialize(
        self,
        domain_id,
        pool_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if domain_id is not None:
            _path_params["domainId"] = domain_id
        if pool_id is not None:
            _path_params["poolId"] = pool_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="DELETE",
            resource_path="/email/1/ip-management/domains/{domainId}/pools/{poolId}",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def reschedule_emails(
        self,
        bulk_id: StrictStr,
        email_bulk_reschedule_request: EmailBulkRescheduleRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> EmailBulkRescheduleResponse:
        """Reschedule Email messages

        Change the date and time for sending scheduled messages.

        :param bulk_id: (required)
        :type bulk_id: str
        :param email_bulk_reschedule_request: (required)
        :type email_bulk_reschedule_request: EmailBulkRescheduleRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._reschedule_emails_serialize(
            bulk_id=bulk_id,
            email_bulk_reschedule_request=email_bulk_reschedule_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "EmailBulkRescheduleResponse",
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def reschedule_emails_with_http_info(
        self,
        bulk_id: StrictStr,
        email_bulk_reschedule_request: EmailBulkRescheduleRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[EmailBulkRescheduleResponse]:
        """Reschedule Email messages

        Change the date and time for sending scheduled messages.

        :param bulk_id: (required)
        :type bulk_id: str
        :param email_bulk_reschedule_request: (required)
        :type email_bulk_reschedule_request: EmailBulkRescheduleRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._reschedule_emails_serialize(
            bulk_id=bulk_id,
            email_bulk_reschedule_request=email_bulk_reschedule_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "EmailBulkRescheduleResponse",
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def reschedule_emails_without_preload_content(
        self,
        bulk_id: StrictStr,
        email_bulk_reschedule_request: EmailBulkRescheduleRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Reschedule Email messages

        Change the date and time for sending scheduled messages.

        :param bulk_id: (required)
        :type bulk_id: str
        :param email_bulk_reschedule_request: (required)
        :type email_bulk_reschedule_request: EmailBulkRescheduleRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._reschedule_emails_serialize(
            bulk_id=bulk_id,
            email_bulk_reschedule_request=email_bulk_reschedule_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "EmailBulkRescheduleResponse",
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _reschedule_emails_serialize(
        self,
        bulk_id,
        email_bulk_reschedule_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if bulk_id is not None:

            _query_params.append(("bulkId", bulk_id))

        # process the header parameters
        # process the form parameters
        # process the body parameter
        if email_bulk_reschedule_request is not None:
            _body_params = email_bulk_reschedule_request

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(
                ["application/json"]
            )
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="PUT",
            resource_path="/email/1/bulks",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def send_email(
        self,
        to: Annotated[
            List[Annotated[str, Field(strict=True)]],
            Field(
                description='Email address of the recipient in a form of `To=\\"john.smith@somecompany.com\\"`. As optional feature on this field, a specific placeholder can be defined whose value will apply only for this destination. Given `To` value should look like: `To= {\\"to\\": \\"john.smith@somecompany.com\\",\\"placeholders\\": {\\"name\\": \\"John\\"}}` `To= {\\"to\\": \\"alice.grey@somecompany.com\\",\\"placeholders\\": {\\"name\\": \\"Alice\\"}}`.  Note: Maximum number of recipients per request is 1000 overall including to, cc and bcc field.'
            ),
        ],
        var_from: Annotated[
            Optional[StrictStr],
            Field(
                description="Email address with optional sender name.  Note: This field is required if `templateId` is not present."
            ),
        ] = None,
        cc: Annotated[
            Optional[List[Annotated[str, Field(strict=True)]]],
            Field(
                description="CC recipient email address. As optional feature on this field, a specific placeholder can be defined whose value will apply only for this destination.  Note: Maximum number of recipients per request is 1000 overall including to, cc and bcc field."
            ),
        ] = None,
        bcc: Annotated[
            Optional[List[Annotated[str, Field(strict=True)]]],
            Field(
                description="BCC recipient email address. As optional feature on this field, a specific placeholder can be defined whose value will apply only for this destination.  Note: Maximum number of recipients per request is 1000 overall including to, cc and bcc field."
            ),
        ] = None,
        subject: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="Message subject.  Note: This field is required if `templateId` is not present."
            ),
        ] = None,
        text: Annotated[
            Optional[StrictStr], Field(description="Body of the message.")
        ] = None,
        html: Annotated[
            Optional[StrictStr],
            Field(
                description="HTML body of the message. If `html` and `text` fields are present, the `text` field will be ignored and `html` will be delivered as a message body."
            ),
        ] = None,
        amp_html: Annotated[
            Optional[StrictStr],
            Field(
                description="Amp HTML body of the message. If `ampHtml` is present, `html` is mandatory. Amp HTML is not supported by all the email clients. Please check this link for configuring gmail client https://developers.google.com/gmail/ampemail/."
            ),
        ] = None,
        template_id: Annotated[
            Optional[StrictInt],
            Field(
                description="Template ID used for generating email content. The template is created over Infobip web interface. If `templateId` is present, then `html` and `text` values are ignored.  Note: `templateId` only supports the value of `Broadcast`. `Content` and `Flow` are not supported."
            ),
        ] = None,
        attachment: Annotated[
            Optional[List[Union[StrictBytes, StrictStr]]],
            Field(description="File attachment."),
        ] = None,
        inline_image: Annotated[
            Optional[List[Union[StrictBytes, StrictStr]]],
            Field(
                description="Allows for inserting an image file inside the HTML code of the email by using `cid:FILENAME` instead of providing an external link to the image."
            ),
        ] = None,
        intermediate_report: Annotated[
            Optional[StrictBool],
            Field(
                description="The real-time Intermediate delivery report that will be sent on your callback server."
            ),
        ] = None,
        notify_url: Annotated[
            Optional[StrictStr],
            Field(
                description="The URL on your callback server on which the Delivery report will be sent."
            ),
        ] = None,
        notify_content_type: Annotated[
            Optional[StrictStr],
            Field(
                description="Preferred Delivery report content type. Can be `application/json` or `application/xml`."
            ),
        ] = None,
        callback_data: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="Additional client data that will be sent on the notifyUrl."
            ),
        ] = None,
        track: Annotated[
            Optional[StrictBool],
            Field(
                description="Enable or disable open and click tracking. Passing true will only enable tracking and the statistics would be visible in the web interface alone. This can be explicitly overridden by `trackClicks` and `trackOpens`."
            ),
        ] = None,
        track_clicks: Annotated[
            Optional[StrictBool],
            Field(
                description="This parameter enables or disables track click feature.  Note: Option to disable click tracking per URL is available. For detailed usage, please refer to the [documentation](https://www.infobip.com/docs/email/tracking-service#disable-click-tracking-on-urls)."
            ),
        ] = None,
        track_opens: Annotated[
            Optional[StrictBool],
            Field(description="This parameter enables or disables track open feature."),
        ] = None,
        tracking_url: Annotated[
            Optional[StrictStr],
            Field(
                description="The URL on your callback server on which the open and click notifications will be sent. See [Tracking Notifications](https://www.infobip.com/docs/email/send-email-over-api#tracking-notifications) for details."
            ),
        ] = None,
        bulk_id: Annotated[
            Optional[StrictStr],
            Field(
                description="The ID uniquely identifies the sent email request. This filter will enable you to query delivery reports for all the messages using just one request. You will receive a `bulkId` in the response after sending an email request. If you don't set your own `bulkId`, unique ID will be generated by our system and returned in the API response. (Optional Field)"
            ),
        ] = None,
        message_id: Annotated[
            Optional[StrictStr],
            Field(
                description="The ID that uniquely identifies the message sent to a recipient. (Optional Field)"
            ),
        ] = None,
        campaign_reference_id: Annotated[
            Optional[StrictStr],
            Field(
                description="The ID that allows you to track, analyze, and show an aggregated overview and the performance of individual campaigns."
            ),
        ] = None,
        reply_to: Annotated[
            Optional[StrictStr],
            Field(
                description="Email address to which recipients of the email can reply."
            ),
        ] = None,
        default_placeholders: Annotated[
            Optional[StrictStr],
            Field(
                description='General placeholder, given in a form of json example: `defaultPlaceholders={\\"ph1\\": \\"Success\\"}`, which will replace given key `{{ph1}}` with given value `Success` anywhere in the email (subject, text, html...). In case of more destinations in `To` field, this placeholder will resolve the same value for key `ph1`.'
            ),
        ] = None,
        preserve_recipients: Annotated[
            Optional[StrictBool],
            Field(
                description="If set to `true`, the `to` recipients will see the list of all other recipients to get the email and the response will return only one `messageId`. Otherwise, each recipient will see just their own email and the response will return a unique `messageId` for each email recipient."
            ),
        ] = None,
        send_at: Annotated[
            Optional[datetime],
            Field(
                description="To schedule message at a given time. Time provided should be in UTC in the following format: `yyyy-MM-dd'T'HH:mm:ss.SSSZ` and cannot exceed 30 days in the future. "
            ),
        ] = None,
        landing_page_placeholders: Annotated[
            Optional[StrictStr],
            Field(
                description="Personalize opt out landing page by inserting placeholders. Insert placeholder or tag while designing landing page."
            ),
        ] = None,
        landing_page_id: Annotated[
            Optional[StrictStr],
            Field(
                description="The ID of an opt out landing page to be used and displayed once an end user clicks the unsubscribe link. If not present, default opt out landing page will be displayed. Create a landing page in your Infobip account and use its ID, e.g., `1_23456`."
            ),
        ] = None,
        template_language_version: Annotated[
            Optional[StrictStr],
            Field(
                description="Specifies template language version that will be used in the current message template. Use version 1 for previous version of template language. Use version 2 for features of the new template language. If not present version 1 will be used as default version. "
            ),
        ] = None,
        client_priority: Annotated[
            Optional[StrictStr],
            Field(
                description="Adds a priority rating to this email message. Allowed values are `HIGH`, `STANDARD` and `LOW`. Messages with a higher priority value sent by your account are prioritized over messages with a lower priority value sent by your account. If no priority value is provided, messages will be treated with `STANDARD` priority by default."
            ),
        ] = None,
        application_id: Annotated[
            Optional[StrictStr],
            Field(
                description="Required for application use in a send request for outbound traffic. Returned in notification events."
            ),
        ] = None,
        entity_id: Annotated[
            Optional[StrictStr],
            Field(
                description="Required for entity use in a send request for outbound traffic. Returned in notification events."
            ),
        ] = None,
        headers: Annotated[
            Optional[StrictStr],
            Field(
                description='Additional email headers for customization that can be provided in a form of JSON. Example: `headers={\\"X-CustomHeader\\": \\"Header value\\"}`.  There are a few exceptions of headers which are not adjustable through this option: `To`, `Cc`, `Bcc`, `From`, `Subject`,`Content-Type`, `DKIM-Signature`, `Content-Transfer-Encoding`, `Return-Path`, `MIME-Version`'
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> EmailSendResponse:
        """Send fully featured email

        Send an email or multiple emails to a recipient or multiple recipients with CC/BCC enabled.

        :param to: Email address of the recipient in a form of `To=\\\"john.smith@somecompany.com\\\"`. As optional feature on this field, a specific placeholder can be defined whose value will apply only for this destination. Given `To` value should look like: `To= {\\\"to\\\": \\\"john.smith@somecompany.com\\\",\\\"placeholders\\\": {\\\"name\\\": \\\"John\\\"}}` `To= {\\\"to\\\": \\\"alice.grey@somecompany.com\\\",\\\"placeholders\\\": {\\\"name\\\": \\\"Alice\\\"}}`.  Note: Maximum number of recipients per request is 1000 overall including to, cc and bcc field. (required)
        :type to: List[str]
        :param var_from: Email address with optional sender name.  Note: This field is required if `templateId` is not present.
        :type var_from: str
        :param cc: CC recipient email address. As optional feature on this field, a specific placeholder can be defined whose value will apply only for this destination.  Note: Maximum number of recipients per request is 1000 overall including to, cc and bcc field.
        :type cc: List[str]
        :param bcc: BCC recipient email address. As optional feature on this field, a specific placeholder can be defined whose value will apply only for this destination.  Note: Maximum number of recipients per request is 1000 overall including to, cc and bcc field.
        :type bcc: List[str]
        :param subject: Message subject.  Note: This field is required if `templateId` is not present.
        :type subject: str
        :param text: Body of the message.
        :type text: str
        :param html: HTML body of the message. If `html` and `text` fields are present, the `text` field will be ignored and `html` will be delivered as a message body.
        :type html: str
        :param amp_html: Amp HTML body of the message. If `ampHtml` is present, `html` is mandatory. Amp HTML is not supported by all the email clients. Please check this link for configuring gmail client https://developers.google.com/gmail/ampemail/.
        :type amp_html: str
        :param template_id: Template ID used for generating email content. The template is created over Infobip web interface. If `templateId` is present, then `html` and `text` values are ignored.  Note: `templateId` only supports the value of `Broadcast`. `Content` and `Flow` are not supported.
        :type template_id: int
        :param attachment: File attachment.
        :type attachment: List[bytearray]
        :param inline_image: Allows for inserting an image file inside the HTML code of the email by using `cid:FILENAME` instead of providing an external link to the image.
        :type inline_image: List[bytearray]
        :param intermediate_report: The real-time Intermediate delivery report that will be sent on your callback server.
        :type intermediate_report: bool
        :param notify_url: The URL on your callback server on which the Delivery report will be sent.
        :type notify_url: str
        :param notify_content_type: Preferred Delivery report content type. Can be `application/json` or `application/xml`.
        :type notify_content_type: str
        :param callback_data: Additional client data that will be sent on the notifyUrl.
        :type callback_data: str
        :param track: Enable or disable open and click tracking. Passing true will only enable tracking and the statistics would be visible in the web interface alone. This can be explicitly overridden by `trackClicks` and `trackOpens`.
        :type track: bool
        :param track_clicks: This parameter enables or disables track click feature.  Note: Option to disable click tracking per URL is available. For detailed usage, please refer to the [documentation](https://www.infobip.com/docs/email/tracking-service#disable-click-tracking-on-urls).
        :type track_clicks: bool
        :param track_opens: This parameter enables or disables track open feature.
        :type track_opens: bool
        :param tracking_url: The URL on your callback server on which the open and click notifications will be sent. See [Tracking Notifications](https://www.infobip.com/docs/email/send-email-over-api#tracking-notifications) for details.
        :type tracking_url: str
        :param bulk_id: The ID uniquely identifies the sent email request. This filter will enable you to query delivery reports for all the messages using just one request. You will receive a `bulkId` in the response after sending an email request. If you don't set your own `bulkId`, unique ID will be generated by our system and returned in the API response. (Optional Field)
        :type bulk_id: str
        :param message_id: The ID that uniquely identifies the message sent to a recipient. (Optional Field)
        :type message_id: str
        :param campaign_reference_id: The ID that allows you to track, analyze, and show an aggregated overview and the performance of individual campaigns.
        :type campaign_reference_id: str
        :param reply_to: Email address to which recipients of the email can reply.
        :type reply_to: str
        :param default_placeholders: General placeholder, given in a form of json example: `defaultPlaceholders={\\\"ph1\\\": \\\"Success\\\"}`, which will replace given key `{{ph1}}` with given value `Success` anywhere in the email (subject, text, html...). In case of more destinations in `To` field, this placeholder will resolve the same value for key `ph1`.
        :type default_placeholders: str
        :param preserve_recipients: If set to `true`, the `to` recipients will see the list of all other recipients to get the email and the response will return only one `messageId`. Otherwise, each recipient will see just their own email and the response will return a unique `messageId` for each email recipient.
        :type preserve_recipients: bool
        :param send_at: To schedule message at a given time. Time provided should be in UTC in the following format: `yyyy-MM-dd'T'HH:mm:ss.SSSZ` and cannot exceed 30 days in the future.
        :type send_at: datetime
        :param landing_page_placeholders: Personalize opt out landing page by inserting placeholders. Insert placeholder or tag while designing landing page.
        :type landing_page_placeholders: str
        :param landing_page_id: The ID of an opt out landing page to be used and displayed once an end user clicks the unsubscribe link. If not present, default opt out landing page will be displayed. Create a landing page in your Infobip account and use its ID, e.g., `1_23456`.
        :type landing_page_id: str
        :param template_language_version: Specifies template language version that will be used in the current message template. Use version 1 for previous version of template language. Use version 2 for features of the new template language. If not present version 1 will be used as default version.
        :type template_language_version: str
        :param client_priority: Adds a priority rating to this email message. Allowed values are `HIGH`, `STANDARD` and `LOW`. Messages with a higher priority value sent by your account are prioritized over messages with a lower priority value sent by your account. If no priority value is provided, messages will be treated with `STANDARD` priority by default.
        :type client_priority: str
        :param application_id: Required for application use in a send request for outbound traffic. Returned in notification events.
        :type application_id: str
        :param entity_id: Required for entity use in a send request for outbound traffic. Returned in notification events.
        :type entity_id: str
        :param headers: Additional email headers for customization that can be provided in a form of JSON. Example: `headers={\\\"X-CustomHeader\\\": \\\"Header value\\\"}`.  There are a few exceptions of headers which are not adjustable through this option: `To`, `Cc`, `Bcc`, `From`, `Subject`,`Content-Type`, `DKIM-Signature`, `Content-Transfer-Encoding`, `Return-Path`, `MIME-Version`
        :type headers: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._send_email_serialize(
            to=to,
            var_from=var_from,
            cc=cc,
            bcc=bcc,
            subject=subject,
            text=text,
            html=html,
            amp_html=amp_html,
            template_id=template_id,
            attachment=attachment,
            inline_image=inline_image,
            intermediate_report=intermediate_report,
            notify_url=notify_url,
            notify_content_type=notify_content_type,
            callback_data=callback_data,
            track=track,
            track_clicks=track_clicks,
            track_opens=track_opens,
            tracking_url=tracking_url,
            bulk_id=bulk_id,
            message_id=message_id,
            campaign_reference_id=campaign_reference_id,
            reply_to=reply_to,
            default_placeholders=default_placeholders,
            preserve_recipients=preserve_recipients,
            send_at=send_at,
            landing_page_placeholders=landing_page_placeholders,
            landing_page_id=landing_page_id,
            template_language_version=template_language_version,
            client_priority=client_priority,
            application_id=application_id,
            entity_id=entity_id,
            headers=headers,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "EmailSendResponse",
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def send_email_with_http_info(
        self,
        to: Annotated[
            List[Annotated[str, Field(strict=True)]],
            Field(
                description='Email address of the recipient in a form of `To=\\"john.smith@somecompany.com\\"`. As optional feature on this field, a specific placeholder can be defined whose value will apply only for this destination. Given `To` value should look like: `To= {\\"to\\": \\"john.smith@somecompany.com\\",\\"placeholders\\": {\\"name\\": \\"John\\"}}` `To= {\\"to\\": \\"alice.grey@somecompany.com\\",\\"placeholders\\": {\\"name\\": \\"Alice\\"}}`.  Note: Maximum number of recipients per request is 1000 overall including to, cc and bcc field.'
            ),
        ],
        var_from: Annotated[
            Optional[StrictStr],
            Field(
                description="Email address with optional sender name.  Note: This field is required if `templateId` is not present."
            ),
        ] = None,
        cc: Annotated[
            Optional[List[Annotated[str, Field(strict=True)]]],
            Field(
                description="CC recipient email address. As optional feature on this field, a specific placeholder can be defined whose value will apply only for this destination.  Note: Maximum number of recipients per request is 1000 overall including to, cc and bcc field."
            ),
        ] = None,
        bcc: Annotated[
            Optional[List[Annotated[str, Field(strict=True)]]],
            Field(
                description="BCC recipient email address. As optional feature on this field, a specific placeholder can be defined whose value will apply only for this destination.  Note: Maximum number of recipients per request is 1000 overall including to, cc and bcc field."
            ),
        ] = None,
        subject: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="Message subject.  Note: This field is required if `templateId` is not present."
            ),
        ] = None,
        text: Annotated[
            Optional[StrictStr], Field(description="Body of the message.")
        ] = None,
        html: Annotated[
            Optional[StrictStr],
            Field(
                description="HTML body of the message. If `html` and `text` fields are present, the `text` field will be ignored and `html` will be delivered as a message body."
            ),
        ] = None,
        amp_html: Annotated[
            Optional[StrictStr],
            Field(
                description="Amp HTML body of the message. If `ampHtml` is present, `html` is mandatory. Amp HTML is not supported by all the email clients. Please check this link for configuring gmail client https://developers.google.com/gmail/ampemail/."
            ),
        ] = None,
        template_id: Annotated[
            Optional[StrictInt],
            Field(
                description="Template ID used for generating email content. The template is created over Infobip web interface. If `templateId` is present, then `html` and `text` values are ignored.  Note: `templateId` only supports the value of `Broadcast`. `Content` and `Flow` are not supported."
            ),
        ] = None,
        attachment: Annotated[
            Optional[List[Union[StrictBytes, StrictStr]]],
            Field(description="File attachment."),
        ] = None,
        inline_image: Annotated[
            Optional[List[Union[StrictBytes, StrictStr]]],
            Field(
                description="Allows for inserting an image file inside the HTML code of the email by using `cid:FILENAME` instead of providing an external link to the image."
            ),
        ] = None,
        intermediate_report: Annotated[
            Optional[StrictBool],
            Field(
                description="The real-time Intermediate delivery report that will be sent on your callback server."
            ),
        ] = None,
        notify_url: Annotated[
            Optional[StrictStr],
            Field(
                description="The URL on your callback server on which the Delivery report will be sent."
            ),
        ] = None,
        notify_content_type: Annotated[
            Optional[StrictStr],
            Field(
                description="Preferred Delivery report content type. Can be `application/json` or `application/xml`."
            ),
        ] = None,
        callback_data: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="Additional client data that will be sent on the notifyUrl."
            ),
        ] = None,
        track: Annotated[
            Optional[StrictBool],
            Field(
                description="Enable or disable open and click tracking. Passing true will only enable tracking and the statistics would be visible in the web interface alone. This can be explicitly overridden by `trackClicks` and `trackOpens`."
            ),
        ] = None,
        track_clicks: Annotated[
            Optional[StrictBool],
            Field(
                description="This parameter enables or disables track click feature.  Note: Option to disable click tracking per URL is available. For detailed usage, please refer to the [documentation](https://www.infobip.com/docs/email/tracking-service#disable-click-tracking-on-urls)."
            ),
        ] = None,
        track_opens: Annotated[
            Optional[StrictBool],
            Field(description="This parameter enables or disables track open feature."),
        ] = None,
        tracking_url: Annotated[
            Optional[StrictStr],
            Field(
                description="The URL on your callback server on which the open and click notifications will be sent. See [Tracking Notifications](https://www.infobip.com/docs/email/send-email-over-api#tracking-notifications) for details."
            ),
        ] = None,
        bulk_id: Annotated[
            Optional[StrictStr],
            Field(
                description="The ID uniquely identifies the sent email request. This filter will enable you to query delivery reports for all the messages using just one request. You will receive a `bulkId` in the response after sending an email request. If you don't set your own `bulkId`, unique ID will be generated by our system and returned in the API response. (Optional Field)"
            ),
        ] = None,
        message_id: Annotated[
            Optional[StrictStr],
            Field(
                description="The ID that uniquely identifies the message sent to a recipient. (Optional Field)"
            ),
        ] = None,
        campaign_reference_id: Annotated[
            Optional[StrictStr],
            Field(
                description="The ID that allows you to track, analyze, and show an aggregated overview and the performance of individual campaigns."
            ),
        ] = None,
        reply_to: Annotated[
            Optional[StrictStr],
            Field(
                description="Email address to which recipients of the email can reply."
            ),
        ] = None,
        default_placeholders: Annotated[
            Optional[StrictStr],
            Field(
                description='General placeholder, given in a form of json example: `defaultPlaceholders={\\"ph1\\": \\"Success\\"}`, which will replace given key `{{ph1}}` with given value `Success` anywhere in the email (subject, text, html...). In case of more destinations in `To` field, this placeholder will resolve the same value for key `ph1`.'
            ),
        ] = None,
        preserve_recipients: Annotated[
            Optional[StrictBool],
            Field(
                description="If set to `true`, the `to` recipients will see the list of all other recipients to get the email and the response will return only one `messageId`. Otherwise, each recipient will see just their own email and the response will return a unique `messageId` for each email recipient."
            ),
        ] = None,
        send_at: Annotated[
            Optional[datetime],
            Field(
                description="To schedule message at a given time. Time provided should be in UTC in the following format: `yyyy-MM-dd'T'HH:mm:ss.SSSZ` and cannot exceed 30 days in the future. "
            ),
        ] = None,
        landing_page_placeholders: Annotated[
            Optional[StrictStr],
            Field(
                description="Personalize opt out landing page by inserting placeholders. Insert placeholder or tag while designing landing page."
            ),
        ] = None,
        landing_page_id: Annotated[
            Optional[StrictStr],
            Field(
                description="The ID of an opt out landing page to be used and displayed once an end user clicks the unsubscribe link. If not present, default opt out landing page will be displayed. Create a landing page in your Infobip account and use its ID, e.g., `1_23456`."
            ),
        ] = None,
        template_language_version: Annotated[
            Optional[StrictStr],
            Field(
                description="Specifies template language version that will be used in the current message template. Use version 1 for previous version of template language. Use version 2 for features of the new template language. If not present version 1 will be used as default version. "
            ),
        ] = None,
        client_priority: Annotated[
            Optional[StrictStr],
            Field(
                description="Adds a priority rating to this email message. Allowed values are `HIGH`, `STANDARD` and `LOW`. Messages with a higher priority value sent by your account are prioritized over messages with a lower priority value sent by your account. If no priority value is provided, messages will be treated with `STANDARD` priority by default."
            ),
        ] = None,
        application_id: Annotated[
            Optional[StrictStr],
            Field(
                description="Required for application use in a send request for outbound traffic. Returned in notification events."
            ),
        ] = None,
        entity_id: Annotated[
            Optional[StrictStr],
            Field(
                description="Required for entity use in a send request for outbound traffic. Returned in notification events."
            ),
        ] = None,
        headers: Annotated[
            Optional[StrictStr],
            Field(
                description='Additional email headers for customization that can be provided in a form of JSON. Example: `headers={\\"X-CustomHeader\\": \\"Header value\\"}`.  There are a few exceptions of headers which are not adjustable through this option: `To`, `Cc`, `Bcc`, `From`, `Subject`,`Content-Type`, `DKIM-Signature`, `Content-Transfer-Encoding`, `Return-Path`, `MIME-Version`'
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[EmailSendResponse]:
        """Send fully featured email

        Send an email or multiple emails to a recipient or multiple recipients with CC/BCC enabled.

        :param to: Email address of the recipient in a form of `To=\\\"john.smith@somecompany.com\\\"`. As optional feature on this field, a specific placeholder can be defined whose value will apply only for this destination. Given `To` value should look like: `To= {\\\"to\\\": \\\"john.smith@somecompany.com\\\",\\\"placeholders\\\": {\\\"name\\\": \\\"John\\\"}}` `To= {\\\"to\\\": \\\"alice.grey@somecompany.com\\\",\\\"placeholders\\\": {\\\"name\\\": \\\"Alice\\\"}}`.  Note: Maximum number of recipients per request is 1000 overall including to, cc and bcc field. (required)
        :type to: List[str]
        :param var_from: Email address with optional sender name.  Note: This field is required if `templateId` is not present.
        :type var_from: str
        :param cc: CC recipient email address. As optional feature on this field, a specific placeholder can be defined whose value will apply only for this destination.  Note: Maximum number of recipients per request is 1000 overall including to, cc and bcc field.
        :type cc: List[str]
        :param bcc: BCC recipient email address. As optional feature on this field, a specific placeholder can be defined whose value will apply only for this destination.  Note: Maximum number of recipients per request is 1000 overall including to, cc and bcc field.
        :type bcc: List[str]
        :param subject: Message subject.  Note: This field is required if `templateId` is not present.
        :type subject: str
        :param text: Body of the message.
        :type text: str
        :param html: HTML body of the message. If `html` and `text` fields are present, the `text` field will be ignored and `html` will be delivered as a message body.
        :type html: str
        :param amp_html: Amp HTML body of the message. If `ampHtml` is present, `html` is mandatory. Amp HTML is not supported by all the email clients. Please check this link for configuring gmail client https://developers.google.com/gmail/ampemail/.
        :type amp_html: str
        :param template_id: Template ID used for generating email content. The template is created over Infobip web interface. If `templateId` is present, then `html` and `text` values are ignored.  Note: `templateId` only supports the value of `Broadcast`. `Content` and `Flow` are not supported.
        :type template_id: int
        :param attachment: File attachment.
        :type attachment: List[bytearray]
        :param inline_image: Allows for inserting an image file inside the HTML code of the email by using `cid:FILENAME` instead of providing an external link to the image.
        :type inline_image: List[bytearray]
        :param intermediate_report: The real-time Intermediate delivery report that will be sent on your callback server.
        :type intermediate_report: bool
        :param notify_url: The URL on your callback server on which the Delivery report will be sent.
        :type notify_url: str
        :param notify_content_type: Preferred Delivery report content type. Can be `application/json` or `application/xml`.
        :type notify_content_type: str
        :param callback_data: Additional client data that will be sent on the notifyUrl.
        :type callback_data: str
        :param track: Enable or disable open and click tracking. Passing true will only enable tracking and the statistics would be visible in the web interface alone. This can be explicitly overridden by `trackClicks` and `trackOpens`.
        :type track: bool
        :param track_clicks: This parameter enables or disables track click feature.  Note: Option to disable click tracking per URL is available. For detailed usage, please refer to the [documentation](https://www.infobip.com/docs/email/tracking-service#disable-click-tracking-on-urls).
        :type track_clicks: bool
        :param track_opens: This parameter enables or disables track open feature.
        :type track_opens: bool
        :param tracking_url: The URL on your callback server on which the open and click notifications will be sent. See [Tracking Notifications](https://www.infobip.com/docs/email/send-email-over-api#tracking-notifications) for details.
        :type tracking_url: str
        :param bulk_id: The ID uniquely identifies the sent email request. This filter will enable you to query delivery reports for all the messages using just one request. You will receive a `bulkId` in the response after sending an email request. If you don't set your own `bulkId`, unique ID will be generated by our system and returned in the API response. (Optional Field)
        :type bulk_id: str
        :param message_id: The ID that uniquely identifies the message sent to a recipient. (Optional Field)
        :type message_id: str
        :param campaign_reference_id: The ID that allows you to track, analyze, and show an aggregated overview and the performance of individual campaigns.
        :type campaign_reference_id: str
        :param reply_to: Email address to which recipients of the email can reply.
        :type reply_to: str
        :param default_placeholders: General placeholder, given in a form of json example: `defaultPlaceholders={\\\"ph1\\\": \\\"Success\\\"}`, which will replace given key `{{ph1}}` with given value `Success` anywhere in the email (subject, text, html...). In case of more destinations in `To` field, this placeholder will resolve the same value for key `ph1`.
        :type default_placeholders: str
        :param preserve_recipients: If set to `true`, the `to` recipients will see the list of all other recipients to get the email and the response will return only one `messageId`. Otherwise, each recipient will see just their own email and the response will return a unique `messageId` for each email recipient.
        :type preserve_recipients: bool
        :param send_at: To schedule message at a given time. Time provided should be in UTC in the following format: `yyyy-MM-dd'T'HH:mm:ss.SSSZ` and cannot exceed 30 days in the future.
        :type send_at: datetime
        :param landing_page_placeholders: Personalize opt out landing page by inserting placeholders. Insert placeholder or tag while designing landing page.
        :type landing_page_placeholders: str
        :param landing_page_id: The ID of an opt out landing page to be used and displayed once an end user clicks the unsubscribe link. If not present, default opt out landing page will be displayed. Create a landing page in your Infobip account and use its ID, e.g., `1_23456`.
        :type landing_page_id: str
        :param template_language_version: Specifies template language version that will be used in the current message template. Use version 1 for previous version of template language. Use version 2 for features of the new template language. If not present version 1 will be used as default version.
        :type template_language_version: str
        :param client_priority: Adds a priority rating to this email message. Allowed values are `HIGH`, `STANDARD` and `LOW`. Messages with a higher priority value sent by your account are prioritized over messages with a lower priority value sent by your account. If no priority value is provided, messages will be treated with `STANDARD` priority by default.
        :type client_priority: str
        :param application_id: Required for application use in a send request for outbound traffic. Returned in notification events.
        :type application_id: str
        :param entity_id: Required for entity use in a send request for outbound traffic. Returned in notification events.
        :type entity_id: str
        :param headers: Additional email headers for customization that can be provided in a form of JSON. Example: `headers={\\\"X-CustomHeader\\\": \\\"Header value\\\"}`.  There are a few exceptions of headers which are not adjustable through this option: `To`, `Cc`, `Bcc`, `From`, `Subject`,`Content-Type`, `DKIM-Signature`, `Content-Transfer-Encoding`, `Return-Path`, `MIME-Version`
        :type headers: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._send_email_serialize(
            to=to,
            var_from=var_from,
            cc=cc,
            bcc=bcc,
            subject=subject,
            text=text,
            html=html,
            amp_html=amp_html,
            template_id=template_id,
            attachment=attachment,
            inline_image=inline_image,
            intermediate_report=intermediate_report,
            notify_url=notify_url,
            notify_content_type=notify_content_type,
            callback_data=callback_data,
            track=track,
            track_clicks=track_clicks,
            track_opens=track_opens,
            tracking_url=tracking_url,
            bulk_id=bulk_id,
            message_id=message_id,
            campaign_reference_id=campaign_reference_id,
            reply_to=reply_to,
            default_placeholders=default_placeholders,
            preserve_recipients=preserve_recipients,
            send_at=send_at,
            landing_page_placeholders=landing_page_placeholders,
            landing_page_id=landing_page_id,
            template_language_version=template_language_version,
            client_priority=client_priority,
            application_id=application_id,
            entity_id=entity_id,
            headers=headers,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "EmailSendResponse",
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def send_email_without_preload_content(
        self,
        to: Annotated[
            List[Annotated[str, Field(strict=True)]],
            Field(
                description='Email address of the recipient in a form of `To=\\"john.smith@somecompany.com\\"`. As optional feature on this field, a specific placeholder can be defined whose value will apply only for this destination. Given `To` value should look like: `To= {\\"to\\": \\"john.smith@somecompany.com\\",\\"placeholders\\": {\\"name\\": \\"John\\"}}` `To= {\\"to\\": \\"alice.grey@somecompany.com\\",\\"placeholders\\": {\\"name\\": \\"Alice\\"}}`.  Note: Maximum number of recipients per request is 1000 overall including to, cc and bcc field.'
            ),
        ],
        var_from: Annotated[
            Optional[StrictStr],
            Field(
                description="Email address with optional sender name.  Note: This field is required if `templateId` is not present."
            ),
        ] = None,
        cc: Annotated[
            Optional[List[Annotated[str, Field(strict=True)]]],
            Field(
                description="CC recipient email address. As optional feature on this field, a specific placeholder can be defined whose value will apply only for this destination.  Note: Maximum number of recipients per request is 1000 overall including to, cc and bcc field."
            ),
        ] = None,
        bcc: Annotated[
            Optional[List[Annotated[str, Field(strict=True)]]],
            Field(
                description="BCC recipient email address. As optional feature on this field, a specific placeholder can be defined whose value will apply only for this destination.  Note: Maximum number of recipients per request is 1000 overall including to, cc and bcc field."
            ),
        ] = None,
        subject: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="Message subject.  Note: This field is required if `templateId` is not present."
            ),
        ] = None,
        text: Annotated[
            Optional[StrictStr], Field(description="Body of the message.")
        ] = None,
        html: Annotated[
            Optional[StrictStr],
            Field(
                description="HTML body of the message. If `html` and `text` fields are present, the `text` field will be ignored and `html` will be delivered as a message body."
            ),
        ] = None,
        amp_html: Annotated[
            Optional[StrictStr],
            Field(
                description="Amp HTML body of the message. If `ampHtml` is present, `html` is mandatory. Amp HTML is not supported by all the email clients. Please check this link for configuring gmail client https://developers.google.com/gmail/ampemail/."
            ),
        ] = None,
        template_id: Annotated[
            Optional[StrictInt],
            Field(
                description="Template ID used for generating email content. The template is created over Infobip web interface. If `templateId` is present, then `html` and `text` values are ignored.  Note: `templateId` only supports the value of `Broadcast`. `Content` and `Flow` are not supported."
            ),
        ] = None,
        attachment: Annotated[
            Optional[List[Union[StrictBytes, StrictStr]]],
            Field(description="File attachment."),
        ] = None,
        inline_image: Annotated[
            Optional[List[Union[StrictBytes, StrictStr]]],
            Field(
                description="Allows for inserting an image file inside the HTML code of the email by using `cid:FILENAME` instead of providing an external link to the image."
            ),
        ] = None,
        intermediate_report: Annotated[
            Optional[StrictBool],
            Field(
                description="The real-time Intermediate delivery report that will be sent on your callback server."
            ),
        ] = None,
        notify_url: Annotated[
            Optional[StrictStr],
            Field(
                description="The URL on your callback server on which the Delivery report will be sent."
            ),
        ] = None,
        notify_content_type: Annotated[
            Optional[StrictStr],
            Field(
                description="Preferred Delivery report content type. Can be `application/json` or `application/xml`."
            ),
        ] = None,
        callback_data: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description="Additional client data that will be sent on the notifyUrl."
            ),
        ] = None,
        track: Annotated[
            Optional[StrictBool],
            Field(
                description="Enable or disable open and click tracking. Passing true will only enable tracking and the statistics would be visible in the web interface alone. This can be explicitly overridden by `trackClicks` and `trackOpens`."
            ),
        ] = None,
        track_clicks: Annotated[
            Optional[StrictBool],
            Field(
                description="This parameter enables or disables track click feature.  Note: Option to disable click tracking per URL is available. For detailed usage, please refer to the [documentation](https://www.infobip.com/docs/email/tracking-service#disable-click-tracking-on-urls)."
            ),
        ] = None,
        track_opens: Annotated[
            Optional[StrictBool],
            Field(description="This parameter enables or disables track open feature."),
        ] = None,
        tracking_url: Annotated[
            Optional[StrictStr],
            Field(
                description="The URL on your callback server on which the open and click notifications will be sent. See [Tracking Notifications](https://www.infobip.com/docs/email/send-email-over-api#tracking-notifications) for details."
            ),
        ] = None,
        bulk_id: Annotated[
            Optional[StrictStr],
            Field(
                description="The ID uniquely identifies the sent email request. This filter will enable you to query delivery reports for all the messages using just one request. You will receive a `bulkId` in the response after sending an email request. If you don't set your own `bulkId`, unique ID will be generated by our system and returned in the API response. (Optional Field)"
            ),
        ] = None,
        message_id: Annotated[
            Optional[StrictStr],
            Field(
                description="The ID that uniquely identifies the message sent to a recipient. (Optional Field)"
            ),
        ] = None,
        campaign_reference_id: Annotated[
            Optional[StrictStr],
            Field(
                description="The ID that allows you to track, analyze, and show an aggregated overview and the performance of individual campaigns."
            ),
        ] = None,
        reply_to: Annotated[
            Optional[StrictStr],
            Field(
                description="Email address to which recipients of the email can reply."
            ),
        ] = None,
        default_placeholders: Annotated[
            Optional[StrictStr],
            Field(
                description='General placeholder, given in a form of json example: `defaultPlaceholders={\\"ph1\\": \\"Success\\"}`, which will replace given key `{{ph1}}` with given value `Success` anywhere in the email (subject, text, html...). In case of more destinations in `To` field, this placeholder will resolve the same value for key `ph1`.'
            ),
        ] = None,
        preserve_recipients: Annotated[
            Optional[StrictBool],
            Field(
                description="If set to `true`, the `to` recipients will see the list of all other recipients to get the email and the response will return only one `messageId`. Otherwise, each recipient will see just their own email and the response will return a unique `messageId` for each email recipient."
            ),
        ] = None,
        send_at: Annotated[
            Optional[datetime],
            Field(
                description="To schedule message at a given time. Time provided should be in UTC in the following format: `yyyy-MM-dd'T'HH:mm:ss.SSSZ` and cannot exceed 30 days in the future. "
            ),
        ] = None,
        landing_page_placeholders: Annotated[
            Optional[StrictStr],
            Field(
                description="Personalize opt out landing page by inserting placeholders. Insert placeholder or tag while designing landing page."
            ),
        ] = None,
        landing_page_id: Annotated[
            Optional[StrictStr],
            Field(
                description="The ID of an opt out landing page to be used and displayed once an end user clicks the unsubscribe link. If not present, default opt out landing page will be displayed. Create a landing page in your Infobip account and use its ID, e.g., `1_23456`."
            ),
        ] = None,
        template_language_version: Annotated[
            Optional[StrictStr],
            Field(
                description="Specifies template language version that will be used in the current message template. Use version 1 for previous version of template language. Use version 2 for features of the new template language. If not present version 1 will be used as default version. "
            ),
        ] = None,
        client_priority: Annotated[
            Optional[StrictStr],
            Field(
                description="Adds a priority rating to this email message. Allowed values are `HIGH`, `STANDARD` and `LOW`. Messages with a higher priority value sent by your account are prioritized over messages with a lower priority value sent by your account. If no priority value is provided, messages will be treated with `STANDARD` priority by default."
            ),
        ] = None,
        application_id: Annotated[
            Optional[StrictStr],
            Field(
                description="Required for application use in a send request for outbound traffic. Returned in notification events."
            ),
        ] = None,
        entity_id: Annotated[
            Optional[StrictStr],
            Field(
                description="Required for entity use in a send request for outbound traffic. Returned in notification events."
            ),
        ] = None,
        headers: Annotated[
            Optional[StrictStr],
            Field(
                description='Additional email headers for customization that can be provided in a form of JSON. Example: `headers={\\"X-CustomHeader\\": \\"Header value\\"}`.  There are a few exceptions of headers which are not adjustable through this option: `To`, `Cc`, `Bcc`, `From`, `Subject`,`Content-Type`, `DKIM-Signature`, `Content-Transfer-Encoding`, `Return-Path`, `MIME-Version`'
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Send fully featured email

        Send an email or multiple emails to a recipient or multiple recipients with CC/BCC enabled.

        :param to: Email address of the recipient in a form of `To=\\\"john.smith@somecompany.com\\\"`. As optional feature on this field, a specific placeholder can be defined whose value will apply only for this destination. Given `To` value should look like: `To= {\\\"to\\\": \\\"john.smith@somecompany.com\\\",\\\"placeholders\\\": {\\\"name\\\": \\\"John\\\"}}` `To= {\\\"to\\\": \\\"alice.grey@somecompany.com\\\",\\\"placeholders\\\": {\\\"name\\\": \\\"Alice\\\"}}`.  Note: Maximum number of recipients per request is 1000 overall including to, cc and bcc field. (required)
        :type to: List[str]
        :param var_from: Email address with optional sender name.  Note: This field is required if `templateId` is not present.
        :type var_from: str
        :param cc: CC recipient email address. As optional feature on this field, a specific placeholder can be defined whose value will apply only for this destination.  Note: Maximum number of recipients per request is 1000 overall including to, cc and bcc field.
        :type cc: List[str]
        :param bcc: BCC recipient email address. As optional feature on this field, a specific placeholder can be defined whose value will apply only for this destination.  Note: Maximum number of recipients per request is 1000 overall including to, cc and bcc field.
        :type bcc: List[str]
        :param subject: Message subject.  Note: This field is required if `templateId` is not present.
        :type subject: str
        :param text: Body of the message.
        :type text: str
        :param html: HTML body of the message. If `html` and `text` fields are present, the `text` field will be ignored and `html` will be delivered as a message body.
        :type html: str
        :param amp_html: Amp HTML body of the message. If `ampHtml` is present, `html` is mandatory. Amp HTML is not supported by all the email clients. Please check this link for configuring gmail client https://developers.google.com/gmail/ampemail/.
        :type amp_html: str
        :param template_id: Template ID used for generating email content. The template is created over Infobip web interface. If `templateId` is present, then `html` and `text` values are ignored.  Note: `templateId` only supports the value of `Broadcast`. `Content` and `Flow` are not supported.
        :type template_id: int
        :param attachment: File attachment.
        :type attachment: List[bytearray]
        :param inline_image: Allows for inserting an image file inside the HTML code of the email by using `cid:FILENAME` instead of providing an external link to the image.
        :type inline_image: List[bytearray]
        :param intermediate_report: The real-time Intermediate delivery report that will be sent on your callback server.
        :type intermediate_report: bool
        :param notify_url: The URL on your callback server on which the Delivery report will be sent.
        :type notify_url: str
        :param notify_content_type: Preferred Delivery report content type. Can be `application/json` or `application/xml`.
        :type notify_content_type: str
        :param callback_data: Additional client data that will be sent on the notifyUrl.
        :type callback_data: str
        :param track: Enable or disable open and click tracking. Passing true will only enable tracking and the statistics would be visible in the web interface alone. This can be explicitly overridden by `trackClicks` and `trackOpens`.
        :type track: bool
        :param track_clicks: This parameter enables or disables track click feature.  Note: Option to disable click tracking per URL is available. For detailed usage, please refer to the [documentation](https://www.infobip.com/docs/email/tracking-service#disable-click-tracking-on-urls).
        :type track_clicks: bool
        :param track_opens: This parameter enables or disables track open feature.
        :type track_opens: bool
        :param tracking_url: The URL on your callback server on which the open and click notifications will be sent. See [Tracking Notifications](https://www.infobip.com/docs/email/send-email-over-api#tracking-notifications) for details.
        :type tracking_url: str
        :param bulk_id: The ID uniquely identifies the sent email request. This filter will enable you to query delivery reports for all the messages using just one request. You will receive a `bulkId` in the response after sending an email request. If you don't set your own `bulkId`, unique ID will be generated by our system and returned in the API response. (Optional Field)
        :type bulk_id: str
        :param message_id: The ID that uniquely identifies the message sent to a recipient. (Optional Field)
        :type message_id: str
        :param campaign_reference_id: The ID that allows you to track, analyze, and show an aggregated overview and the performance of individual campaigns.
        :type campaign_reference_id: str
        :param reply_to: Email address to which recipients of the email can reply.
        :type reply_to: str
        :param default_placeholders: General placeholder, given in a form of json example: `defaultPlaceholders={\\\"ph1\\\": \\\"Success\\\"}`, which will replace given key `{{ph1}}` with given value `Success` anywhere in the email (subject, text, html...). In case of more destinations in `To` field, this placeholder will resolve the same value for key `ph1`.
        :type default_placeholders: str
        :param preserve_recipients: If set to `true`, the `to` recipients will see the list of all other recipients to get the email and the response will return only one `messageId`. Otherwise, each recipient will see just their own email and the response will return a unique `messageId` for each email recipient.
        :type preserve_recipients: bool
        :param send_at: To schedule message at a given time. Time provided should be in UTC in the following format: `yyyy-MM-dd'T'HH:mm:ss.SSSZ` and cannot exceed 30 days in the future.
        :type send_at: datetime
        :param landing_page_placeholders: Personalize opt out landing page by inserting placeholders. Insert placeholder or tag while designing landing page.
        :type landing_page_placeholders: str
        :param landing_page_id: The ID of an opt out landing page to be used and displayed once an end user clicks the unsubscribe link. If not present, default opt out landing page will be displayed. Create a landing page in your Infobip account and use its ID, e.g., `1_23456`.
        :type landing_page_id: str
        :param template_language_version: Specifies template language version that will be used in the current message template. Use version 1 for previous version of template language. Use version 2 for features of the new template language. If not present version 1 will be used as default version.
        :type template_language_version: str
        :param client_priority: Adds a priority rating to this email message. Allowed values are `HIGH`, `STANDARD` and `LOW`. Messages with a higher priority value sent by your account are prioritized over messages with a lower priority value sent by your account. If no priority value is provided, messages will be treated with `STANDARD` priority by default.
        :type client_priority: str
        :param application_id: Required for application use in a send request for outbound traffic. Returned in notification events.
        :type application_id: str
        :param entity_id: Required for entity use in a send request for outbound traffic. Returned in notification events.
        :type entity_id: str
        :param headers: Additional email headers for customization that can be provided in a form of JSON. Example: `headers={\\\"X-CustomHeader\\\": \\\"Header value\\\"}`.  There are a few exceptions of headers which are not adjustable through this option: `To`, `Cc`, `Bcc`, `From`, `Subject`,`Content-Type`, `DKIM-Signature`, `Content-Transfer-Encoding`, `Return-Path`, `MIME-Version`
        :type headers: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._send_email_serialize(
            to=to,
            var_from=var_from,
            cc=cc,
            bcc=bcc,
            subject=subject,
            text=text,
            html=html,
            amp_html=amp_html,
            template_id=template_id,
            attachment=attachment,
            inline_image=inline_image,
            intermediate_report=intermediate_report,
            notify_url=notify_url,
            notify_content_type=notify_content_type,
            callback_data=callback_data,
            track=track,
            track_clicks=track_clicks,
            track_opens=track_opens,
            tracking_url=tracking_url,
            bulk_id=bulk_id,
            message_id=message_id,
            campaign_reference_id=campaign_reference_id,
            reply_to=reply_to,
            default_placeholders=default_placeholders,
            preserve_recipients=preserve_recipients,
            send_at=send_at,
            landing_page_placeholders=landing_page_placeholders,
            landing_page_id=landing_page_id,
            template_language_version=template_language_version,
            client_priority=client_priority,
            application_id=application_id,
            entity_id=entity_id,
            headers=headers,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "EmailSendResponse",
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _send_email_serialize(
        self,
        to,
        var_from,
        cc,
        bcc,
        subject,
        text,
        html,
        amp_html,
        template_id,
        attachment,
        inline_image,
        intermediate_report,
        notify_url,
        notify_content_type,
        callback_data,
        track,
        track_clicks,
        track_opens,
        tracking_url,
        bulk_id,
        message_id,
        campaign_reference_id,
        reply_to,
        default_placeholders,
        preserve_recipients,
        send_at,
        landing_page_placeholders,
        landing_page_id,
        template_language_version,
        client_priority,
        application_id,
        entity_id,
        headers,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            "to": "multi",
            "cc": "multi",
            "bcc": "multi",
            "attachment": "multi",
            "inlineImage": "multi",
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        if var_from is not None:
            _form_params.append(("from", var_from))
        if to is not None:
            _form_params.append(("to", to))
        if cc is not None:
            _form_params.append(("cc", cc))
        if bcc is not None:
            _form_params.append(("bcc", bcc))
        if subject is not None:
            _form_params.append(("subject", subject))
        if text is not None:
            _form_params.append(("text", text))
        if html is not None:
            _form_params.append(("html", html))
        if amp_html is not None:
            _form_params.append(("ampHtml", amp_html))
        if template_id is not None:
            _form_params.append(("templateId", template_id))
        if attachment is not None:
            _files["attachment"] = attachment
        if inline_image is not None:
            _files["inlineImage"] = inline_image
        if intermediate_report is not None:
            _form_params.append(("intermediateReport", intermediate_report))
        if notify_url is not None:
            _form_params.append(("notifyUrl", notify_url))
        if notify_content_type is not None:
            _form_params.append(("notifyContentType", notify_content_type))
        if callback_data is not None:
            _form_params.append(("callbackData", callback_data))
        if track is not None:
            _form_params.append(("track", track))
        if track_clicks is not None:
            _form_params.append(("trackClicks", track_clicks))
        if track_opens is not None:
            _form_params.append(("trackOpens", track_opens))
        if tracking_url is not None:
            _form_params.append(("trackingUrl", tracking_url))
        if bulk_id is not None:
            _form_params.append(("bulkId", bulk_id))
        if message_id is not None:
            _form_params.append(("messageId", message_id))
        if campaign_reference_id is not None:
            _form_params.append(("campaignReferenceId", campaign_reference_id))
        if reply_to is not None:
            _form_params.append(("replyTo", reply_to))
        if default_placeholders is not None:
            _form_params.append(("defaultPlaceholders", default_placeholders))
        if preserve_recipients is not None:
            _form_params.append(("preserveRecipients", preserve_recipients))
        if send_at is not None:
            _form_params.append(("sendAt", send_at))
        if landing_page_placeholders is not None:
            _form_params.append(("landingPagePlaceholders", landing_page_placeholders))
        if landing_page_id is not None:
            _form_params.append(("landingPageId", landing_page_id))
        if template_language_version is not None:
            _form_params.append(("templateLanguageVersion", template_language_version))
        if client_priority is not None:
            _form_params.append(("clientPriority", client_priority))
        if application_id is not None:
            _form_params.append(("applicationId", application_id))
        if entity_id is not None:
            _form_params.append(("entityId", entity_id))
        if headers is not None:
            _form_params.append(("headers", headers))
        # process the body parameter

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(
                ["multipart/form-data"]
            )
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/email/3/send",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def update_domain_pool_priority(
        self,
        domain_id: Annotated[
            int, Field(strict=True, ge=1, description="Domain identifier.")
        ],
        pool_id: Annotated[StrictStr, Field(description="IP pool identifier.")],
        email_domain_ip_pool_update_api_request: EmailDomainIpPoolUpdateApiRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Update IP pool sending priority

        Update specified pool's sending priority for the provided domain.

        :param domain_id: Domain identifier. (required)
        :type domain_id: int
        :param pool_id: IP pool identifier. (required)
        :type pool_id: str
        :param email_domain_ip_pool_update_api_request: (required)
        :type email_domain_ip_pool_update_api_request: EmailDomainIpPoolUpdateApiRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._update_domain_pool_priority_serialize(
            domain_id=domain_id,
            pool_id=pool_id,
            email_domain_ip_pool_update_api_request=email_domain_ip_pool_update_api_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "400": "ApiError",
            "401": "ApiError",
            "403": "ApiError",
            "404": "ApiError",
            "429": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def update_domain_pool_priority_with_http_info(
        self,
        domain_id: Annotated[
            int, Field(strict=True, ge=1, description="Domain identifier.")
        ],
        pool_id: Annotated[StrictStr, Field(description="IP pool identifier.")],
        email_domain_ip_pool_update_api_request: EmailDomainIpPoolUpdateApiRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Update IP pool sending priority

        Update specified pool's sending priority for the provided domain.

        :param domain_id: Domain identifier. (required)
        :type domain_id: int
        :param pool_id: IP pool identifier. (required)
        :type pool_id: str
        :param email_domain_ip_pool_update_api_request: (required)
        :type email_domain_ip_pool_update_api_request: EmailDomainIpPoolUpdateApiRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._update_domain_pool_priority_serialize(
            domain_id=domain_id,
            pool_id=pool_id,
            email_domain_ip_pool_update_api_request=email_domain_ip_pool_update_api_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "400": "ApiError",
            "401": "ApiError",
            "403": "ApiError",
            "404": "ApiError",
            "429": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def update_domain_pool_priority_without_preload_content(
        self,
        domain_id: Annotated[
            int, Field(strict=True, ge=1, description="Domain identifier.")
        ],
        pool_id: Annotated[StrictStr, Field(description="IP pool identifier.")],
        email_domain_ip_pool_update_api_request: EmailDomainIpPoolUpdateApiRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update IP pool sending priority

        Update specified pool's sending priority for the provided domain.

        :param domain_id: Domain identifier. (required)
        :type domain_id: int
        :param pool_id: IP pool identifier. (required)
        :type pool_id: str
        :param email_domain_ip_pool_update_api_request: (required)
        :type email_domain_ip_pool_update_api_request: EmailDomainIpPoolUpdateApiRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._update_domain_pool_priority_serialize(
            domain_id=domain_id,
            pool_id=pool_id,
            email_domain_ip_pool_update_api_request=email_domain_ip_pool_update_api_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "204": None,
            "400": "ApiError",
            "401": "ApiError",
            "403": "ApiError",
            "404": "ApiError",
            "429": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _update_domain_pool_priority_serialize(
        self,
        domain_id,
        pool_id,
        email_domain_ip_pool_update_api_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if domain_id is not None:
            _path_params["domainId"] = domain_id
        if pool_id is not None:
            _path_params["poolId"] = pool_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if email_domain_ip_pool_update_api_request is not None:
            _body_params = email_domain_ip_pool_update_api_request

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(
                ["application/json"]
            )
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="PUT",
            resource_path="/email/1/ip-management/domains/{domainId}/pools/{poolId}",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def update_ip_pool(
        self,
        pool_id: Annotated[StrictStr, Field(description="IP pool identifier.")],
        email_ip_pool_create_api_request: EmailIpPoolCreateApiRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> EmailIpPoolResponse:
        """Update IP pool

        Update a provided IP pool.

        :param pool_id: IP pool identifier. (required)
        :type pool_id: str
        :param email_ip_pool_create_api_request: (required)
        :type email_ip_pool_create_api_request: EmailIpPoolCreateApiRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._update_ip_pool_serialize(
            pool_id=pool_id,
            email_ip_pool_create_api_request=email_ip_pool_create_api_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "EmailIpPoolResponse",
            "400": "ApiError",
            "401": "ApiError",
            "403": "ApiError",
            "404": "ApiError",
            "429": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def update_ip_pool_with_http_info(
        self,
        pool_id: Annotated[StrictStr, Field(description="IP pool identifier.")],
        email_ip_pool_create_api_request: EmailIpPoolCreateApiRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[EmailIpPoolResponse]:
        """Update IP pool

        Update a provided IP pool.

        :param pool_id: IP pool identifier. (required)
        :type pool_id: str
        :param email_ip_pool_create_api_request: (required)
        :type email_ip_pool_create_api_request: EmailIpPoolCreateApiRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._update_ip_pool_serialize(
            pool_id=pool_id,
            email_ip_pool_create_api_request=email_ip_pool_create_api_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "EmailIpPoolResponse",
            "400": "ApiError",
            "401": "ApiError",
            "403": "ApiError",
            "404": "ApiError",
            "429": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def update_ip_pool_without_preload_content(
        self,
        pool_id: Annotated[StrictStr, Field(description="IP pool identifier.")],
        email_ip_pool_create_api_request: EmailIpPoolCreateApiRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update IP pool

        Update a provided IP pool.

        :param pool_id: IP pool identifier. (required)
        :type pool_id: str
        :param email_ip_pool_create_api_request: (required)
        :type email_ip_pool_create_api_request: EmailIpPoolCreateApiRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._update_ip_pool_serialize(
            pool_id=pool_id,
            email_ip_pool_create_api_request=email_ip_pool_create_api_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "EmailIpPoolResponse",
            "400": "ApiError",
            "401": "ApiError",
            "403": "ApiError",
            "404": "ApiError",
            "429": "ApiError",
            "500": "ApiError",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _update_ip_pool_serialize(
        self,
        pool_id,
        email_ip_pool_create_api_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if pool_id is not None:
            _path_params["poolId"] = pool_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if email_ip_pool_create_api_request is not None:
            _body_params = email_ip_pool_create_api_request

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(
                ["application/json"]
            )
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="PUT",
            resource_path="/email/1/ip-management/pools/{poolId}",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def update_return_path(
        self,
        domain_name: Annotated[
            StrictStr,
            Field(
                description="Domain for which the return path address needs to be updated."
            ),
        ],
        email_return_path_address_request: EmailReturnPathAddressRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> EmailDomainResponse:
        """Update return path

        API to update return path for the provided domain. The mailbox used for return path should be based on the same domain.

        :param domain_name: Domain for which the return path address needs to be updated. (required)
        :type domain_name: str
        :param email_return_path_address_request: (required)
        :type email_return_path_address_request: EmailReturnPathAddressRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._update_return_path_serialize(
            domain_name=domain_name,
            email_return_path_address_request=email_return_path_address_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "EmailDomainResponse",
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "404": "ApiException",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def update_return_path_with_http_info(
        self,
        domain_name: Annotated[
            StrictStr,
            Field(
                description="Domain for which the return path address needs to be updated."
            ),
        ],
        email_return_path_address_request: EmailReturnPathAddressRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[EmailDomainResponse]:
        """Update return path

        API to update return path for the provided domain. The mailbox used for return path should be based on the same domain.

        :param domain_name: Domain for which the return path address needs to be updated. (required)
        :type domain_name: str
        :param email_return_path_address_request: (required)
        :type email_return_path_address_request: EmailReturnPathAddressRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._update_return_path_serialize(
            domain_name=domain_name,
            email_return_path_address_request=email_return_path_address_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "EmailDomainResponse",
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "404": "ApiException",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def update_return_path_without_preload_content(
        self,
        domain_name: Annotated[
            StrictStr,
            Field(
                description="Domain for which the return path address needs to be updated."
            ),
        ],
        email_return_path_address_request: EmailReturnPathAddressRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update return path

        API to update return path for the provided domain. The mailbox used for return path should be based on the same domain.

        :param domain_name: Domain for which the return path address needs to be updated. (required)
        :type domain_name: str
        :param email_return_path_address_request: (required)
        :type email_return_path_address_request: EmailReturnPathAddressRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._update_return_path_serialize(
            domain_name=domain_name,
            email_return_path_address_request=email_return_path_address_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "EmailDomainResponse",
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "404": "ApiException",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _update_return_path_serialize(
        self,
        domain_name,
        email_return_path_address_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if domain_name is not None:
            _path_params["domainName"] = domain_name
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if email_return_path_address_request is not None:
            _body_params = email_return_path_address_request

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(
                ["application/json"]
            )
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="PUT",
            resource_path="/email/1/domains/{domainName}/return-path",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def update_scheduled_email_statuses(
        self,
        bulk_id: Annotated[
            StrictStr,
            Field(description="The ID uniquely identifies the sent email request."),
        ],
        email_bulk_update_status_request: EmailBulkUpdateStatusRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> EmailBulkUpdateStatusResponse:
        """Update scheduled Email messages status

        Change status or completely cancel sending of scheduled messages.

        :param bulk_id: The ID uniquely identifies the sent email request. (required)
        :type bulk_id: str
        :param email_bulk_update_status_request: (required)
        :type email_bulk_update_status_request: EmailBulkUpdateStatusRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._update_scheduled_email_statuses_serialize(
            bulk_id=bulk_id,
            email_bulk_update_status_request=email_bulk_update_status_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "EmailBulkUpdateStatusResponse",
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def update_scheduled_email_statuses_with_http_info(
        self,
        bulk_id: Annotated[
            StrictStr,
            Field(description="The ID uniquely identifies the sent email request."),
        ],
        email_bulk_update_status_request: EmailBulkUpdateStatusRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[EmailBulkUpdateStatusResponse]:
        """Update scheduled Email messages status

        Change status or completely cancel sending of scheduled messages.

        :param bulk_id: The ID uniquely identifies the sent email request. (required)
        :type bulk_id: str
        :param email_bulk_update_status_request: (required)
        :type email_bulk_update_status_request: EmailBulkUpdateStatusRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._update_scheduled_email_statuses_serialize(
            bulk_id=bulk_id,
            email_bulk_update_status_request=email_bulk_update_status_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "EmailBulkUpdateStatusResponse",
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def update_scheduled_email_statuses_without_preload_content(
        self,
        bulk_id: Annotated[
            StrictStr,
            Field(description="The ID uniquely identifies the sent email request."),
        ],
        email_bulk_update_status_request: EmailBulkUpdateStatusRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update scheduled Email messages status

        Change status or completely cancel sending of scheduled messages.

        :param bulk_id: The ID uniquely identifies the sent email request. (required)
        :type bulk_id: str
        :param email_bulk_update_status_request: (required)
        :type email_bulk_update_status_request: EmailBulkUpdateStatusRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._update_scheduled_email_statuses_serialize(
            bulk_id=bulk_id,
            email_bulk_update_status_request=email_bulk_update_status_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "EmailBulkUpdateStatusResponse",
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _update_scheduled_email_statuses_serialize(
        self,
        bulk_id,
        email_bulk_update_status_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if bulk_id is not None:

            _query_params.append(("bulkId", bulk_id))

        # process the header parameters
        # process the form parameters
        # process the body parameter
        if email_bulk_update_status_request is not None:
            _body_params = email_bulk_update_status_request

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(
                ["application/json"]
            )
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="PUT",
            resource_path="/email/1/bulks/status",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def update_tracking_events(
        self,
        domain_name: Annotated[
            StrictStr,
            Field(
                description="Domain for which the tracking events need to be updated."
            ),
        ],
        email_tracking_event_request: EmailTrackingEventRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> EmailDomainResponse:
        """Update tracking events

        API to update tracking events for the provided domain. Tracking events can be updated only for CLICKS, OPENS and UNSUBSCRIBES.

        :param domain_name: Domain for which the tracking events need to be updated. (required)
        :type domain_name: str
        :param email_tracking_event_request: (required)
        :type email_tracking_event_request: EmailTrackingEventRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._update_tracking_events_serialize(
            domain_name=domain_name,
            email_tracking_event_request=email_tracking_event_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "EmailDomainResponse",
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "404": "ApiException",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def update_tracking_events_with_http_info(
        self,
        domain_name: Annotated[
            StrictStr,
            Field(
                description="Domain for which the tracking events need to be updated."
            ),
        ],
        email_tracking_event_request: EmailTrackingEventRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[EmailDomainResponse]:
        """Update tracking events

        API to update tracking events for the provided domain. Tracking events can be updated only for CLICKS, OPENS and UNSUBSCRIBES.

        :param domain_name: Domain for which the tracking events need to be updated. (required)
        :type domain_name: str
        :param email_tracking_event_request: (required)
        :type email_tracking_event_request: EmailTrackingEventRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._update_tracking_events_serialize(
            domain_name=domain_name,
            email_tracking_event_request=email_tracking_event_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "EmailDomainResponse",
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "404": "ApiException",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def update_tracking_events_without_preload_content(
        self,
        domain_name: Annotated[
            StrictStr,
            Field(
                description="Domain for which the tracking events need to be updated."
            ),
        ],
        email_tracking_event_request: EmailTrackingEventRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update tracking events

        API to update tracking events for the provided domain. Tracking events can be updated only for CLICKS, OPENS and UNSUBSCRIBES.

        :param domain_name: Domain for which the tracking events need to be updated. (required)
        :type domain_name: str
        :param email_tracking_event_request: (required)
        :type email_tracking_event_request: EmailTrackingEventRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._update_tracking_events_serialize(
            domain_name=domain_name,
            email_tracking_event_request=email_tracking_event_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "EmailDomainResponse",
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "404": "ApiException",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _update_tracking_events_serialize(
        self,
        domain_name,
        email_tracking_event_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if domain_name is not None:
            _path_params["domainName"] = domain_name
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if email_tracking_event_request is not None:
            _body_params = email_tracking_event_request

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(
                ["application/json"]
            )
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="PUT",
            resource_path="/email/1/domains/{domainName}/tracking",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def validate_email_addresses(
        self,
        email_validation_request: EmailValidationRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> EmailValidationResponse:
        """Validate email addresses

        Run validation to identify poor quality emails to clean up your recipient list.

        :param email_validation_request: (required)
        :type email_validation_request: EmailValidationRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._validate_email_addresses_serialize(
            email_validation_request=email_validation_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "EmailValidationResponse",
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def validate_email_addresses_with_http_info(
        self,
        email_validation_request: EmailValidationRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[EmailValidationResponse]:
        """Validate email addresses

        Run validation to identify poor quality emails to clean up your recipient list.

        :param email_validation_request: (required)
        :type email_validation_request: EmailValidationRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._validate_email_addresses_serialize(
            email_validation_request=email_validation_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "EmailValidationResponse",
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def validate_email_addresses_without_preload_content(
        self,
        email_validation_request: EmailValidationRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Validate email addresses

        Run validation to identify poor quality emails to clean up your recipient list.

        :param email_validation_request: (required)
        :type email_validation_request: EmailValidationRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._validate_email_addresses_serialize(
            email_validation_request=email_validation_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "EmailValidationResponse",
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _validate_email_addresses_serialize(
        self,
        email_validation_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if email_validation_request is not None:
            _body_params = email_validation_request

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(
                ["application/json"]
            )
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/email/2/validation",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def verify_domain(
        self,
        domain_name: Annotated[
            StrictStr, Field(description="Name of the domain that has to be verified.")
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Verify Domain

        API request to verify records(TXT, MX, DKIM) associated with the provided domain.

        :param domain_name: Name of the domain that has to be verified. (required)
        :type domain_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._verify_domain_serialize(
            domain_name=domain_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "202": None,
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "404": "ApiException",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def verify_domain_with_http_info(
        self,
        domain_name: Annotated[
            StrictStr, Field(description="Name of the domain that has to be verified.")
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Verify Domain

        API request to verify records(TXT, MX, DKIM) associated with the provided domain.

        :param domain_name: Name of the domain that has to be verified. (required)
        :type domain_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._verify_domain_serialize(
            domain_name=domain_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "202": None,
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "404": "ApiException",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def verify_domain_without_preload_content(
        self,
        domain_name: Annotated[
            StrictStr, Field(description="Name of the domain that has to be verified.")
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Verify Domain

        API request to verify records(TXT, MX, DKIM) associated with the provided domain.

        :param domain_name: Name of the domain that has to be verified. (required)
        :type domain_name: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._verify_domain_serialize(
            domain_name=domain_name,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "202": None,
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "404": "ApiException",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _verify_domain_serialize(
        self,
        domain_name,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes]] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if domain_name is not None:
            _path_params["domainName"] = domain_name
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        _header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/email/1/domains/{domainName}/verify",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )
