# coding: utf-8

"""
    Infobip Client API Libraries OpenAPI Specification

    OpenAPI specification containing public endpoints supported in client API libraries.

    The version of the OpenAPI document: 1.0.0
    Contact: support@infobip.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from infobip_api_client.models.calls_media_stream_config_request import (
    CallsMediaStreamConfigRequest,
)
from typing import Optional, Set
from typing_extensions import Self


class CallsWebsocketEndpointConfigRequest(CallsMediaStreamConfigRequest):
    """
    CallsWebsocketEndpointConfigRequest
    """  # noqa: E501

    sample_rate: Optional[StrictStr] = Field(
        default="8000", description="Audio sampling rate.", alias="sampleRate"
    )
    __properties: ClassVar[List[str]] = ["type", "name", "url", "sampleRate"]

    @field_validator("sample_rate")
    def sample_rate_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(["8000", "16000"]):
            raise ValueError("must be one of enum values ('8000', '16000')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CallsWebsocketEndpointConfigRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CallsWebsocketEndpointConfigRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "type": obj.get("type"),
                "name": obj.get("name"),
                "url": obj.get("url"),
                "sampleRate": obj.get("sampleRate")
                if obj.get("sampleRate") is not None
                else "8000",
            }
        )
        return _obj
