# coding: utf-8

"""
    Infobip Client API Libraries OpenAPI Specification

    OpenAPI specification containing public endpoints supported in client API libraries.

    The version of the OpenAPI document: 1.0.0
    Contact: support@infobip.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self


class TfaApplicationConfiguration(BaseModel):
    """
    Created 2FA application configuration.
    """  # noqa: E501

    allow_multiple_pin_verifications: Optional[StrictBool] = Field(
        default=True,
        description="Indicates whether multiple PIN verification is allowed.",
        alias="allowMultiplePinVerifications",
    )
    pin_attempts: Optional[StrictInt] = Field(
        default=10, description="Number of possible PIN attempts.", alias="pinAttempts"
    )
    pin_time_to_live: Optional[StrictStr] = Field(
        default="15m",
        description="Validity period of PIN in specified time unit. Required format: `{timeLength}{timeUnit}`. `timeLength` is optional with a default value of 1. `timeUnit` can be set to: `ms`, `s`, `m`, `h` or `d` representing milliseconds, seconds, minutes, hours, and days respectively. Must not exceed one year, although much lower value is recommended.",
        alias="pinTimeToLive",
    )
    send_pin_per_application_limit: Optional[StrictStr] = Field(
        default="10000/1d",
        description="Overall number of requests over a specified time period for generating a PIN and sending a message using a single application. Required format: `{attempts}/{timeLength}{timeUnit}`. `attempts` and `timeunit` are mandatory and `timeLength` is optional with a default value of 1. `timeUnit` is one of: `ms`, `s`, `m`, `h` or `d` representing milliseconds, seconds, minutes, hours, and days respectively. Must not exceed one year, although much lower value is recommended.",
        alias="sendPinPerApplicationLimit",
    )
    send_pin_per_phone_number_limit: Optional[StrictStr] = Field(
        default="3/1d",
        description="Number of requests over a specified time period for generating a PIN and sending a message to one destination. Required format: `{attempts}/{timeLength}{timeUnit}`. `attempts` and `timeunit` are mandatory and `timeLength` is optional with a default value of 1. `timeUnit` is one of: `ms`, `s`, `m`, `h` or `d` representing milliseconds, seconds, minutes, hours, and days respectively. Must not exceed one year, although much lower value is recommended.",
        alias="sendPinPerPhoneNumberLimit",
    )
    verify_pin_limit: Optional[StrictStr] = Field(
        default="1/3s",
        description="The number of PIN verification requests over a specififed time period from one phone number (MSISDN). Required format: `{attempts}/{timeLength}{timeUnit}`. `attempts` and `timeunit` are mandatory and `timeLength` is optional with a default value of 1. `timeUnit` is one of: `ms`, `s`, `m`, `h` or `d` representing milliseconds, seconds, minutes, hours, and days respectively. Must not exceed one day, although much lower value is recommended.",
        alias="verifyPinLimit",
    )
    __properties: ClassVar[List[str]] = [
        "allowMultiplePinVerifications",
        "pinAttempts",
        "pinTimeToLive",
        "sendPinPerApplicationLimit",
        "sendPinPerPhoneNumberLimit",
        "verifyPinLimit",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TfaApplicationConfiguration from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TfaApplicationConfiguration from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "allowMultiplePinVerifications": obj.get(
                    "allowMultiplePinVerifications"
                )
                if obj.get("allowMultiplePinVerifications") is not None
                else True,
                "pinAttempts": obj.get("pinAttempts")
                if obj.get("pinAttempts") is not None
                else 10,
                "pinTimeToLive": obj.get("pinTimeToLive")
                if obj.get("pinTimeToLive") is not None
                else "15m",
                "sendPinPerApplicationLimit": obj.get("sendPinPerApplicationLimit")
                if obj.get("sendPinPerApplicationLimit") is not None
                else "10000/1d",
                "sendPinPerPhoneNumberLimit": obj.get("sendPinPerPhoneNumberLimit")
                if obj.get("sendPinPerPhoneNumberLimit") is not None
                else "3/1d",
                "verifyPinLimit": obj.get("verifyPinLimit")
                if obj.get("verifyPinLimit") is not None
                else "1/3s",
            }
        )
        return _obj
