# coding: utf-8

"""
    Infobip Client API Libraries OpenAPI Specification

    OpenAPI specification containing public endpoints supported in client API libraries.

    The version of the OpenAPI document: 1.0.0
    Contact: support@infobip.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool
from typing import Any, ClassVar, Dict, List, Optional
from infobip_api_client.models.calls_action_call_request import CallsActionCallRequest
from infobip_api_client.models.calls_action_conference_request import (
    CallsActionConferenceRequest,
)
from infobip_api_client.models.ringback_generation import RingbackGeneration
from typing import Optional, Set
from typing_extensions import Self


class CallsConnectWithNewCallRequest(BaseModel):
    """
    CallsConnectWithNewCallRequest
    """  # noqa: E501

    call_request: Optional[CallsActionCallRequest] = Field(
        default=None, alias="callRequest"
    )
    connect_on_early_media: Optional[StrictBool] = Field(
        default=False,
        description="Indicates whether to connect calls on early media. Otherwise, the calls are connected after being established. Cannot be `true` when `ringbackGeneration` is enabled.",
        alias="connectOnEarlyMedia",
    )
    ringback_generation: Optional[RingbackGeneration] = Field(
        default=None, alias="ringbackGeneration"
    )
    conference_request: Optional[CallsActionConferenceRequest] = Field(
        default=None, alias="conferenceRequest"
    )
    __properties: ClassVar[List[str]] = [
        "callRequest",
        "connectOnEarlyMedia",
        "ringbackGeneration",
        "conferenceRequest",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CallsConnectWithNewCallRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of call_request
        if self.call_request:
            _dict["callRequest"] = self.call_request.to_dict()
        # override the default output from pydantic by calling `to_dict()` of ringback_generation
        if self.ringback_generation:
            _dict["ringbackGeneration"] = self.ringback_generation.to_dict()
        # override the default output from pydantic by calling `to_dict()` of conference_request
        if self.conference_request:
            _dict["conferenceRequest"] = self.conference_request.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CallsConnectWithNewCallRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "callRequest": CallsActionCallRequest.from_dict(obj["callRequest"])
                if obj.get("callRequest") is not None
                else None,
                "connectOnEarlyMedia": obj.get("connectOnEarlyMedia")
                if obj.get("connectOnEarlyMedia") is not None
                else False,
                "ringbackGeneration": RingbackGeneration.from_dict(
                    obj["ringbackGeneration"]
                )
                if obj.get("ringbackGeneration") is not None
                else None,
                "conferenceRequest": CallsActionConferenceRequest.from_dict(
                    obj["conferenceRequest"]
                )
                if obj.get("conferenceRequest") is not None
                else None,
            }
        )
        return _obj
