# coding: utf-8

"""
    Infobip Client API Libraries OpenAPI Specification

    OpenAPI specification containing public endpoints supported in client API libraries.

    The version of the OpenAPI document: 1.0.0
    Contact: support@infobip.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from infobip_api_client.models.calls_destination import CallsDestination
from infobip_api_client.models.calls_retry import CallsRetry
from infobip_api_client.models.calls_sending_speed import CallsSendingSpeed
from infobip_api_client.models.delivery_time_window import DeliveryTimeWindow
from typing import Optional, Set
from typing_extensions import Self


class CallsIvrMessage(BaseModel):
    """
    Array of IVR messages to be sent, one object per every message.
    """  # noqa: E501

    scenario_id: StrictStr = Field(description="Scenario key.", alias="scenarioId")
    var_from: Optional[StrictStr] = Field(
        default=None,
        description="Numeric sender ID length should be between 3 and 14 characters.",
        alias="from",
    )
    destinations: List[CallsDestination] = Field(
        description="Array of message destination addresses. Maximum number of destination addresses is 20k."
    )
    notify_url: Optional[StrictStr] = Field(
        default=None,
        description="The URL on your callback server on which the Delivery report will be sent.",
        alias="notifyUrl",
    )
    notify_content_type: Optional[StrictStr] = Field(
        default=None,
        description="Preferred Delivery report content type. Can be `application/json` or `application/xml`.",
        alias="notifyContentType",
    )
    notify_content_version: Optional[StrictInt] = Field(
        default=None,
        description="Specifies the version of the report model to be sent. Can be `1` ([deprecated version 1](#programmable-communications/voice/receive-voice-delivery-reports-deprecated)) or `2` ([current version 2](#programmable-communications/voice/receive-voice-delivery-reports)). The default is version 2.",
        alias="notifyContentVersion",
    )
    callback_data: Optional[StrictStr] = Field(
        default=None,
        description="Additional client's data that will be sent on the notifyUrl. The maximum value is 200 characters.",
        alias="callbackData",
    )
    validity_period: Optional[StrictInt] = Field(
        default=None,
        description="The message validity period shown in minutes. When the period expires, it will not be allowed for the message to be sent. A validity period longer than 48h is not supported (in this case, it will be automatically set to 48h).",
        alias="validityPeriod",
    )
    send_at: Optional[datetime] = Field(
        default=None,
        description="Used for scheduled Voice messages (message not to be sent immediately, but at scheduled time).",
        alias="sendAt",
    )
    retry: Optional[CallsRetry] = None
    ring_timeout: Optional[StrictInt] = Field(
        default=None,
        description="Ringing duration, unless there are no operator limitations. Default value is `45`. Note: There are no limitations on the Voice platform regarding this value, however, most of the operators have their own ring timeout limitations and it is advisable to keep the ringTimeout value up to `45` seconds.",
        alias="ringTimeout",
    )
    sending_speed: Optional[CallsSendingSpeed] = Field(
        default=None, alias="sendingSpeed"
    )
    parameters: Optional[Dict[str, StrictStr]] = Field(
        default=None,
        description="The parameters that should be passed to the scenario on execution.",
    )
    pause: Optional[StrictInt] = Field(
        default=None,
        description="Indicating period of time in seconds between end user answering the call and message starting to be played. Minimal value is `0` and maximum value is `10` seconds. Default value is `0`.",
    )
    record: Optional[StrictBool] = Field(
        default=None,
        description="[Early access: Contact your account manager to enable the usage] Record the call and expose it to client as URL inside the delivery report. Can be `true` or `false`.",
    )
    delivery_time_window: Optional[DeliveryTimeWindow] = Field(
        default=None, alias="deliveryTimeWindow"
    )
    call_timeout: Optional[StrictInt] = Field(
        default=None,
        description="Maximum possible duration of the call to be set, shown in seconds.",
        alias="callTimeout",
    )
    __properties: ClassVar[List[str]] = [
        "scenarioId",
        "from",
        "destinations",
        "notifyUrl",
        "notifyContentType",
        "notifyContentVersion",
        "callbackData",
        "validityPeriod",
        "sendAt",
        "retry",
        "ringTimeout",
        "sendingSpeed",
        "parameters",
        "pause",
        "record",
        "deliveryTimeWindow",
        "callTimeout",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CallsIvrMessage from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in destinations (list)
        _items = []
        if self.destinations:
            for _item in self.destinations:
                if _item:
                    _items.append(_item.to_dict())
            _dict["destinations"] = _items
        # override the default output from pydantic by calling `to_dict()` of retry
        if self.retry:
            _dict["retry"] = self.retry.to_dict()
        # override the default output from pydantic by calling `to_dict()` of sending_speed
        if self.sending_speed:
            _dict["sendingSpeed"] = self.sending_speed.to_dict()
        # override the default output from pydantic by calling `to_dict()` of delivery_time_window
        if self.delivery_time_window:
            _dict["deliveryTimeWindow"] = self.delivery_time_window.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CallsIvrMessage from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "scenarioId": obj.get("scenarioId"),
                "from": obj.get("from"),
                "destinations": [
                    CallsDestination.from_dict(_item) for _item in obj["destinations"]
                ]
                if obj.get("destinations") is not None
                else None,
                "notifyUrl": obj.get("notifyUrl"),
                "notifyContentType": obj.get("notifyContentType"),
                "notifyContentVersion": obj.get("notifyContentVersion"),
                "callbackData": obj.get("callbackData"),
                "validityPeriod": obj.get("validityPeriod"),
                "sendAt": obj.get("sendAt"),
                "retry": CallsRetry.from_dict(obj["retry"])
                if obj.get("retry") is not None
                else None,
                "ringTimeout": obj.get("ringTimeout"),
                "sendingSpeed": CallsSendingSpeed.from_dict(obj["sendingSpeed"])
                if obj.get("sendingSpeed") is not None
                else None,
                "parameters": obj.get("parameters"),
                "pause": obj.get("pause"),
                "record": obj.get("record"),
                "deliveryTimeWindow": DeliveryTimeWindow.from_dict(
                    obj["deliveryTimeWindow"]
                )
                if obj.get("deliveryTimeWindow") is not None
                else None,
                "callTimeout": obj.get("callTimeout"),
            }
        )
        return _obj
