# coding: utf-8

"""
    Infobip Client API Libraries OpenAPI Specification

    OpenAPI specification containing public endpoints supported in client API libraries.

    The version of the OpenAPI document: 1.0.0
    Contact: support@infobip.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from infobip_api_client.models.calls_price import CallsPrice
from infobip_api_client.models.calls_single_message_status import (
    CallsSingleMessageStatus,
)
from infobip_api_client.models.calls_voice_error import CallsVoiceError
from typing import Optional, Set
from typing_extensions import Self


class CallsLogsReport(BaseModel):
    """
    Array of voice message logs, one object per each message.
    """  # noqa: E501

    bulk_id: Optional[StrictStr] = Field(
        default=None,
        description="The ID that uniquely identifies the bulk of messages.",
        alias="bulkId",
    )
    message_id: Optional[StrictStr] = Field(
        default=None,
        description="The ID that uniquely identifies the message sent.",
        alias="messageId",
    )
    to: Optional[StrictStr] = Field(
        default=None, description="Destination address of the voice message."
    )
    var_from: Optional[StrictStr] = Field(
        default=None,
        description="The sender ID which can be alphanumeric or numeric.",
        alias="from",
    )
    text: Optional[StrictStr] = Field(
        default=None, description="Content of the voice message that was sent."
    )
    sent_at: Optional[datetime] = Field(
        default=None,
        description="Date and time when the voice message was initiated. Has the following format: yyyy-MM-dd'T'HH:mm:ss.SSSZ.",
        alias="sentAt",
    )
    done_at: Optional[datetime] = Field(
        default=None,
        description="Date and time when the Infobip services finished processing the voice message (i.e. delivered to the destination, delivered to the destination network, etc.).",
        alias="doneAt",
    )
    duration: Optional[StrictInt] = Field(
        default=None, description="Voice message duration in seconds."
    )
    mcc_mnc: Optional[StrictStr] = Field(
        default=None, description="Mobile country and network codes.", alias="mccMnc"
    )
    price: Optional[CallsPrice] = None
    status: Optional[CallsSingleMessageStatus] = None
    error: Optional[CallsVoiceError] = None
    __properties: ClassVar[List[str]] = [
        "bulkId",
        "messageId",
        "to",
        "from",
        "text",
        "sentAt",
        "doneAt",
        "duration",
        "mccMnc",
        "price",
        "status",
        "error",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CallsLogsReport from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of price
        if self.price:
            _dict["price"] = self.price.to_dict()
        # override the default output from pydantic by calling `to_dict()` of status
        if self.status:
            _dict["status"] = self.status.to_dict()
        # override the default output from pydantic by calling `to_dict()` of error
        if self.error:
            _dict["error"] = self.error.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CallsLogsReport from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "bulkId": obj.get("bulkId"),
                "messageId": obj.get("messageId"),
                "to": obj.get("to"),
                "from": obj.get("from"),
                "text": obj.get("text"),
                "sentAt": obj.get("sentAt"),
                "doneAt": obj.get("doneAt"),
                "duration": obj.get("duration"),
                "mccMnc": obj.get("mccMnc"),
                "price": CallsPrice.from_dict(obj["price"])
                if obj.get("price") is not None
                else None,
                "status": CallsSingleMessageStatus.from_dict(obj["status"])
                if obj.get("status") is not None
                else None,
                "error": CallsVoiceError.from_dict(obj["error"])
                if obj.get("error") is not None
                else None,
            }
        )
        return _obj
