# coding: utf-8

"""
    Infobip Client API Libraries OpenAPI Specification

    OpenAPI specification containing public endpoints supported in client API libraries.

    The version of the OpenAPI document: 1.0.0
    Contact: support@infobip.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from infobip_api_client.models.calls_play_content import CallsPlayContent
from typing import Optional, Set
from typing_extensions import Self


class CallsDtmfCaptureRequest(BaseModel):
    """
    CallsDtmfCaptureRequest
    """  # noqa: E501

    max_length: StrictInt = Field(
        description="Maximum number of digits to capture.", alias="maxLength"
    )
    timeout: StrictInt = Field(
        description="The duration, in milliseconds, to wait for the first DTMF digit response."
    )
    terminator: Optional[StrictStr] = Field(
        default=None,
        description="Digit used to end input if less than `maxLength` digits have been pressed.",
    )
    digit_timeout: Optional[StrictInt] = Field(
        default=None,
        description="Duration, in milliseconds, to wait for a DTMF digit in-between individual digit inputs. If not set, `digitTimeout` will use the same duration as `timeout`.",
        alias="digitTimeout",
    )
    play_content: Optional[CallsPlayContent] = Field(default=None, alias="playContent")
    custom_data: Optional[Dict[str, StrictStr]] = Field(
        default=None,
        description="Optional parameter to update a call's custom data.",
        alias="customData",
    )
    __properties: ClassVar[List[str]] = [
        "maxLength",
        "timeout",
        "terminator",
        "digitTimeout",
        "playContent",
        "customData",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CallsDtmfCaptureRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of play_content
        if self.play_content:
            _dict["playContent"] = self.play_content.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CallsDtmfCaptureRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "maxLength": obj.get("maxLength"),
                "timeout": obj.get("timeout"),
                "terminator": obj.get("terminator"),
                "digitTimeout": obj.get("digitTimeout"),
                "playContent": CallsPlayContent.from_dict(obj["playContent"])
                if obj.get("playContent") is not None
                else None,
                "customData": obj.get("customData"),
            }
        )
        return _obj
