# coding: utf-8

"""
    Infobip Client API Libraries OpenAPI Specification

    OpenAPI specification containing public endpoints supported in client API libraries.

    The version of the OpenAPI document: 1.0.0
    Contact: support@infobip.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List
from infobip_api_client.models.email_domain_access import EmailDomainAccess
from typing import Optional, Set
from typing_extensions import Self


class EmailDomainInfo(BaseModel):
    """
    Domain get response.
    """  # noqa: E501

    domain_name: StrictStr = Field(
        description="Name of the requested domain.", alias="domainName"
    )
    data_access: EmailDomainAccess = Field(alias="dataAccess")
    read_bounces: StrictBool = Field(
        description="Read bounces permission.", alias="readBounces"
    )
    create_bounces: StrictBool = Field(
        description="Create bounces permission.", alias="createBounces"
    )
    delete_bounces: StrictBool = Field(
        description="Delete bounces permission.", alias="deleteBounces"
    )
    read_complaints: StrictBool = Field(
        description="Read complaints permission.", alias="readComplaints"
    )
    create_complaints: StrictBool = Field(
        description="Create complaints permission.", alias="createComplaints"
    )
    delete_complaints: StrictBool = Field(
        description="Delete complaints permission.", alias="deleteComplaints"
    )
    read_overquotas: StrictBool = Field(
        description="Read overquotas permission.", alias="readOverquotas"
    )
    delete_overquotas: StrictBool = Field(
        description="Delete overquotas permission.", alias="deleteOverquotas"
    )
    __properties: ClassVar[List[str]] = [
        "domainName",
        "dataAccess",
        "readBounces",
        "createBounces",
        "deleteBounces",
        "readComplaints",
        "createComplaints",
        "deleteComplaints",
        "readOverquotas",
        "deleteOverquotas",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EmailDomainInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EmailDomainInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "domainName": obj.get("domainName"),
                "dataAccess": obj.get("dataAccess"),
                "readBounces": obj.get("readBounces"),
                "createBounces": obj.get("createBounces"),
                "deleteBounces": obj.get("deleteBounces"),
                "readComplaints": obj.get("readComplaints"),
                "createComplaints": obj.get("createComplaints"),
                "deleteComplaints": obj.get("deleteComplaints"),
                "readOverquotas": obj.get("readOverquotas"),
                "deleteOverquotas": obj.get("deleteOverquotas"),
            }
        )
        return _obj
