# coding: utf-8

"""
    Infobip Client API Libraries OpenAPI Specification

    OpenAPI specification containing public endpoints supported in client API libraries.

    The version of the OpenAPI document: 1.0.0
    Contact: support@infobip.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List
from typing_extensions import Annotated
from infobip_api_client.models.email_ip_response import EmailIpResponse
from typing import Optional, Set
from typing_extensions import Self


class EmailDomainIpApiPool(BaseModel):
    """
    IP pools assigned to the domain. Assigned IP pools with the lowest priority value have the highest sending precedence.
    """  # noqa: E501

    id: StrictStr = Field(description="IP pool identifier.")
    name: StrictStr = Field(description="IP pool name.")
    priority: Annotated[int, Field(le=49, strict=True, ge=0)] = Field(
        description="IP pool sending priority. Higher value will result in a lower sending precedence for the specified IP pool."
    )
    ips: Annotated[List[EmailIpResponse], Field(min_length=0)]
    __properties: ClassVar[List[str]] = ["id", "name", "priority", "ips"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EmailDomainIpApiPool from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in ips (list)
        _items = []
        if self.ips:
            for _item in self.ips:
                if _item:
                    _items.append(_item.to_dict())
            _dict["ips"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EmailDomainIpApiPool from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "id": obj.get("id"),
                "name": obj.get("name"),
                "priority": obj.get("priority"),
                "ips": [EmailIpResponse.from_dict(_item) for _item in obj["ips"]]
                if obj.get("ips") is not None
                else None,
            }
        )
        return _obj
