# coding: utf-8

"""
    Infobip Client API Libraries OpenAPI Specification

    OpenAPI specification containing public endpoints supported in client API libraries.

    The version of the OpenAPI document: 1.0.0
    Contact: support@infobip.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from infobip_api_client.models.email_webhook_geo_location import EmailWebhookGeoLocation
from infobip_api_client.models.email_webhook_recipient_info import (
    EmailWebhookRecipientInfo,
)
from typing import Optional, Set
from typing_extensions import Self


class EmailWebhookTrackResponse(BaseModel):
    """
    EmailWebhookTrackResponse
    """  # noqa: E501

    notification_type: Optional[StrictStr] = Field(
        default=None,
        description="Tells the type of user event that took place. Possible events: `OPENED`, `CLICKED`, `COMPLAINED`, `UNSUBSCRIBED`.",
        alias="notificationType",
    )
    domain: Optional[StrictStr] = Field(
        default=None,
        description="The sending domain used to send the email to the recipient.",
    )
    recipient: Optional[StrictStr] = Field(
        default=None, description="Recipient of the email."
    )
    url: Optional[StrictStr] = Field(
        default=None,
        description="The link the recipient has clicked. This attribute will only be present if the event is of the type `CLICKED`.",
    )
    send_date_time: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=None,
        description="The time at which the email was sent. Time is in milliseconds.",
        alias="sendDateTime",
    )
    message_id: Optional[StrictStr] = Field(
        default=None,
        description="The ID that uniquely identifies the message sent to the recipient.",
        alias="messageId",
    )
    bulk_id: Optional[StrictStr] = Field(
        default=None,
        description="The ID that uniquely identifies a list of email messages. This is either defined by user in the request or auto generated.",
        alias="bulkId",
    )
    callback_data: Optional[StrictStr] = Field(
        default=None,
        description="The callback data sent through the callbackData field in your fully featured Email message.",
        alias="callbackData",
    )
    recipient_info: Optional[EmailWebhookRecipientInfo] = Field(
        default=None, alias="recipientInfo"
    )
    geo_location: Optional[EmailWebhookGeoLocation] = Field(
        default=None, alias="geoLocation"
    )
    campaign_reference_id: Optional[StrictStr] = Field(
        default=None,
        description="ID of a campaign that was sent in the message.",
        alias="campaignReferenceId",
    )
    entity_id: Optional[StrictStr] = Field(
        default=None,
        description="Used when specifying an entity in outbound send requests. It is also returned in notification events. For detailed usage, refer to the [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management).",
        alias="entityId",
    )
    application_id: Optional[StrictStr] = Field(
        default=None,
        description="Used when specifying an application in outbound send requests. It is also returned in notification events. For detailed usage, refer to the [documentation](https://www.infobip.com/docs/cpaas-x/application-and-entity-management).",
        alias="applicationId",
    )
    __properties: ClassVar[List[str]] = [
        "notificationType",
        "domain",
        "recipient",
        "url",
        "sendDateTime",
        "messageId",
        "bulkId",
        "callbackData",
        "recipientInfo",
        "geoLocation",
        "campaignReferenceId",
        "entityId",
        "applicationId",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of EmailWebhookTrackResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of recipient_info
        if self.recipient_info:
            _dict["recipientInfo"] = self.recipient_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of geo_location
        if self.geo_location:
            _dict["geoLocation"] = self.geo_location.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of EmailWebhookTrackResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "notificationType": obj.get("notificationType"),
                "domain": obj.get("domain"),
                "recipient": obj.get("recipient"),
                "url": obj.get("url"),
                "sendDateTime": obj.get("sendDateTime"),
                "messageId": obj.get("messageId"),
                "bulkId": obj.get("bulkId"),
                "callbackData": obj.get("callbackData"),
                "recipientInfo": EmailWebhookRecipientInfo.from_dict(
                    obj["recipientInfo"]
                )
                if obj.get("recipientInfo") is not None
                else None,
                "geoLocation": EmailWebhookGeoLocation.from_dict(obj["geoLocation"])
                if obj.get("geoLocation") is not None
                else None,
                "campaignReferenceId": obj.get("campaignReferenceId"),
                "entityId": obj.get("entityId"),
                "applicationId": obj.get("applicationId"),
            }
        )
        return _obj
