# coding: utf-8

"""
    Infobip Client API Libraries OpenAPI Specification

    OpenAPI specification containing public endpoints supported in client API libraries.

    The version of the OpenAPI document: 1.0.0
    Contact: support@infobip.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import json
from enum import Enum
from typing_extensions import Self


class FlowErrorStatusReason(str, Enum):
    """
    Detailed reason for the REJECTED status: * `REJECTED_INVALID_CONTACT` - Person started to be processed but has been rejected as the contact is not recognized. * `REJECTED_ATTRIBUTE_MISSED` - One of the person's attributes specified in the request does not exist or has spelling error. * `REJECTED_PERSON_ALREADY_IN_FLOW` - Person is already in flow. * `REJECTED_PERSON_NOT_ALLOWED_TO_REENTER` - Person is not allowed to re-enter flow now. * `REJECTED_FLOW_ERROR_UNKNOWN` - Generic flow error. * `REJECTED_NOT_ENOUGH_CREDITS` - Your account is out of credits for further submission. Top up your account. For further assistance in topping up or applying for an online account top-up service, you may contact your Account Manager.
    """

    """
    allowed enum values
    """
    REJECTED_INVALID_CONTACT = "REJECTED_INVALID_CONTACT"
    REJECTED_ATTRIBUTE_MISSED = "REJECTED_ATTRIBUTE_MISSED"
    REJECTED_PERSON_IN_FLOW = "REJECTED_PERSON_IN_FLOW"
    REJECTED_PERSON_NOT_ALLOWED_TO_REENTER = "REJECTED_PERSON_NOT_ALLOWED_TO_REENTER"
    REJECTED_FLOW_ERROR_UNKNOWN = "REJECTED_FLOW_ERROR_UNKNOWN"
    REJECTED_NOT_ENOUGH_CREDITS = "REJECTED_NOT_ENOUGH_CREDITS"
    REJECTED_CDP_ERROR_UNKNOWN = "REJECTED_CDP_ERROR_UNKNOWN"

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Create an instance of FlowErrorStatusReason from a JSON string"""
        return cls(json.loads(json_str))
