# coding: utf-8

"""
Infobip Client API Libraries OpenAPI Specification

OpenAPI specification containing public endpoints supported in client API libraries.

The version of the OpenAPI document: 1.0.0
Contact: support@infobip.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from datetime import datetime
from pydantic import Field, StrictStr
from typing import Optional, Tuple, Union
from typing_extensions import Annotated
from infobip_api_client.models.call_routing_call_routing_recording_page import (
    CallRoutingCallRoutingRecordingPage,
)
from infobip_api_client.models.call_routing_recording_api_response import (
    CallRoutingRecordingApiResponse,
)
from infobip_api_client.models.call_routing_recording_location import (
    CallRoutingRecordingLocation,
)
from infobip_api_client.models.call_routing_recording_sort_column import (
    CallRoutingRecordingSortColumn,
)
from infobip_api_client.models.call_routing_route_order_request import (
    CallRoutingRouteOrderRequest,
)
from infobip_api_client.models.call_routing_route_request import CallRoutingRouteRequest
from infobip_api_client.models.call_routing_route_response import (
    CallRoutingRouteResponse,
)
from infobip_api_client.models.call_routing_route_response_page import (
    CallRoutingRouteResponsePage,
)
from infobip_api_client.models.call_routing_route_simulator_request import (
    CallRoutingRouteSimulatorRequest,
)
from infobip_api_client.models.call_routing_route_status_request import (
    CallRoutingRouteStatusRequest,
)
from infobip_api_client.models.call_routing_sort_direction import (
    CallRoutingSortDirection,
)

from infobip_api_client.api_client import ApiClient, RequestSerialized
from infobip_api_client.api_response import ApiResponse
from infobip_api_client.models.file_parameter import FileParameter
from infobip_api_client.rest import RESTResponseType


class CallRoutingApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_call
    def create_call_route(
        self,
        call_routing_route_request: CallRoutingRouteRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CallRoutingRouteResponse:
        """Create a call route

        Create a new call route.

        :param call_routing_route_request: (required)
        :type call_routing_route_request: CallRoutingRouteRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._create_call_route_serialize(
            call_routing_route_request=call_routing_route_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "201": "CallRoutingRouteResponse",
            "400": "ApiError",
            "401": "ApiException",
            "403": "ApiException",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def create_call_route_with_http_info(
        self,
        call_routing_route_request: CallRoutingRouteRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CallRoutingRouteResponse]:
        """Create a call route

        Create a new call route.

        :param call_routing_route_request: (required)
        :type call_routing_route_request: CallRoutingRouteRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._create_call_route_serialize(
            call_routing_route_request=call_routing_route_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "201": "CallRoutingRouteResponse",
            "400": "ApiError",
            "401": "ApiException",
            "403": "ApiException",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def create_call_route_without_preload_content(
        self,
        call_routing_route_request: CallRoutingRouteRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create a call route

        Create a new call route.

        :param call_routing_route_request: (required)
        :type call_routing_route_request: CallRoutingRouteRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._create_call_route_serialize(
            call_routing_route_request=call_routing_route_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "201": "CallRoutingRouteResponse",
            "400": "ApiError",
            "401": "ApiException",
            "403": "ApiException",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _create_call_route_serialize(
        self,
        call_routing_route_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[Union[str, bytes, FileParameter]]]] = (
            {}
        )
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if call_routing_route_request is not None:
            _body_params = call_routing_route_request

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/xml"]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(
                ["application/json"]
            )
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/callrouting/1/routes",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def delete_by_correlation_id(
        self,
        correlation_id: Annotated[
            StrictStr, Field(description="Correlation ID to match.")
        ],
        location: Annotated[
            Optional[CallRoutingRecordingLocation],
            Field(description="Recording location."),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CallRoutingRecordingApiResponse:
        """Delete by correlation ID

        This method allows deleting call recordings based on correlation ID.

        :param correlation_id: Correlation ID to match. (required)
        :type correlation_id: str
        :param location: Recording location.
        :type location: CallRoutingRecordingLocation
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._delete_by_correlation_id_serialize(
            correlation_id=correlation_id,
            location=location,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallRoutingRecordingApiResponse",
            "400": "ApiError",
            "401": "ApiException",
            "403": "ApiException",
            "404": "CallRoutingRecordingNotFoundException",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def delete_by_correlation_id_with_http_info(
        self,
        correlation_id: Annotated[
            StrictStr, Field(description="Correlation ID to match.")
        ],
        location: Annotated[
            Optional[CallRoutingRecordingLocation],
            Field(description="Recording location."),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CallRoutingRecordingApiResponse]:
        """Delete by correlation ID

        This method allows deleting call recordings based on correlation ID.

        :param correlation_id: Correlation ID to match. (required)
        :type correlation_id: str
        :param location: Recording location.
        :type location: CallRoutingRecordingLocation
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._delete_by_correlation_id_serialize(
            correlation_id=correlation_id,
            location=location,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallRoutingRecordingApiResponse",
            "400": "ApiError",
            "401": "ApiException",
            "403": "ApiException",
            "404": "CallRoutingRecordingNotFoundException",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def delete_by_correlation_id_without_preload_content(
        self,
        correlation_id: Annotated[
            StrictStr, Field(description="Correlation ID to match.")
        ],
        location: Annotated[
            Optional[CallRoutingRecordingLocation],
            Field(description="Recording location."),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete by correlation ID

        This method allows deleting call recordings based on correlation ID.

        :param correlation_id: Correlation ID to match. (required)
        :type correlation_id: str
        :param location: Recording location.
        :type location: CallRoutingRecordingLocation
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._delete_by_correlation_id_serialize(
            correlation_id=correlation_id,
            location=location,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallRoutingRecordingApiResponse",
            "400": "ApiError",
            "401": "ApiException",
            "403": "ApiException",
            "404": "CallRoutingRecordingNotFoundException",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _delete_by_correlation_id_serialize(
        self,
        correlation_id,
        location,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[Union[str, bytes, FileParameter]]]] = (
            {}
        )
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if correlation_id is not None:

            _query_params.append(("correlationId", correlation_id))

        if location is not None:

            _query_params.append(("location", location.value))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/xml"]
            )

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="DELETE",
            resource_path="/callrouting/1/recordings",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def delete_call_route(
        self,
        route_id: Annotated[StrictStr, Field(description="Route identifier")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CallRoutingRouteResponse:
        """Delete a call route

        Delete an existing call route.

        :param route_id: Route identifier (required)
        :type route_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._delete_call_route_serialize(
            route_id=route_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallRoutingRouteResponse",
            "401": "ApiException",
            "403": "ApiException",
            "404": "ApiError",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def delete_call_route_with_http_info(
        self,
        route_id: Annotated[StrictStr, Field(description="Route identifier")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CallRoutingRouteResponse]:
        """Delete a call route

        Delete an existing call route.

        :param route_id: Route identifier (required)
        :type route_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._delete_call_route_serialize(
            route_id=route_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallRoutingRouteResponse",
            "401": "ApiException",
            "403": "ApiException",
            "404": "ApiError",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def delete_call_route_without_preload_content(
        self,
        route_id: Annotated[StrictStr, Field(description="Route identifier")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete a call route

        Delete an existing call route.

        :param route_id: Route identifier (required)
        :type route_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._delete_call_route_serialize(
            route_id=route_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallRoutingRouteResponse",
            "401": "ApiException",
            "403": "ApiException",
            "404": "ApiError",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _delete_call_route_serialize(
        self,
        route_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[Union[str, bytes, FileParameter]]]] = (
            {}
        )
        _body_params: Optional[bytes] = None

        # process the path parameters
        if route_id is not None:
            _path_params["routeId"] = route_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/xml"]
            )

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="DELETE",
            resource_path="/callrouting/1/routes/{routeId}",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def get_call_route(
        self,
        route_id: Annotated[StrictStr, Field(description="Route identifier")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CallRoutingRouteResponse:
        """Get a call route

        Get an existing call route.

        :param route_id: Route identifier (required)
        :type route_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_call_route_serialize(
            route_id=route_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallRoutingRouteResponse",
            "401": "ApiException",
            "403": "ApiException",
            "404": "ApiError",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def get_call_route_with_http_info(
        self,
        route_id: Annotated[StrictStr, Field(description="Route identifier")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CallRoutingRouteResponse]:
        """Get a call route

        Get an existing call route.

        :param route_id: Route identifier (required)
        :type route_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_call_route_serialize(
            route_id=route_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallRoutingRouteResponse",
            "401": "ApiException",
            "403": "ApiException",
            "404": "ApiError",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def get_call_route_without_preload_content(
        self,
        route_id: Annotated[StrictStr, Field(description="Route identifier")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a call route

        Get an existing call route.

        :param route_id: Route identifier (required)
        :type route_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_call_route_serialize(
            route_id=route_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallRoutingRouteResponse",
            "401": "ApiException",
            "403": "ApiException",
            "404": "ApiError",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _get_call_route_serialize(
        self,
        route_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[Union[str, bytes, FileParameter]]]] = (
            {}
        )
        _body_params: Optional[bytes] = None

        # process the path parameters
        if route_id is not None:
            _path_params["routeId"] = route_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/xml"]
            )

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/callrouting/1/routes/{routeId}",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def get_call_routes(
        self,
        name_contains: Annotated[
            Optional[Annotated[str, Field(strict=True, max_length=255)]],
            Field(
                description="String contained in the name of the route, case-insensitive."
            ),
        ] = None,
        page: Annotated[
            Optional[Annotated[int, Field(strict=True, ge=0)]],
            Field(description="Results page to retrieve (0..N)."),
        ] = None,
        size: Annotated[
            Optional[Annotated[int, Field(le=100, strict=True, ge=1)]],
            Field(description="Number of records per page."),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CallRoutingRouteResponsePage:
        """Get call routes

        Get existing call routes with pagination.

        :param name_contains: String contained in the name of the route, case-insensitive.
        :type name_contains: str
        :param page: Results page to retrieve (0..N).
        :type page: int
        :param size: Number of records per page.
        :type size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_call_routes_serialize(
            name_contains=name_contains,
            page=page,
            size=size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallRoutingRouteResponsePage",
            "400": "ApiError",
            "401": "ApiException",
            "403": "ApiException",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def get_call_routes_with_http_info(
        self,
        name_contains: Annotated[
            Optional[Annotated[str, Field(strict=True, max_length=255)]],
            Field(
                description="String contained in the name of the route, case-insensitive."
            ),
        ] = None,
        page: Annotated[
            Optional[Annotated[int, Field(strict=True, ge=0)]],
            Field(description="Results page to retrieve (0..N)."),
        ] = None,
        size: Annotated[
            Optional[Annotated[int, Field(le=100, strict=True, ge=1)]],
            Field(description="Number of records per page."),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CallRoutingRouteResponsePage]:
        """Get call routes

        Get existing call routes with pagination.

        :param name_contains: String contained in the name of the route, case-insensitive.
        :type name_contains: str
        :param page: Results page to retrieve (0..N).
        :type page: int
        :param size: Number of records per page.
        :type size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_call_routes_serialize(
            name_contains=name_contains,
            page=page,
            size=size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallRoutingRouteResponsePage",
            "400": "ApiError",
            "401": "ApiException",
            "403": "ApiException",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def get_call_routes_without_preload_content(
        self,
        name_contains: Annotated[
            Optional[Annotated[str, Field(strict=True, max_length=255)]],
            Field(
                description="String contained in the name of the route, case-insensitive."
            ),
        ] = None,
        page: Annotated[
            Optional[Annotated[int, Field(strict=True, ge=0)]],
            Field(description="Results page to retrieve (0..N)."),
        ] = None,
        size: Annotated[
            Optional[Annotated[int, Field(le=100, strict=True, ge=1)]],
            Field(description="Number of records per page."),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get call routes

        Get existing call routes with pagination.

        :param name_contains: String contained in the name of the route, case-insensitive.
        :type name_contains: str
        :param page: Results page to retrieve (0..N).
        :type page: int
        :param size: Number of records per page.
        :type size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_call_routes_serialize(
            name_contains=name_contains,
            page=page,
            size=size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallRoutingRouteResponsePage",
            "400": "ApiError",
            "401": "ApiException",
            "403": "ApiException",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _get_call_routes_serialize(
        self,
        name_contains,
        page,
        size,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[Union[str, bytes, FileParameter]]]] = (
            {}
        )
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if name_contains is not None:

            _query_params.append(("nameContains", name_contains))

        if page is not None:

            _query_params.append(("page", page))

        if size is not None:

            _query_params.append(("size", size))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/xml"]
            )

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/callrouting/1/routes",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def recording_file_download(
        self,
        file_id: Annotated[StrictStr, Field(description="File ID to match.")],
        location: Annotated[
            Optional[CallRoutingRecordingLocation],
            Field(description="Recording location."),
        ] = None,
        range: Annotated[
            Optional[StrictStr],
            Field(
                description="Range header specifies range of bytes to be returned by the response. If range header is not specified, response will return a complete file."
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """Download recording file

        Download a recording file.

        :param file_id: File ID to match. (required)
        :type file_id: str
        :param location: Recording location.
        :type location: CallRoutingRecordingLocation
        :param range: Range header specifies range of bytes to be returned by the response. If range header is not specified, response will return a complete file.
        :type range: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._recording_file_download_serialize(
            file_id=file_id,
            location=location,
            range=range,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "bytearray",
            "400": "CallRoutingRecordingServiceException",
            "401": "ApiException",
            "403": "ApiException",
            "404": "CallRoutingRecordingNotFoundException",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def recording_file_download_with_http_info(
        self,
        file_id: Annotated[StrictStr, Field(description="File ID to match.")],
        location: Annotated[
            Optional[CallRoutingRecordingLocation],
            Field(description="Recording location."),
        ] = None,
        range: Annotated[
            Optional[StrictStr],
            Field(
                description="Range header specifies range of bytes to be returned by the response. If range header is not specified, response will return a complete file."
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """Download recording file

        Download a recording file.

        :param file_id: File ID to match. (required)
        :type file_id: str
        :param location: Recording location.
        :type location: CallRoutingRecordingLocation
        :param range: Range header specifies range of bytes to be returned by the response. If range header is not specified, response will return a complete file.
        :type range: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._recording_file_download_serialize(
            file_id=file_id,
            location=location,
            range=range,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "bytearray",
            "400": "CallRoutingRecordingServiceException",
            "401": "ApiException",
            "403": "ApiException",
            "404": "CallRoutingRecordingNotFoundException",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def recording_file_download_without_preload_content(
        self,
        file_id: Annotated[StrictStr, Field(description="File ID to match.")],
        location: Annotated[
            Optional[CallRoutingRecordingLocation],
            Field(description="Recording location."),
        ] = None,
        range: Annotated[
            Optional[StrictStr],
            Field(
                description="Range header specifies range of bytes to be returned by the response. If range header is not specified, response will return a complete file."
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Download recording file

        Download a recording file.

        :param file_id: File ID to match. (required)
        :type file_id: str
        :param location: Recording location.
        :type location: CallRoutingRecordingLocation
        :param range: Range header specifies range of bytes to be returned by the response. If range header is not specified, response will return a complete file.
        :type range: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._recording_file_download_serialize(
            file_id=file_id,
            location=location,
            range=range,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "bytearray",
            "400": "CallRoutingRecordingServiceException",
            "401": "ApiException",
            "403": "ApiException",
            "404": "CallRoutingRecordingNotFoundException",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _recording_file_download_serialize(
        self,
        file_id,
        location,
        range,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[Union[str, bytes, FileParameter]]]] = (
            {}
        )
        _body_params: Optional[bytes] = None

        # process the path parameters
        if file_id is not None:
            _path_params["fileId"] = file_id
        # process the query parameters
        if location is not None:

            _query_params.append(("location", location.value))

        # process the header parameters
        if range is not None:
            _header_params["Range"] = range
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/octet-stream", "application/json", "application/xml"]
            )

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/callrouting/1/recordings/files/{fileId}",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def search_call_routing_recording(
        self,
        sort_by: Annotated[
            Optional[CallRoutingRecordingSortColumn],
            Field(description="Field that will be used for sorting."),
        ] = None,
        sort_direction: Annotated[
            Optional[CallRoutingSortDirection],
            Field(
                description="Order in which files will be sorted based on sortBy field."
            ),
        ] = None,
        endpoint_type: Annotated[
            Optional[StrictStr],
            Field(
                description="Endpoint type of at least one participant in the recorded call."
            ),
        ] = None,
        phone_number: Annotated[
            Optional[StrictStr],
            Field(
                description="Phone number that was participant of the recorded call."
            ),
        ] = None,
        sip_trunk_id: Annotated[
            Optional[StrictStr],
            Field(
                description="SIP Trunk ID that was participant of the recorded call."
            ),
        ] = None,
        sip_username: Annotated[
            Optional[StrictStr],
            Field(
                description="Username on the SIP trunk that was participant of the recorded call."
            ),
        ] = None,
        webrtc_identity: Annotated[
            Optional[StrictStr],
            Field(
                description="WebRTC Identity that was participant of the recorded call."
            ),
        ] = None,
        route_id: Annotated[
            Optional[StrictStr],
            Field(description="Route ID that was used to establish the recorded call."),
        ] = None,
        route_name: Annotated[
            Optional[StrictStr],
            Field(
                description="Route name to be used to match recordings. Name will be matched comparing it to all route names."
            ),
        ] = None,
        correlation_id: Annotated[
            Optional[StrictStr], Field(description="Correlation ID to match.")
        ] = None,
        start_time_after: Annotated[
            Optional[datetime],
            Field(description="Date and time when the (first) call recording started."),
        ] = None,
        start_time_before: Annotated[
            Optional[datetime],
            Field(description="Date and time when the (last) call recording started."),
        ] = None,
        location: Annotated[
            Optional[CallRoutingRecordingLocation],
            Field(description="Recording location."),
        ] = None,
        page: Annotated[
            Optional[Annotated[int, Field(strict=True, ge=0)]],
            Field(description="Results page to retrieve (0..N)."),
        ] = None,
        size: Annotated[
            Optional[Annotated[int, Field(le=100, strict=True, ge=1)]],
            Field(description="Number of records per page."),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CallRoutingCallRoutingRecordingPage:
        """Get recordings

        This method allows searching and filtering based on various recording data properties.

        :param sort_by: Field that will be used for sorting.
        :type sort_by: CallRoutingRecordingSortColumn
        :param sort_direction: Order in which files will be sorted based on sortBy field.
        :type sort_direction: CallRoutingSortDirection
        :param endpoint_type: Endpoint type of at least one participant in the recorded call.
        :type endpoint_type: str
        :param phone_number: Phone number that was participant of the recorded call.
        :type phone_number: str
        :param sip_trunk_id: SIP Trunk ID that was participant of the recorded call.
        :type sip_trunk_id: str
        :param sip_username: Username on the SIP trunk that was participant of the recorded call.
        :type sip_username: str
        :param webrtc_identity: WebRTC Identity that was participant of the recorded call.
        :type webrtc_identity: str
        :param route_id: Route ID that was used to establish the recorded call.
        :type route_id: str
        :param route_name: Route name to be used to match recordings. Name will be matched comparing it to all route names.
        :type route_name: str
        :param correlation_id: Correlation ID to match.
        :type correlation_id: str
        :param start_time_after: Date and time when the (first) call recording started.
        :type start_time_after: datetime
        :param start_time_before: Date and time when the (last) call recording started.
        :type start_time_before: datetime
        :param location: Recording location.
        :type location: CallRoutingRecordingLocation
        :param page: Results page to retrieve (0..N).
        :type page: int
        :param size: Number of records per page.
        :type size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._search_call_routing_recording_serialize(
            sort_by=sort_by,
            sort_direction=sort_direction,
            endpoint_type=endpoint_type,
            phone_number=phone_number,
            sip_trunk_id=sip_trunk_id,
            sip_username=sip_username,
            webrtc_identity=webrtc_identity,
            route_id=route_id,
            route_name=route_name,
            correlation_id=correlation_id,
            start_time_after=start_time_after,
            start_time_before=start_time_before,
            location=location,
            page=page,
            size=size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallRoutingCallRoutingRecordingPage",
            "400": "ApiError",
            "401": "ApiException",
            "403": "ApiException",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def search_call_routing_recording_with_http_info(
        self,
        sort_by: Annotated[
            Optional[CallRoutingRecordingSortColumn],
            Field(description="Field that will be used for sorting."),
        ] = None,
        sort_direction: Annotated[
            Optional[CallRoutingSortDirection],
            Field(
                description="Order in which files will be sorted based on sortBy field."
            ),
        ] = None,
        endpoint_type: Annotated[
            Optional[StrictStr],
            Field(
                description="Endpoint type of at least one participant in the recorded call."
            ),
        ] = None,
        phone_number: Annotated[
            Optional[StrictStr],
            Field(
                description="Phone number that was participant of the recorded call."
            ),
        ] = None,
        sip_trunk_id: Annotated[
            Optional[StrictStr],
            Field(
                description="SIP Trunk ID that was participant of the recorded call."
            ),
        ] = None,
        sip_username: Annotated[
            Optional[StrictStr],
            Field(
                description="Username on the SIP trunk that was participant of the recorded call."
            ),
        ] = None,
        webrtc_identity: Annotated[
            Optional[StrictStr],
            Field(
                description="WebRTC Identity that was participant of the recorded call."
            ),
        ] = None,
        route_id: Annotated[
            Optional[StrictStr],
            Field(description="Route ID that was used to establish the recorded call."),
        ] = None,
        route_name: Annotated[
            Optional[StrictStr],
            Field(
                description="Route name to be used to match recordings. Name will be matched comparing it to all route names."
            ),
        ] = None,
        correlation_id: Annotated[
            Optional[StrictStr], Field(description="Correlation ID to match.")
        ] = None,
        start_time_after: Annotated[
            Optional[datetime],
            Field(description="Date and time when the (first) call recording started."),
        ] = None,
        start_time_before: Annotated[
            Optional[datetime],
            Field(description="Date and time when the (last) call recording started."),
        ] = None,
        location: Annotated[
            Optional[CallRoutingRecordingLocation],
            Field(description="Recording location."),
        ] = None,
        page: Annotated[
            Optional[Annotated[int, Field(strict=True, ge=0)]],
            Field(description="Results page to retrieve (0..N)."),
        ] = None,
        size: Annotated[
            Optional[Annotated[int, Field(le=100, strict=True, ge=1)]],
            Field(description="Number of records per page."),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CallRoutingCallRoutingRecordingPage]:
        """Get recordings

        This method allows searching and filtering based on various recording data properties.

        :param sort_by: Field that will be used for sorting.
        :type sort_by: CallRoutingRecordingSortColumn
        :param sort_direction: Order in which files will be sorted based on sortBy field.
        :type sort_direction: CallRoutingSortDirection
        :param endpoint_type: Endpoint type of at least one participant in the recorded call.
        :type endpoint_type: str
        :param phone_number: Phone number that was participant of the recorded call.
        :type phone_number: str
        :param sip_trunk_id: SIP Trunk ID that was participant of the recorded call.
        :type sip_trunk_id: str
        :param sip_username: Username on the SIP trunk that was participant of the recorded call.
        :type sip_username: str
        :param webrtc_identity: WebRTC Identity that was participant of the recorded call.
        :type webrtc_identity: str
        :param route_id: Route ID that was used to establish the recorded call.
        :type route_id: str
        :param route_name: Route name to be used to match recordings. Name will be matched comparing it to all route names.
        :type route_name: str
        :param correlation_id: Correlation ID to match.
        :type correlation_id: str
        :param start_time_after: Date and time when the (first) call recording started.
        :type start_time_after: datetime
        :param start_time_before: Date and time when the (last) call recording started.
        :type start_time_before: datetime
        :param location: Recording location.
        :type location: CallRoutingRecordingLocation
        :param page: Results page to retrieve (0..N).
        :type page: int
        :param size: Number of records per page.
        :type size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._search_call_routing_recording_serialize(
            sort_by=sort_by,
            sort_direction=sort_direction,
            endpoint_type=endpoint_type,
            phone_number=phone_number,
            sip_trunk_id=sip_trunk_id,
            sip_username=sip_username,
            webrtc_identity=webrtc_identity,
            route_id=route_id,
            route_name=route_name,
            correlation_id=correlation_id,
            start_time_after=start_time_after,
            start_time_before=start_time_before,
            location=location,
            page=page,
            size=size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallRoutingCallRoutingRecordingPage",
            "400": "ApiError",
            "401": "ApiException",
            "403": "ApiException",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def search_call_routing_recording_without_preload_content(
        self,
        sort_by: Annotated[
            Optional[CallRoutingRecordingSortColumn],
            Field(description="Field that will be used for sorting."),
        ] = None,
        sort_direction: Annotated[
            Optional[CallRoutingSortDirection],
            Field(
                description="Order in which files will be sorted based on sortBy field."
            ),
        ] = None,
        endpoint_type: Annotated[
            Optional[StrictStr],
            Field(
                description="Endpoint type of at least one participant in the recorded call."
            ),
        ] = None,
        phone_number: Annotated[
            Optional[StrictStr],
            Field(
                description="Phone number that was participant of the recorded call."
            ),
        ] = None,
        sip_trunk_id: Annotated[
            Optional[StrictStr],
            Field(
                description="SIP Trunk ID that was participant of the recorded call."
            ),
        ] = None,
        sip_username: Annotated[
            Optional[StrictStr],
            Field(
                description="Username on the SIP trunk that was participant of the recorded call."
            ),
        ] = None,
        webrtc_identity: Annotated[
            Optional[StrictStr],
            Field(
                description="WebRTC Identity that was participant of the recorded call."
            ),
        ] = None,
        route_id: Annotated[
            Optional[StrictStr],
            Field(description="Route ID that was used to establish the recorded call."),
        ] = None,
        route_name: Annotated[
            Optional[StrictStr],
            Field(
                description="Route name to be used to match recordings. Name will be matched comparing it to all route names."
            ),
        ] = None,
        correlation_id: Annotated[
            Optional[StrictStr], Field(description="Correlation ID to match.")
        ] = None,
        start_time_after: Annotated[
            Optional[datetime],
            Field(description="Date and time when the (first) call recording started."),
        ] = None,
        start_time_before: Annotated[
            Optional[datetime],
            Field(description="Date and time when the (last) call recording started."),
        ] = None,
        location: Annotated[
            Optional[CallRoutingRecordingLocation],
            Field(description="Recording location."),
        ] = None,
        page: Annotated[
            Optional[Annotated[int, Field(strict=True, ge=0)]],
            Field(description="Results page to retrieve (0..N)."),
        ] = None,
        size: Annotated[
            Optional[Annotated[int, Field(le=100, strict=True, ge=1)]],
            Field(description="Number of records per page."),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get recordings

        This method allows searching and filtering based on various recording data properties.

        :param sort_by: Field that will be used for sorting.
        :type sort_by: CallRoutingRecordingSortColumn
        :param sort_direction: Order in which files will be sorted based on sortBy field.
        :type sort_direction: CallRoutingSortDirection
        :param endpoint_type: Endpoint type of at least one participant in the recorded call.
        :type endpoint_type: str
        :param phone_number: Phone number that was participant of the recorded call.
        :type phone_number: str
        :param sip_trunk_id: SIP Trunk ID that was participant of the recorded call.
        :type sip_trunk_id: str
        :param sip_username: Username on the SIP trunk that was participant of the recorded call.
        :type sip_username: str
        :param webrtc_identity: WebRTC Identity that was participant of the recorded call.
        :type webrtc_identity: str
        :param route_id: Route ID that was used to establish the recorded call.
        :type route_id: str
        :param route_name: Route name to be used to match recordings. Name will be matched comparing it to all route names.
        :type route_name: str
        :param correlation_id: Correlation ID to match.
        :type correlation_id: str
        :param start_time_after: Date and time when the (first) call recording started.
        :type start_time_after: datetime
        :param start_time_before: Date and time when the (last) call recording started.
        :type start_time_before: datetime
        :param location: Recording location.
        :type location: CallRoutingRecordingLocation
        :param page: Results page to retrieve (0..N).
        :type page: int
        :param size: Number of records per page.
        :type size: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._search_call_routing_recording_serialize(
            sort_by=sort_by,
            sort_direction=sort_direction,
            endpoint_type=endpoint_type,
            phone_number=phone_number,
            sip_trunk_id=sip_trunk_id,
            sip_username=sip_username,
            webrtc_identity=webrtc_identity,
            route_id=route_id,
            route_name=route_name,
            correlation_id=correlation_id,
            start_time_after=start_time_after,
            start_time_before=start_time_before,
            location=location,
            page=page,
            size=size,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallRoutingCallRoutingRecordingPage",
            "400": "ApiError",
            "401": "ApiException",
            "403": "ApiException",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _search_call_routing_recording_serialize(
        self,
        sort_by,
        sort_direction,
        endpoint_type,
        phone_number,
        sip_trunk_id,
        sip_username,
        webrtc_identity,
        route_id,
        route_name,
        correlation_id,
        start_time_after,
        start_time_before,
        location,
        page,
        size,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[Union[str, bytes, FileParameter]]]] = (
            {}
        )
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if sort_by is not None:

            _query_params.append(("sortBy", sort_by.value))

        if sort_direction is not None:

            _query_params.append(("sortDirection", sort_direction.value))

        if endpoint_type is not None:

            _query_params.append(("endpointType", endpoint_type))

        if phone_number is not None:

            _query_params.append(("phoneNumber", phone_number))

        if sip_trunk_id is not None:

            _query_params.append(("sipTrunkId", sip_trunk_id))

        if sip_username is not None:

            _query_params.append(("sipUsername", sip_username))

        if webrtc_identity is not None:

            _query_params.append(("webrtcIdentity", webrtc_identity))

        if route_id is not None:

            _query_params.append(("routeId", route_id))

        if route_name is not None:

            _query_params.append(("routeName", route_name))

        if correlation_id is not None:

            _query_params.append(("correlationId", correlation_id))

        if start_time_after is not None:
            if isinstance(start_time_after, datetime):
                _query_params.append(
                    (
                        "startTimeAfter",
                        start_time_after.strftime(
                            self.api_client.configuration.datetime_format
                        ),
                    )
                )
            else:
                _query_params.append(("startTimeAfter", start_time_after))

        if start_time_before is not None:
            if isinstance(start_time_before, datetime):
                _query_params.append(
                    (
                        "startTimeBefore",
                        start_time_before.strftime(
                            self.api_client.configuration.datetime_format
                        ),
                    )
                )
            else:
                _query_params.append(("startTimeBefore", start_time_before))

        if location is not None:

            _query_params.append(("location", location.value))

        if page is not None:

            _query_params.append(("page", page))

        if size is not None:

            _query_params.append(("size", size))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/xml"]
            )

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/callrouting/1/recordings",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def set_order_call_route(
        self,
        route_id: Annotated[StrictStr, Field(description="Route identifier")],
        call_routing_route_order_request: CallRoutingRouteOrderRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CallRoutingRouteResponse:
        """Set order on call route

        Set order on existing call route.

        :param route_id: Route identifier (required)
        :type route_id: str
        :param call_routing_route_order_request: (required)
        :type call_routing_route_order_request: CallRoutingRouteOrderRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._set_order_call_route_serialize(
            route_id=route_id,
            call_routing_route_order_request=call_routing_route_order_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallRoutingRouteResponse",
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "404": "ApiError",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def set_order_call_route_with_http_info(
        self,
        route_id: Annotated[StrictStr, Field(description="Route identifier")],
        call_routing_route_order_request: CallRoutingRouteOrderRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CallRoutingRouteResponse]:
        """Set order on call route

        Set order on existing call route.

        :param route_id: Route identifier (required)
        :type route_id: str
        :param call_routing_route_order_request: (required)
        :type call_routing_route_order_request: CallRoutingRouteOrderRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._set_order_call_route_serialize(
            route_id=route_id,
            call_routing_route_order_request=call_routing_route_order_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallRoutingRouteResponse",
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "404": "ApiError",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def set_order_call_route_without_preload_content(
        self,
        route_id: Annotated[StrictStr, Field(description="Route identifier")],
        call_routing_route_order_request: CallRoutingRouteOrderRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Set order on call route

        Set order on existing call route.

        :param route_id: Route identifier (required)
        :type route_id: str
        :param call_routing_route_order_request: (required)
        :type call_routing_route_order_request: CallRoutingRouteOrderRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._set_order_call_route_serialize(
            route_id=route_id,
            call_routing_route_order_request=call_routing_route_order_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallRoutingRouteResponse",
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "404": "ApiError",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _set_order_call_route_serialize(
        self,
        route_id,
        call_routing_route_order_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[Union[str, bytes, FileParameter]]]] = (
            {}
        )
        _body_params: Optional[bytes] = None

        # process the path parameters
        if route_id is not None:
            _path_params["routeId"] = route_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if call_routing_route_order_request is not None:
            _body_params = call_routing_route_order_request

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/xml"]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(
                ["application/json"]
            )
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="PATCH",
            resource_path="/callrouting/1/routes/{routeId}",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def simulate_route_selection(
        self,
        call_routing_route_simulator_request: CallRoutingRouteSimulatorRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CallRoutingRouteResponse:
        """Simulate route selection

        Simulates which route will be selected upon predefined request.

        :param call_routing_route_simulator_request: (required)
        :type call_routing_route_simulator_request: CallRoutingRouteSimulatorRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._simulate_route_selection_serialize(
            call_routing_route_simulator_request=call_routing_route_simulator_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallRoutingRouteResponse",
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "404": "ApiError",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def simulate_route_selection_with_http_info(
        self,
        call_routing_route_simulator_request: CallRoutingRouteSimulatorRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CallRoutingRouteResponse]:
        """Simulate route selection

        Simulates which route will be selected upon predefined request.

        :param call_routing_route_simulator_request: (required)
        :type call_routing_route_simulator_request: CallRoutingRouteSimulatorRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._simulate_route_selection_serialize(
            call_routing_route_simulator_request=call_routing_route_simulator_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallRoutingRouteResponse",
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "404": "ApiError",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def simulate_route_selection_without_preload_content(
        self,
        call_routing_route_simulator_request: CallRoutingRouteSimulatorRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Simulate route selection

        Simulates which route will be selected upon predefined request.

        :param call_routing_route_simulator_request: (required)
        :type call_routing_route_simulator_request: CallRoutingRouteSimulatorRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._simulate_route_selection_serialize(
            call_routing_route_simulator_request=call_routing_route_simulator_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallRoutingRouteResponse",
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "404": "ApiError",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _simulate_route_selection_serialize(
        self,
        call_routing_route_simulator_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[Union[str, bytes, FileParameter]]]] = (
            {}
        )
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if call_routing_route_simulator_request is not None:
            _body_params = call_routing_route_simulator_request

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/xml"]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(
                ["application/json"]
            )
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/callrouting/1/routes/simulate",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def update_call_route(
        self,
        route_id: Annotated[StrictStr, Field(description="Route identifier")],
        call_routing_route_request: CallRoutingRouteRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CallRoutingRouteResponse:
        """Update a call route

        Update an already existing call route. Fields that are not sent in the request body will take default values and overwrite existing ones.

        :param route_id: Route identifier (required)
        :type route_id: str
        :param call_routing_route_request: (required)
        :type call_routing_route_request: CallRoutingRouteRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._update_call_route_serialize(
            route_id=route_id,
            call_routing_route_request=call_routing_route_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallRoutingRouteResponse",
            "400": "ApiError",
            "401": "ApiException",
            "403": "ApiException",
            "404": "ApiError",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def update_call_route_with_http_info(
        self,
        route_id: Annotated[StrictStr, Field(description="Route identifier")],
        call_routing_route_request: CallRoutingRouteRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CallRoutingRouteResponse]:
        """Update a call route

        Update an already existing call route. Fields that are not sent in the request body will take default values and overwrite existing ones.

        :param route_id: Route identifier (required)
        :type route_id: str
        :param call_routing_route_request: (required)
        :type call_routing_route_request: CallRoutingRouteRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._update_call_route_serialize(
            route_id=route_id,
            call_routing_route_request=call_routing_route_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallRoutingRouteResponse",
            "400": "ApiError",
            "401": "ApiException",
            "403": "ApiException",
            "404": "ApiError",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def update_call_route_without_preload_content(
        self,
        route_id: Annotated[StrictStr, Field(description="Route identifier")],
        call_routing_route_request: CallRoutingRouteRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update a call route

        Update an already existing call route. Fields that are not sent in the request body will take default values and overwrite existing ones.

        :param route_id: Route identifier (required)
        :type route_id: str
        :param call_routing_route_request: (required)
        :type call_routing_route_request: CallRoutingRouteRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._update_call_route_serialize(
            route_id=route_id,
            call_routing_route_request=call_routing_route_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallRoutingRouteResponse",
            "400": "ApiError",
            "401": "ApiException",
            "403": "ApiException",
            "404": "ApiError",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _update_call_route_serialize(
        self,
        route_id,
        call_routing_route_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[Union[str, bytes, FileParameter]]]] = (
            {}
        )
        _body_params: Optional[bytes] = None

        # process the path parameters
        if route_id is not None:
            _path_params["routeId"] = route_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if call_routing_route_request is not None:
            _body_params = call_routing_route_request

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/xml"]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(
                ["application/json"]
            )
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="PUT",
            resource_path="/callrouting/1/routes/{routeId}",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def update_call_route_status(
        self,
        route_id: Annotated[StrictStr, Field(description="Route identifier")],
        call_routing_route_status_request: CallRoutingRouteStatusRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CallRoutingRouteResponse:
        """Update route status

        Update status of existing call route.

        :param route_id: Route identifier (required)
        :type route_id: str
        :param call_routing_route_status_request: (required)
        :type call_routing_route_status_request: CallRoutingRouteStatusRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._update_call_route_status_serialize(
            route_id=route_id,
            call_routing_route_status_request=call_routing_route_status_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallRoutingRouteResponse",
            "400": "ApiError",
            "401": "ApiException",
            "403": "ApiException",
            "404": "ApiError",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def update_call_route_status_with_http_info(
        self,
        route_id: Annotated[StrictStr, Field(description="Route identifier")],
        call_routing_route_status_request: CallRoutingRouteStatusRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CallRoutingRouteResponse]:
        """Update route status

        Update status of existing call route.

        :param route_id: Route identifier (required)
        :type route_id: str
        :param call_routing_route_status_request: (required)
        :type call_routing_route_status_request: CallRoutingRouteStatusRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._update_call_route_status_serialize(
            route_id=route_id,
            call_routing_route_status_request=call_routing_route_status_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallRoutingRouteResponse",
            "400": "ApiError",
            "401": "ApiException",
            "403": "ApiException",
            "404": "ApiError",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def update_call_route_status_without_preload_content(
        self,
        route_id: Annotated[StrictStr, Field(description="Route identifier")],
        call_routing_route_status_request: CallRoutingRouteStatusRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update route status

        Update status of existing call route.

        :param route_id: Route identifier (required)
        :type route_id: str
        :param call_routing_route_status_request: (required)
        :type call_routing_route_status_request: CallRoutingRouteStatusRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._update_call_route_status_serialize(
            route_id=route_id,
            call_routing_route_status_request=call_routing_route_status_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallRoutingRouteResponse",
            "400": "ApiError",
            "401": "ApiException",
            "403": "ApiException",
            "404": "ApiError",
            "429": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _update_call_route_status_serialize(
        self,
        route_id,
        call_routing_route_status_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[Union[str, bytes, FileParameter]]]] = (
            {}
        )
        _body_params: Optional[bytes] = None

        # process the path parameters
        if route_id is not None:
            _path_params["routeId"] = route_id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if call_routing_route_status_request is not None:
            _body_params = call_routing_route_status_request

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/xml"]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(
                ["application/json"]
            )
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/callrouting/1/routes/{routeId}/status",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )
