# coding: utf-8

"""
Infobip Client API Libraries OpenAPI Specification

OpenAPI specification containing public endpoints supported in client API libraries.

The version of the OpenAPI document: 1.0.0
Contact: support@infobip.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from datetime import date, datetime
from pydantic import Field, StrictBool, StrictInt, StrictStr
from typing import List, Optional, Tuple, Union
from typing_extensions import Annotated
from infobip_api_client.models.calls_advanced_body import CallsAdvancedBody
from infobip_api_client.models.calls_bulk_request import CallsBulkRequest
from infobip_api_client.models.calls_bulk_response import CallsBulkResponse
from infobip_api_client.models.calls_bulk_status_response import CallsBulkStatusResponse
from infobip_api_client.models.calls_get_voices_response import CallsGetVoicesResponse
from infobip_api_client.models.calls_ip_core_general_status import (
    CallsIpCoreGeneralStatus,
)
from infobip_api_client.models.calls_launch_scenario_request import (
    CallsLaunchScenarioRequest,
)
from infobip_api_client.models.calls_logs_response import CallsLogsResponse
from infobip_api_client.models.calls_multi_body import CallsMultiBody
from infobip_api_client.models.calls_recorded_audio_files_response import (
    CallsRecordedAudioFilesResponse,
)
from infobip_api_client.models.calls_report_response import CallsReportResponse
from infobip_api_client.models.calls_search_response import CallsSearchResponse
from infobip_api_client.models.calls_single_body import CallsSingleBody
from infobip_api_client.models.calls_update_scenario_request import (
    CallsUpdateScenarioRequest,
)
from infobip_api_client.models.calls_update_scenario_response import (
    CallsUpdateScenarioResponse,
)
from infobip_api_client.models.calls_update_status_request import (
    CallsUpdateStatusRequest,
)
from infobip_api_client.models.calls_voice_response import CallsVoiceResponse

from infobip_api_client.api_client import ApiClient, RequestSerialized
from infobip_api_client.api_response import ApiResponse
from infobip_api_client.models.file_parameter import FileParameter
from infobip_api_client.rest import RESTResponseType


class VoiceApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_call
    def create_a_voice_ivr_scenario(
        self,
        calls_update_scenario_request: CallsUpdateScenarioRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CallsUpdateScenarioResponse:
        """Create Voice IVR Scenarios

        This method allows you to create a Voice IVR Scenario. The IVR scenario will be removed if not used for more than 1 year.

        :param calls_update_scenario_request: (required)
        :type calls_update_scenario_request: CallsUpdateScenarioRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._create_a_voice_ivr_scenario_serialize(
            calls_update_scenario_request=calls_update_scenario_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallsUpdateScenarioResponse",
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def create_a_voice_ivr_scenario_with_http_info(
        self,
        calls_update_scenario_request: CallsUpdateScenarioRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CallsUpdateScenarioResponse]:
        """Create Voice IVR Scenarios

        This method allows you to create a Voice IVR Scenario. The IVR scenario will be removed if not used for more than 1 year.

        :param calls_update_scenario_request: (required)
        :type calls_update_scenario_request: CallsUpdateScenarioRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._create_a_voice_ivr_scenario_serialize(
            calls_update_scenario_request=calls_update_scenario_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallsUpdateScenarioResponse",
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def create_a_voice_ivr_scenario_without_preload_content(
        self,
        calls_update_scenario_request: CallsUpdateScenarioRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create Voice IVR Scenarios

        This method allows you to create a Voice IVR Scenario. The IVR scenario will be removed if not used for more than 1 year.

        :param calls_update_scenario_request: (required)
        :type calls_update_scenario_request: CallsUpdateScenarioRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._create_a_voice_ivr_scenario_serialize(
            calls_update_scenario_request=calls_update_scenario_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallsUpdateScenarioResponse",
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _create_a_voice_ivr_scenario_serialize(
        self,
        calls_update_scenario_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[Union[str, bytes, FileParameter]]]] = (
            {}
        )
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if calls_update_scenario_request is not None:
            _body_params = calls_update_scenario_request

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/xml"]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(
                ["application/json"]
            )
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/voice/ivr/1/scenarios",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def delete_a_voice_ivr_scenario(
        self,
        id: Annotated[
            StrictStr,
            Field(
                description="Scenario identifier (for example E83E787CF2613450157ADA3476171E3F)."
            ),
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Delete Voice IVR Scenarios

        This method allows you to delete a Voice IVR Scenario.

        :param id: Scenario identifier (for example E83E787CF2613450157ADA3476171E3F). (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._delete_a_voice_ivr_scenario_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": None,
            "401": "ApiException",
            "403": "ApiException",
            "404": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def delete_a_voice_ivr_scenario_with_http_info(
        self,
        id: Annotated[
            StrictStr,
            Field(
                description="Scenario identifier (for example E83E787CF2613450157ADA3476171E3F)."
            ),
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Delete Voice IVR Scenarios

        This method allows you to delete a Voice IVR Scenario.

        :param id: Scenario identifier (for example E83E787CF2613450157ADA3476171E3F). (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._delete_a_voice_ivr_scenario_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": None,
            "401": "ApiException",
            "403": "ApiException",
            "404": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def delete_a_voice_ivr_scenario_without_preload_content(
        self,
        id: Annotated[
            StrictStr,
            Field(
                description="Scenario identifier (for example E83E787CF2613450157ADA3476171E3F)."
            ),
        ],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete Voice IVR Scenarios

        This method allows you to delete a Voice IVR Scenario.

        :param id: Scenario identifier (for example E83E787CF2613450157ADA3476171E3F). (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._delete_a_voice_ivr_scenario_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": None,
            "401": "ApiException",
            "403": "ApiException",
            "404": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _delete_a_voice_ivr_scenario_serialize(
        self,
        id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[Union[str, bytes, FileParameter]]]] = (
            {}
        )
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params["id"] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/xml"]
            )

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="DELETE",
            resource_path="/voice/ivr/1/scenarios/{id}",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def download_voice_ivr_recorded_file(
        self,
        id: Annotated[StrictStr, Field(description="File ID to download.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> bytearray:
        """Download Voice IVR Recorded File.

        This method allows you to download Voice IVR Recorded Audio File. The returned audio data is encoded as PCM 16bit 8kHz WAVE audio. The files are available on Infobip servers for 2 months.

        :param id: File ID to download. (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._download_voice_ivr_recorded_file_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "bytearray",
            "401": "ApiException",
            "403": "ApiException",
            "404": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def download_voice_ivr_recorded_file_with_http_info(
        self,
        id: Annotated[StrictStr, Field(description="File ID to download.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[bytearray]:
        """Download Voice IVR Recorded File.

        This method allows you to download Voice IVR Recorded Audio File. The returned audio data is encoded as PCM 16bit 8kHz WAVE audio. The files are available on Infobip servers for 2 months.

        :param id: File ID to download. (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._download_voice_ivr_recorded_file_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "bytearray",
            "401": "ApiException",
            "403": "ApiException",
            "404": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def download_voice_ivr_recorded_file_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="File ID to download.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Download Voice IVR Recorded File.

        This method allows you to download Voice IVR Recorded Audio File. The returned audio data is encoded as PCM 16bit 8kHz WAVE audio. The files are available on Infobip servers for 2 months.

        :param id: File ID to download. (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._download_voice_ivr_recorded_file_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "bytearray",
            "401": "ApiException",
            "403": "ApiException",
            "404": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _download_voice_ivr_recorded_file_serialize(
        self,
        id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[Union[str, bytes, FileParameter]]]] = (
            {}
        )
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params["id"] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/octet-stream", "application/json", "application/xml"]
            )

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/voice/ivr/1/files/{id}",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def get_a_voice_ivr_scenario(
        self,
        id: Annotated[StrictStr, Field(description="Scenario identifier.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CallsUpdateScenarioResponse:
        """Get a Voice IVR Scenario

        This method allows you to get a Voice IVR Scenario.

        :param id: Scenario identifier. (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_a_voice_ivr_scenario_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallsUpdateScenarioResponse",
            "401": "ApiException",
            "403": "ApiException",
            "404": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def get_a_voice_ivr_scenario_with_http_info(
        self,
        id: Annotated[StrictStr, Field(description="Scenario identifier.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CallsUpdateScenarioResponse]:
        """Get a Voice IVR Scenario

        This method allows you to get a Voice IVR Scenario.

        :param id: Scenario identifier. (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_a_voice_ivr_scenario_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallsUpdateScenarioResponse",
            "401": "ApiException",
            "403": "ApiException",
            "404": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def get_a_voice_ivr_scenario_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="Scenario identifier.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get a Voice IVR Scenario

        This method allows you to get a Voice IVR Scenario.

        :param id: Scenario identifier. (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_a_voice_ivr_scenario_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallsUpdateScenarioResponse",
            "401": "ApiException",
            "403": "ApiException",
            "404": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _get_a_voice_ivr_scenario_serialize(
        self,
        id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[Union[str, bytes, FileParameter]]]] = (
            {}
        )
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params["id"] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/xml"]
            )

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/voice/ivr/1/scenarios/{id}",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def get_sent_bulks(
        self,
        bulk_id: Annotated[StrictStr, Field(description="Unique ID of the bulk.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CallsBulkResponse:
        """Get sent bulks

        This method will return information about the scheduled time for a unique bulk message. Canceling and rescheduling are supported only when the Fully featured voice message request contains at least one message and the message bulkId is unique.

        :param bulk_id: Unique ID of the bulk. (required)
        :type bulk_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_sent_bulks_serialize(
            bulk_id=bulk_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallsBulkResponse",
            "401": "ApiException",
            "403": "ApiException",
            "500": "ApiException",
            "4XX": "ApiException",
            "5XX": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def get_sent_bulks_with_http_info(
        self,
        bulk_id: Annotated[StrictStr, Field(description="Unique ID of the bulk.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CallsBulkResponse]:
        """Get sent bulks

        This method will return information about the scheduled time for a unique bulk message. Canceling and rescheduling are supported only when the Fully featured voice message request contains at least one message and the message bulkId is unique.

        :param bulk_id: Unique ID of the bulk. (required)
        :type bulk_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_sent_bulks_serialize(
            bulk_id=bulk_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallsBulkResponse",
            "401": "ApiException",
            "403": "ApiException",
            "500": "ApiException",
            "4XX": "ApiException",
            "5XX": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def get_sent_bulks_without_preload_content(
        self,
        bulk_id: Annotated[StrictStr, Field(description="Unique ID of the bulk.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get sent bulks

        This method will return information about the scheduled time for a unique bulk message. Canceling and rescheduling are supported only when the Fully featured voice message request contains at least one message and the message bulkId is unique.

        :param bulk_id: Unique ID of the bulk. (required)
        :type bulk_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_sent_bulks_serialize(
            bulk_id=bulk_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallsBulkResponse",
            "401": "ApiException",
            "403": "ApiException",
            "500": "ApiException",
            "4XX": "ApiException",
            "5XX": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _get_sent_bulks_serialize(
        self,
        bulk_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[Union[str, bytes, FileParameter]]]] = (
            {}
        )
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if bulk_id is not None:

            _query_params.append(("bulkId", bulk_id))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/xml"]
            )

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/tts/3/bulks",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def get_sent_bulks_status(
        self,
        bulk_id: Annotated[StrictStr, Field(description="Unique ID of the bulk.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CallsBulkStatusResponse:
        """Get sent bulk's status

        This method allows you to get status of scheduled TTS bulk.

        :param bulk_id: Unique ID of the bulk. (required)
        :type bulk_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_sent_bulks_status_serialize(
            bulk_id=bulk_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallsBulkStatusResponse",
            "401": "ApiException",
            "403": "ApiException",
            "500": "ApiException",
            "4XX": "ApiException",
            "5XX": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def get_sent_bulks_status_with_http_info(
        self,
        bulk_id: Annotated[StrictStr, Field(description="Unique ID of the bulk.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CallsBulkStatusResponse]:
        """Get sent bulk's status

        This method allows you to get status of scheduled TTS bulk.

        :param bulk_id: Unique ID of the bulk. (required)
        :type bulk_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_sent_bulks_status_serialize(
            bulk_id=bulk_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallsBulkStatusResponse",
            "401": "ApiException",
            "403": "ApiException",
            "500": "ApiException",
            "4XX": "ApiException",
            "5XX": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def get_sent_bulks_status_without_preload_content(
        self,
        bulk_id: Annotated[StrictStr, Field(description="Unique ID of the bulk.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get sent bulk's status

        This method allows you to get status of scheduled TTS bulk.

        :param bulk_id: Unique ID of the bulk. (required)
        :type bulk_id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_sent_bulks_status_serialize(
            bulk_id=bulk_id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallsBulkStatusResponse",
            "401": "ApiException",
            "403": "ApiException",
            "500": "ApiException",
            "4XX": "ApiException",
            "5XX": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _get_sent_bulks_status_serialize(
        self,
        bulk_id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[Union[str, bytes, FileParameter]]]] = (
            {}
        )
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if bulk_id is not None:

            _query_params.append(("bulkId", bulk_id))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/xml"]
            )

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/tts/3/bulks/status",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def get_sent_voice_logs(
        self,
        var_from: Annotated[
            Optional[StrictStr],
            Field(description="The sender ID which can be alphanumeric or numeric."),
        ] = None,
        to: Annotated[
            Optional[StrictStr],
            Field(description="Destination address of the voice message."),
        ] = None,
        bulk_id: Annotated[
            Optional[List[StrictStr]],
            Field(description="The ID which uniquely identifies the request."),
        ] = None,
        message_id: Annotated[
            Optional[List[StrictStr]],
            Field(description="The ID that uniquely identifies the message sent."),
        ] = None,
        general_status: Annotated[
            Optional[CallsIpCoreGeneralStatus],
            Field(
                description="Sent voice message status group. Indicates whether the message has been successfully sent, not sent, delivered, not delivered, waiting for delivery or any other possible status."
            ),
        ] = None,
        sent_since: Annotated[
            Optional[datetime],
            Field(
                description="Lower limit on date and time of sending a Voice message. Has the following format: yyyy-MM-dd'T'HH:mm:ss.SSSXXX."
            ),
        ] = None,
        sent_until: Annotated[
            Optional[datetime],
            Field(
                description="Upper limit on date and time of sending a Voice message. Has the following format: yyyy-MM-dd'T'HH:mm:ss.SSSXXX."
            ),
        ] = None,
        limit: Annotated[
            Optional[StrictInt],
            Field(
                description="Maximal number of messages in the returned logs. Default value is 50."
            ),
        ] = None,
        mcc: Annotated[
            Optional[StrictStr], Field(description="Mobile country code.")
        ] = None,
        mnc: Annotated[
            Optional[StrictStr], Field(description="Mobile network code.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CallsLogsResponse:
        """Get sent Voice logs

        This method allows you to get logs of sent Voice messages. Voice logs are available for the last 48 hours!

        :param var_from: The sender ID which can be alphanumeric or numeric.
        :type var_from: str
        :param to: Destination address of the voice message.
        :type to: str
        :param bulk_id: The ID which uniquely identifies the request.
        :type bulk_id: List[str]
        :param message_id: The ID that uniquely identifies the message sent.
        :type message_id: List[str]
        :param general_status: Sent voice message status group. Indicates whether the message has been successfully sent, not sent, delivered, not delivered, waiting for delivery or any other possible status.
        :type general_status: CallsIpCoreGeneralStatus
        :param sent_since: Lower limit on date and time of sending a Voice message. Has the following format: yyyy-MM-dd'T'HH:mm:ss.SSSXXX.
        :type sent_since: datetime
        :param sent_until: Upper limit on date and time of sending a Voice message. Has the following format: yyyy-MM-dd'T'HH:mm:ss.SSSXXX.
        :type sent_until: datetime
        :param limit: Maximal number of messages in the returned logs. Default value is 50.
        :type limit: int
        :param mcc: Mobile country code.
        :type mcc: str
        :param mnc: Mobile network code.
        :type mnc: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_sent_voice_logs_serialize(
            var_from=var_from,
            to=to,
            bulk_id=bulk_id,
            message_id=message_id,
            general_status=general_status,
            sent_since=sent_since,
            sent_until=sent_until,
            limit=limit,
            mcc=mcc,
            mnc=mnc,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallsLogsResponse",
            "401": "ApiException",
            "403": "ApiException",
            "429": "ApiException",
            "500": "ApiException",
            "4XX": "ApiException",
            "5XX": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def get_sent_voice_logs_with_http_info(
        self,
        var_from: Annotated[
            Optional[StrictStr],
            Field(description="The sender ID which can be alphanumeric or numeric."),
        ] = None,
        to: Annotated[
            Optional[StrictStr],
            Field(description="Destination address of the voice message."),
        ] = None,
        bulk_id: Annotated[
            Optional[List[StrictStr]],
            Field(description="The ID which uniquely identifies the request."),
        ] = None,
        message_id: Annotated[
            Optional[List[StrictStr]],
            Field(description="The ID that uniquely identifies the message sent."),
        ] = None,
        general_status: Annotated[
            Optional[CallsIpCoreGeneralStatus],
            Field(
                description="Sent voice message status group. Indicates whether the message has been successfully sent, not sent, delivered, not delivered, waiting for delivery or any other possible status."
            ),
        ] = None,
        sent_since: Annotated[
            Optional[datetime],
            Field(
                description="Lower limit on date and time of sending a Voice message. Has the following format: yyyy-MM-dd'T'HH:mm:ss.SSSXXX."
            ),
        ] = None,
        sent_until: Annotated[
            Optional[datetime],
            Field(
                description="Upper limit on date and time of sending a Voice message. Has the following format: yyyy-MM-dd'T'HH:mm:ss.SSSXXX."
            ),
        ] = None,
        limit: Annotated[
            Optional[StrictInt],
            Field(
                description="Maximal number of messages in the returned logs. Default value is 50."
            ),
        ] = None,
        mcc: Annotated[
            Optional[StrictStr], Field(description="Mobile country code.")
        ] = None,
        mnc: Annotated[
            Optional[StrictStr], Field(description="Mobile network code.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CallsLogsResponse]:
        """Get sent Voice logs

        This method allows you to get logs of sent Voice messages. Voice logs are available for the last 48 hours!

        :param var_from: The sender ID which can be alphanumeric or numeric.
        :type var_from: str
        :param to: Destination address of the voice message.
        :type to: str
        :param bulk_id: The ID which uniquely identifies the request.
        :type bulk_id: List[str]
        :param message_id: The ID that uniquely identifies the message sent.
        :type message_id: List[str]
        :param general_status: Sent voice message status group. Indicates whether the message has been successfully sent, not sent, delivered, not delivered, waiting for delivery or any other possible status.
        :type general_status: CallsIpCoreGeneralStatus
        :param sent_since: Lower limit on date and time of sending a Voice message. Has the following format: yyyy-MM-dd'T'HH:mm:ss.SSSXXX.
        :type sent_since: datetime
        :param sent_until: Upper limit on date and time of sending a Voice message. Has the following format: yyyy-MM-dd'T'HH:mm:ss.SSSXXX.
        :type sent_until: datetime
        :param limit: Maximal number of messages in the returned logs. Default value is 50.
        :type limit: int
        :param mcc: Mobile country code.
        :type mcc: str
        :param mnc: Mobile network code.
        :type mnc: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_sent_voice_logs_serialize(
            var_from=var_from,
            to=to,
            bulk_id=bulk_id,
            message_id=message_id,
            general_status=general_status,
            sent_since=sent_since,
            sent_until=sent_until,
            limit=limit,
            mcc=mcc,
            mnc=mnc,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallsLogsResponse",
            "401": "ApiException",
            "403": "ApiException",
            "429": "ApiException",
            "500": "ApiException",
            "4XX": "ApiException",
            "5XX": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def get_sent_voice_logs_without_preload_content(
        self,
        var_from: Annotated[
            Optional[StrictStr],
            Field(description="The sender ID which can be alphanumeric or numeric."),
        ] = None,
        to: Annotated[
            Optional[StrictStr],
            Field(description="Destination address of the voice message."),
        ] = None,
        bulk_id: Annotated[
            Optional[List[StrictStr]],
            Field(description="The ID which uniquely identifies the request."),
        ] = None,
        message_id: Annotated[
            Optional[List[StrictStr]],
            Field(description="The ID that uniquely identifies the message sent."),
        ] = None,
        general_status: Annotated[
            Optional[CallsIpCoreGeneralStatus],
            Field(
                description="Sent voice message status group. Indicates whether the message has been successfully sent, not sent, delivered, not delivered, waiting for delivery or any other possible status."
            ),
        ] = None,
        sent_since: Annotated[
            Optional[datetime],
            Field(
                description="Lower limit on date and time of sending a Voice message. Has the following format: yyyy-MM-dd'T'HH:mm:ss.SSSXXX."
            ),
        ] = None,
        sent_until: Annotated[
            Optional[datetime],
            Field(
                description="Upper limit on date and time of sending a Voice message. Has the following format: yyyy-MM-dd'T'HH:mm:ss.SSSXXX."
            ),
        ] = None,
        limit: Annotated[
            Optional[StrictInt],
            Field(
                description="Maximal number of messages in the returned logs. Default value is 50."
            ),
        ] = None,
        mcc: Annotated[
            Optional[StrictStr], Field(description="Mobile country code.")
        ] = None,
        mnc: Annotated[
            Optional[StrictStr], Field(description="Mobile network code.")
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get sent Voice logs

        This method allows you to get logs of sent Voice messages. Voice logs are available for the last 48 hours!

        :param var_from: The sender ID which can be alphanumeric or numeric.
        :type var_from: str
        :param to: Destination address of the voice message.
        :type to: str
        :param bulk_id: The ID which uniquely identifies the request.
        :type bulk_id: List[str]
        :param message_id: The ID that uniquely identifies the message sent.
        :type message_id: List[str]
        :param general_status: Sent voice message status group. Indicates whether the message has been successfully sent, not sent, delivered, not delivered, waiting for delivery or any other possible status.
        :type general_status: CallsIpCoreGeneralStatus
        :param sent_since: Lower limit on date and time of sending a Voice message. Has the following format: yyyy-MM-dd'T'HH:mm:ss.SSSXXX.
        :type sent_since: datetime
        :param sent_until: Upper limit on date and time of sending a Voice message. Has the following format: yyyy-MM-dd'T'HH:mm:ss.SSSXXX.
        :type sent_until: datetime
        :param limit: Maximal number of messages in the returned logs. Default value is 50.
        :type limit: int
        :param mcc: Mobile country code.
        :type mcc: str
        :param mnc: Mobile network code.
        :type mnc: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_sent_voice_logs_serialize(
            var_from=var_from,
            to=to,
            bulk_id=bulk_id,
            message_id=message_id,
            general_status=general_status,
            sent_since=sent_since,
            sent_until=sent_until,
            limit=limit,
            mcc=mcc,
            mnc=mnc,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallsLogsResponse",
            "401": "ApiException",
            "403": "ApiException",
            "429": "ApiException",
            "500": "ApiException",
            "4XX": "ApiException",
            "5XX": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _get_sent_voice_logs_serialize(
        self,
        var_from,
        to,
        bulk_id,
        message_id,
        general_status,
        sent_since,
        sent_until,
        limit,
        mcc,
        mnc,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            "bulkId": "multi",
            "messageId": "multi",
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[Union[str, bytes, FileParameter]]]] = (
            {}
        )
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if var_from is not None:

            _query_params.append(("from", var_from))

        if to is not None:

            _query_params.append(("to", to))

        if bulk_id is not None:

            _query_params.append(("bulkId", bulk_id))

        if message_id is not None:

            _query_params.append(("messageId", message_id))

        if general_status is not None:

            _query_params.append(("generalStatus", general_status.value))

        if sent_since is not None:
            if isinstance(sent_since, datetime):
                _query_params.append(
                    (
                        "sentSince",
                        sent_since.strftime(
                            self.api_client.configuration.datetime_format
                        ),
                    )
                )
            else:
                _query_params.append(("sentSince", sent_since))

        if sent_until is not None:
            if isinstance(sent_until, datetime):
                _query_params.append(
                    (
                        "sentUntil",
                        sent_until.strftime(
                            self.api_client.configuration.datetime_format
                        ),
                    )
                )
            else:
                _query_params.append(("sentUntil", sent_until))

        if limit is not None:

            _query_params.append(("limit", limit))

        if mcc is not None:

            _query_params.append(("mcc", mcc))

        if mnc is not None:

            _query_params.append(("mnc", mnc))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/xml"]
            )

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/tts/3/logs",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def get_voice_delivery_reports(
        self,
        bulk_id: Annotated[
            Optional[StrictStr],
            Field(
                description="The ID that uniquely identifies the request. Bulk ID will be received only when you send a message to more than one destination addresses."
            ),
        ] = None,
        message_id: Annotated[
            Optional[StrictStr],
            Field(description="The ID that uniquely identifies the message sent."),
        ] = None,
        limit: Annotated[
            Optional[StrictInt],
            Field(
                description="The maximum number of returned delivery reports. Default value is 50."
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CallsReportResponse:
        """Get Voice Delivery Reports

        This method allows you to get delivery reports for sent Voice messages, outbound IVR or Click-to-call (without notifyUrl request parameter). Delivery reports are returned only once. Additional delivery report request will return an empty collection.

        :param bulk_id: The ID that uniquely identifies the request. Bulk ID will be received only when you send a message to more than one destination addresses.
        :type bulk_id: str
        :param message_id: The ID that uniquely identifies the message sent.
        :type message_id: str
        :param limit: The maximum number of returned delivery reports. Default value is 50.
        :type limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_voice_delivery_reports_serialize(
            bulk_id=bulk_id,
            message_id=message_id,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallsReportResponse",
            "401": "ApiException",
            "403": "ApiException",
            "500": "ApiException",
            "4XX": "ApiException",
            "5XX": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def get_voice_delivery_reports_with_http_info(
        self,
        bulk_id: Annotated[
            Optional[StrictStr],
            Field(
                description="The ID that uniquely identifies the request. Bulk ID will be received only when you send a message to more than one destination addresses."
            ),
        ] = None,
        message_id: Annotated[
            Optional[StrictStr],
            Field(description="The ID that uniquely identifies the message sent."),
        ] = None,
        limit: Annotated[
            Optional[StrictInt],
            Field(
                description="The maximum number of returned delivery reports. Default value is 50."
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CallsReportResponse]:
        """Get Voice Delivery Reports

        This method allows you to get delivery reports for sent Voice messages, outbound IVR or Click-to-call (without notifyUrl request parameter). Delivery reports are returned only once. Additional delivery report request will return an empty collection.

        :param bulk_id: The ID that uniquely identifies the request. Bulk ID will be received only when you send a message to more than one destination addresses.
        :type bulk_id: str
        :param message_id: The ID that uniquely identifies the message sent.
        :type message_id: str
        :param limit: The maximum number of returned delivery reports. Default value is 50.
        :type limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_voice_delivery_reports_serialize(
            bulk_id=bulk_id,
            message_id=message_id,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallsReportResponse",
            "401": "ApiException",
            "403": "ApiException",
            "500": "ApiException",
            "4XX": "ApiException",
            "5XX": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def get_voice_delivery_reports_without_preload_content(
        self,
        bulk_id: Annotated[
            Optional[StrictStr],
            Field(
                description="The ID that uniquely identifies the request. Bulk ID will be received only when you send a message to more than one destination addresses."
            ),
        ] = None,
        message_id: Annotated[
            Optional[StrictStr],
            Field(description="The ID that uniquely identifies the message sent."),
        ] = None,
        limit: Annotated[
            Optional[StrictInt],
            Field(
                description="The maximum number of returned delivery reports. Default value is 50."
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Voice Delivery Reports

        This method allows you to get delivery reports for sent Voice messages, outbound IVR or Click-to-call (without notifyUrl request parameter). Delivery reports are returned only once. Additional delivery report request will return an empty collection.

        :param bulk_id: The ID that uniquely identifies the request. Bulk ID will be received only when you send a message to more than one destination addresses.
        :type bulk_id: str
        :param message_id: The ID that uniquely identifies the message sent.
        :type message_id: str
        :param limit: The maximum number of returned delivery reports. Default value is 50.
        :type limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_voice_delivery_reports_serialize(
            bulk_id=bulk_id,
            message_id=message_id,
            limit=limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallsReportResponse",
            "401": "ApiException",
            "403": "ApiException",
            "500": "ApiException",
            "4XX": "ApiException",
            "5XX": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _get_voice_delivery_reports_serialize(
        self,
        bulk_id,
        message_id,
        limit,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[Union[str, bytes, FileParameter]]]] = (
            {}
        )
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if bulk_id is not None:

            _query_params.append(("bulkId", bulk_id))

        if message_id is not None:

            _query_params.append(("messageId", message_id))

        if limit is not None:

            _query_params.append(("limit", limit))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/xml"]
            )

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/voice/1/reports",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def get_voices(
        self,
        language: Annotated[
            StrictStr,
            Field(
                description="Represents the language abbreviation. (e.g. `en`). You can find the list of supported languages in corresponding section for sending voice message."
            ),
        ],
        include_neural: Annotated[
            Optional[StrictBool],
            Field(
                description="Indicates whether neural voices should be included in the response. If set to `false` or omitted, only standard voices will be included in the response. If set to `true`, both standard and neural voices will be included in the response. "
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CallsGetVoicesResponse:
        """Get Voices

        This method allows you to retrieve all voices for the given language

        :param language: Represents the language abbreviation. (e.g. `en`). You can find the list of supported languages in corresponding section for sending voice message. (required)
        :type language: str
        :param include_neural: Indicates whether neural voices should be included in the response. If set to `false` or omitted, only standard voices will be included in the response. If set to `true`, both standard and neural voices will be included in the response.
        :type include_neural: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_voices_serialize(
            language=language,
            include_neural=include_neural,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallsGetVoicesResponse",
            "401": "ApiException",
            "403": "ApiException",
            "404": "ApiException",
            "500": "ApiException",
            "4XX": "ApiException",
            "5XX": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def get_voices_with_http_info(
        self,
        language: Annotated[
            StrictStr,
            Field(
                description="Represents the language abbreviation. (e.g. `en`). You can find the list of supported languages in corresponding section for sending voice message."
            ),
        ],
        include_neural: Annotated[
            Optional[StrictBool],
            Field(
                description="Indicates whether neural voices should be included in the response. If set to `false` or omitted, only standard voices will be included in the response. If set to `true`, both standard and neural voices will be included in the response. "
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CallsGetVoicesResponse]:
        """Get Voices

        This method allows you to retrieve all voices for the given language

        :param language: Represents the language abbreviation. (e.g. `en`). You can find the list of supported languages in corresponding section for sending voice message. (required)
        :type language: str
        :param include_neural: Indicates whether neural voices should be included in the response. If set to `false` or omitted, only standard voices will be included in the response. If set to `true`, both standard and neural voices will be included in the response.
        :type include_neural: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_voices_serialize(
            language=language,
            include_neural=include_neural,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallsGetVoicesResponse",
            "401": "ApiException",
            "403": "ApiException",
            "404": "ApiException",
            "500": "ApiException",
            "4XX": "ApiException",
            "5XX": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def get_voices_without_preload_content(
        self,
        language: Annotated[
            StrictStr,
            Field(
                description="Represents the language abbreviation. (e.g. `en`). You can find the list of supported languages in corresponding section for sending voice message."
            ),
        ],
        include_neural: Annotated[
            Optional[StrictBool],
            Field(
                description="Indicates whether neural voices should be included in the response. If set to `false` or omitted, only standard voices will be included in the response. If set to `true`, both standard and neural voices will be included in the response. "
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get Voices

        This method allows you to retrieve all voices for the given language

        :param language: Represents the language abbreviation. (e.g. `en`). You can find the list of supported languages in corresponding section for sending voice message. (required)
        :type language: str
        :param include_neural: Indicates whether neural voices should be included in the response. If set to `false` or omitted, only standard voices will be included in the response. If set to `true`, both standard and neural voices will be included in the response.
        :type include_neural: bool
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._get_voices_serialize(
            language=language,
            include_neural=include_neural,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallsGetVoicesResponse",
            "401": "ApiException",
            "403": "ApiException",
            "404": "ApiException",
            "500": "ApiException",
            "4XX": "ApiException",
            "5XX": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _get_voices_serialize(
        self,
        language,
        include_neural,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[Union[str, bytes, FileParameter]]]] = (
            {}
        )
        _body_params: Optional[bytes] = None

        # process the path parameters
        if language is not None:
            _path_params["language"] = language
        # process the query parameters
        if include_neural is not None:

            _query_params.append(("includeNeural", include_neural))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/xml"]
            )

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/tts/3/voices/{language}",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def manage_sent_bulks_status(
        self,
        bulk_id: Annotated[StrictStr, Field(description="Unique ID of the bulk.")],
        calls_update_status_request: CallsUpdateStatusRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CallsBulkStatusResponse:
        """Manage sent bulk's status

        This method allows you to manage statuses of scheduled TTS bulk. Messages scheduled with the sendAt or sending speed parameter can be paused, resumed or canceled by changing the message status, or rescheduled using the bulkId parameter as an identifier. Only voice messages that were not already sent can be canceled.

        :param bulk_id: Unique ID of the bulk. (required)
        :type bulk_id: str
        :param calls_update_status_request: (required)
        :type calls_update_status_request: CallsUpdateStatusRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._manage_sent_bulks_status_serialize(
            bulk_id=bulk_id,
            calls_update_status_request=calls_update_status_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallsBulkStatusResponse",
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "500": "ApiException",
            "4XX": "ApiException",
            "5XX": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def manage_sent_bulks_status_with_http_info(
        self,
        bulk_id: Annotated[StrictStr, Field(description="Unique ID of the bulk.")],
        calls_update_status_request: CallsUpdateStatusRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CallsBulkStatusResponse]:
        """Manage sent bulk's status

        This method allows you to manage statuses of scheduled TTS bulk. Messages scheduled with the sendAt or sending speed parameter can be paused, resumed or canceled by changing the message status, or rescheduled using the bulkId parameter as an identifier. Only voice messages that were not already sent can be canceled.

        :param bulk_id: Unique ID of the bulk. (required)
        :type bulk_id: str
        :param calls_update_status_request: (required)
        :type calls_update_status_request: CallsUpdateStatusRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._manage_sent_bulks_status_serialize(
            bulk_id=bulk_id,
            calls_update_status_request=calls_update_status_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallsBulkStatusResponse",
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "500": "ApiException",
            "4XX": "ApiException",
            "5XX": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def manage_sent_bulks_status_without_preload_content(
        self,
        bulk_id: Annotated[StrictStr, Field(description="Unique ID of the bulk.")],
        calls_update_status_request: CallsUpdateStatusRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Manage sent bulk's status

        This method allows you to manage statuses of scheduled TTS bulk. Messages scheduled with the sendAt or sending speed parameter can be paused, resumed or canceled by changing the message status, or rescheduled using the bulkId parameter as an identifier. Only voice messages that were not already sent can be canceled.

        :param bulk_id: Unique ID of the bulk. (required)
        :type bulk_id: str
        :param calls_update_status_request: (required)
        :type calls_update_status_request: CallsUpdateStatusRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._manage_sent_bulks_status_serialize(
            bulk_id=bulk_id,
            calls_update_status_request=calls_update_status_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallsBulkStatusResponse",
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "500": "ApiException",
            "4XX": "ApiException",
            "5XX": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _manage_sent_bulks_status_serialize(
        self,
        bulk_id,
        calls_update_status_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[Union[str, bytes, FileParameter]]]] = (
            {}
        )
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if bulk_id is not None:

            _query_params.append(("bulkId", bulk_id))

        # process the header parameters
        # process the form parameters
        # process the body parameter
        if calls_update_status_request is not None:
            _body_params = calls_update_status_request

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/xml"]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(
                ["application/json"]
            )
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="PUT",
            resource_path="/tts/3/bulks/status",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def reschedule_sent_bulk(
        self,
        bulk_id: Annotated[StrictStr, Field(description="Unique ID of the bulk.")],
        calls_bulk_request: CallsBulkRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CallsBulkResponse:
        """Reschedule sent bulk

        This method allows you to reschedule scheduled TTS bulk. Messages scheduled with the sendAt or Sending speed parameter can be paused, resumed or canceled by changing the message status, or rescheduled using the bulkId parameter as an identifier. Rescheduling is only possible if the bulk status is PAUSED.

        :param bulk_id: Unique ID of the bulk. (required)
        :type bulk_id: str
        :param calls_bulk_request: (required)
        :type calls_bulk_request: CallsBulkRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._reschedule_sent_bulk_serialize(
            bulk_id=bulk_id,
            calls_bulk_request=calls_bulk_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallsBulkResponse",
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "500": "ApiException",
            "4XX": "ApiException",
            "5XX": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def reschedule_sent_bulk_with_http_info(
        self,
        bulk_id: Annotated[StrictStr, Field(description="Unique ID of the bulk.")],
        calls_bulk_request: CallsBulkRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CallsBulkResponse]:
        """Reschedule sent bulk

        This method allows you to reschedule scheduled TTS bulk. Messages scheduled with the sendAt or Sending speed parameter can be paused, resumed or canceled by changing the message status, or rescheduled using the bulkId parameter as an identifier. Rescheduling is only possible if the bulk status is PAUSED.

        :param bulk_id: Unique ID of the bulk. (required)
        :type bulk_id: str
        :param calls_bulk_request: (required)
        :type calls_bulk_request: CallsBulkRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._reschedule_sent_bulk_serialize(
            bulk_id=bulk_id,
            calls_bulk_request=calls_bulk_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallsBulkResponse",
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "500": "ApiException",
            "4XX": "ApiException",
            "5XX": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def reschedule_sent_bulk_without_preload_content(
        self,
        bulk_id: Annotated[StrictStr, Field(description="Unique ID of the bulk.")],
        calls_bulk_request: CallsBulkRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Reschedule sent bulk

        This method allows you to reschedule scheduled TTS bulk. Messages scheduled with the sendAt or Sending speed parameter can be paused, resumed or canceled by changing the message status, or rescheduled using the bulkId parameter as an identifier. Rescheduling is only possible if the bulk status is PAUSED.

        :param bulk_id: Unique ID of the bulk. (required)
        :type bulk_id: str
        :param calls_bulk_request: (required)
        :type calls_bulk_request: CallsBulkRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._reschedule_sent_bulk_serialize(
            bulk_id=bulk_id,
            calls_bulk_request=calls_bulk_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallsBulkResponse",
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "500": "ApiException",
            "4XX": "ApiException",
            "5XX": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _reschedule_sent_bulk_serialize(
        self,
        bulk_id,
        calls_bulk_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[Union[str, bytes, FileParameter]]]] = (
            {}
        )
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if bulk_id is not None:

            _query_params.append(("bulkId", bulk_id))

        # process the header parameters
        # process the form parameters
        # process the body parameter
        if calls_bulk_request is not None:
            _body_params = calls_bulk_request

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/xml"]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(
                ["application/json"]
            )
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="PUT",
            resource_path="/tts/3/bulks",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def search_voice_ivr_recorded_files(
        self,
        page: Annotated[
            Optional[StrictInt], Field(description="Page number you want to see.")
        ] = None,
        page_size: Annotated[
            Optional[StrictInt], Field(description="Size of the page you want to see.")
        ] = None,
        message_id: Annotated[
            Optional[StrictStr], Field(description="The message ID to search by.")
        ] = None,
        number: Annotated[
            Optional[StrictStr],
            Field(description="The called phone number to search by."),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CallsRecordedAudioFilesResponse:
        """Search Voice IVR Recorded Files

        This method allows you to search Voice IVR Recorded Audio Files.

        :param page: Page number you want to see.
        :type page: int
        :param page_size: Size of the page you want to see.
        :type page_size: int
        :param message_id: The message ID to search by.
        :type message_id: str
        :param number: The called phone number to search by.
        :type number: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._search_voice_ivr_recorded_files_serialize(
            page=page,
            page_size=page_size,
            message_id=message_id,
            number=number,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallsRecordedAudioFilesResponse",
            "401": "ApiException",
            "403": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def search_voice_ivr_recorded_files_with_http_info(
        self,
        page: Annotated[
            Optional[StrictInt], Field(description="Page number you want to see.")
        ] = None,
        page_size: Annotated[
            Optional[StrictInt], Field(description="Size of the page you want to see.")
        ] = None,
        message_id: Annotated[
            Optional[StrictStr], Field(description="The message ID to search by.")
        ] = None,
        number: Annotated[
            Optional[StrictStr],
            Field(description="The called phone number to search by."),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CallsRecordedAudioFilesResponse]:
        """Search Voice IVR Recorded Files

        This method allows you to search Voice IVR Recorded Audio Files.

        :param page: Page number you want to see.
        :type page: int
        :param page_size: Size of the page you want to see.
        :type page_size: int
        :param message_id: The message ID to search by.
        :type message_id: str
        :param number: The called phone number to search by.
        :type number: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._search_voice_ivr_recorded_files_serialize(
            page=page,
            page_size=page_size,
            message_id=message_id,
            number=number,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallsRecordedAudioFilesResponse",
            "401": "ApiException",
            "403": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def search_voice_ivr_recorded_files_without_preload_content(
        self,
        page: Annotated[
            Optional[StrictInt], Field(description="Page number you want to see.")
        ] = None,
        page_size: Annotated[
            Optional[StrictInt], Field(description="Size of the page you want to see.")
        ] = None,
        message_id: Annotated[
            Optional[StrictStr], Field(description="The message ID to search by.")
        ] = None,
        number: Annotated[
            Optional[StrictStr],
            Field(description="The called phone number to search by."),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Search Voice IVR Recorded Files

        This method allows you to search Voice IVR Recorded Audio Files.

        :param page: Page number you want to see.
        :type page: int
        :param page_size: Size of the page you want to see.
        :type page_size: int
        :param message_id: The message ID to search by.
        :type message_id: str
        :param number: The called phone number to search by.
        :type number: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._search_voice_ivr_recorded_files_serialize(
            page=page,
            page_size=page_size,
            message_id=message_id,
            number=number,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallsRecordedAudioFilesResponse",
            "401": "ApiException",
            "403": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _search_voice_ivr_recorded_files_serialize(
        self,
        page,
        page_size,
        message_id,
        number,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[Union[str, bytes, FileParameter]]]] = (
            {}
        )
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if page is not None:

            _query_params.append(("page", page))

        if page_size is not None:

            _query_params.append(("pageSize", page_size))

        if message_id is not None:

            _query_params.append(("messageId", message_id))

        if number is not None:

            _query_params.append(("number", number))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/xml"]
            )

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/voice/ivr/1/files",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def search_voice_ivr_scenarios(
        self,
        page: Annotated[
            Optional[Annotated[int, Field(strict=True, ge=1)]],
            Field(description="Page number you want to see. Default is 1."),
        ] = None,
        page_size: Annotated[
            Optional[Annotated[int, Field(le=50, strict=True, ge=1)]],
            Field(description="Size of the page you want to see. Default is 50."),
        ] = None,
        name: Annotated[
            Optional[StrictStr], Field(description="The name to search by.")
        ] = None,
        label: Annotated[
            Optional[StrictStr],
            Field(description="The label of scenario to search by."),
        ] = None,
        last_usage_date_since: Annotated[
            Optional[date],
            Field(
                description="Lower limit of last usage date in `yyyy-MM-dd` format. Note: For scenarios where `lastUsageDate` is `null`, filtering matches `createTime`."
            ),
        ] = None,
        last_usage_date_until: Annotated[
            Optional[date],
            Field(
                description="Upper limit of last usage date in `yyyy-MM-dd` format. Note: For scenarios where `lastUsageDate` is `null`, filtering matches `createTime`."
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[CallsSearchResponse]:
        """Search Voice IVR Scenarios

        This method allows you to search Voice IVR Scenarios by name. To get a list of all IVR Scenarios, make a request without any parameters.

        :param page: Page number you want to see. Default is 1.
        :type page: int
        :param page_size: Size of the page you want to see. Default is 50.
        :type page_size: int
        :param name: The name to search by.
        :type name: str
        :param label: The label of scenario to search by.
        :type label: str
        :param last_usage_date_since: Lower limit of last usage date in `yyyy-MM-dd` format. Note: For scenarios where `lastUsageDate` is `null`, filtering matches `createTime`.
        :type last_usage_date_since: date
        :param last_usage_date_until: Upper limit of last usage date in `yyyy-MM-dd` format. Note: For scenarios where `lastUsageDate` is `null`, filtering matches `createTime`.
        :type last_usage_date_until: date
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._search_voice_ivr_scenarios_serialize(
            page=page,
            page_size=page_size,
            name=name,
            label=label,
            last_usage_date_since=last_usage_date_since,
            last_usage_date_until=last_usage_date_until,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "List[CallsSearchResponse]",
            "401": "ApiException",
            "403": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def search_voice_ivr_scenarios_with_http_info(
        self,
        page: Annotated[
            Optional[Annotated[int, Field(strict=True, ge=1)]],
            Field(description="Page number you want to see. Default is 1."),
        ] = None,
        page_size: Annotated[
            Optional[Annotated[int, Field(le=50, strict=True, ge=1)]],
            Field(description="Size of the page you want to see. Default is 50."),
        ] = None,
        name: Annotated[
            Optional[StrictStr], Field(description="The name to search by.")
        ] = None,
        label: Annotated[
            Optional[StrictStr],
            Field(description="The label of scenario to search by."),
        ] = None,
        last_usage_date_since: Annotated[
            Optional[date],
            Field(
                description="Lower limit of last usage date in `yyyy-MM-dd` format. Note: For scenarios where `lastUsageDate` is `null`, filtering matches `createTime`."
            ),
        ] = None,
        last_usage_date_until: Annotated[
            Optional[date],
            Field(
                description="Upper limit of last usage date in `yyyy-MM-dd` format. Note: For scenarios where `lastUsageDate` is `null`, filtering matches `createTime`."
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[CallsSearchResponse]]:
        """Search Voice IVR Scenarios

        This method allows you to search Voice IVR Scenarios by name. To get a list of all IVR Scenarios, make a request without any parameters.

        :param page: Page number you want to see. Default is 1.
        :type page: int
        :param page_size: Size of the page you want to see. Default is 50.
        :type page_size: int
        :param name: The name to search by.
        :type name: str
        :param label: The label of scenario to search by.
        :type label: str
        :param last_usage_date_since: Lower limit of last usage date in `yyyy-MM-dd` format. Note: For scenarios where `lastUsageDate` is `null`, filtering matches `createTime`.
        :type last_usage_date_since: date
        :param last_usage_date_until: Upper limit of last usage date in `yyyy-MM-dd` format. Note: For scenarios where `lastUsageDate` is `null`, filtering matches `createTime`.
        :type last_usage_date_until: date
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._search_voice_ivr_scenarios_serialize(
            page=page,
            page_size=page_size,
            name=name,
            label=label,
            last_usage_date_since=last_usage_date_since,
            last_usage_date_until=last_usage_date_until,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "List[CallsSearchResponse]",
            "401": "ApiException",
            "403": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def search_voice_ivr_scenarios_without_preload_content(
        self,
        page: Annotated[
            Optional[Annotated[int, Field(strict=True, ge=1)]],
            Field(description="Page number you want to see. Default is 1."),
        ] = None,
        page_size: Annotated[
            Optional[Annotated[int, Field(le=50, strict=True, ge=1)]],
            Field(description="Size of the page you want to see. Default is 50."),
        ] = None,
        name: Annotated[
            Optional[StrictStr], Field(description="The name to search by.")
        ] = None,
        label: Annotated[
            Optional[StrictStr],
            Field(description="The label of scenario to search by."),
        ] = None,
        last_usage_date_since: Annotated[
            Optional[date],
            Field(
                description="Lower limit of last usage date in `yyyy-MM-dd` format. Note: For scenarios where `lastUsageDate` is `null`, filtering matches `createTime`."
            ),
        ] = None,
        last_usage_date_until: Annotated[
            Optional[date],
            Field(
                description="Upper limit of last usage date in `yyyy-MM-dd` format. Note: For scenarios where `lastUsageDate` is `null`, filtering matches `createTime`."
            ),
        ] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Search Voice IVR Scenarios

        This method allows you to search Voice IVR Scenarios by name. To get a list of all IVR Scenarios, make a request without any parameters.

        :param page: Page number you want to see. Default is 1.
        :type page: int
        :param page_size: Size of the page you want to see. Default is 50.
        :type page_size: int
        :param name: The name to search by.
        :type name: str
        :param label: The label of scenario to search by.
        :type label: str
        :param last_usage_date_since: Lower limit of last usage date in `yyyy-MM-dd` format. Note: For scenarios where `lastUsageDate` is `null`, filtering matches `createTime`.
        :type last_usage_date_since: date
        :param last_usage_date_until: Upper limit of last usage date in `yyyy-MM-dd` format. Note: For scenarios where `lastUsageDate` is `null`, filtering matches `createTime`.
        :type last_usage_date_until: date
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._search_voice_ivr_scenarios_serialize(
            page=page,
            page_size=page_size,
            name=name,
            label=label,
            last_usage_date_since=last_usage_date_since,
            last_usage_date_until=last_usage_date_until,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "List[CallsSearchResponse]",
            "401": "ApiException",
            "403": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _search_voice_ivr_scenarios_serialize(
        self,
        page,
        page_size,
        name,
        label,
        last_usage_date_since,
        last_usage_date_until,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[Union[str, bytes, FileParameter]]]] = (
            {}
        )
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if page is not None:

            _query_params.append(("page", page))

        if page_size is not None:

            _query_params.append(("pageSize", page_size))

        if name is not None:

            _query_params.append(("name", name))

        if label is not None:

            _query_params.append(("label", label))

        if last_usage_date_since is not None:
            if isinstance(last_usage_date_since, date):
                _query_params.append(
                    (
                        "lastUsageDateSince",
                        last_usage_date_since.strftime(
                            self.api_client.configuration.date_format
                        ),
                    )
                )
            else:
                _query_params.append(("lastUsageDateSince", last_usage_date_since))

        if last_usage_date_until is not None:
            if isinstance(last_usage_date_until, date):
                _query_params.append(
                    (
                        "lastUsageDateUntil",
                        last_usage_date_until.strftime(
                            self.api_client.configuration.date_format
                        ),
                    )
                )
            else:
                _query_params.append(("lastUsageDateUntil", last_usage_date_until))

        # process the header parameters
        # process the form parameters
        # process the body parameter

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/xml"]
            )

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="GET",
            resource_path="/voice/ivr/1/scenarios",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def send_advanced_voice_tts(
        self,
        calls_advanced_body: CallsAdvancedBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CallsVoiceResponse:
        """Send advanced voice message

        This method allows you to send advanced voice messages to one or more destination addresses.

        :param calls_advanced_body: (required)
        :type calls_advanced_body: CallsAdvancedBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._send_advanced_voice_tts_serialize(
            calls_advanced_body=calls_advanced_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallsVoiceResponse",
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "500": "ApiException",
            "4XX": "ApiException",
            "5XX": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def send_advanced_voice_tts_with_http_info(
        self,
        calls_advanced_body: CallsAdvancedBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CallsVoiceResponse]:
        """Send advanced voice message

        This method allows you to send advanced voice messages to one or more destination addresses.

        :param calls_advanced_body: (required)
        :type calls_advanced_body: CallsAdvancedBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._send_advanced_voice_tts_serialize(
            calls_advanced_body=calls_advanced_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallsVoiceResponse",
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "500": "ApiException",
            "4XX": "ApiException",
            "5XX": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def send_advanced_voice_tts_without_preload_content(
        self,
        calls_advanced_body: CallsAdvancedBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Send advanced voice message

        This method allows you to send advanced voice messages to one or more destination addresses.

        :param calls_advanced_body: (required)
        :type calls_advanced_body: CallsAdvancedBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._send_advanced_voice_tts_serialize(
            calls_advanced_body=calls_advanced_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallsVoiceResponse",
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "500": "ApiException",
            "4XX": "ApiException",
            "5XX": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _send_advanced_voice_tts_serialize(
        self,
        calls_advanced_body,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[Union[str, bytes, FileParameter]]]] = (
            {}
        )
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if calls_advanced_body is not None:
            _body_params = calls_advanced_body

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/xml"]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(
                ["application/json"]
            )
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/tts/3/advanced",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def send_multiple_voice_tts(
        self,
        calls_multi_body: CallsMultiBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CallsVoiceResponse:
        """Send multiple voice messages

        This method allows you to send multiple voice messages to one or more destination addresses.

        :param calls_multi_body: (required)
        :type calls_multi_body: CallsMultiBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._send_multiple_voice_tts_serialize(
            calls_multi_body=calls_multi_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallsVoiceResponse",
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "500": "ApiException",
            "4XX": "ApiException",
            "5XX": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def send_multiple_voice_tts_with_http_info(
        self,
        calls_multi_body: CallsMultiBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CallsVoiceResponse]:
        """Send multiple voice messages

        This method allows you to send multiple voice messages to one or more destination addresses.

        :param calls_multi_body: (required)
        :type calls_multi_body: CallsMultiBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._send_multiple_voice_tts_serialize(
            calls_multi_body=calls_multi_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallsVoiceResponse",
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "500": "ApiException",
            "4XX": "ApiException",
            "5XX": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def send_multiple_voice_tts_without_preload_content(
        self,
        calls_multi_body: CallsMultiBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Send multiple voice messages

        This method allows you to send multiple voice messages to one or more destination addresses.

        :param calls_multi_body: (required)
        :type calls_multi_body: CallsMultiBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._send_multiple_voice_tts_serialize(
            calls_multi_body=calls_multi_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallsVoiceResponse",
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "500": "ApiException",
            "4XX": "ApiException",
            "5XX": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _send_multiple_voice_tts_serialize(
        self,
        calls_multi_body,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[Union[str, bytes, FileParameter]]]] = (
            {}
        )
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if calls_multi_body is not None:
            _body_params = calls_multi_body

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/xml"]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(
                ["application/json"]
            )
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/tts/3/multi",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def send_single_voice_tts(
        self,
        calls_single_body: CallsSingleBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CallsVoiceResponse:
        """Send single voice message

        This method allows you to send single voice message to one or more destination addresses.

        :param calls_single_body: (required)
        :type calls_single_body: CallsSingleBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._send_single_voice_tts_serialize(
            calls_single_body=calls_single_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallsVoiceResponse",
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "500": "ApiException",
            "4XX": "ApiException",
            "5XX": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def send_single_voice_tts_with_http_info(
        self,
        calls_single_body: CallsSingleBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CallsVoiceResponse]:
        """Send single voice message

        This method allows you to send single voice message to one or more destination addresses.

        :param calls_single_body: (required)
        :type calls_single_body: CallsSingleBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._send_single_voice_tts_serialize(
            calls_single_body=calls_single_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallsVoiceResponse",
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "500": "ApiException",
            "4XX": "ApiException",
            "5XX": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def send_single_voice_tts_without_preload_content(
        self,
        calls_single_body: CallsSingleBody,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Send single voice message

        This method allows you to send single voice message to one or more destination addresses.

        :param calls_single_body: (required)
        :type calls_single_body: CallsSingleBody
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._send_single_voice_tts_serialize(
            calls_single_body=calls_single_body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallsVoiceResponse",
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "500": "ApiException",
            "4XX": "ApiException",
            "5XX": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _send_single_voice_tts_serialize(
        self,
        calls_single_body,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[Union[str, bytes, FileParameter]]]] = (
            {}
        )
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if calls_single_body is not None:
            _body_params = calls_single_body

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/xml"]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(
                ["application/json"]
            )
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/tts/3/single",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def send_voice_messages_with_an_ivr_scenario(
        self,
        calls_launch_scenario_request: CallsLaunchScenarioRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CallsVoiceResponse:
        """Launch IVR Scenario

        This method allows you to start an outbound IVR toward a multiple destinations.

        :param calls_launch_scenario_request: (required)
        :type calls_launch_scenario_request: CallsLaunchScenarioRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._send_voice_messages_with_an_ivr_scenario_serialize(
            calls_launch_scenario_request=calls_launch_scenario_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallsVoiceResponse",
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def send_voice_messages_with_an_ivr_scenario_with_http_info(
        self,
        calls_launch_scenario_request: CallsLaunchScenarioRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CallsVoiceResponse]:
        """Launch IVR Scenario

        This method allows you to start an outbound IVR toward a multiple destinations.

        :param calls_launch_scenario_request: (required)
        :type calls_launch_scenario_request: CallsLaunchScenarioRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._send_voice_messages_with_an_ivr_scenario_serialize(
            calls_launch_scenario_request=calls_launch_scenario_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallsVoiceResponse",
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def send_voice_messages_with_an_ivr_scenario_without_preload_content(
        self,
        calls_launch_scenario_request: CallsLaunchScenarioRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Launch IVR Scenario

        This method allows you to start an outbound IVR toward a multiple destinations.

        :param calls_launch_scenario_request: (required)
        :type calls_launch_scenario_request: CallsLaunchScenarioRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._send_voice_messages_with_an_ivr_scenario_serialize(
            calls_launch_scenario_request=calls_launch_scenario_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallsVoiceResponse",
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _send_voice_messages_with_an_ivr_scenario_serialize(
        self,
        calls_launch_scenario_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[Union[str, bytes, FileParameter]]]] = (
            {}
        )
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if calls_launch_scenario_request is not None:
            _body_params = calls_launch_scenario_request

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/xml"]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(
                ["application/json"]
            )
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="POST",
            resource_path="/voice/ivr/1/messages",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )

    @validate_call
    def update_voice_ivr_scenario(
        self,
        id: Annotated[StrictStr, Field(description="Scenario identifier.")],
        calls_update_scenario_request: CallsUpdateScenarioRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CallsUpdateScenarioResponse:
        """Update Voice IVR Scenarios

        This method allows you to update a Voice IVR Scenario. Changes may take up to 10 minutes to apply.

        :param id: Scenario identifier. (required)
        :type id: str
        :param calls_update_scenario_request: (required)
        :type calls_update_scenario_request: CallsUpdateScenarioRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._update_voice_ivr_scenario_serialize(
            id=id,
            calls_update_scenario_request=calls_update_scenario_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallsUpdateScenarioResponse",
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "404": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data

    @validate_call
    def update_voice_ivr_scenario_with_http_info(
        self,
        id: Annotated[StrictStr, Field(description="Scenario identifier.")],
        calls_update_scenario_request: CallsUpdateScenarioRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CallsUpdateScenarioResponse]:
        """Update Voice IVR Scenarios

        This method allows you to update a Voice IVR Scenario. Changes may take up to 10 minutes to apply.

        :param id: Scenario identifier. (required)
        :type id: str
        :param calls_update_scenario_request: (required)
        :type calls_update_scenario_request: CallsUpdateScenarioRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._update_voice_ivr_scenario_serialize(
            id=id,
            calls_update_scenario_request=calls_update_scenario_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallsUpdateScenarioResponse",
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "404": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )

    @validate_call
    def update_voice_ivr_scenario_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="Scenario identifier.")],
        calls_update_scenario_request: CallsUpdateScenarioRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)], Annotated[StrictFloat, Field(gt=0)]
            ],
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update Voice IVR Scenarios

        This method allows you to update a Voice IVR Scenario. Changes may take up to 10 minutes to apply.

        :param id: Scenario identifier. (required)
        :type id: str
        :param calls_update_scenario_request: (required)
        :type calls_update_scenario_request: CallsUpdateScenarioRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """  # noqa: E501

        _param = self._update_voice_ivr_scenario_serialize(
            id=id,
            calls_update_scenario_request=calls_update_scenario_request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index,
        )

        _response_types_map: Dict[str, Optional[str]] = {
            "200": "CallsUpdateScenarioResponse",
            "400": "ApiException",
            "401": "ApiException",
            "403": "ApiException",
            "404": "ApiException",
            "500": "ApiException",
        }

        response_data = self.api_client.call_api(
            *_param, _request_timeout=_request_timeout
        )
        return response_data.response

    def _update_voice_ivr_scenario_serialize(
        self,
        id,
        calls_update_scenario_request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {}

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[str, Union[str, bytes, List[Union[str, bytes, FileParameter]]]] = (
            {}
        )
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params["id"] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if calls_update_scenario_request is not None:
            _body_params = calls_update_scenario_request

        # set the HTTP header `Accept`
        if "Accept" not in _header_params:
            _header_params["Accept"] = self.api_client.select_header_accept(
                ["application/json", "application/xml"]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params["Content-Type"] = _content_type
        else:
            _default_content_type = self.api_client.select_header_content_type(
                ["application/json"]
            )
            if _default_content_type is not None:
                _header_params["Content-Type"] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = ["APIKeyHeader"]

        return self.api_client.param_serialize(
            method="PUT",
            resource_path="/voice/ivr/1/scenarios/{id}",
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth,
        )
