# coding: utf-8

"""
Infobip Client API Libraries OpenAPI Specification

OpenAPI specification containing public endpoints supported in client API libraries.

The version of the OpenAPI document: 1.0.0
Contact: support@infobip.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from infobip_api_client.models.calls_execution_mode import CallsExecutionMode
from typing import Optional, Set
from typing_extensions import Self


class CallsMachineDetection(BaseModel):
    """
    Answering machine detection configuration of a Number Masking call. Detection will be performed only on the callee side of the call.
    """  # noqa: E501

    enabled: Optional[StrictBool] = Field(
        default=None,
        description="Indicates whether machine detection is enabled from the callee perspective.",
    )
    execution_mode: Optional[CallsExecutionMode] = Field(
        default=CallsExecutionMode.SYNC, alias="executionMode"
    )
    detection_time: Optional[Union[StrictFloat, StrictInt]] = Field(
        default=3.74,
        description="Duration of machine detection. Higher values will increase the accuracy of machine detection, but will also increase the time it takes to detect a machine.",
        alias="detectionTime",
    )
    hangup_on_machine_detection: Optional[StrictBool] = Field(
        default=True,
        description="Indicates whether the callee side will hangup upon machine detection.",
        alias="hangupOnMachineDetection",
    )
    __properties: ClassVar[List[str]] = [
        "enabled",
        "executionMode",
        "detectionTime",
        "hangupOnMachineDetection",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CallsMachineDetection from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CallsMachineDetection from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "enabled": obj.get("enabled"),
                "executionMode": obj.get("executionMode"),
                "detectionTime": (
                    obj.get("detectionTime")
                    if obj.get("detectionTime") is not None
                    else 3.74
                ),
                "hangupOnMachineDetection": (
                    obj.get("hangupOnMachineDetection")
                    if obj.get("hangupOnMachineDetection") is not None
                    else True
                ),
            }
        )
        return _obj
