# coding: utf-8

"""
Infobip Client API Libraries OpenAPI Specification

OpenAPI specification containing public endpoints supported in client API libraries.

The version of the OpenAPI document: 1.0.0
Contact: support@infobip.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List
from typing import Optional, Set
from typing_extensions import Self


class CallsRetry(BaseModel):
    """
    Used to define if the delivery of the Voice messages should be retried in case the first try doesn't succeed. Additional retries will be made according to the schedule defined by _minPeriod_ and _maxPeriod_ parameters and platform's internal retry logic. If the _minPeriod_ differs _maxPeriod_, delivery will be retried in the following manner: after 1 min, 2 min, 5 min, 10 min, 20 min, 30 min, 1 hour, 2 hours, 4 hours, 8 hours, 16 hours, 24 hours or until maxPeriod is reached.  If the retry attempt for the _maxPeriod_ is reached, the _maxPeriod_ will be used for all subsequent retries. If the _minPeriod_ and the _maxPeriod_ are defined as equal values, the period of time between retries will be equal to this value. Message delivery will be retried until the successful delivery or message validity or _maxCount_ value is reached.
    """  # noqa: E501

    max_count: StrictInt = Field(
        description="Specify the maximum number of retry attempts. Maximum value of the maxCount is `4`. If the value is higher than `4`, it will be set to `4`.",
        alias="maxCount",
    )
    max_period: StrictInt = Field(
        description="Defines the maximum waiting time (in minutes) after the previous failed attempt to try to deliver the message again. Supported values are 1 min, 2 min, 5 min, 10 min, 20 min, 30 min, 1 hour, 2 hours, 4 hours, 8 hours, 16 hours, 24 hours. If entered a value that isn't from the previous list but that's smaller than 24 hours, it is used the next bigger value from the list. If entered value that is bigger than 24 hours than it is used 24 hours.",
        alias="maxPeriod",
    )
    min_period: StrictInt = Field(
        description="Defines the minimal waiting time (in minutes) after the previous failed attempt to try to deliver the message again. Supported values are 1 min, 2 min, 5 min, 10 min, 20 min, 30 min, 1 hour, 2 hours, 4 hours, 8 hours, 16 hours, 24 hours. If entered a value that isn't from the previous list but that's smaller than 24 hours, it is used the next bigger value from the list. If entered value that is bigger than 24 hours than it is used 24 hours.",
        alias="minPeriod",
    )
    __properties: ClassVar[List[str]] = ["maxCount", "maxPeriod", "minPeriod"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CallsRetry from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CallsRetry from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "maxCount": obj.get("maxCount"),
                "maxPeriod": obj.get("maxPeriod"),
                "minPeriod": obj.get("minPeriod"),
            }
        )
        return _obj
