# coding: utf-8

"""
Infobip Client API Libraries OpenAPI Specification

OpenAPI specification containing public endpoints supported in client API libraries.

The version of the OpenAPI document: 1.0.0
Contact: support@infobip.com
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self


class CallsUpdateScenarioRequest(BaseModel):
    """
    CallsUpdateScenarioRequest
    """  # noqa: E501

    name: StrictStr = Field(description="The name of IVR scenario.")
    description: Optional[StrictStr] = Field(
        default=None, description="Description of IVR scenario."
    )
    notify_url: Optional[StrictStr] = Field(
        default=None,
        description="The URL on your callback server on which the Delivery report will be sent.",
        alias="notifyUrl",
    )
    notify_content_type: Optional[StrictStr] = Field(
        default=None,
        description="Preferred Delivery report content type. Can be `application/json` or `application/xml`.",
        alias="notifyContentType",
    )
    record: Optional[StrictBool] = Field(
        default=None,
        description="Indicates if all calls using the scenario should be recorded.",
    )
    script: StrictStr
    __properties: ClassVar[List[str]] = [
        "name",
        "description",
        "notifyUrl",
        "notifyContentType",
        "record",
        "script",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CallsUpdateScenarioRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        if "script" in _dict:
            try:
                _dict["script"] = json.loads(self.script)
            except json.JSONDecodeError:
                pass

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CallsUpdateScenarioRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        script_value = obj.get("script")
        if isinstance(script_value, (list, dict)):
            script_value = json.dumps(script_value)

        _obj = cls.model_validate(
            {
                "name": obj.get("name"),
                "description": obj.get("description"),
                "notifyUrl": obj.get("notifyUrl"),
                "notifyContentType": obj.get("notifyContentType"),
                "record": obj.get("record"),
                "script": script_value,
            }
        )
        return _obj
